/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;

public class CppUtil {
    private static Map<PrimitiveType, String> typeNameByPrimitiveTypeMap = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cppTypeName(PrimitiveType primitiveType) {
        return typeNameByPrimitiveTypeMap.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String value) {
        String formattedValue = CppUtil.toLowerFirstChar(value);
        if (ValidationUtil.isCppKeyword(formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + formattedValue + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            formattedValue = formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatClassName(String value) {
        return CppUtil.toUpperFirstChar(value);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "SBE_" + byteOrder + "_ENCODE_16";
            }
            case 4: {
                return "SBE_" + byteOrder + "_ENCODE_32";
            }
            case 8: {
                return "SBE_" + byteOrder + "_ENCODE_64";
            }
        }
        return "";
    }

    public static String closingBraces(int count) {
        return new String(new char[count]).replace("\u0000", "}\n");
    }

    static {
        typeNameByPrimitiveTypeMap.put(PrimitiveType.CHAR, "char");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT8, "std::int8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT16, "std::int16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT32, "std::int32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT64, "std::int64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT8, "std::uint8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT16, "std::uint16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT32, "std::uint32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT64, "std::uint64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.FLOAT, "float");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.DOUBLE, "double");
    }
}

