/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.lang.reflect.Method;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.spi.MidiDeviceProvider;

public class HighResolutionTimer {
    private static final MidiDevice MIDI_DEVICE;
    private static volatile boolean isEnabled;

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static synchronized void enable() {
        if (null != MIDI_DEVICE && !MIDI_DEVICE.isOpen()) {
            try {
                MIDI_DEVICE.open();
            }
            catch (MidiUnavailableException ignore) {
                isEnabled = false;
                return;
            }
            isEnabled = true;
        }
    }

    public static synchronized void disable() {
        if (MIDI_DEVICE != null && MIDI_DEVICE.isOpen()) {
            MIDI_DEVICE.close();
        }
        isEnabled = false;
    }

    static {
        MidiDevice midiDevice = null;
        try {
            Class<?> mediaProviderClass = Class.forName("com.sun.media.sound.MidiOutDeviceProvider");
            Method getDeviceInfoMethod = mediaProviderClass.getMethod("getDeviceInfo", new Class[0]);
            MidiDeviceProvider provider = (MidiDeviceProvider)mediaProviderClass.newInstance();
            MidiDevice.Info[] info = (MidiDevice.Info[])getDeviceInfoMethod.invoke((Object)provider, new Object[0]);
            midiDevice = info.length > 0 ? provider.getDevice(info[0]) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MIDI_DEVICE = midiDevice;
        isEnabled = false;
    }
}

