/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import org.w3c.dom.Node;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class EncodedDataType
extends Type {
    public static final String ENCODED_DATA_TYPE = "type";
    private final PrimitiveType primitiveType;
    private final int length;
    private final PrimitiveValue constValue;
    private final PrimitiveValue minValue;
    private final PrimitiveValue maxValue;
    private final PrimitiveValue nullValue;
    private final String characterEncoding;
    private boolean varLen;

    public EncodedDataType(Node node) {
        this(node, null);
    }

    public EncodedDataType(Node node, String givenName) {
        super(node, givenName, null);
        this.primitiveType = PrimitiveType.get(XmlSchemaParser.getAttributeValue(node, "primitiveType"));
        this.length = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "length", "1"));
        this.varLen = Boolean.parseBoolean(XmlSchemaParser.getAttributeValue(node, "variableLength", "false"));
        this.characterEncoding = PrimitiveType.CHAR == this.primitiveType ? XmlSchemaParser.getAttributeValue(node, "characterEncoding", "US-ASCII") : XmlSchemaParser.getAttributeValueOrNull(node, "characterEncoding");
        if (this.presence() == Presence.CONSTANT) {
            if (node.getFirstChild() == null) {
                XmlSchemaParser.handleError(node, "type has declared presence as \"constant\" but XML node has no data");
                this.constValue = null;
            } else {
                String nodeValue = node.getFirstChild().getNodeValue();
                this.constValue = PrimitiveType.CHAR == this.primitiveType ? (nodeValue.length() == 1 ? PrimitiveValue.parse(nodeValue, this.primitiveType) : PrimitiveValue.parse(nodeValue, nodeValue.length(), this.characterEncoding)) : PrimitiveValue.parse(nodeValue, this.primitiveType);
            }
        } else {
            this.constValue = null;
        }
        String minValStr = XmlSchemaParser.getAttributeValueOrNull(node, "minValue");
        this.minValue = minValStr != null ? PrimitiveValue.parse(minValStr, this.primitiveType) : null;
        String maxValStr = XmlSchemaParser.getAttributeValueOrNull(node, "maxValue");
        this.maxValue = maxValStr != null ? PrimitiveValue.parse(maxValStr, this.primitiveType) : null;
        String nullValStr = XmlSchemaParser.getAttributeValueOrNull(node, "nullValue");
        if (nullValStr != null) {
            if (this.presence() != Presence.OPTIONAL) {
                XmlSchemaParser.handleWarning(node, "nullValue set, but presence is not optional");
            }
            this.nullValue = PrimitiveValue.parse(nullValStr, this.primitiveType);
        } else {
            this.nullValue = null;
        }
    }

    public EncodedDataType(String name, Presence presence, String description, String semanticType, PrimitiveType primitiveType, int length, boolean varLen) {
        super(name, presence, description, 0, 0, semanticType);
        this.primitiveType = primitiveType;
        this.length = length;
        this.varLen = varLen;
        this.constValue = null;
        this.minValue = null;
        this.maxValue = null;
        this.nullValue = null;
        this.characterEncoding = null;
    }

    public int length() {
        return this.length;
    }

    @Override
    public boolean isVariableLength() {
        return this.varLen;
    }

    public void variableLength(boolean variableLength) {
        this.varLen = variableLength;
    }

    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    @Override
    public int encodedLength() {
        if (this.presence() == Presence.CONSTANT) {
            return 0;
        }
        if (this.varLen) {
            return -1;
        }
        return this.primitiveType.size() * this.length;
    }

    public PrimitiveValue constVal() throws IllegalArgumentException {
        if (this.presence() != Presence.CONSTANT) {
            throw new IllegalStateException("type is not of constant presence");
        }
        return this.constValue;
    }

    public PrimitiveValue minValue() {
        return this.minValue;
    }

    public PrimitiveValue maxValue() {
        return this.maxValue;
    }

    public PrimitiveValue nullValue() {
        return this.nullValue;
    }

    public String characterEncoding() {
        return this.characterEncoding;
    }
}

