/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.agrona.generation.OutputManager;

public class PackageOutputManager
implements OutputManager {
    private final File outputDir;

    public PackageOutputManager(String baseDirName, String packageName) throws IOException {
        Objects.requireNonNull(baseDirName, "baseDirName");
        Objects.requireNonNull(packageName, "packageName");
        String dirName = (baseDirName.endsWith("" + File.separatorChar) ? baseDirName : baseDirName + File.separatorChar) + packageName.replace('.', File.separatorChar);
        this.outputDir = new File(dirName);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + dirName);
        }
    }

    @Override
    public Writer createOutput(String name) throws IOException {
        File targetFile = new File(this.outputDir, name + ".java");
        return Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

