/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentRunner
implements Runnable,
AutoCloseable {
    public static final Thread TOMBSTONE = new Thread();
    private volatile boolean running = true;
    private volatile boolean done = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final IdleStrategy idleStrategy;
    private final Agent agent;
    private final AtomicReference<Thread> thread = new AtomicReference();

    public AgentRunner(IdleStrategy idleStrategy, ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(idleStrategy, "idleStrategy");
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public static Thread startOnThread(AgentRunner runner) {
        return AgentRunner.startOnThread(runner, Thread::new);
    }

    public static Thread startOnThread(AgentRunner runner, ThreadFactory threadFactory) {
        Thread thread = threadFactory.newThread(runner);
        thread.setName(runner.agent().roleName());
        thread.start();
        return thread;
    }

    public Agent agent() {
        return this.agent;
    }

    public Thread thread() {
        return this.thread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.thread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            IdleStrategy idleStrategy = this.idleStrategy;
            Agent agent = this.agent;
            while (this.running) {
                try {
                    idleStrategy.idle(agent.doWork());
                }
                catch (InterruptedException | ClosedByInterruptException ignore) {
                    Thread.interrupted();
                    break;
                }
                catch (Throwable throwable) {
                    if (!this.running) continue;
                    if (null != this.errorCounter) {
                        this.errorCounter.increment();
                    }
                    this.errorHandler.onError(throwable);
                }
            }
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public final void close() {
        this.running = false;
        Thread thread = this.thread.getAndSet(TOMBSTONE);
        if (TOMBSTONE != thread) {
            if (null != thread) {
                try {
                    while (true) {
                        thread.join(1000L);
                        if (thread.isAlive() && !this.done) {
                            System.err.println("Timeout waiting for " + this.agent.roleName() + " Retrying...");
                            thread.interrupt();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
            this.agent.onClose();
        }
    }
}

