/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentInvoker
implements AutoCloseable {
    private boolean closed = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final Agent agent;

    public AgentInvoker(ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public Agent agent() {
        return this.agent;
    }

    public int invoke() {
        int workCount = 0;
        if (!this.closed) {
            try {
                workCount = this.agent.doWork();
            }
            catch (InterruptedException | ClosedByInterruptException ignore) {
                Thread.interrupted();
            }
            catch (Throwable throwable) {
                if (null != this.errorCounter) {
                    this.errorCounter.increment();
                }
                this.errorHandler.onError(throwable);
            }
        }
        return workCount;
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.agent.onClose();
        }
    }
}

