/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongIterator
implements Iterator<Long> {
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private long[] values;
    private boolean containsMissingValue;

    void reset(long[] values, boolean containsMissingValue) {
        int length;
        this.values = values;
        this.containsMissingValue = containsMissingValue;
        int i = length = values.length;
        if (values[length - 1] != -1L) {
            int size = length;
            for (i = 0; i < size && values[i] != -1L; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        long[] values = this.values;
        int mask = values.length - 1;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1L) continue;
            return true;
        }
        return this.containsMissingValue;
    }

    protected void findNext() {
        long[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = false;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1L) continue;
            this.positionCounter = i;
            this.isPositionValid = true;
            return;
        }
        if (!this.containsMissingValue) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Long next() {
        return this.nextValue();
    }

    public long nextValue() {
        this.findNext();
        if (this.isPositionValid) {
            return this.values[this.position()];
        }
        this.containsMissingValue = false;
        return -1L;
    }
}

