/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.util.function.Supplier;
import org.agrona.Verify;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Signal;

public class Token {
    public static final int INVALID_ID = -1;
    public static final int VARIABLE_LENGTH = -1;
    public static final int UNKNOWN_OFFSET = -1;
    private final Signal signal;
    private final String name;
    private final String description;
    private final int id;
    private final int version;
    private final int deprecated;
    private int encodedLength;
    private final int offset;
    private int componentTokenCount;
    private final Encoding encoding;

    public Token(Signal signal, String name, String description, int id, int version, int deprecated, int encodedLength, int offset, int componentTokenCount, Encoding encoding) {
        Verify.notNull((Object)signal, "signal");
        Verify.notNull(name, "name");
        Verify.notNull(encoding, "encoding");
        this.signal = signal;
        this.name = name;
        this.description = description;
        this.id = id;
        this.version = version;
        this.deprecated = deprecated;
        this.encodedLength = encodedLength;
        this.offset = offset;
        this.componentTokenCount = componentTokenCount;
        this.encoding = encoding;
    }

    public Signal signal() {
        return this.signal;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public int deprecated() {
        return this.deprecated;
    }

    public VersionContext versionContext() {
        if (this.signal == Signal.BEGIN_MESSAGE || this.signal == Signal.END_MESSAGE) {
            return VersionContext.TEMPLATE_VERSION;
        }
        return VersionContext.SINCE_TEMPLATE_VERSION;
    }

    public int encodedLength() {
        return this.encodedLength;
    }

    public void encodedLength(int encodedLength) {
        this.encodedLength = encodedLength;
    }

    public int arrayLength() {
        if (null == this.encoding.primitiveType() || 0 == this.encodedLength) {
            return 0;
        }
        return this.encodedLength / this.encoding.primitiveType().size();
    }

    public CharSequence matchOnLength(Supplier<CharSequence> one, Supplier<CharSequence> many) {
        int arrayLength = this.arrayLength();
        if (arrayLength == 1) {
            return one.get();
        }
        if (arrayLength > 1) {
            return many.get();
        }
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public int componentTokenCount() {
        return this.componentTokenCount;
    }

    public void componentTokenCount(int componentTokenCount) {
        this.componentTokenCount = componentTokenCount;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public boolean isConstantEncoding() {
        return this.encoding.presence() == Encoding.Presence.CONSTANT;
    }

    public boolean isOptionalEncoding() {
        return this.encoding.presence() == Encoding.Presence.OPTIONAL;
    }

    public String toString() {
        return "Token{signal=" + (Object)((Object)this.signal) + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", id=" + this.id + ", version=" + this.version + ", deprecated=" + this.deprecated + ", encodedLength=" + this.encodedLength + ", offset=" + this.offset + ", componentTokenCount=" + this.componentTokenCount + ", encoding=" + this.encoding + '}';
    }

    public static class Builder {
        private Signal signal;
        private String name;
        private String description;
        private int id = -1;
        private int version = 0;
        private int deprecated = 0;
        private int size = 0;
        private int offset = 0;
        private int componentTokenCount = 1;
        private Encoding encoding = new Encoding();

        public Builder signal(Signal signal) {
            this.signal = signal;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder deprecated(int deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder componentTokenCount(int componentTokenCount) {
            this.componentTokenCount = componentTokenCount;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Token build() {
            return new Token(this.signal, this.name, this.description, this.id, this.version, this.deprecated, this.size, this.offset, this.componentTokenCount, this.encoding);
        }
    }

    public static enum VersionContext {
        TEMPLATE_VERSION,
        SINCE_TEMPLATE_VERSION;

    }
}

