/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.golang;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;

public class GolangUtil {
    private static Map<PrimitiveType, String> typeNameByPrimitiveTypeMap = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String golangTypeName(PrimitiveType primitiveType) {
        return typeNameByPrimitiveTypeMap.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String value) {
        String formattedValue = GolangUtil.toUpperFirstChar(value);
        if (ValidationUtil.isGolangKeyword(formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + formattedValue + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            formattedValue = formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatTypeName(String value) {
        return GolangUtil.toUpperFirstChar(value);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "binary.Write(buf, order, obj)";
            }
            case 4: {
                return "binary.Write(buf, order, obj)";
            }
            case 8: {
                return "binary.Write(buf, order, obj)";
            }
        }
        return "";
    }

    public static String closingBraces(int count) {
        return new String(new char[count]).replace("\u0000", "}\n");
    }

    static {
        typeNameByPrimitiveTypeMap.put(PrimitiveType.CHAR, "byte");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT8, "int8");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT16, "int16");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT32, "int32");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT64, "int64");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT8, "uint8");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT16, "uint16");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT32, "uint32");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT64, "uint64");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.FLOAT, "float32");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.DOUBLE, "float64");
    }
}

