/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIterator<T>
implements Iterator<T> {
    private static final Object MISSING_VALUE = null;
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private T[] values;

    protected ObjectIterator(T[] values) {
        this.reset(values);
    }

    void reset() {
        this.reset(this.values);
    }

    void reset(T[] values) {
        int length;
        this.values = values;
        int i = length = values.length;
        if (values[length - 1] != MISSING_VALUE) {
            for (i = 0; i < length && values[i] != MISSING_VALUE; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        T[] values = this.values;
        int mask = values.length - 1;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == MISSING_VALUE) continue;
            return true;
        }
        return false;
    }

    protected void findNext() {
        T[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = false;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == MISSING_VALUE) continue;
            this.positionCounter = i;
            this.isPositionValid = true;
            return;
        }
        throw new NoSuchElementException();
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    public T nextValue() {
        this.findNext();
        return this.values[this.position()];
    }
}

