/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;
import org.agrona.collections.MapDelegatingSet;

public class Int2IntHashMap
implements Map<Integer, Integer> {
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size = 0;
    private int[] entries;
    private final KeySet keySet;
    private final Values values;
    private final Set<Map.Entry<Integer, Integer>> entrySet;

    public Int2IntHashMap(int missingValue) {
        this(8, 0.67f, missingValue);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(initialCapacity));
        this.keySet = new KeySet();
        this.values = new Values();
        this.entrySet = new EntrySet();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public int put(int key, int value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("Cannot accept missingValue");
        }
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int[] oldEntries = this.entries;
        int missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (oldEntries[keyIndex + 1] == missingValue) continue;
            this.put(oldEntries[keyIndex], oldEntries[keyIndex + 1]);
        }
    }

    public void intForEach(IntIntConsumer consumer) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int length = entries.length;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (entries[keyIndex + 1] == missingValue) continue;
            consumer.accept(entries[keyIndex], entries[keyIndex + 1]);
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (value != this.missingValue) {
            int[] entries = this.entries;
            int length = entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (value != entries[valueIndex]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, this.missingValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsInt(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Integer get(Object key) {
        return this.get((Integer)key);
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return this.put((int)key, (int)value);
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        this.intForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        return this.keySet;
    }

    public Values values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Integer remove(Object key) {
        return this.remove((Integer)key);
    }

    public int remove(int key) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while (entries[keyIndex + 1] != missingValue) {
            if (entries[keyIndex] == key) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Int2IntHashMap.next(keyIndex, mask)) + 1] != missingValue) {
            int hash = Hashing.evenHash(entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public int minValue() {
        int missingValue = this.missingValue;
        int min = this.size == 0 ? missingValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int missingValue = this.missingValue;
        int max = this.size == 0 ? missingValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<Integer, Integer> entry : this.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int replace(int key, int value) {
        int curValue = this.get(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        int curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.missingValue);
    }

    private final class EntrySet
    extends MapDelegatingSet<Map.Entry<Integer, Integer>> {
        private final EntryIterator entryIterator;

        private EntrySet() {
            super(Int2IntHashMap.this);
            this.entryIterator = new EntryIterator();
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return this.entryIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return Int2IntHashMap.this.containsKey(((Map.Entry)o).getKey());
        }
    }

    public final class Values
    extends AbstractCollection<Integer> {
        private final IntIterator valueIterator;

        private Values() {
            this.valueIterator = new IntIterator(1);
        }

        public IntIterator iterator() {
            return this.valueIterator.reset();
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends MapDelegatingSet<Integer> {
        private final IntIterator keyIterator;

        private KeySet() {
            super(Int2IntHashMap.this);
            this.keyIterator = new IntIterator(0);
        }

        public IntIterator iterator() {
            return this.keyIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsKey(key);
        }
    }

    final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        private int key;
        private int value;

        private EntryIterator() {
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            int keyPosition = this.keyPosition();
            this.key = Int2IntHashMap.this.entries[keyPosition];
            this.value = Int2IntHashMap.this.entries[keyPosition + 1];
            return this;
        }

        public EntryIterator reset() {
            ((AbstractIterator)this).reset();
            this.key = Int2IntHashMap.this.missingValue;
            this.value = Int2IntHashMap.this.missingValue;
            return this;
        }
    }

    public final class IntIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        private final int offset;

        private IntIterator(int offset) {
            this.offset = offset;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + this.offset];
        }

        public IntIterator reset() {
            ((AbstractIterator)this).reset();
            return this;
        }
    }

    abstract class AbstractIterator {
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
            this.reset();
        }

        private void reset() {
            int capacity;
            int missingValue = Int2IntHashMap.this.missingValue;
            int[] entries = Int2IntHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != missingValue) {
                int size = capacity;
                for (keyIndex = 0; keyIndex < size && entries[keyIndex + 1] != missingValue; keyIndex += 2) {
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public boolean hasNext() {
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            boolean hasNext = false;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                hasNext = true;
                break;
            }
            return hasNext;
        }

        protected void findNext() {
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                this.positionCounter = keyIndex;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

