/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;

public class JavaUtil {
    private static final Map<PrimitiveType, String> TYPE_NAME_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);
    private static final Map<String, String> STD_CHARSETS;

    public static String javaTypeName(PrimitiveType primitiveType) {
        return TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerFirstChar(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String formatPropertyName(String value) {
        String formattedValue = JavaUtil.toLowerFirstChar(value);
        if (ValidationUtil.isJavaKeyword(formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + formattedValue + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            formattedValue = formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatClassName(String value) {
        return JavaUtil.toUpperFirstChar(value);
    }

    public static void append(StringBuilder builder, String indent, String line) {
        builder.append(indent).append(line).append('\n');
    }

    public static String charset(String encoding) {
        String charsetName = STD_CHARSETS.get(encoding);
        if (charsetName != null) {
            return "java.nio.charset.StandardCharsets." + charsetName;
        }
        return "java.nio.charset.Charset.forName(\"" + encoding + "\")";
    }

    static {
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "float");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "double");
        STD_CHARSETS = new HashMap<String, String>();
        try {
            for (Field field : StandardCharsets.class.getDeclaredFields()) {
                if (!Charset.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 8) != 8) continue;
                Charset charset = (Charset)field.get(null);
                STD_CHARSETS.put(charset.name(), field.getName());
                charset.aliases().forEach(alias -> STD_CHARSETS.put((String)alias, field.getName()));
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static enum Separators {
        BEGIN_GROUP('['),
        END_GROUP(']'),
        BEGIN_COMPOSITE('('),
        END_COMPOSITE(')'),
        BEGIN_SET('{'),
        END_SET('}'),
        BEGIN_ARRAY('['),
        END_ARRAY(']'),
        FIELD('|'),
        KEY_VALUE('='),
        ENTRY(',');

        public final char symbol;

        private Separators(char symbol) {
            this.symbol = symbol;
        }

        public void appendToGeneratedBuilder(StringBuilder builder, String indent, String generatedBuilder) {
            JavaUtil.append(builder, indent, generatedBuilder + ".append('" + this.symbol + "');");
        }

        public String toString() {
            return String.valueOf(this.symbol);
        }
    }
}

