/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.cpp.CppUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CppGenerator
implements CodeGenerator {
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public CppGenerator(Ir ir, OutputManager outputManager) throws IOException {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        String messageHeader = "MessageHeader";
        try (Writer out = this.outputManager.createOutput("MessageHeader");){
            List<Token> tokens = this.ir.headerStructure().tokens();
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), "MessageHeader", null));
            out.append(CppGenerator.generateClassDeclaration("MessageHeader"));
            out.append(CppGenerator.generateFixedFlyweightCode("MessageHeader", tokens.get(0).encodedLength()));
            out.append(this.generateCompositePropertyElements("MessageHeader", tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append(CppUtil.closingBraces(this.ir.namespaces().length) + "}\n#endif\n");
        }
    }

    public List<String> generateTypeStubs() throws IOException {
        ArrayList<String> typesToInclude = new ArrayList<String>();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
            typesToInclude.add(tokens.get(0).name());
        }
        return typesToInclude;
    }

    public List<String> generateTypesToIncludes(List<Token> tokens) {
        ArrayList<String> typesToInclude = new ArrayList<String>();
        for (Token token : tokens) {
            switch (token.signal()) {
                case BEGIN_ENUM: 
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    typesToInclude.add(token.name());
                }
            }
        }
        return typesToInclude;
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        List<String> typesToInclude = this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = CppUtil.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), className, typesToInclude));
                out.append(CppGenerator.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int i = 0;
                ArrayList<Token> fields = new ArrayList<Token>();
                i = GenerationUtil.collectFields(messageBody, i, fields);
                ArrayList<Token> groups = new ArrayList<Token>();
                i = GenerationUtil.collectGroups(messageBody, i, groups);
                ArrayList<Token> varData = new ArrayList<Token>();
                GenerationUtil.collectVarData(messageBody, i, varData);
                StringBuilder sb = new StringBuilder();
                out.append(this.generateFields(className, fields, BASE_INDENT));
                this.generateGroups(sb, groups, BASE_INDENT);
                out.append(sb);
                out.append(this.generateVarData(className, varData, BASE_INDENT));
                out.append(CppUtil.closingBraces(this.ir.namespaces().length) + "}\n#endif\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String cppTypeForNumInGroup = CppUtil.cppTypeName(tokens.get(i + 3).encoding().primitiveType());
            CppGenerator.generateGroupClassHeader(sb, groupName, tokens, i, indent + INDENT);
            int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            sb.append(this.generateFields(groupName, fields, indent + INDENT));
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(sb, groups, indent + INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            sb.append(this.generateVarData(CppUtil.formatClassName(groupName), varData, indent + INDENT));
            sb.append(indent).append("    };\n");
            sb.append(CppGenerator.generateGroupProperty(groupName, groupToken, cppTypeForNumInGroup, indent));
        }
    }

    private static void generateGroupClassHeader(StringBuilder sb, String groupName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = CppUtil.formatClassName(tokens.get(index + 1).name());
        int dimensionHeaderLength = tokens.get(index + 1).encodedLength();
        int blockLength = tokens.get(index).encodedLength();
        Token numInGroupToken = tokens.get(index + 3);
        String cppTypeForBlockLength = CppUtil.cppTypeName(tokens.get(index + 2).encoding().primitiveType());
        String cppTypeForNumInGroup = CppUtil.cppTypeName(numInGroupToken.encoding().primitiveType());
        sb.append(String.format("\n" + indent + "class %1$s\n" + indent + "{\n" + indent + "private:\n" + indent + "    char *m_buffer;\n" + indent + "    std::uint64_t m_bufferLength;\n" + indent + "    std::uint64_t *m_positionPtr;\n" + indent + "    std::uint64_t m_blockLength;\n" + indent + "    std::uint64_t m_count;\n" + indent + "    std::uint64_t m_index;\n" + indent + "    std::uint64_t m_offset;\n" + indent + "    std::uint64_t m_actingVersion;\n" + indent + "    %2$s m_dimensions;\n\n" + indent + "public:\n\n", CppUtil.formatClassName(groupName), dimensionsClassName));
        sb.append(String.format(indent + "    inline void wrapForDecode(char *buffer, std::uint64_t *pos, const std::uint64_t actingVersion," + " const std::uint64_t bufferLength)\n" + indent + "    {\n" + indent + "        m_buffer = buffer;\n" + indent + "        m_bufferLength = bufferLength;\n" + indent + "        m_dimensions.wrap(m_buffer, *pos, actingVersion, bufferLength);\n" + indent + "        m_blockLength = m_dimensions.blockLength();\n" + indent + "        m_count = m_dimensions.numInGroup();\n" + indent + "        m_index = -1;\n" + indent + "        m_actingVersion = actingVersion;\n" + indent + "        m_positionPtr = pos;\n" + indent + "        *m_positionPtr = *m_positionPtr + %1$d;\n" + indent + "    }\n\n", dimensionHeaderLength));
        sb.append(String.format(indent + "    inline void wrapForEncode(char *buffer, const %3$s count," + " std::uint64_t *pos, const std::uint64_t actingVersion, const std::uint64_t bufferLength)\n" + indent + "    {\n" + indent + "        if (count < %5$d || count > %6$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"count outside of allowed range [E110]\");\n" + indent + "        }\n" + indent + "        m_buffer = buffer;\n" + indent + "        m_bufferLength = bufferLength;\n" + indent + "        m_dimensions.wrap(m_buffer, *pos, actingVersion, bufferLength);\n" + indent + "        m_dimensions.blockLength((%1$s)%2$d);\n" + indent + "        m_dimensions.numInGroup((%3$s)count);\n" + indent + "        m_index = -1;\n" + indent + "        m_count = count;\n" + indent + "        m_blockLength = %2$d;\n" + indent + "        m_actingVersion = actingVersion;\n" + indent + "        m_positionPtr = pos;\n" + indent + "        *m_positionPtr = *m_positionPtr + %4$d;\n" + indent + "    }\n\n", cppTypeForBlockLength, blockLength, cppTypeForNumInGroup, dimensionHeaderLength, numInGroupToken.encoding().applicableMinValue().longValue(), numInGroupToken.encoding().applicableMaxValue().longValue()));
        sb.append(String.format(indent + "    static const std::uint64_t sbeHeaderSize()\n" + indent + "    {\n" + indent + "        return %1$d;\n" + indent + "    }\n\n" + indent + "    static const std::uint64_t sbeBlockLength()\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n" + indent + "    std::uint64_t position(void) const\n" + indent + "    {\n" + indent + "        return *m_positionPtr;\n" + indent + "    }\n\n" + indent + "    void position(const std::uint64_t position)\n" + indent + "    {\n" + indent + "        if (SBE_BOUNDS_CHECK_EXPECT((position > m_bufferLength), false))\n" + indent + "        {\n" + indent + "             throw std::runtime_error(\"buffer too short [E100]\");\n" + indent + "        }\n" + indent + "        *m_positionPtr = position;\n" + indent + "    }\n\n" + indent + "    inline std::uint64_t count(void) const\n" + indent + "    {\n" + indent + "        return m_count;\n" + indent + "    }\n\n" + indent + "    inline bool hasNext(void) const\n" + indent + "    {\n" + indent + "        return m_index + 1 < m_count;\n" + indent + "    }\n\n" + indent + "    inline %3$s &next(void)\n" + indent + "    {\n" + indent + "        m_offset = *m_positionPtr;\n" + indent + "        if (SBE_BOUNDS_CHECK_EXPECT(( (m_offset + m_blockLength) > m_bufferLength ), false))\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"buffer too short to support next group index [E108]\");\n" + indent + "        }\n" + indent + "        *m_positionPtr = m_offset + m_blockLength;\n" + indent + "        ++m_index;\n\n" + indent + "        return *this;\n" + indent + "    }\n\n", dimensionHeaderLength, blockLength, CppUtil.formatClassName(groupName)));
        sb.append(String.format(indent + "#if __cplusplus < 201103L\n" + indent + "    template<class Func> inline void forEach(Func& func)\n" + indent + "    {\n" + indent + "        while(hasNext())\n" + indent + "        {\n" + indent + "            next(); func(*this);\n" + indent + "        }\n" + indent + "    }\n\n" + indent + "#else\n" + indent + "    inline void forEach(std::function<void(%1$s&)> func)\n" + indent + "    {\n" + indent + "        while(hasNext())\n" + indent + "        {\n" + indent + "            next(); func(*this);\n" + indent + "        }\n" + indent + "    }\n\n" + indent + "#endif\n\n", CppUtil.formatClassName(groupName)));
    }

    private static CharSequence generateGroupProperty(String groupName, Token token, String cppTypeForNumInGroup, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = CppUtil.formatClassName(groupName);
        String propertyName = CppUtil.formatPropertyName(groupName);
        sb.append(String.format("\nprivate:\n" + indent + "    %1$s m_%2$s;\n\n" + "public:\n", className, propertyName));
        sb.append(String.format("\n" + indent + "    static const std::uint16_t %1$sId(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", groupName, (long)token.id()));
        sb.append(String.format("\n" + indent + "    inline %1$s &%2$s(void)\n" + indent + "    {\n" + indent + "        m_%2$s.wrapForDecode(m_buffer, m_positionPtr, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", className, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$sCount(const %3$s count)\n" + indent + "    {\n" + indent + "        m_%2$s.wrapForEncode(m_buffer, count, m_positionPtr, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", className, propertyName, cppTypeForNumInGroup));
        return sb;
    }

    private CharSequence generateVarData(String className, List<Token> tokens, String indent) {
        Token token;
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + token);
            }
            String propertyName = CppUtil.toUpperFirstChar(token.name());
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            Token lengthToken = tokens.get(i + 2);
            int lengthOfLengthField = lengthToken.encodedLength();
            String lengthCppType = CppUtil.cppTypeName(lengthToken.encoding().primitiveType());
            CppGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            this.generateVarDataDescriptors(sb, token, propertyName, characterEncoding, lengthToken, lengthOfLengthField, lengthCppType, indent);
            sb.append(String.format(indent + "    const char *%1$s(void)\n" + indent + "    {\n" + "%2$s" + indent + "         const char *fieldPtr = (m_buffer + position() + %3$d);\n" + indent + "         position(position() + %3$d + *((%4$s *)(m_buffer + position())));\n" + indent + "         return fieldPtr;\n" + indent + "    }\n\n", CppUtil.formatPropertyName(propertyName), CppGenerator.generateTypeFieldNotPresentCondition(token.version(), BASE_INDENT), lengthOfLengthField, lengthCppType));
            sb.append(String.format(indent + "    std::uint64_t get%1$s(char *dst, const std::uint64_t length)\n" + indent + "    {\n" + "%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = position();\n" + indent + "        position(lengthPosition + lengthOfLengthField);\n" + indent + "        std::uint64_t dataLength = %4$s(*((%5$s *)(m_buffer + lengthPosition)));\n" + indent + "        std::uint64_t bytesToCopy = (length < dataLength) ? length : dataLength;\n" + indent + "        std::uint64_t pos = position();\n" + indent + "        position(position() + dataLength);\n" + indent + "        std::memcpy(dst, m_buffer + pos, bytesToCopy);\n" + indent + "        return bytesToCopy;\n" + indent + "    }\n\n", propertyName, CppGenerator.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), lengthOfLengthField, CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCppType));
            sb.append(String.format(indent + "    %5$s &put%1$s(const char *src, const %3$s length)\n" + indent + "    {\n" + indent + "        std::uint64_t lengthOfLengthField = %2$d;\n" + indent + "        std::uint64_t lengthPosition = position();\n" + indent + "        position(lengthPosition + lengthOfLengthField);\n" + indent + "        *((%3$s *)(m_buffer + lengthPosition)) = %4$s(length);\n" + indent + "        std::uint64_t pos = position();\n" + indent + "        position(position() + length);\n" + indent + "        std::memcpy(m_buffer + pos, src, length);\n" + indent + "        return *this;\n" + indent + "    }\n\n", propertyName, lengthOfLengthField, lengthCppType, CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), className));
            sb.append(String.format(indent + "    const std::string get%1$sAsString()\n" + indent + "    {\n" + "%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = position();\n" + indent + "        position(lengthPosition + lengthOfLengthField);\n" + indent + "        std::uint64_t dataLength = %4$s(*((%5$s *)(m_buffer + lengthPosition)));\n" + indent + "        std::uint64_t pos = position();\n" + indent + "        const std::string result(m_buffer + pos, dataLength);\n" + indent + "        position(position() + dataLength);\n" + indent + "        return result;\n" + indent + "    }\n\n", propertyName, CppGenerator.generateStringNotPresentCondition(token.version(), BASE_INDENT), lengthOfLengthField, CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCppType));
            sb.append(String.format(indent + "    %1$s &put%2$s(const std::string& str)\n" + indent + "    {\n" + indent + "        if (str.length() > %6$d)\n" + indent + "        {\n" + indent + "             throw std::runtime_error(\"std::string length too long for length type [E109]\");\n" + indent + "        }\n" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = position();\n" + indent + "        position(lengthPosition + lengthOfLengthField);\n" + indent + "        *((%4$s *)(m_buffer + lengthPosition)) = %5$s((%4$s)str.length());\n" + indent + "        std::uint64_t pos = position();\n" + indent + "        position(position() + str.length());\n" + indent + "        std::memcpy(m_buffer + pos, str.c_str(), str.length());\n" + indent + "        return *this;\n" + indent + "    }\n", className, propertyName, lengthOfLengthField, lengthCppType, CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthToken.encoding().applicableMaxValue().longValue()));
        }
        return sb;
    }

    private void generateVarDataDescriptors(StringBuilder sb, Token token, String propertyName, String characterEncoding, Token lengthToken, Integer sizeOfLengthField, String lengthCppType, String indent) {
        sb.append(String.format("\n" + indent + "    static const char *%1$sCharacterEncoding()\n" + indent + "    {\n" + indent + "        return \"%2$s\";\n" + indent + "    }\n\n", CppUtil.toLowerFirstChar(propertyName), characterEncoding));
        sb.append(String.format(indent + "    static const std::uint64_t %1$sSinceVersion(void)\n" + indent + "    {\n" + indent + "         return %2$d;\n" + indent + "    }\n\n" + indent + "    bool %1$sInActingVersion(void)\n" + indent + "    {\n" + indent + "        return (m_actingVersion >= %1$sSinceVersion()) ? true : false;\n" + indent + "    }\n\n" + indent + "    static const std::uint16_t %1$sId(void)\n" + indent + "    {\n" + indent + "        return %3$d;\n" + indent + "    }\n\n", CppUtil.toLowerFirstChar(propertyName), (long)token.version(), token.id()));
        sb.append(String.format("\n" + indent + "    static const std::uint64_t %sHeaderLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", CppUtil.toLowerFirstChar(propertyName), sizeOfLengthField));
        sb.append(String.format("\n" + indent + "    %4$s %1$sLength(void) const\n" + indent + "    {\n" + "%2$s" + indent + "        return %3$s(*((%4$s *)(m_buffer + position())));\n" + indent + "    }\n\n", CppUtil.toLowerFirstChar(propertyName), CppGenerator.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCppType));
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        String bitSetName = CppUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(bitSetName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), bitSetName, null));
            out.append(CppGenerator.generateClassDeclaration(bitSetName));
            out.append(CppGenerator.generateFixedFlyweightCode(bitSetName, tokens.get(0).encodedLength()));
            out.append(String.format("\n    %1$s &clear(void)\n    {\n        *((%2$s *)(m_buffer + m_offset)) = 0;\n        return *this;\n    }\n\n", bitSetName, CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType())));
            out.append(this.generateChoices(bitSetName, tokens.subList(1, tokens.size() - 1)));
            out.append(CppUtil.closingBraces(this.ir.namespaces().length) + "}\n#endif\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CppUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), enumName, null));
            out.append(CppGenerator.generateEnumDeclaration(enumName));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(CppGenerator.generateEnumLookupMethod(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(CppUtil.closingBraces(this.ir.namespaces().length) + "}\n#endif\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = CppUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), compositeName, this.generateTypesToIncludes(tokens.subList(1, tokens.size() - 1))));
            out.append(CppGenerator.generateClassDeclaration(compositeName));
            out.append(CppGenerator.generateFixedFlyweightCode(compositeName, tokens.get(0).encodedLength()));
            out.append(this.generateCompositePropertyElements(compositeName, tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append(CppUtil.closingBraces(this.ir.namespaces().length) + "}\n#endif\n");
        }
    }

    private static CharSequence generateChoiceNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return false;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateChoices(String bitsetClassName, List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        tokens.stream().filter(token -> token.signal() == Signal.CHOICE).forEach(token -> {
            String choiceName = CppUtil.formatPropertyName(token.name());
            String typeName = CppUtil.cppTypeName(token.encoding().primitiveType());
            String choiceBitPosition = token.encoding().constValue().toString();
            String byteOrderStr = CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType());
            sb.append(String.format("\n    bool %1$s(void) const\n    {\n%2$s        return (%3$s(*((%4$s *)(m_buffer + m_offset))) & (0x1L << %5$s)) ? true : false;\n    }\n\n", choiceName, CppGenerator.generateChoiceNotPresentCondition(token.version(), BASE_INDENT), byteOrderStr, typeName, choiceBitPosition));
            sb.append(String.format("    %1$s &%2$s(const bool value)\n    {\n        %3$s bits = %4$s(*((%3$s *)(m_buffer + m_offset)));\n        bits = value ? (bits | (0x1L << %5$s)) : (bits & ~(0x1L << %5$s));\n        *((%3$s *)(m_buffer + m_offset)) = %4$s(bits);\n        return *this;\n    }\n", bitsetClassName, choiceName, typeName, byteOrderStr, choiceBitPosition));
        });
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        sb.append("    enum Value \n    {\n");
        for (Token token : tokens) {
            CharSequence constVal = this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString());
            sb.append("        ").append(token.name()).append(" = ").append(constVal).append(",\n");
        }
        sb.append(String.format("        NULL_VALUE = %1$s", this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString())));
        sb.append("\n    };\n\n");
        return sb;
    }

    private static CharSequence generateEnumLookupMethod(List<Token> tokens, Token encodingToken) {
        String enumName = CppUtil.formatClassName(encodingToken.name());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("    static %1$s::Value get(const %2$s value)\n    {\n        switch (value)\n        {\n", enumName, CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType())));
        for (Token token : tokens) {
            sb.append(String.format("            case %1$s: return %2$s;\n", token.encoding().constValue().toString(), token.name()));
        }
        sb.append(String.format("            case %1$s: return NULL_VALUE;\n        }\n\n        throw std::runtime_error(\"unknown value for enum %2$s [E103]\");\n    }\n", encodingToken.encoding().applicableNullValue().toString(), enumName));
        return sb;
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s;\n" + indent + "        }\n\n", sinceVersion, this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
    }

    private static CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateStringNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return std::string(\"\");\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return nullptr;\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateFileHeader(String[] namespaces, String className, List<String> typesToInclude) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated SBE (Simple Binary Encoding) message codec */\n");
        sb.append(String.format("#ifndef _%1$s_%2$s_H_\n#define _%1$s_%2$s_H_\n\n#if defined(SBE_HAVE_CMATH)\n/* cmath needed for std::numeric_limits<double>::quiet_NaN() */\n#  include <cmath>\n#  define SBE_FLOAT_NAN std::numeric_limits<float>::quiet_NaN()\n#  define SBE_DOUBLE_NAN std::numeric_limits<double>::quiet_NaN()\n#else\n/* math.h needed for NAN */\n#  include <math.h>\n#  define SBE_FLOAT_NAN NAN\n#  define SBE_DOUBLE_NAN NAN\n#endif\n\n#if __cplusplus >= 201103L\n#  include <cstdint>\n#  include <functional>\n#  include <string>\n#  include <cstring>\n#endif\n\n#include <sbe/sbe.h>\n\n", String.join((CharSequence)"_", namespaces).toUpperCase(), className.toUpperCase()));
        if (typesToInclude != null) {
            for (String incName : typesToInclude) {
                sb.append(String.format("#include \"%1$s.h\"\n", CppUtil.toUpperFirstChar(incName)));
            }
            sb.append("\n");
        }
        sb.append("using namespace sbe;\n\nnamespace " + String.join((CharSequence)" {\nnamespace ", namespaces) + " {\n\n");
        return sb;
    }

    private static CharSequence generateClassDeclaration(String className) {
        return String.format("class %s\n{\n", className);
    }

    private static CharSequence generateEnumDeclaration(String name) {
        return "class " + name + "\n{\npublic:\n\n";
    }

    private CharSequence generateCompositePropertyElements(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = CppUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(containingClassName, propertyName, token, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(containingClassName, token, propertyName, token, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(CppGenerator.generateBitsetProperty(propertyName, token, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(CppGenerator.generateCompositeProperty(propertyName, token, indent));
                }
            }
        }
        return sb;
    }

    private CharSequence generatePrimitiveProperty(String containingClassName, String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (token.isConstantEncoding()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(containingClassName, propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String containingClassName, String propertyName, Token token, String indent) {
        int arrayLength = token.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(containingClassName, propertyName, token, indent);
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(containingClassName, propertyName, token, indent);
        }
        return BASE_INDENT;
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = token.encoding();
        PrimitiveType primitiveType = encoding.primitiveType();
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        CharSequence nullValueString = this.generateNullValueLiteral(primitiveType, encoding);
        sb.append(String.format("\n" + indent + "    static const %1$s %2$sNullValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, nullValueString));
        sb.append(String.format("\n" + indent + "    static const %1$s %2$sMinValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString())));
        sb.append(String.format("\n" + indent + "    static const %1$s %2$sMaxValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString())));
        return sb;
    }

    private CharSequence generateSingleValueProperty(String containingClassName, String propertyName, Token token, String indent) {
        String cppTypeName = CppUtil.cppTypeName(token.encoding().primitiveType());
        int offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    %1$s %2$s(void) const\n" + indent + "    {\n" + "%3$s" + indent + "        return %4$s(*((%1$s *)(m_buffer + m_offset + %5$d)));\n" + indent + "    }\n\n", cppTypeName, propertyName, this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), offset));
        sb.append(String.format(indent + "    %1$s &%2$s(const %3$s value)\n" + indent + "    {\n" + indent + "        *((%3$s *)(m_buffer + m_offset + %4$d)) = %5$s(value);\n" + indent + "        return *this;\n" + indent + "    }\n", CppUtil.formatClassName(containingClassName), propertyName, cppTypeName, offset, CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        return sb;
    }

    private CharSequence generateArrayProperty(String containingClassName, String propertyName, Token token, String indent) {
        String cppTypeName = CppUtil.cppTypeName(token.encoding().primitiveType());
        int offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    static const std::uint64_t %1$sLength(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, token.arrayLength()));
        sb.append(String.format(indent + "    const char *%1$s(void) const\n" + indent + "    {\n" + "%2$s" + indent + "        return (m_buffer + m_offset + %3$d);\n" + indent + "    }\n\n", propertyName, CppGenerator.generateTypeFieldNotPresentCondition(token.version(), indent), offset));
        sb.append(String.format(indent + "    %1$s %2$s(const std::uint64_t index) const\n" + indent + "    {\n" + indent + "        if (index >= %3$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"index out of range for %2$s [E104]\");\n" + indent + "        }\n\n" + "%4$s" + indent + "        return %5$s(*((%1$s *)(m_buffer + m_offset + %6$d + (index * %7$d))));\n" + indent + "    }\n\n", cppTypeName, propertyName, token.arrayLength(), this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), offset, token.encoding().primitiveType().size()));
        sb.append(String.format(indent + "    void %1$s(const std::uint64_t index, const %2$s value)\n" + indent + "    {\n" + indent + "        if (index >= %3$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"index out of range for %1$s [E105]\");\n" + indent + "        }\n\n" + indent + "        *((%2$s *)(m_buffer + m_offset + %4$d + (index * %5$d))) = %6$s(value);\n" + indent + "    }\n\n", propertyName, cppTypeName, token.arrayLength(), offset, token.encoding().primitiveType().size(), CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        sb.append(String.format(indent + "    std::uint64_t get%1$s(char *dst, const std::uint64_t length) const\n" + indent + "    {\n" + indent + "        if (length > %2$d)\n" + indent + "        {\n" + indent + "             throw std::runtime_error(\"length too large for get%1$s [E106]\");\n" + indent + "        }\n\n" + "%3$s" + indent + "        std::memcpy(dst, m_buffer + m_offset + %4$d, length);\n" + indent + "        return length;\n" + indent + "    }\n\n", CppUtil.toUpperFirstChar(propertyName), token.arrayLength(), CppGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
        sb.append(String.format(indent + "    %1$s &put%2$s(const char *src)\n" + indent + "    {\n" + indent + "        std::memcpy(m_buffer + m_offset + %3$d, src, %4$d);\n" + indent + "        return *this;\n" + indent + "    }\n\n", containingClassName, CppUtil.toUpperFirstChar(propertyName), offset, token.arrayLength()));
        if (token.encoding().primitiveType() == PrimitiveType.CHAR) {
            sb.append(String.format(indent + "    std::string get%1$sAsString() const\n" + indent + "    {\n" + indent + "        std::string result(m_buffer + m_offset + %2$d, %3$d);\n" + indent + "        return result;\n" + indent + "    }\n\n", CppUtil.toUpperFirstChar(propertyName), offset, token.arrayLength()));
            sb.append(String.format(indent + "    %1$s &put%2$s(const std::string& str)\n" + indent + "    {\n" + indent + "        std::memcpy(m_buffer + m_offset + %3$d, str.c_str(), %4$d);\n" + indent + "        return *this;\n" + indent + "    }\n\n", containingClassName, CppUtil.toUpperFirstChar(propertyName), offset, token.arrayLength()));
        }
        return sb;
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        String cppTypeName = CppUtil.cppTypeName(token.encoding().primitiveType());
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    %1$s %2$s(void) const\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        StringBuilder values = new StringBuilder();
        for (byte b : constantValue) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        sb.append(String.format("\n" + indent + "    static const std::uint64_t %1$sLength(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, constantValue.length));
        sb.append(String.format(indent + "    const char *%1$s(void) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %1$sValues[] = {%2$s};\n\n" + indent + "        return (const char *)%1$sValues;\n" + indent + "    }\n\n", propertyName, values));
        sb.append(String.format(indent + "    %1$s %2$s(const std::uint64_t index) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %2$sValues[] = {%3$s};\n\n" + indent + "        return %2$sValues[index];\n" + indent + "    }\n\n", cppTypeName, propertyName, values));
        sb.append(String.format(indent + "    std::uint64_t get%1$s(char *dst, const std::uint64_t length) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %2$sValues[] = {%3$s};\n" + indent + "        std::uint64_t bytesToCopy = (length < sizeof(%2$sValues)) ? length : sizeof(%2$sValues);\n\n" + indent + "        std::memcpy(dst, %2$sValues, bytesToCopy);\n" + indent + "        return bytesToCopy;\n" + indent + "    }\n", CppUtil.toUpperFirstChar(propertyName), propertyName, values));
        return sb;
    }

    private static CharSequence generateFixedFlyweightCode(String className, int size) {
        return String.format("private:\n    char *m_buffer;\n    std::uint64_t m_bufferLength;\n    std::uint64_t m_offset;\n    std::uint64_t m_actingVersion;\n\n    inline void reset(char *buffer, const std::uint64_t offset, const std::uint64_t bufferLength, const std::uint64_t actingVersion)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT(((offset + %2$s) > bufferLength), false))\n        {\n            throw std::runtime_error(\"buffer too short for flyweight [E107]\");\n        }\n        m_buffer = buffer;\n        m_bufferLength = bufferLength;\n        m_offset = offset;\n        m_actingVersion = actingVersion;\n    }\n\npublic:\n    %1$s(void) : m_buffer(nullptr), m_offset(0) {}\n\n    %1$s(char *buffer, const std::uint64_t bufferLength, const std::uint64_t actingVersion)\n    {\n        reset(buffer, 0, bufferLength, actingVersion);\n    }\n\n    %1$s(const %1$s& codec) :\n        m_buffer(codec.m_buffer), m_offset(codec.m_offset), m_actingVersion(codec.m_actingVersion) {}\n\n#if __cplusplus >= 201103L\n    %1$s(%1$s&& codec) :\n        m_buffer(codec.m_buffer), m_offset(codec.m_offset), m_actingVersion(codec.m_actingVersion) {}\n\n    %1$s& operator=(%1$s&& codec)\n    {\n        m_buffer = codec.m_buffer;\n        m_bufferLength = codec.m_bufferLength;\n        m_offset = codec.m_offset;\n        m_actingVersion = codec.m_actingVersion;\n        return *this;\n    }\n\n#endif\n\n    %1$s& operator=(const %1$s& codec)\n    {\n        m_buffer = codec.m_buffer;\n        m_bufferLength = codec.m_bufferLength;\n        m_offset = codec.m_offset;\n        m_actingVersion = codec.m_actingVersion;\n        return *this;\n    }\n\n    %1$s &wrap(char *buffer, const std::uint64_t offset, const std::uint64_t actingVersion, const std::uint64_t bufferLength)\n    {\n        reset(buffer, offset, bufferLength, actingVersion);\n        return *this;\n    }\n\n    static const std::uint64_t encodedLength(void)\n    {\n        return %2$s;\n    }\n\n", className, size);
    }

    private static CharSequence generateConstructorsAndOperators(String className) {
        return String.format("    %1$s(void) : m_buffer(nullptr), m_bufferLength(0), m_offset(0) {}\n\n    %1$s(char *buffer, const std::uint64_t bufferLength)\n    {\n        reset(buffer, 0, bufferLength, sbeBlockLength(), sbeSchemaVersion());\n    }\n\n    %1$s(char *buffer, const std::uint64_t bufferLength, const std::uint64_t actingBlockLength, const std::uint64_t actingVersion)\n    {\n        reset(buffer, 0, bufferLength, actingBlockLength, actingVersion);\n    }\n\n    %1$s(const %1$s& codec)\n    {\n        reset(codec.m_buffer, codec.m_offset, codec.m_bufferLength, codec.m_actingBlockLength, codec.m_actingVersion);\n    }\n\n#if __cplusplus >= 201103L\n    %1$s(%1$s&& codec)\n    {\n        reset(codec.m_buffer, codec.m_offset, codec.m_bufferLength, codec.m_actingBlockLength, codec.m_actingVersion);\n    }\n\n    %1$s& operator=(%1$s&& codec)\n    {\n        reset(codec.m_buffer, codec.m_offset, codec.m_bufferLength, codec.m_actingBlockLength, codec.m_actingVersion);\n        return *this;\n    }\n\n#endif\n\n    %1$s& operator=(const %1$s& codec)\n    {\n        reset(codec.m_buffer, codec.m_offset, codec.m_bufferLength, codec.m_actingBlockLength, codec.m_actingVersion);\n        return *this;\n    }\n\n", className);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token) {
        String blockLengthType = CppUtil.cppTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = CppUtil.cppTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = CppUtil.cppTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CppUtil.cppTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        return String.format("private:\n    char *m_buffer;\n    std::uint64_t m_bufferLength;\n    std::uint64_t *m_positionPtr;\n    std::uint64_t m_offset;\n    std::uint64_t m_position;\n    std::uint64_t m_actingBlockLength;\n    std::uint64_t m_actingVersion;\n\n    inline void reset(\n        char *buffer, const std::uint64_t offset, const std::uint64_t bufferLength,\n        const std::uint64_t actingBlockLength, const std::uint64_t actingVersion)\n    {\n        m_buffer = buffer;\n        m_offset = offset;\n        m_bufferLength = bufferLength;\n        m_actingBlockLength = actingBlockLength;\n        m_actingVersion = actingVersion;\n        m_positionPtr = &m_position;\n        position(offset + m_actingBlockLength);\n    }\n\npublic:\n\n%11$s    static const %1$s sbeBlockLength(void)\n    {\n        return %2$s;\n    }\n\n    static const %3$s sbeTemplateId(void)\n    {\n        return %4$s;\n    }\n\n    static const %5$s sbeSchemaId(void)\n    {\n        return %6$s;\n    }\n\n    static const %7$s sbeSchemaVersion(void)\n    {\n        return %8$s;\n    }\n\n    static const char *sbeSemanticType(void)\n    {\n        return \"%9$s\";\n    }\n\n    std::uint64_t offset(void) const\n    {\n        return m_offset;\n    }\n\n    %10$s &wrapForEncode(char *buffer, const std::uint64_t offset, const std::uint64_t bufferLength)\n    {\n        reset(buffer, offset, bufferLength, sbeBlockLength(), sbeSchemaVersion());\n        return *this;\n    }\n\n    %10$s &wrapForDecode(\n         char *buffer, const std::uint64_t offset, const std::uint64_t actingBlockLength,\n         const std::uint64_t actingVersion, const std::uint64_t bufferLength)\n    {\n        reset(buffer, offset, bufferLength, actingBlockLength, actingVersion);\n        return *this;\n    }\n\n    std::uint64_t position(void) const\n    {\n        return m_position;\n    }\n\n    void position(const std::uint64_t position)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT((position > m_bufferLength), false))\n        {\n            throw std::runtime_error(\"buffer too short [E100]\");\n        }\n        m_position = position;\n    }\n\n    std::uint64_t encodedLength(void) const\n    {\n        return position() - m_offset;\n    }\n\n    char *buffer(void)\n    {\n        return m_buffer;\n    }\n\n    std::uint64_t actingVersion(void) const\n    {\n        return m_actingVersion;\n    }\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(token.version())), semanticType, className, CppGenerator.generateConstructorsAndOperators(className));
    }

    private CharSequence generateFields(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = CppUtil.formatPropertyName(signalToken.name());
            sb.append(String.format("\n" + indent + "    static const std::uint16_t %1$sId(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, signalToken.id()));
            sb.append(String.format(indent + "    static const std::uint64_t %1$sSinceVersion(void)\n" + indent + "    {\n" + indent + "         return %2$d;\n" + indent + "    }\n\n" + indent + "    bool %1$sInActingVersion(void)\n" + indent + "    {\n" + indent + "        return (m_actingVersion >= %1$sSinceVersion()) ? true : false;\n" + indent + "    }\n\n", propertyName, (long)signalToken.version()));
            CppGenerator.generateFieldMetaAttributeMethod(sb, signalToken, indent);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(containingClassName, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(containingClassName, signalToken, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(CppGenerator.generateBitsetProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(CppGenerator.generateCompositeProperty(propertyName, encodingToken, indent));
                }
            }
        }
        return sb;
    }

    private static void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append(String.format("\n" + indent + "    static const char *%sMetaAttribute(const MetaAttribute::Attribute metaAttribute)\n" + indent + "    {\n" + indent + "        switch (metaAttribute)\n" + indent + "        {\n" + indent + "            case MetaAttribute::EPOCH: return \"%s\";\n" + indent + "            case MetaAttribute::TIME_UNIT: return \"%s\";\n" + indent + "            case MetaAttribute::SEMANTIC_TYPE: return \"%s\";\n" + indent + "        }\n\n" + indent + "        return \"\";\n" + indent + "    }\n", token.name(), epoch, timeUnit, semanticType));
    }

    private static CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s::NULL_VALUE;\n" + indent + "        }\n\n", sinceVersion, enumName);
    }

    private CharSequence generateEnumProperty(String containingClassName, Token signalToken, String propertyName, Token token, String indent) {
        String enumName = CppUtil.formatClassName(token.name());
        String typeName = CppUtil.cppTypeName(token.encoding().primitiveType());
        int offset = token.offset();
        StringBuilder sb = new StringBuilder();
        if (token.isConstantEncoding()) {
            String constValue = signalToken.encoding().constValue().toString();
            sb.append(String.format("\n" + indent + "    %1$s::Value %2$s(void) const\n" + indent + "    {\n" + "%3$s" + indent + "        return %1$s::Value::%4$s;\n" + indent + "    }\n\n", enumName, propertyName, CppGenerator.generateEnumFieldNotPresentCondition(token.version(), enumName, indent), constValue.substring(constValue.indexOf(".") + 1)));
        } else {
            sb.append(String.format("\n" + indent + "    %1$s::Value %2$s(void) const\n" + indent + "    {\n" + "%3$s" + indent + "        return %1$s::get(%4$s(*((%5$s *)(m_buffer + m_offset + %6$d))));\n" + indent + "    }\n\n", enumName, propertyName, CppGenerator.generateEnumFieldNotPresentCondition(token.version(), enumName, indent), CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), typeName, offset));
            sb.append(String.format(indent + "    %1$s &%2$s(const %3$s::Value value)\n" + indent + "    {\n" + indent + "        *((%4$s *)(m_buffer + m_offset + %5$d)) = %6$s(value);\n" + indent + "        return *this;\n" + indent + "    }\n", CppUtil.formatClassName(containingClassName), propertyName, enumName, typeName, offset, CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        }
        return sb;
    }

    private static Object generateBitsetProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String bitsetName = CppUtil.formatClassName(token.name());
        int offset = token.offset();
        sb.append(String.format("\n" + indent + "private:\n" + indent + "    %1$s m_%2$s;\n\n" + indent + "public:\n", bitsetName, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$s()\n" + indent + "    {\n" + indent + "        m_%2$s.wrap(m_buffer, m_offset + %3$d, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", bitsetName, propertyName, offset));
        return sb;
    }

    private static Object generateCompositeProperty(String propertyName, Token token, String indent) {
        String compositeName = CppUtil.formatClassName(token.name());
        int offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\nprivate:\n" + indent + "    %1$s m_%2$s;\n\n" + "public:\n", compositeName, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$s(void)\n" + indent + "    {\n" + indent + "        m_%2$s.wrap(m_buffer, m_offset + %3$d, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", compositeName, propertyName, offset));
        return sb;
    }

    private CharSequence generateNullValueLiteral(PrimitiveType primitiveType, Encoding encoding) {
        if (null == encoding.nullValue()) {
            switch (primitiveType) {
                case CHAR: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                case INT8: {
                    return "SBE_NULLVALUE_INT8";
                }
                case INT16: {
                    return "SBE_NULLVALUE_INT16";
                }
                case INT32: {
                    return "SBE_NULLVALUE_INT32";
                }
                case INT64: {
                    return "SBE_NULLVALUE_INT64";
                }
                case UINT8: {
                    return "SBE_NULLVALUE_UINT8";
                }
                case UINT16: {
                    return "SBE_NULLVALUE_UINT16";
                }
                case UINT32: {
                    return "SBE_NULLVALUE_UINT32";
                }
                case UINT64: {
                    return "SBE_NULLVALUE_UINT64";
                }
            }
        }
        return this.generateLiteral(primitiveType, encoding.applicableNullValue().toString());
    }

    private CharSequence generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        String castType = CppUtil.cppTypeName(type);
        switch (type) {
            case CHAR: 
            case INT8: 
            case INT16: 
            case UINT8: 
            case UINT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case INT32: 
            case UINT32: {
                literal = value;
                break;
            }
            case FLOAT: {
                literal = value.endsWith("NaN") ? "SBE_FLOAT_NAN" : value + "f";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "SBE_DOUBLE_NAN" : value;
            }
        }
        return literal;
    }
}

