/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.Map;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.SchemaTransformer;

class IdKeyedSchemaTransformer
implements SchemaTransformer {
    private final Map<Integer, SchemaTransformer> transformerBySchemaId;
    private final SchemaTransformer defaultTransformer;

    IdKeyedSchemaTransformer(Map<Integer, SchemaTransformer> transformerBySchemaId, SchemaTransformer defaultTransformer) {
        this.transformerBySchemaId = transformerBySchemaId;
        this.defaultTransformer = defaultTransformer;
    }

    @Override
    public MessageSchema transform(MessageSchema originalSchema) {
        return this.lookupTransformer(originalSchema.id()).transform(originalSchema);
    }

    SchemaTransformer lookupTransformer(int schemaId) {
        return this.transformerBySchemaId.getOrDefault(schemaId, this.defaultTransformer);
    }
}

