/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.Strings;
import org.agrona.Verify;
import org.agrona.collections.MutableBoolean;
import org.agrona.generation.DynamicPackageOutputManager;
import org.agrona.sbe.CompositeDecoderFlyweight;
import org.agrona.sbe.CompositeEncoderFlyweight;
import org.agrona.sbe.Flyweight;
import org.agrona.sbe.MessageDecoderFlyweight;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.common.FieldPrecedenceModel;
import uk.co.real_logic.sbe.generation.common.PrecedenceChecks;
import uk.co.real_logic.sbe.generation.java.JavaUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class JavaGenerator
implements CodeGenerator {
    static final String MESSAGE_HEADER_ENCODER_TYPE = "MessageHeaderEncoder";
    static final String MESSAGE_HEADER_DECODER_TYPE = "MessageHeaderDecoder";
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String PACKAGE_INFO = "package-info";
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private static final Set<String> PACKAGES_EMPTY_SET = Collections.emptySet();
    private final Ir ir;
    private final DynamicPackageOutputManager outputManager;
    private final String fqMutableBuffer;
    private final String mutableBuffer;
    private final String fqReadOnlyBuffer;
    private final String readOnlyBuffer;
    private final boolean shouldGenerateGroupOrderAnnotation;
    private final boolean shouldGenerateInterfaces;
    private final boolean shouldDecodeUnknownEnumValues;
    private final boolean shouldSupportTypesPackageNames;
    private final PrecedenceChecks precedenceChecks;
    private final String precedenceChecksFlagName;
    private final String precedenceChecksPropName;
    private final Set<String> packageNameByTypes = new HashSet<String>();

    public JavaGenerator(Ir ir, String mutableBuffer, String readOnlyBuffer, boolean shouldGenerateGroupOrderAnnotation, boolean shouldGenerateInterfaces, boolean shouldDecodeUnknownEnumValues, DynamicPackageOutputManager outputManager) {
        this(ir, mutableBuffer, readOnlyBuffer, shouldGenerateGroupOrderAnnotation, shouldGenerateInterfaces, shouldDecodeUnknownEnumValues, false, outputManager);
    }

    public JavaGenerator(Ir ir, String mutableBuffer, String readOnlyBuffer, boolean shouldGenerateGroupOrderAnnotation, boolean shouldGenerateInterfaces, boolean shouldDecodeUnknownEnumValues, boolean shouldSupportTypesPackageNames, DynamicPackageOutputManager outputManager) {
        this(ir, mutableBuffer, readOnlyBuffer, shouldGenerateGroupOrderAnnotation, shouldGenerateInterfaces, shouldDecodeUnknownEnumValues, shouldSupportTypesPackageNames, PrecedenceChecks.newInstance(new PrecedenceChecks.Context()), outputManager);
    }

    public JavaGenerator(Ir ir, String mutableBuffer, String readOnlyBuffer, boolean shouldGenerateGroupOrderAnnotation, boolean shouldGenerateInterfaces, boolean shouldDecodeUnknownEnumValues, boolean shouldSupportTypesPackageNames, PrecedenceChecks precedenceChecks, DynamicPackageOutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        Verify.notNull(precedenceChecks, "precedenceChecks");
        this.ir = ir;
        this.shouldSupportTypesPackageNames = shouldSupportTypesPackageNames;
        this.outputManager = outputManager;
        this.mutableBuffer = JavaGenerator.validateBufferImplementation(mutableBuffer, MutableDirectBuffer.class);
        this.fqMutableBuffer = mutableBuffer;
        this.readOnlyBuffer = JavaGenerator.validateBufferImplementation(readOnlyBuffer, DirectBuffer.class);
        this.fqReadOnlyBuffer = readOnlyBuffer;
        this.shouldGenerateGroupOrderAnnotation = shouldGenerateGroupOrderAnnotation;
        this.shouldGenerateInterfaces = shouldGenerateInterfaces;
        this.shouldDecodeUnknownEnumValues = shouldDecodeUnknownEnumValues;
        this.precedenceChecks = precedenceChecks;
        this.precedenceChecksFlagName = precedenceChecks.context().precedenceChecksFlagName();
        this.precedenceChecksPropName = precedenceChecks.context().precedenceChecksPropName();
    }

    public void generateMessageHeaderStub() throws IOException {
        this.generateComposite(this.ir.headerStructure().tokens());
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                    break;
                }
            }
        }
    }

    private String registerTypesPackageName(Token token, Ir ir) {
        if (!this.shouldSupportTypesPackageNames) {
            return ir.applicableNamespace();
        }
        if (token.packageName() != null) {
            this.packageNameByTypes.add(token.packageName());
            this.outputManager.setPackageName(token.packageName());
            return token.packageName();
        }
        return ir.applicableNamespace();
    }

    @Override
    public void generate() throws IOException {
        this.packageNameByTypes.clear();
        this.generatePackageInfo();
        this.generateTypeStubs();
        this.generateMessageHeaderStub();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            List<Token> messageBody = GenerationUtil.getMessageBody(tokens);
            boolean hasVarData = -1 != GenerationUtil.findSignal(messageBody, Signal.BEGIN_VAR_DATA);
            int i = 0;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(messageBody, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(messageBody, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, i, varData);
            String decoderClassName = JavaUtil.formatClassName(JavaUtil.decoderName(msgToken.name()));
            String decoderStateClassName = decoderClassName + "#CodecStates";
            FieldPrecedenceModel decoderPrecedenceModel = this.precedenceChecks.createDecoderModel(decoderStateClassName, tokens);
            this.generateDecoder(decoderClassName, msgToken, fields, groups, varData, hasVarData, decoderPrecedenceModel);
            String encoderClassName = JavaUtil.formatClassName(JavaUtil.encoderName(msgToken.name()));
            String encoderStateClassName = encoderClassName + "#CodecStates";
            FieldPrecedenceModel encoderPrecedenceModel = this.precedenceChecks.createEncoderModel(encoderStateClassName, tokens);
            this.generateEncoder(encoderClassName, msgToken, fields, groups, varData, hasVarData, encoderPrecedenceModel);
        }
    }

    private void generateEncoder(String className, Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData, boolean hasVarData, FieldPrecedenceModel fieldPrecedenceModel) throws IOException {
        String implementsString = this.implementsInterface(MessageEncoderFlyweight.class.getSimpleName());
        try (Writer out = this.outputManager.createOutput(className);){
            out.append(this.generateMainHeader(this.ir.applicableNamespace(), CodecType.ENCODER, hasVarData));
            if (this.shouldGenerateGroupOrderAnnotation) {
                this.generateAnnotations(BASE_INDENT, className, groups, out, JavaUtil::encoderName);
            }
            out.append(JavaGenerator.generateDeclaration(className, implementsString, msgToken));
            out.append(this.generateFieldOrderStates(fieldPrecedenceModel));
            out.append(this.generateEncoderFlyweightCode(className, fieldPrecedenceModel, msgToken));
            StringBuilder sb = new StringBuilder();
            this.generateEncoderFields(sb, className, fieldPrecedenceModel, fields, BASE_INDENT);
            this.generateEncoderGroups(sb, className, fieldPrecedenceModel, groups, BASE_INDENT, false);
            this.generateEncoderVarData(sb, className, fieldPrecedenceModel, varData, BASE_INDENT);
            this.generateEncoderDisplay(sb, JavaUtil.decoderName(msgToken.name()));
            this.generateFullyEncodedCheck(sb, fieldPrecedenceModel);
            out.append(sb);
            out.append("}\n");
        }
    }

    private static CharSequence qualifiedStateCase(FieldPrecedenceModel.State state) {
        return "CodecStates." + state.name();
    }

    private static CharSequence stateCaseForSwitchCase(FieldPrecedenceModel.State state) {
        return JavaGenerator.qualifiedStateCase(state);
    }

    private static CharSequence unqualifiedStateCase(FieldPrecedenceModel.State state) {
        return state.name();
    }

    private CharSequence generateFieldOrderStates(FieldPrecedenceModel fieldPrecedenceModel) {
        if (null == fieldPrecedenceModel) {
            return BASE_INDENT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    private static final boolean ENABLE_BOUNDS_CHECKS = ").append("!Boolean.getBoolean(\"agrona.disable.bounds.checks\");\n\n");
        sb.append("    private static final boolean ").append(this.precedenceChecksFlagName).append(" = ").append("Boolean.parseBoolean(System.getProperty(\n").append("        \"").append(this.precedenceChecksPropName).append("\",\n").append("        Boolean.toString(ENABLE_BOUNDS_CHECKS)));\n\n");
        sb.append("    /**\n");
        sb.append("     * The states in which a encoder/decoder/codec can live.\n");
        sb.append("     *\n");
        sb.append("     * <p>The state machine diagram below, encoded in the dot language, describes\n");
        sb.append("     * the valid state transitions according to the order in which fields may be\n");
        sb.append("     * accessed safely. Tools such as PlantUML and Graphviz can render it.\n");
        sb.append("     *\n");
        sb.append("     * <pre>{@code\n");
        fieldPrecedenceModel.generateGraph(sb, "     *   ");
        sb.append("     * }</pre>\n");
        sb.append("     */\n");
        sb.append("    private static class CodecStates\n").append("    {\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> sb.append("        private static final int ").append(JavaGenerator.unqualifiedStateCase(state)).append(" = ").append(state.number()).append(";\n"));
        sb.append("\n").append("        private static final String[] STATE_NAME_LOOKUP =\n").append("        {\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> sb.append("            \"").append(state.name()).append("\",\n"));
        sb.append("        };\n\n");
        sb.append("        private static final String[] STATE_TRANSITIONS_LOOKUP =\n").append("        {\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> {
            sb.append("            \"");
            MutableBoolean isFirst = new MutableBoolean(true);
            HashSet transitionDescriptions = new HashSet();
            fieldPrecedenceModel.forEachTransitionFrom((FieldPrecedenceModel.State)state, transitionGroup -> {
                if (transitionDescriptions.add(transitionGroup.exampleCode())) {
                    if (isFirst.get()) {
                        isFirst.set(false);
                    } else {
                        sb.append(", ");
                    }
                    sb.append("\\\"").append(transitionGroup.exampleCode()).append("\\\"");
                }
            });
            sb.append("\",\n");
        });
        sb.append("        };\n\n");
        sb.append("        private static String name(final int state)\n").append("        {\n").append("            return STATE_NAME_LOOKUP[state];\n").append("        }\n\n");
        sb.append("        private static String transitions(final int state)\n").append("        {\n").append("            return STATE_TRANSITIONS_LOOKUP[state];\n").append("        }\n");
        sb.append("    }\n\n");
        sb.append("    private int codecState = ").append(JavaGenerator.qualifiedStateCase(fieldPrecedenceModel.notWrappedState())).append(";\n\n");
        sb.append("    private int codecState()\n").append("    {\n").append("        return codecState;\n").append("    }\n\n");
        sb.append("    private void codecState(int newState)\n").append("    {\n").append("        codecState = newState;\n").append("    }\n\n");
        return sb;
    }

    private void generateFullyEncodedCheck(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n");
        sb.append("    public void checkEncodingIsComplete()\n").append("    {\n").append("        if (").append(this.precedenceChecksFlagName).append(")\n").append("        {\n").append("            switch (codecState)\n").append("            {\n");
        fieldPrecedenceModel.forEachTerminalEncoderState(state -> sb.append("                case ").append(JavaGenerator.stateCaseForSwitchCase(state)).append(":\n").append("                    return;\n"));
        sb.append("                default:\n").append("                    throw new IllegalStateException(\"Not fully encoded, current state: \" +\n").append("                        CodecStates.name(codecState) + \", allowed transitions: \" +\n").append("                        CodecStates.transitions(codecState));\n").append("            }\n").append("        }\n").append("    }\n\n");
    }

    private static String accessOrderListenerMethodName(Token token) {
        return "on" + Generators.toUpperFirstChar(token.name()) + "Accessed";
    }

    private static String accessOrderListenerMethodName(Token token, String suffix) {
        return "on" + Generators.toUpperFirstChar(token.name()) + suffix + "Accessed";
    }

    private static void generateAccessOrderListenerMethod(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("private void ").append(JavaGenerator.accessOrderListenerMethodName(token)).append("()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction fieldAccess = fieldPrecedenceModel.interactionFactory().accessField(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + INDENT, "access field", fieldPrecedenceModel, fieldAccess);
        sb.append(indent).append("}\n");
    }

    private CharSequence generateAccessOrderListenerCall(FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token, String ... arguments) {
        return this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent, JavaGenerator.accessOrderListenerMethodName(token), arguments);
    }

    private CharSequence generateAccessOrderListenerCall(FieldPrecedenceModel fieldPrecedenceModel, String indent, String methodName, String ... arguments) {
        if (null == fieldPrecedenceModel) {
            return BASE_INDENT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("if (").append(this.precedenceChecksFlagName).append(")\n").append(indent).append("{\n").append(indent).append(INDENT).append(methodName).append("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arguments[i]);
        }
        sb.append(");\n");
        sb.append(indent).append("}\n\n");
        return sb;
    }

    private static void generateAccessOrderListenerMethodForGroupWrap(StringBuilder sb, String action, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("private void ").append(JavaGenerator.accessOrderListenerMethodName(token)).append("(final int count)\n").append(indent).append("{\n").append(indent).append("    if (count == 0)\n").append(indent).append("    {\n");
        FieldPrecedenceModel.CodecInteraction selectEmptyGroup = fieldPrecedenceModel.interactionFactory().determineGroupIsEmpty(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + "        ", action + " count of repeating group", fieldPrecedenceModel, selectEmptyGroup);
        sb.append(indent).append("    }\n").append(indent).append("    else\n").append(indent).append("    {\n");
        FieldPrecedenceModel.CodecInteraction selectNonEmptyGroup = fieldPrecedenceModel.interactionFactory().determineGroupHasElements(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + "        ", action + " count of repeating group", fieldPrecedenceModel, selectNonEmptyGroup);
        sb.append(indent).append("    }\n").append(indent).append("}\n");
    }

    private static void generateAccessOrderListener(StringBuilder sb, String indent, String action, FieldPrecedenceModel fieldPrecedenceModel, FieldPrecedenceModel.CodecInteraction interaction) {
        if (interaction.isTopLevelBlockFieldAccess()) {
            sb.append(indent).append("if (codecState() == ").append(JavaGenerator.qualifiedStateCase(fieldPrecedenceModel.notWrappedState())).append(")\n").append(indent).append("{\n");
            JavaGenerator.generateAccessOrderException(sb, indent + INDENT, action, fieldPrecedenceModel, interaction);
            sb.append(indent).append("}\n");
        } else {
            sb.append(indent).append("switch (codecState())\n").append(indent).append("{\n");
            fieldPrecedenceModel.forEachTransition(interaction, transitionGroup -> {
                transitionGroup.forEachStartState(startState -> sb.append(indent).append("    case ").append(JavaGenerator.stateCaseForSwitchCase(startState)).append(":\n"));
                sb.append(indent).append("        codecState(").append(JavaGenerator.qualifiedStateCase(transitionGroup.endState())).append(");\n").append(indent).append("        break;\n");
            });
            sb.append(indent).append("    default:\n");
            JavaGenerator.generateAccessOrderException(sb, indent + "        ", action, fieldPrecedenceModel, interaction);
            sb.append(indent).append("}\n");
        }
    }

    private static void generateAccessOrderException(StringBuilder sb, String indent, String action, FieldPrecedenceModel fieldPrecedenceModel, FieldPrecedenceModel.CodecInteraction interaction) {
        sb.append(indent).append("throw new IllegalStateException(").append("\"Illegal field access order. \" +\n").append(indent).append("    \"Cannot ").append(action).append(" \\\"").append(interaction.groupQualifiedName()).append("\\\" in state: \" + CodecStates.name(codecState()) +\n").append(indent).append("    \". Expected one of these transitions: [\" + CodecStates.transitions(codecState()) +\n").append(indent).append("    \"]. Please see the diagram in the Javadoc of the class ").append(fieldPrecedenceModel.generatedRepresentationClassName()).append(".\");\n");
    }

    private static void generateAccessOrderListenerMethodForNextGroupElement(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append(indent).append("private void onNextElementAccessed()\n").append(indent).append("{\n").append(indent).append("    final int remaining = ").append("count - index").append(";\n").append(indent).append("    if (remaining > 1)\n").append(indent).append("    {\n");
        FieldPrecedenceModel.CodecInteraction selectNextElementInGroup = fieldPrecedenceModel.interactionFactory().moveToNextElement(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + "       ", "access next element in repeating group", fieldPrecedenceModel, selectNextElementInGroup);
        sb.append(indent).append("    }\n").append(indent).append("    else if (remaining == 1)\n").append(indent).append("    {\n");
        FieldPrecedenceModel.CodecInteraction selectLastElementInGroup = fieldPrecedenceModel.interactionFactory().moveToLastElement(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + "        ", "access next element in repeating group", fieldPrecedenceModel, selectLastElementInGroup);
        sb.append(indent).append("    }\n").append(indent).append("}\n\n");
    }

    private static void generateAccessOrderListenerMethodForResetGroupCount(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append(indent).append("private void onResetCountToIndex()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction resetCountToIndex = fieldPrecedenceModel.interactionFactory().resetCountToIndex(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + "   ", "reset count of repeating group", fieldPrecedenceModel, resetCountToIndex);
        sb.append(indent).append("}\n\n");
    }

    private static void generateAccessOrderListenerMethodForVarDataLength(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("void ").append(JavaGenerator.accessOrderListenerMethodName(token, "Length")).append("()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction accessLength = fieldPrecedenceModel.interactionFactory().accessVarDataLength(token);
        JavaGenerator.generateAccessOrderListener(sb, indent + INDENT, "decode length of var data", fieldPrecedenceModel, accessLength);
        sb.append(indent).append("}\n");
    }

    private static CharSequence generateDecoderWrapListener(FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        if (null == fieldPrecedenceModel) {
            return BASE_INDENT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("private void onWrap(final int actingVersion)\n").append(indent).append("{\n");
        fieldPrecedenceModel.forEachWrappedStateByVersionDesc((version, state) -> sb.append(indent).append("    if (actingVersion >= ").append(version).append(")\n").append(indent).append("    {\n").append(indent).append("        codecState(").append(JavaGenerator.qualifiedStateCase(state)).append(");\n").append(indent).append("        return;\n").append(indent).append("    }\n\n"));
        sb.append(indent).append("    throw new IllegalStateException(\"Unsupported acting version: \" + actingVersion);\n").append(indent).append("}\n\n");
        return sb;
    }

    private CharSequence generateEncoderWrapListener(FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        if (null == fieldPrecedenceModel) {
            return BASE_INDENT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("if (").append(this.precedenceChecksFlagName).append(")").append("\n").append(indent).append("{\n").append(indent).append("    codecState(").append(JavaGenerator.qualifiedStateCase(fieldPrecedenceModel.latestVersionWrappedState())).append(");\n").append(indent).append("}\n\n");
        return sb;
    }

    private void generateDecoder(String className, Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData, boolean hasVarData, FieldPrecedenceModel fieldPrecedenceModel) throws IOException {
        String implementsString = this.implementsInterface(MessageDecoderFlyweight.class.getSimpleName());
        try (Writer out = this.outputManager.createOutput(className);){
            out.append(this.generateMainHeader(this.ir.applicableNamespace(), CodecType.DECODER, hasVarData));
            if (this.shouldGenerateGroupOrderAnnotation) {
                this.generateAnnotations(BASE_INDENT, className, groups, out, JavaUtil::decoderName);
            }
            out.append(JavaGenerator.generateDeclaration(className, implementsString, msgToken));
            out.append(this.generateFieldOrderStates(fieldPrecedenceModel));
            out.append(this.generateDecoderFlyweightCode(fieldPrecedenceModel, className, msgToken));
            StringBuilder sb = new StringBuilder();
            this.generateDecoderFields(sb, fieldPrecedenceModel, fields, BASE_INDENT);
            this.generateDecoderGroups(sb, fieldPrecedenceModel, className, groups, BASE_INDENT, false);
            this.generateDecoderVarData(sb, fieldPrecedenceModel, varData, BASE_INDENT);
            this.generateDecoderDisplay(sb, msgToken.name(), fields, groups, varData);
            this.generateMessageLength(sb, className, true, groups, varData, BASE_INDENT);
            out.append(sb);
            out.append("}\n");
        }
    }

    private void generateDecoderGroups(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String outerClassName, List<Token> tokens, String indent, boolean isSubGroup) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + String.valueOf(groupToken));
            }
            int index = i++;
            String groupName = JavaUtil.decoderName(JavaUtil.formatClassName(groupToken.name()));
            int groupHeaderTokenCount = tokens.get(i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateGroupDecoderProperty(sb, groupName, fieldPrecedenceModel, groupToken, indent, isSubGroup);
            JavaUtil.generateTypeJavadoc(sb, indent + INDENT, groupToken);
            if (this.shouldGenerateGroupOrderAnnotation) {
                this.generateAnnotations(indent + INDENT, groupName, groups, sb, JavaUtil::decoderName);
            }
            this.generateGroupDecoderClassHeader(sb, groupName, outerClassName, fieldPrecedenceModel, groupToken, tokens, groups, index, indent + INDENT);
            this.generateDecoderFields(sb, fieldPrecedenceModel, fields, indent + INDENT);
            this.generateDecoderGroups(sb, fieldPrecedenceModel, outerClassName, groups, indent + INDENT, true);
            this.generateDecoderVarData(sb, fieldPrecedenceModel, varData, indent + INDENT);
            this.appendGroupInstanceDecoderDisplay(sb, fields, groups, varData, indent + INDENT);
            this.generateMessageLength(sb, groupName, false, groups, varData, indent + INDENT);
            sb.append(indent).append("    }\n");
        }
    }

    private void generateEncoderGroups(StringBuilder sb, String outerClassName, FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent, boolean isSubGroup) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + String.valueOf(groupToken));
            }
            int index = i++;
            String groupName = groupToken.name();
            String groupClassName = JavaUtil.encoderName(groupName);
            int groupHeaderTokenCount = tokens.get(i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateGroupEncoderProperty(sb, groupName, fieldPrecedenceModel, groupToken, indent, isSubGroup);
            JavaUtil.generateTypeJavadoc(sb, indent + INDENT, groupToken);
            if (this.shouldGenerateGroupOrderAnnotation) {
                this.generateAnnotations(indent + INDENT, groupClassName, groups, sb, JavaUtil::encoderName);
            }
            this.generateGroupEncoderClassHeader(sb, groupName, outerClassName, fieldPrecedenceModel, groupToken, tokens, groups, index, indent + INDENT);
            this.generateEncoderFields(sb, groupClassName, fieldPrecedenceModel, fields, indent + INDENT);
            this.generateEncoderGroups(sb, outerClassName, fieldPrecedenceModel, groups, indent + INDENT, true);
            this.generateEncoderVarData(sb, groupClassName, fieldPrecedenceModel, varData, indent + INDENT);
            sb.append(indent).append("    }\n");
        }
    }

    private void generateGroupDecoderClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, FieldPrecedenceModel fieldPrecedenceModel, Token groupToken, List<Token> tokens, List<Token> subGroupTokens, int index, String indent) {
        String className = JavaUtil.formatClassName(groupName);
        int dimensionHeaderLen = tokens.get(index + 1).encodedLength();
        Token blockLengthToken = Generators.findFirst("blockLength", tokens, index);
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        PrimitiveType blockLengthType = blockLengthToken.encoding().primitiveType();
        String blockLengthOffset = "limit + " + blockLengthToken.offset();
        String blockLengthGet = this.generateGet(blockLengthType, blockLengthOffset, this.byteOrderString(blockLengthToken.encoding()));
        PrimitiveType numInGroupType = numInGroupToken.encoding().primitiveType();
        String numInGroupOffset = "limit + " + numInGroupToken.offset();
        String numInGroupGet = this.generateGet(numInGroupType, numInGroupOffset, this.byteOrderString(numInGroupToken.encoding()));
        this.generateGroupDecoderClassDeclaration(sb, groupName, parentMessageClassName, GenerationUtil.findSubGroupNames(subGroupTokens), indent, dimensionHeaderLen);
        String blockLenCast = PrimitiveType.UINT32 == blockLengthType ? "(int)" : BASE_INDENT;
        String numInGroupCast = PrimitiveType.UINT32 == numInGroupType ? "(int)" : BASE_INDENT;
        sb.append("\n").append(indent).append("    public void wrap(final ").append(this.readOnlyBuffer).append(" buffer)\n").append(indent).append("    {\n").append(indent).append("        if (buffer != this.buffer)\n").append(indent).append("        {\n").append(indent).append("            this.buffer = buffer;\n").append(indent).append("        }\n\n").append(indent).append("        index = 0;\n").append(indent).append("        final int limit = parentMessage.limit();\n").append(indent).append("        parentMessage.limit(limit + HEADER_SIZE);\n").append(indent).append("        blockLength = ").append(blockLenCast).append(blockLengthGet).append(";\n").append(indent).append("        count = ").append(numInGroupCast).append(numInGroupGet).append(";\n").append(indent).append("    }\n\n");
        JavaGenerator.generateAccessOrderListenerMethodForNextGroupElement(sb, fieldPrecedenceModel, indent + INDENT, groupToken);
        sb.append(indent).append("    public ").append(className).append(" next()\n").append(indent).append("    {\n").append(indent).append("        if (index >= count)\n").append(indent).append("        {\n").append(indent).append("            throw new java.util.NoSuchElementException();\n").append(indent).append("        }\n\n").append(this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", "onNextElementAccessed", new String[0])).append(indent).append("        offset = parentMessage.limit();\n").append(indent).append("        parentMessage.limit(offset + blockLength);\n").append(indent).append("        ++index;\n\n").append(indent).append("        return this;\n").append(indent).append("    }\n");
        String numInGroupJavaTypeName = JavaUtil.javaTypeName(numInGroupType);
        String numInGroupMinValue = JavaUtil.generateLiteral(numInGroupType, numInGroupToken.encoding().applicableMinValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, indent, numInGroupJavaTypeName, "count", "Min", numInGroupMinValue);
        String numInGroupMaxValue = JavaUtil.generateLiteral(numInGroupType, numInGroupToken.encoding().applicableMaxValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, indent, numInGroupJavaTypeName, "count", "Max", numInGroupMaxValue);
        sb.append("\n").append(indent).append("    public static int sbeHeaderSize()\n").append(indent).append("    {\n").append(indent).append("        return HEADER_SIZE;\n").append(indent).append("    }\n");
        sb.append("\n").append(indent).append("    public static int sbeBlockLength()\n").append(indent).append("    {\n").append(indent).append("        return ").append(tokens.get(index).encodedLength()).append(";\n").append(indent).append("    }\n");
        sb.append("\n").append(indent).append("    public int actingBlockLength()\n").append(indent).append("    {\n").append(indent).append("        return blockLength;\n").append(indent).append("    }\n\n").append(indent).append("    public int actingVersion()\n").append(indent).append("    {\n").append(indent).append("        return parentMessage.actingVersion;\n").append(indent).append("    }\n\n").append(indent).append("    public int count()\n").append(indent).append("    {\n").append(indent).append("        return count;\n").append(indent).append("    }\n\n").append(indent).append("    public java.util.Iterator<").append(className).append("> iterator()\n").append(indent).append("    {\n").append(indent).append("        return this;\n").append(indent).append("    }\n\n").append(indent).append("    public void remove()\n").append(indent).append("    {\n").append(indent).append("        throw new UnsupportedOperationException();\n").append(indent).append("    }\n\n").append(indent).append("    public boolean hasNext()\n").append(indent).append("    {\n").append(indent).append("        return index < count;\n").append(indent).append("    }\n");
        if (null != fieldPrecedenceModel) {
            sb.append("\n").append(indent).append("    private int codecState()\n").append(indent).append("    {\n").append(indent).append("        return parentMessage.codecState();\n").append(indent).append("    }\n");
            sb.append("\n").append(indent).append("    private void codecState(final int newState)\n").append(indent).append("    {\n").append(indent).append("        parentMessage.codecState(newState);\n").append(indent).append("    }\n");
        }
    }

    private void generateGroupEncoderClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, FieldPrecedenceModel fieldPrecedenceModel, Token groupToken, List<Token> tokens, List<Token> subGroupTokens, int index, String ind) {
        int dimensionHeaderSize = tokens.get(index + 1).encodedLength();
        this.generateGroupEncoderClassDeclaration(sb, groupName, parentMessageClassName, GenerationUtil.findSubGroupNames(subGroupTokens), ind, dimensionHeaderSize);
        int blockLength = tokens.get(index).encodedLength();
        Token blockLengthToken = Generators.findFirst("blockLength", tokens, index);
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        PrimitiveType blockLengthType = blockLengthToken.encoding().primitiveType();
        String blockLengthOffset = "limit + " + blockLengthToken.offset();
        String blockLengthValue = Integer.toString(blockLength);
        String blockLengthPut = this.generatePut(blockLengthType, blockLengthOffset, blockLengthValue, this.byteOrderString(blockLengthToken.encoding()));
        PrimitiveType numInGroupType = numInGroupToken.encoding().primitiveType();
        PrimitiveType numInGroupTypeCast = PrimitiveType.UINT32 == numInGroupType ? PrimitiveType.INT32 : numInGroupType;
        String numInGroupOffset = "limit + " + numInGroupToken.offset();
        String numInGroupValue = "count";
        String numInGroupPut = this.generatePut(numInGroupTypeCast, numInGroupOffset, "count", this.byteOrderString(numInGroupToken.encoding()));
        new Formatter(sb).format("\n" + ind + "    public void wrap(final %2$s buffer, final int count)\n" + ind + "    {\n" + ind + "        if (count < %3$d || count > %4$d)\n" + ind + "        {\n" + ind + "            throw new IllegalArgumentException(\"count outside allowed range: count=\" + count);\n" + ind + "        }\n\n" + ind + "        if (buffer != this.buffer)\n" + ind + "        {\n" + ind + "            this.buffer = buffer;\n" + ind + "        }\n\n" + ind + "        index = 0;\n" + ind + "        this.count = count;\n" + ind + "        final int limit = parentMessage.limit();\n" + ind + "        initialLimit = limit;\n" + ind + "        parentMessage.limit(limit + HEADER_SIZE);\n" + ind + "        %5$s;\n" + ind + "        %6$s;\n" + ind + "    }\n\n", parentMessageClassName, this.mutableBuffer, numInGroupToken.encoding().applicableMinValue().longValue(), numInGroupToken.encoding().applicableMaxValue().longValue(), blockLengthPut, numInGroupPut);
        JavaGenerator.generateAccessOrderListenerMethodForNextGroupElement(sb, fieldPrecedenceModel, ind + INDENT, groupToken);
        JavaGenerator.generateAccessOrderListenerMethodForResetGroupCount(sb, fieldPrecedenceModel, ind + INDENT, groupToken);
        sb.append(ind).append("    public ").append(JavaUtil.encoderName(groupName)).append(" next()\n").append(ind).append("    {\n").append(this.generateAccessOrderListenerCall(fieldPrecedenceModel, ind + "        ", "onNextElementAccessed", new String[0])).append(ind).append("        if (index >= count)\n").append(ind).append("        {\n").append(ind).append("            throw new java.util.NoSuchElementException();\n").append(ind).append("        }\n\n").append(ind).append("        offset = parentMessage.limit();\n").append(ind).append("        parentMessage.limit(offset + sbeBlockLength());\n").append(ind).append("        ++index;\n\n").append(ind).append("        return this;\n").append(ind).append("    }\n\n");
        String countOffset = "initialLimit + " + numInGroupToken.offset();
        String resetCountPut = this.generatePut(numInGroupTypeCast, countOffset, "count", this.byteOrderString(numInGroupToken.encoding()));
        sb.append(ind).append("    public int resetCountToIndex()\n").append(ind).append("    {\n").append(this.generateAccessOrderListenerCall(fieldPrecedenceModel, ind + "        ", "onResetCountToIndex", new String[0])).append(ind).append("        count = index;\n").append(ind).append("        ").append(resetCountPut).append(";\n\n").append(ind).append("        return count;\n").append(ind).append("    }\n");
        String numInGroupJavaTypeName = JavaUtil.javaTypeName(numInGroupType);
        String numInGroupMinValue = JavaUtil.generateLiteral(numInGroupType, numInGroupToken.encoding().applicableMinValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, ind, numInGroupJavaTypeName, "count", "Min", numInGroupMinValue);
        String numInGroupMaxValue = JavaUtil.generateLiteral(numInGroupType, numInGroupToken.encoding().applicableMaxValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, ind, numInGroupJavaTypeName, "count", "Max", numInGroupMaxValue);
        sb.append("\n").append(ind).append("    public static int sbeHeaderSize()\n").append(ind).append("    {\n").append(ind).append("        return HEADER_SIZE;\n").append(ind).append("    }\n");
        sb.append("\n").append(ind).append("    public static int sbeBlockLength()\n").append(ind).append("    {\n").append(ind).append("        return ").append(blockLength).append(";\n").append(ind).append("    }\n");
        if (null != fieldPrecedenceModel) {
            sb.append("\n").append(ind).append("    private int codecState()\n").append(ind).append("    {\n").append(ind).append("        return parentMessage.codecState();\n").append(ind).append("    }\n");
            sb.append("\n").append(ind).append("    private void codecState(final int newState)\n").append(ind).append("    {\n").append(ind).append("        parentMessage.codecState(newState);\n").append(ind).append("    }\n");
        }
    }

    private static String primitiveTypeName(Token token) {
        return JavaUtil.javaTypeName(token.encoding().primitiveType());
    }

    private void generateGroupDecoderClassDeclaration(StringBuilder sb, String groupName, String parentMessageClassName, List<String> subGroupNames, String indent, int dimensionHeaderSize) {
        String field;
        String type;
        String className = JavaUtil.formatClassName(groupName);
        new Formatter(sb).format("\n" + indent + "public static final class %1$s\n" + indent + "    implements Iterable<%1$s>, java.util.Iterator<%1$s>\n" + indent + "{\n" + indent + "    public static final int HEADER_SIZE = %2$d;\n" + indent + "    private final %3$s parentMessage;\n" + indent + "    private %4$s buffer;\n" + indent + "    private int count;\n" + indent + "    private int index;\n" + indent + "    private int offset;\n" + indent + "    private int blockLength;\n", className, dimensionHeaderSize, parentMessageClassName, this.readOnlyBuffer);
        for (String subGroupName : subGroupNames) {
            type = JavaUtil.formatClassName(JavaUtil.decoderName(subGroupName));
            field = JavaUtil.formatPropertyName(subGroupName);
            sb.append(indent).append("    private final ").append(type).append(" ").append(field).append(";\n");
        }
        sb.append("\n").append(indent).append(INDENT).append(className).append("(final ").append(parentMessageClassName).append(" parentMessage)\n").append(indent).append("    {\n").append(indent).append("        this.parentMessage = parentMessage;\n");
        for (String subGroupName : subGroupNames) {
            type = JavaUtil.formatClassName(JavaUtil.decoderName(subGroupName));
            field = JavaUtil.formatPropertyName(subGroupName);
            sb.append(indent).append("        ").append(field).append(" = new ").append(type).append("(parentMessage);\n");
        }
        sb.append(indent).append("    }\n");
    }

    private void generateGroupEncoderClassDeclaration(StringBuilder sb, String groupName, String parentMessageClassName, List<String> subGroupNames, String indent, int dimensionHeaderSize) {
        String field;
        String type;
        String className = JavaUtil.encoderName(groupName);
        new Formatter(sb).format("\n" + indent + "public static final class %1$s\n" + indent + "{\n" + indent + "    public static final int HEADER_SIZE = %2$d;\n" + indent + "    private final %3$s parentMessage;\n" + indent + "    private %4$s buffer;\n" + indent + "    private int count;\n" + indent + "    private int index;\n" + indent + "    private int offset;\n" + indent + "    private int initialLimit;\n", className, dimensionHeaderSize, parentMessageClassName, this.mutableBuffer);
        for (String subGroupName : subGroupNames) {
            type = JavaUtil.encoderName(subGroupName);
            field = JavaUtil.formatPropertyName(subGroupName);
            sb.append(indent).append("    private final ").append(type).append(" ").append(field).append(";\n");
        }
        sb.append("\n").append(indent).append(INDENT).append(className).append("(final ").append(parentMessageClassName).append(" parentMessage)\n").append(indent).append("    {\n").append(indent).append("        this.parentMessage = parentMessage;\n");
        for (String subGroupName : subGroupNames) {
            type = JavaUtil.encoderName(subGroupName);
            field = JavaUtil.formatPropertyName(subGroupName);
            sb.append(indent).append("        ").append(field).append(" = new ").append(type).append("(parentMessage);\n");
        }
        sb.append(indent).append("    }\n");
    }

    private void generateGroupDecoderProperty(StringBuilder sb, String groupName, FieldPrecedenceModel fieldPrecedenceModel, Token token, String indent, boolean isSubGroup) {
        String className = JavaUtil.formatClassName(groupName);
        String propertyName = JavaUtil.formatPropertyName(token.name());
        if (!isSubGroup) {
            new Formatter(sb).format("\n" + indent + "    private final %s %s = new %s(this);\n", className, propertyName, className);
        }
        new Formatter(sb).format("\n" + indent + "    public static long %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(groupName), token.id());
        new Formatter(sb).format("\n" + indent + "    public static int %sSinceVersion()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(groupName), token.version());
        String actingVersionGuard = token.version() == 0 ? BASE_INDENT : indent + "        if (parentMessage.actingVersion < " + token.version() + ")\n" + indent + "        {\n" + indent + "            " + propertyName + ".count = 0;\n" + indent + "            " + propertyName + ".index = 0;\n" + indent + "            return " + propertyName + ";\n" + indent + "        }\n\n";
        JavaGenerator.generateAccessOrderListenerMethodForGroupWrap(sb, "decode", fieldPrecedenceModel, indent + INDENT, token);
        JavaUtil.generateFlyweightPropertyJavadoc(sb, indent + INDENT, token, className);
        new Formatter(sb).format("\n" + indent + "    public %1$s %2$s()\n" + indent + "    {\n%3$s" + indent + "        %2$s.wrap(buffer);\n%4$s" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName, actingVersionGuard, this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", token, propertyName + ".count"));
    }

    private void generateGroupEncoderProperty(StringBuilder sb, String groupName, FieldPrecedenceModel fieldPrecedenceModel, Token token, String indent, boolean isSubGroup) {
        String className = JavaUtil.formatClassName(JavaUtil.encoderName(groupName));
        String propertyName = JavaUtil.formatPropertyName(groupName);
        if (!isSubGroup) {
            new Formatter(sb).format("\n" + indent + "    private final %s %s = new %s(this);\n", className, propertyName, className);
        }
        new Formatter(sb).format("\n" + indent + "    public static long %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(groupName), token.id());
        JavaGenerator.generateAccessOrderListenerMethodForGroupWrap(sb, "encode", fieldPrecedenceModel, indent + INDENT, token);
        JavaUtil.generateGroupEncodePropertyJavadoc(sb, indent + INDENT, token, className);
        new Formatter(sb).format("\n" + indent + "    public %1$s %2$sCount(final int count)\n" + indent + "    {\n%3$s" + indent + "        %2$s.wrap(buffer, count);\n" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName, this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", token, "count"));
    }

    private void generateDecoderVarData(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        Token token;
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + String.valueOf(token));
            }
            JavaGenerator.generateFieldIdMethod(sb, token, indent);
            JavaGenerator.generateFieldSinceVersionMethod(sb, token, indent);
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            JavaGenerator.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = Generators.toUpperFirstChar(token.name());
            Token lengthToken = tokens.get(i + 2);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            PrimitiveType lengthType = lengthEncoding.primitiveType();
            String byteOrderStr = this.byteOrderString(lengthEncoding);
            String methodPropName = Generators.toLowerFirstChar(propertyName);
            sb.append("\n").append(indent).append("    public static int ").append(methodPropName).append("HeaderLength()\n").append(indent).append("    {\n").append(indent).append("        return ").append(sizeOfLengthField).append(";\n").append(indent).append("    }\n");
            JavaGenerator.generateAccessOrderListenerMethodForVarDataLength(sb, fieldPrecedenceModel, indent + INDENT, token);
            CharSequence lengthAccessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", JavaGenerator.accessOrderListenerMethodName(token, "Length"), new String[0]);
            JavaGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent + INDENT, token);
            sb.append("\n").append(indent).append("    public int ").append(methodPropName).append("Length()\n").append(indent).append("    {\n").append(JavaGenerator.generateArrayFieldNotPresentCondition(false, token.version(), indent)).append(lengthAccessOrderListenerCall).append(indent).append("        final int limit = parentMessage.limit();\n").append(indent).append("        return ").append(PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT).append(this.generateGet(lengthType, "limit", byteOrderStr)).append(";\n").append(indent).append("    }\n");
            CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", token, new String[0]);
            this.generateDataDecodeMethods(sb, token, propertyName, sizeOfLengthField, lengthType, byteOrderStr, characterEncoding, accessOrderListenerCall, indent);
        }
    }

    private void generateEncoderVarData(StringBuilder sb, String className, FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        Token token;
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + String.valueOf(token));
            }
            JavaGenerator.generateFieldIdMethod(sb, token, indent);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            JavaGenerator.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = Generators.toUpperFirstChar(token.name());
            Token lengthToken = Generators.findFirst("length", tokens, i);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            int maxLengthValue = (int)lengthEncoding.applicableMaxValue().longValue();
            String byteOrderStr = this.byteOrderString(lengthEncoding);
            String methodPropName = Generators.toLowerFirstChar(propertyName);
            sb.append("\n").append(indent).append("    public static int ").append(methodPropName).append("HeaderLength()\n").append(indent).append("    {\n").append(indent).append("        return ").append(sizeOfLengthField).append(";\n").append(indent).append("    }\n");
            JavaGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent + INDENT, token);
            CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", token, new String[0]);
            this.generateDataEncodeMethods(sb, propertyName, accessOrderListenerCall, sizeOfLengthField, maxLengthValue, lengthEncoding.primitiveType(), byteOrderStr, characterEncoding, className, indent);
        }
    }

    private void generateDataDecodeMethods(StringBuilder sb, Token token, String propertyName, int sizeOfLengthField, PrimitiveType lengthType, String byteOrderStr, String characterEncoding, CharSequence accessOrderListenerCall, String indent) {
        new Formatter(sb).format("\n" + indent + "    public int skip%1$s()\n" + indent + "    {\n%2$s%6$s" + indent + "        final int headerLength = %3$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = %4$s%5$s;\n" + indent + "        final int dataOffset = limit + headerLength;\n" + indent + "        parentMessage.limit(dataOffset + dataLength);\n\n" + indent + "        return dataLength;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), JavaGenerator.generateStringNotPresentConditionForAppendable(false, token.version(), indent), sizeOfLengthField, PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT, this.generateGet(lengthType, "limit", byteOrderStr), accessOrderListenerCall);
        this.generateVarDataTypedDecoder(sb, token, propertyName, sizeOfLengthField, this.mutableBuffer, lengthType, byteOrderStr, accessOrderListenerCall, indent);
        this.generateVarDataTypedDecoder(sb, token, propertyName, sizeOfLengthField, "byte[]", lengthType, byteOrderStr, accessOrderListenerCall, indent);
        this.generateVarDataWrapDecoder(sb, token, propertyName, sizeOfLengthField, lengthType, byteOrderStr, accessOrderListenerCall, indent);
        if (null != characterEncoding) {
            new Formatter(sb).format("\n" + indent + "    public String %1$s()\n" + indent + "    {\n%2$s%7$s" + indent + "        final int headerLength = %3$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = %4$s%5$s;\n" + indent + "        parentMessage.limit(limit + headerLength + dataLength);\n\n" + indent + "        if (0 == dataLength)\n" + indent + "        {\n" + indent + "            return \"\";\n" + indent + "        }\n\n" + indent + "        final byte[] tmp = new byte[dataLength];\n" + indent + "        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);\n\n" + indent + "        return new String(tmp, %6$s);\n" + indent + "    }\n", JavaUtil.formatPropertyName(propertyName), JavaGenerator.generateStringNotPresentCondition(false, token.version(), indent), sizeOfLengthField, PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT, this.generateGet(lengthType, "limit", byteOrderStr), JavaUtil.charset(characterEncoding), accessOrderListenerCall);
            if (JavaUtil.isAsciiEncoding(characterEncoding)) {
                new Formatter(sb).format("\n" + indent + "    public int get%1$s(final Appendable appendable)\n" + indent + "    {\n%2$s%6$s" + indent + "        final int headerLength = %3$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = %4$s%5$s;\n" + indent + "        final int dataOffset = limit + headerLength;\n\n" + indent + "        parentMessage.limit(dataOffset + dataLength);\n" + indent + "        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);\n\n" + indent + "        return dataLength;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), JavaGenerator.generateStringNotPresentConditionForAppendable(false, token.version(), indent), sizeOfLengthField, PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT, this.generateGet(lengthType, "limit", byteOrderStr), accessOrderListenerCall);
            }
        }
    }

    private void generateVarDataWrapDecoder(StringBuilder sb, Token token, String propertyName, int sizeOfLengthField, PrimitiveType lengthType, String byteOrderStr, CharSequence accessOrderListenerCall, String indent) {
        new Formatter(sb).format("\n" + indent + "    public void wrap%s(final %s wrapBuffer)\n" + indent + "    {\n%s%s" + indent + "        final int headerLength = %d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = %s%s;\n" + indent + "        parentMessage.limit(limit + headerLength + dataLength);\n" + indent + "        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);\n" + indent + "    }\n", propertyName, this.readOnlyBuffer, this.generateWrapFieldNotPresentCondition(false, token.version(), indent), accessOrderListenerCall, sizeOfLengthField, PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT, this.generateGet(lengthType, "limit", byteOrderStr));
    }

    private void generateDataEncodeMethods(StringBuilder sb, String propertyName, CharSequence accessOrderListenerCall, int sizeOfLengthField, int maxLengthValue, PrimitiveType lengthType, String byteOrderStr, String characterEncoding, String className, String indent) {
        this.generateDataTypedEncoder(sb, className, propertyName, accessOrderListenerCall, sizeOfLengthField, maxLengthValue, this.readOnlyBuffer, lengthType, byteOrderStr, indent);
        this.generateDataTypedEncoder(sb, className, propertyName, accessOrderListenerCall, sizeOfLengthField, maxLengthValue, "byte[]", lengthType, byteOrderStr, indent);
        if (null != characterEncoding) {
            this.generateCharArrayEncodeMethods(sb, propertyName, accessOrderListenerCall, sizeOfLengthField, maxLengthValue, lengthType, byteOrderStr, characterEncoding, className, indent);
        }
    }

    private void generateCharArrayEncodeMethods(StringBuilder sb, String propertyName, CharSequence accessOrderListenerCall, int sizeOfLengthField, int maxLengthValue, PrimitiveType lengthType, String byteOrderStr, String characterEncoding, String className, String indent) {
        PrimitiveType lengthPutType;
        PrimitiveType primitiveType = lengthPutType = PrimitiveType.UINT32 == lengthType ? PrimitiveType.INT32 : lengthType;
        if (JavaUtil.isAsciiEncoding(characterEncoding)) {
            new Formatter(sb).format("\n" + indent + "    public %1$s %2$s(final String value)\n" + indent + "    {\n" + indent + "        final int length = null == value ? 0 : value.length();\n" + indent + "        if (length > %3$d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%6$s" + indent + "        final int headerLength = %4$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %5$s;\n" + indent + "        buffer.putStringWithoutLengthAscii(limit + headerLength, value);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, JavaUtil.formatPropertyName(propertyName), maxLengthValue, sizeOfLengthField, this.generatePut(lengthPutType, "limit", "length", byteOrderStr), accessOrderListenerCall);
            new Formatter(sb).format("\n" + indent + "    public %1$s %2$s(final CharSequence value)\n" + indent + "    {\n" + indent + "        final int length = null == value ? 0 : value.length();\n" + indent + "        if (length > %3$d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%6$s" + indent + "        final int headerLength = %4$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %5$s;\n" + indent + "        buffer.putStringWithoutLengthAscii(limit + headerLength, value);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, JavaUtil.formatPropertyName(propertyName), maxLengthValue, sizeOfLengthField, this.generatePut(lengthPutType, "limit", "length", byteOrderStr), accessOrderListenerCall);
        } else {
            new Formatter(sb).format("\n" + indent + "    public %1$s %2$s(final String value)\n" + indent + "    {\n" + indent + "        final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(%3$s);\n\n" + indent + "        final int length = bytes.length;\n" + indent + "        if (length > %4$d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%7$s" + indent + "        final int headerLength = %5$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %6$s;\n" + indent + "        buffer.putBytes(limit + headerLength, bytes, 0, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, JavaUtil.formatPropertyName(propertyName), JavaUtil.charset(characterEncoding), maxLengthValue, sizeOfLengthField, this.generatePut(lengthPutType, "limit", "length", byteOrderStr), accessOrderListenerCall);
        }
    }

    private void generateVarDataTypedDecoder(StringBuilder sb, Token token, String propertyName, int sizeOfLengthField, String exchangeType, PrimitiveType lengthType, String byteOrderStr, CharSequence accessOrderListenerCall, String indent) {
        new Formatter(sb).format("\n" + indent + "    public int get%s(final %s dst, final int dstOffset, final int length)\n" + indent + "    {\n%s%s" + indent + "        final int headerLength = %d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = %s%s;\n" + indent + "        final int bytesCopied = Math.min(length, dataLength);\n" + indent + "        parentMessage.limit(limit + headerLength + dataLength);\n" + indent + "        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", propertyName, exchangeType, JavaGenerator.generateArrayFieldNotPresentCondition(false, token.version(), indent), accessOrderListenerCall, sizeOfLengthField, PrimitiveType.UINT32 == lengthType ? "(int)" : BASE_INDENT, this.generateGet(lengthType, "limit", byteOrderStr));
    }

    private void generateDataTypedEncoder(StringBuilder sb, String className, String propertyName, CharSequence accessOrderListenerCall, int sizeOfLengthField, int maxLengthValue, String exchangeType, PrimitiveType lengthType, String byteOrderStr, String indent) {
        PrimitiveType lengthPutType = PrimitiveType.UINT32 == lengthType ? PrimitiveType.INT32 : lengthType;
        new Formatter(sb).format("\n" + indent + "    public %1$s put%2$s(final %3$s src, final int srcOffset, final int length)\n" + indent + "    {\n" + indent + "        if (length > %4$d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%7$s" + indent + "        final int headerLength = %5$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %6$s;\n" + indent + "        buffer.putBytes(limit + headerLength, src, srcOffset, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, propertyName, exchangeType, maxLengthValue, sizeOfLengthField, this.generatePut(lengthPutType, "limit", "length", byteOrderStr), accessOrderListenerCall);
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        Token token = tokens.get(0);
        String bitSetName = token.applicableTypeName();
        String decoderName = JavaUtil.decoderName(bitSetName);
        String encoderName = JavaUtil.encoderName(bitSetName);
        List<Token> choiceList = tokens.subList(1, tokens.size() - 1);
        String implementsString = this.implementsInterface(Flyweight.class.getSimpleName());
        this.registerTypesPackageName(token, this.ir);
        try (Writer out = this.outputManager.createOutput(decoderName);){
            Encoding encoding = token.encoding();
            this.generateFixedFlyweightHeader(out, token, decoderName, implementsString, this.readOnlyBuffer, this.fqReadOnlyBuffer, PACKAGES_EMPTY_SET);
            out.append(this.generateChoiceIsEmpty(encoding.primitiveType()));
            new Formatter(out).format("\n    public %s getRaw()\n    {\n        return %s;\n    }\n", JavaGenerator.primitiveTypeName(token), this.generateGet(encoding.primitiveType(), "offset", this.byteOrderString(encoding)));
            this.generateChoiceDecoders(out, choiceList);
            out.append(this.generateChoiceDisplay(choiceList));
            out.append("}\n");
        }
        this.registerTypesPackageName(token, this.ir);
        out = this.outputManager.createOutput(encoderName);
        try {
            this.generateFixedFlyweightHeader(out, token, encoderName, implementsString, this.mutableBuffer, this.fqMutableBuffer, PACKAGES_EMPTY_SET);
            this.generateChoiceClear(out, encoderName, token);
            this.generateChoiceEncoders(out, encoderName, choiceList);
            out.append("}\n");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void generateFixedFlyweightHeader(Writer out, Token token, String typeName, String implementsString, String buffer, String fqBuffer, Set<String> importedTypesPackages) throws IOException {
        out.append(this.generateFileHeader(this.registerTypesPackageName(token, this.ir), importedTypesPackages, fqBuffer));
        out.append(JavaGenerator.generateDeclaration(typeName, implementsString, token));
        out.append(this.generateFixedFlyweightCode(typeName, token.encodedLength(), buffer));
    }

    private void generateCompositeFlyweightHeader(Token token, String typeName, Writer out, String buffer, String fqBuffer, String implementsString, Set<String> importedTypesPackages) throws IOException {
        out.append(this.generateFileHeader(this.registerTypesPackageName(token, this.ir), importedTypesPackages, fqBuffer));
        out.append(JavaGenerator.generateDeclaration(typeName, implementsString, token));
        out.append(this.generateFixedFlyweightCode(typeName, token.encodedLength(), buffer));
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = JavaUtil.formatClassName(enumToken.applicableTypeName());
        Encoding encoding = enumToken.encoding();
        String nullVal = encoding.applicableNullValue().toString();
        String packageName = this.registerTypesPackageName(enumToken, this.ir);
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(JavaGenerator.generateEnumFileHeader(packageName));
            out.append(JavaGenerator.generateEnumDeclaration(enumName, enumToken));
            List<Token> valuesList = tokens.subList(1, tokens.size() - 1);
            out.append(this.generateEnumValues(valuesList, JavaUtil.generateLiteral(encoding.primitiveType(), nullVal)));
            out.append(this.generateEnumBody(enumToken, enumName));
            out.append(this.generateEnumLookupMethod(valuesList, enumName, nullVal));
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String accessOrderListenerCall;
        StringBuilder sb;
        String typeName;
        String propertyName;
        int i;
        Token encodingToken;
        int end;
        String implementsString;
        Token token = tokens.get(0);
        String compositeName = token.applicableTypeName();
        String decoderName = JavaUtil.decoderName(compositeName);
        String encoderName = JavaUtil.encoderName(compositeName);
        this.registerTypesPackageName(token, this.ir);
        Set<String> importedTypesPackages = this.scanPackagesToImport(tokens);
        try (Writer out = this.outputManager.createOutput(decoderName);){
            implementsString = this.implementsInterface(CompositeDecoderFlyweight.class.getSimpleName());
            this.generateCompositeFlyweightHeader(token, decoderName, out, this.readOnlyBuffer, this.fqReadOnlyBuffer, implementsString, importedTypesPackages);
            end = tokens.size() - 1;
            for (i = 1; i < end; i += encodingToken.componentTokenCount()) {
                encodingToken = tokens.get(i);
                propertyName = JavaUtil.formatPropertyName(encodingToken.name());
                typeName = JavaUtil.decoderName(encodingToken.applicableTypeName());
                sb = new StringBuilder();
                JavaGenerator.generateEncodingOffsetMethod(sb, propertyName, encodingToken.offset(), BASE_INDENT);
                JavaGenerator.generateEncodingLengthMethod(sb, propertyName, encodingToken.encodedLength(), BASE_INDENT);
                JavaGenerator.generateFieldSinceVersionMethod(sb, encodingToken, BASE_INDENT);
                accessOrderListenerCall = BASE_INDENT;
                switch (encodingToken.signal()) {
                    case ENCODING: {
                        this.generatePrimitiveDecoder(sb, true, encodingToken.name(), BASE_INDENT, encodingToken, encodingToken, BASE_INDENT);
                        break;
                    }
                    case BEGIN_ENUM: {
                        this.generateEnumDecoder(sb, true, BASE_INDENT, encodingToken, propertyName, encodingToken, BASE_INDENT);
                        break;
                    }
                    case BEGIN_SET: {
                        this.generateBitSetProperty(sb, true, CodecType.DECODER, propertyName, BASE_INDENT, encodingToken, encodingToken, BASE_INDENT, typeName);
                        break;
                    }
                    case BEGIN_COMPOSITE: {
                        this.generateCompositeProperty(sb, true, CodecType.DECODER, propertyName, BASE_INDENT, encodingToken, encodingToken, BASE_INDENT, typeName);
                        break;
                    }
                }
                out.append(sb);
            }
            out.append(this.generateCompositeDecoderDisplay(tokens));
            out.append("}\n");
        }
        this.registerTypesPackageName(token, this.ir);
        out = this.outputManager.createOutput(encoderName);
        try {
            implementsString = this.implementsInterface(CompositeEncoderFlyweight.class.getSimpleName());
            this.generateCompositeFlyweightHeader(token, encoderName, out, this.mutableBuffer, this.fqMutableBuffer, implementsString, importedTypesPackages);
            end = tokens.size() - 1;
            for (i = 1; i < end; i += encodingToken.componentTokenCount()) {
                encodingToken = tokens.get(i);
                propertyName = JavaUtil.formatPropertyName(encodingToken.name());
                typeName = JavaUtil.encoderName(encodingToken.applicableTypeName());
                sb = new StringBuilder();
                JavaGenerator.generateEncodingOffsetMethod(sb, propertyName, encodingToken.offset(), BASE_INDENT);
                JavaGenerator.generateEncodingLengthMethod(sb, propertyName, encodingToken.encodedLength(), BASE_INDENT);
                accessOrderListenerCall = BASE_INDENT;
                switch (encodingToken.signal()) {
                    case ENCODING: {
                        this.generatePrimitiveEncoder(sb, encoderName, encodingToken.name(), BASE_INDENT, encodingToken, BASE_INDENT);
                        break;
                    }
                    case BEGIN_ENUM: {
                        this.generateEnumEncoder(sb, encoderName, BASE_INDENT, encodingToken, propertyName, encodingToken, BASE_INDENT);
                        break;
                    }
                    case BEGIN_SET: {
                        this.generateBitSetProperty(sb, true, CodecType.ENCODER, propertyName, BASE_INDENT, encodingToken, encodingToken, BASE_INDENT, typeName);
                        break;
                    }
                    case BEGIN_COMPOSITE: {
                        this.generateCompositeProperty(sb, true, CodecType.ENCODER, propertyName, BASE_INDENT, encodingToken, encodingToken, BASE_INDENT, typeName);
                        break;
                    }
                }
                out.append(sb);
            }
            out.append(this.generateCompositeEncoderDisplay(decoderName));
            out.append("}\n");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private Set<String> scanPackagesToImport(List<Token> tokens) {
        if (!this.shouldSupportTypesPackageNames) {
            return PACKAGES_EMPTY_SET;
        }
        HashSet<String> packagesToImport = new HashSet<String>();
        int limit = tokens.size() - 1;
        for (int i = 1; i < limit; ++i) {
            Token typeToken = tokens.get(i);
            if (typeToken.signal() != Signal.BEGIN_ENUM && typeToken.signal() != Signal.BEGIN_SET && typeToken.signal() != Signal.BEGIN_COMPOSITE || typeToken.packageName() == null) continue;
            packagesToImport.add(typeToken.packageName());
        }
        return packagesToImport;
    }

    private void generateChoiceClear(Appendable out, String bitSetClassName, Token token) throws IOException {
        Encoding encoding = token.encoding();
        String literalValue = JavaUtil.generateLiteral(encoding.primitiveType(), "0");
        String byteOrderStr = this.byteOrderString(encoding);
        String clearStr = this.generatePut(encoding.primitiveType(), "offset", literalValue, byteOrderStr);
        out.append("\n").append("    public ").append(bitSetClassName).append(" clear()\n").append("    {\n").append("        ").append(clearStr).append(";\n").append("        return this;\n").append("    }\n");
    }

    private void generateChoiceDecoders(Appendable out, List<Token> tokens) throws IOException {
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = JavaUtil.formatPropertyName(token.name());
            Encoding encoding = token.encoding();
            String choiceBitIndex = encoding.constValue().toString();
            String byteOrderStr = this.byteOrderString(encoding);
            PrimitiveType primitiveType = encoding.primitiveType();
            String argType = this.bitsetArgType(primitiveType);
            JavaUtil.generateOptionDecodeJavadoc(out, INDENT, token);
            String choiceGet = this.generateChoiceGet(primitiveType, choiceBitIndex, byteOrderStr);
            String staticChoiceGet = this.generateStaticChoiceGet(primitiveType, choiceBitIndex);
            out.append("\n").append("    public boolean ").append(choiceName).append("()\n").append("    {\n").append("        return ").append(choiceGet).append(";\n").append("    }\n\n").append("    public static boolean ").append(choiceName).append("(final ").append(argType).append(" value)\n").append("    {\n").append("        return ").append(staticChoiceGet).append(";\n").append("    }\n");
        }
    }

    private void generateChoiceEncoders(Appendable out, String bitSetClassName, List<Token> tokens) throws IOException {
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = JavaUtil.formatPropertyName(token.name());
            Encoding encoding = token.encoding();
            String choiceBitIndex = encoding.constValue().toString();
            String byteOrderStr = this.byteOrderString(encoding);
            PrimitiveType primitiveType = encoding.primitiveType();
            String argType = this.bitsetArgType(primitiveType);
            JavaUtil.generateOptionEncodeJavadoc(out, INDENT, token);
            String choicePut = this.generateChoicePut(encoding.primitiveType(), choiceBitIndex, byteOrderStr);
            String staticChoicePut = this.generateStaticChoicePut(encoding.primitiveType(), choiceBitIndex);
            out.append("\n").append("    public ").append(bitSetClassName).append(" ").append(choiceName).append("(final boolean value)\n").append("    {\n").append(choicePut).append("\n").append("        return this;\n").append("    }\n\n").append("    public static ").append(argType).append(" ").append(choiceName).append("(final ").append(argType).append(" bits, final boolean value)\n").append("    {\n").append(staticChoicePut).append("    }\n");
        }
    }

    private String bitsetArgType(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case UINT8: {
                return "byte";
            }
            case UINT16: {
                return "short";
            }
            case UINT32: {
                return "int";
            }
            case UINT64: {
                return "long";
            }
        }
        throw new IllegalStateException("Invalid type: " + String.valueOf((Object)primitiveType));
    }

    private CharSequence generateEnumValues(List<Token> tokens, String nullVal) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            Encoding encoding = token.encoding();
            String constVal = JavaUtil.generateLiteral(encoding.primitiveType(), encoding.constValue().toString());
            JavaUtil.generateTypeJavadoc(sb, INDENT, token);
            sb.append(INDENT).append(JavaUtil.formatForJavaKeyword(token.name())).append('(').append((CharSequence)constVal).append("),\n\n");
        }
        if (this.shouldDecodeUnknownEnumValues) {
            sb.append(INDENT).append("/**\n");
            sb.append(INDENT).append(" * To be used to represent an unknown value from a later version.\n");
            sb.append(INDENT).append(" */\n");
            sb.append(INDENT).append("SBE_UNKNOWN").append('(').append(nullVal).append("),\n\n");
        }
        sb.append(INDENT).append("/**\n");
        sb.append(INDENT).append(" * To be used to represent not present or null.\n");
        sb.append(INDENT).append(" */\n");
        sb.append(INDENT).append("NULL_VAL").append('(').append(nullVal).append(");\n\n");
        return sb;
    }

    private CharSequence generateEnumBody(Token token, String enumName) {
        String javaEncodingType = JavaGenerator.primitiveTypeName(token);
        return "    private final " + javaEncodingType + " value;\n\n    " + enumName + "(final " + javaEncodingType + " value)\n    {\n        this.value = value;\n    }\n\n    /**\n     * The raw encoded value in the Java type representation.\n     *\n     * @return the raw value encoded.\n     */\n    public " + javaEncodingType + " value()\n    {\n        return value;\n    }\n";
    }

    private CharSequence generateEnumLookupMethod(List<Token> tokens, String enumName, String nullVal) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = tokens.get(0).encoding().primitiveType();
        sb.append("\n").append("    /**\n").append("     * Lookup the enum value representing the value.\n").append("     *\n").append("     * @param value encoded to be looked up.\n").append("     * @return the enum value representing the value.\n").append("     */\n").append("    public static ").append(enumName).append(" get(final ").append(JavaUtil.javaTypeName(primitiveType)).append(" value)\n").append("    {\n").append("        switch (value)\n").append("        {\n");
        for (Token token : tokens) {
            String constStr = token.encoding().constValue().toString();
            String name = JavaUtil.formatForJavaKeyword(token.name());
            sb.append("            case ").append(constStr).append(": return ").append(name).append(";\n");
        }
        sb.append("            case ").append(nullVal).append(": return NULL_VAL").append(";\n");
        String handleUnknownLogic = this.shouldDecodeUnknownEnumValues ? "        return SBE_UNKNOWN;\n" : "        throw new IllegalArgumentException(\"Unknown value: \" + value);\n";
        sb.append("        }\n\n").append(handleUnknownLogic).append("    }\n");
        return sb;
    }

    private StringBuilder generateImportStatements(Set<String> packages, String currentPackage) {
        StringBuilder importStatements = new StringBuilder();
        for (String candidatePackage : packages) {
            if (candidatePackage.equals(currentPackage)) continue;
            importStatements.append("import ").append(candidatePackage).append(".*;\n");
        }
        if (importStatements.length() > 0) {
            importStatements.append("\n\n");
        }
        return importStatements;
    }

    private String interfaceImportLine() {
        if (!this.shouldGenerateInterfaces) {
            return "\n";
        }
        return "import org.agrona.sbe.*;\n\n";
    }

    private CharSequence generateFileHeader(String packageName, Set<String> importedTypesPackages, String fqBuffer) {
        return "/* Generated SBE (Simple Binary Encoding) message codec. */\npackage " + packageName + ";\n\nimport " + fqBuffer + ";\n" + this.interfaceImportLine() + String.valueOf(this.generateImportStatements(importedTypesPackages, packageName));
    }

    private CharSequence generateMainHeader(String packageName, CodecType codecType, boolean hasVarData) {
        StringBuilder importStatements = this.generateImportStatements(this.packageNameByTypes, packageName);
        if (this.fqMutableBuffer.equals(this.fqReadOnlyBuffer)) {
            return "/* Generated SBE (Simple Binary Encoding) message codec. */\npackage " + packageName + ";\n\nimport " + this.fqMutableBuffer + ";\n" + this.interfaceImportLine() + String.valueOf(importStatements);
        }
        boolean hasMutableBuffer = CodecType.ENCODER == codecType || hasVarData;
        boolean hasReadOnlyBuffer = CodecType.DECODER == codecType || hasVarData;
        return "/* Generated SBE (Simple Binary Encoding) message codec. */\npackage " + packageName + ";\n\n" + (String)(hasMutableBuffer ? "import " + this.fqMutableBuffer + ";\n" : BASE_INDENT) + (String)(hasReadOnlyBuffer ? "import " + this.fqReadOnlyBuffer + ";\n" : BASE_INDENT) + this.interfaceImportLine() + String.valueOf(importStatements);
    }

    private static CharSequence generateEnumFileHeader(String packageName) {
        return "/* Generated SBE (Simple Binary Encoding) message codec. */\npackage " + packageName + ";\n\n";
    }

    private void generateAnnotations(String indent, String className, List<Token> tokens, Appendable out, Function<String, String> nameMapping) throws IOException {
        ArrayList<String> groupClassNames = new ArrayList<String>();
        int level = 0;
        for (Token token : tokens) {
            if (token.signal() == Signal.BEGIN_GROUP) {
                if (1 != ++level) continue;
                groupClassNames.add(JavaUtil.formatClassName(nameMapping.apply(token.name())));
                continue;
            }
            if (token.signal() != Signal.END_GROUP) continue;
            --level;
        }
        if (!groupClassNames.isEmpty()) {
            out.append(indent).append("@uk.co.real_logic.sbe.codec.java.GroupOrder({\n");
            int i = 0;
            for (String name : groupClassNames) {
                out.append(indent).append(INDENT).append(className).append('.').append(name).append(".class");
                if (++i >= groupClassNames.size()) continue;
                out.append(",\n");
            }
            out.append("})");
        }
    }

    private static CharSequence generateDeclaration(String className, String implementsString, Token typeToken) {
        StringBuilder sb = new StringBuilder();
        JavaUtil.generateTypeJavadoc(sb, BASE_INDENT, typeToken);
        if (typeToken.deprecated() > 0) {
            sb.append("@Deprecated\n");
        }
        sb.append("@SuppressWarnings(\"all\")\n").append("public final class ").append(className).append(implementsString).append('\n').append("{\n");
        return sb;
    }

    private void generatePackageInfo() throws IOException {
        try (Writer out = this.outputManager.createOutput(PACKAGE_INFO);){
            out.append("/* Generated SBE (Simple Binary Encoding) message codecs.*/\n/**\n * ").append(this.ir.description()).append("\n").append(" */\npackage ").append(this.ir.applicableNamespace()).append(";\n");
        }
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append("/* Generated SBE (Simple Binary Encoding) message codec. */\npackage ").append(this.ir.applicableNamespace()).append(";\n\n").append("/**\n * Meta attribute enum for selecting a particular meta attribute value.\n */\n @SuppressWarnings(\"all\")\npublic enum MetaAttribute\n{\n    /**\n     * The epoch or start of time. Default is 'UNIX' which is midnight 1st January 1970 UTC.\n     */\n    EPOCH,\n\n    /**\n     * Time unit applied to the epoch. Can be second, millisecond, microsecond, or nanosecond.\n     */\n    TIME_UNIT,\n\n    /**\n     * The type relationship to a FIX tag value encoded type. For reference only.\n     */\n    SEMANTIC_TYPE,\n\n    /**\n     * Field presence indication. Can be optional, required, or constant.\n     */\n    PRESENCE\n}\n");
        }
    }

    private static CharSequence generateEnumDeclaration(String name, Token typeToken) {
        StringBuilder sb = new StringBuilder();
        JavaUtil.generateTypeJavadoc(sb, BASE_INDENT, typeToken);
        sb.append("@SuppressWarnings(\"all\")\n").append("public enum ").append(name).append("\n{\n");
        return sb;
    }

    private void generatePrimitiveDecoder(StringBuilder sb, boolean inComposite, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token encodingToken, String indent) {
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        this.generatePrimitiveFieldMetaMethod(sb, formattedPropertyName, encodingToken, indent);
        if (encodingToken.isConstantEncoding()) {
            this.generateConstPropertyMethods(sb, formattedPropertyName, encodingToken, indent);
        } else {
            sb.append(this.generatePrimitivePropertyDecodeMethods(inComposite, formattedPropertyName, accessOrderListenerCall, propertyToken, encodingToken, indent));
        }
    }

    private void generatePrimitiveEncoder(StringBuilder sb, String containingClassName, String propertyName, CharSequence accessOrderListenerCall, Token typeToken, String indent) {
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        this.generatePrimitiveFieldMetaMethod(sb, formattedPropertyName, typeToken, indent);
        if (!typeToken.isConstantEncoding()) {
            sb.append(this.generatePrimitivePropertyEncodeMethods(containingClassName, formattedPropertyName, accessOrderListenerCall, typeToken, indent));
        } else {
            this.generateConstPropertyMethods(sb, formattedPropertyName, typeToken, indent);
        }
    }

    private CharSequence generatePrimitivePropertyDecodeMethods(boolean inComposite, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token encodingToken, String indent) {
        return encodingToken.matchOnLength(() -> this.generatePrimitivePropertyDecode(inComposite, propertyName, accessOrderListenerCall, propertyToken, encodingToken, indent), () -> this.generatePrimitiveArrayPropertyDecode(inComposite, propertyName, accessOrderListenerCall, propertyToken, encodingToken, indent));
    }

    private CharSequence generatePrimitivePropertyEncodeMethods(String containingClassName, String propertyName, CharSequence accessOrderListenerCall, Token typeToken, String indent) {
        return typeToken.matchOnLength(() -> this.generatePrimitivePropertyEncode(containingClassName, propertyName, accessOrderListenerCall, typeToken, indent), () -> this.generatePrimitiveArrayPropertyEncode(containingClassName, propertyName, accessOrderListenerCall, typeToken, indent));
    }

    private void generatePrimitiveFieldMetaMethod(StringBuilder sb, String propertyName, Token token, String indent) {
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String javaTypeName = JavaUtil.javaTypeName(primitiveType);
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String nullValue = JavaUtil.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, indent, javaTypeName, formattedPropertyName, "Null", nullValue);
        String minValue = JavaUtil.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, indent, javaTypeName, formattedPropertyName, "Min", minValue);
        String maxValue = JavaUtil.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString());
        this.generatePrimitiveFieldMetaMethod(sb, indent, javaTypeName, formattedPropertyName, "Max", maxValue);
    }

    private void generatePrimitiveFieldMetaMethod(StringBuilder sb, String indent, String javaTypeName, String formattedPropertyName, String metaType, String retValue) {
        sb.append("\n").append(indent).append("    public static ").append(javaTypeName).append(" ").append(formattedPropertyName).append(metaType).append("Value()\n").append(indent).append("    {\n").append(indent).append("        return ").append(retValue).append(";\n").append(indent).append("    }\n");
    }

    private CharSequence generatePrimitivePropertyDecode(boolean inComposite, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token encodingToken, String indent) {
        Encoding encoding = encodingToken.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = encodingToken.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s%s" + indent + "        return %s;\n" + indent + "    }\n\n", javaTypeName, JavaUtil.formatPropertyName(propertyName), this.generateFieldNotPresentCondition(inComposite, propertyToken.version(), encoding, indent), accessOrderListenerCall, this.generateGet(encoding.primitiveType(), "offset + " + offset, byteOrderStr));
    }

    private CharSequence generatePrimitivePropertyEncode(String containingClassName, String propertyName, CharSequence accessOrderListenerCall, Token typeToken, String indent) {
        Encoding encoding = typeToken.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = typeToken.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        return String.format("\n" + indent + "    public %s %s(final %s value)\n" + indent + "    {\n%s" + indent + "        %s;\n" + indent + "        return this;\n" + indent + "    }\n\n", JavaUtil.formatClassName(containingClassName), JavaUtil.formatPropertyName(propertyName), javaTypeName, accessOrderListenerCall, this.generatePut(encoding.primitiveType(), "offset + " + offset, "value", byteOrderStr));
    }

    private CharSequence generateWrapFieldNotPresentCondition(boolean inComposite, int sinceVersion, String indent) {
        if (inComposite || 0 == sinceVersion) {
            return BASE_INDENT;
        }
        return indent + "        if (parentMessage.actingVersion < " + sinceVersion + ")\n" + indent + "        {\n" + indent + "            wrapBuffer.wrap(buffer, offset, 0);\n" + indent + "            return;\n" + indent + "        }\n\n";
    }

    private CharSequence generateFieldNotPresentCondition(boolean inComposite, int sinceVersion, Encoding encoding, String indent) {
        if (inComposite || 0 == sinceVersion) {
            return BASE_INDENT;
        }
        String nullValue = JavaUtil.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        return indent + "        if (parentMessage.actingVersion < " + sinceVersion + ")\n" + indent + "        {\n" + indent + "            return " + nullValue + ";\n" + indent + "        }\n\n";
    }

    private static CharSequence generateArrayFieldNotPresentCondition(boolean inComposite, int sinceVersion, String indent) {
        if (inComposite || 0 == sinceVersion) {
            return BASE_INDENT;
        }
        return indent + "        if (parentMessage.actingVersion < " + sinceVersion + ")\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n";
    }

    private static CharSequence generateStringNotPresentConditionForAppendable(boolean inComposite, int sinceVersion, String indent) {
        if (inComposite || 0 == sinceVersion) {
            return BASE_INDENT;
        }
        return indent + "        if (parentMessage.actingVersion < " + sinceVersion + ")\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n";
    }

    private static CharSequence generateStringNotPresentCondition(boolean inComposite, int sinceVersion, String indent) {
        if (inComposite || 0 == sinceVersion) {
            return BASE_INDENT;
        }
        return indent + "        if (parentMessage.actingVersion < " + sinceVersion + ")\n" + indent + "        {\n" + indent + "            return \"\";\n" + indent + "        }\n\n";
    }

    private static CharSequence generatePropertyNotPresentCondition(boolean inComposite, CodecType codecType, Token propertyToken, String enumName, String indent) {
        if (inComposite || codecType == CodecType.ENCODER || 0 == propertyToken.version()) {
            return BASE_INDENT;
        }
        Object nullValue = enumName == null ? "null" : enumName + ".NULL_VAL";
        return indent + "        if (parentMessage.actingVersion < " + propertyToken.version() + ")\n" + indent + "        {\n" + indent + "            return " + (String)nullValue + ";\n" + indent + "        }\n\n";
    }

    private CharSequence generatePrimitiveArrayPropertyDecode(boolean inComposite, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token encodingToken, String indent) {
        Encoding encoding = encodingToken.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = encodingToken.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        int fieldLength = encodingToken.arrayLength();
        int typeSize = JavaGenerator.sizeOfPrimitive(encoding);
        StringBuilder sb = new StringBuilder();
        JavaGenerator.generateArrayLengthMethod(propertyName, indent, fieldLength, sb);
        new Formatter(sb).format("\n" + indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n%s%s" + indent + "        final int pos = offset + %d + (index * %d);\n\n" + indent + "        return %s;\n" + indent + "    }\n\n", javaTypeName, propertyName, fieldLength, this.generateFieldNotPresentCondition(inComposite, propertyToken.version(), encoding, indent), accessOrderListenerCall, offset, typeSize, this.generateGet(encoding.primitiveType(), "pos", byteOrderStr));
        if (encoding.primitiveType() == PrimitiveType.CHAR) {
            JavaGenerator.generateCharacterEncodingMethod(sb, propertyName, encoding.characterEncoding(), indent);
            new Formatter(sb).format("\n" + indent + "    public int get%s(final byte[] dst, final int dstOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (dstOffset < 0 || dstOffset > (dst.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"Copy will go out of range: offset=\" + dstOffset);\n" + indent + "        }\n\n%s%s" + indent + "        buffer.getBytes(offset + %d, dst, dstOffset, length);\n\n" + indent + "        return length;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), fieldLength, JavaGenerator.generateArrayFieldNotPresentCondition(inComposite, propertyToken.version(), indent), accessOrderListenerCall, offset);
            new Formatter(sb).format("\n" + indent + "    public String %s()\n" + indent + "    {\n%s%s" + indent + "        final byte[] dst = new byte[%d];\n" + indent + "        buffer.getBytes(offset + %d, dst, 0, %d);\n\n" + indent + "        int end = 0;\n" + indent + "        for (; end < %d && dst[end] != 0; ++end);\n\n" + indent + "        return new String(dst, 0, end, %s);\n" + indent + "    }\n\n", propertyName, JavaGenerator.generateStringNotPresentCondition(inComposite, propertyToken.version(), indent), accessOrderListenerCall, fieldLength, offset, fieldLength, fieldLength, JavaUtil.charset(encoding.characterEncoding()));
            if (JavaUtil.isAsciiEncoding(encoding.characterEncoding())) {
                new Formatter(sb).format("\n" + indent + "    public int get%1$s(final Appendable value)\n" + indent + "    {\n%2$s%5$s" + indent + "        for (int i = 0; i < %3$d; ++i)\n" + indent + "        {\n" + indent + "            final int c = buffer.getByte(offset + %4$d + i) & 0xFF;\n" + indent + "            if (c == 0)\n" + indent + "            {\n" + indent + "                return i;\n" + indent + "            }\n\n" + indent + "            try\n" + indent + "            {\n" + indent + "                value.append(c > 127 ? '?' : (char)c);\n" + indent + "            }\n" + indent + "            catch (final java.io.IOException ex)\n" + indent + "            {\n" + indent + "                throw new java.io.UncheckedIOException(ex);\n" + indent + "            }\n" + indent + "        }\n\n" + indent + "        return %3$d;\n" + indent + "    }\n\n", Generators.toUpperFirstChar(propertyName), JavaGenerator.generateStringNotPresentConditionForAppendable(inComposite, propertyToken.version(), indent), fieldLength, offset, accessOrderListenerCall);
            }
        } else if (encoding.primitiveType() == PrimitiveType.UINT8) {
            new Formatter(sb).format("\n" + indent + "    public int get%s(final byte[] dst, final int dstOffset, final int length)\n" + indent + "    {\n%s%s" + indent + "        final int bytesCopied = Math.min(length, %d);\n" + indent + "        buffer.getBytes(offset + %d, dst, dstOffset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), JavaGenerator.generateArrayFieldNotPresentCondition(inComposite, propertyToken.version(), indent), accessOrderListenerCall, fieldLength, offset);
            new Formatter(sb).format("\n" + indent + "    public int get%s(final %s dst, final int dstOffset, final int length)\n" + indent + "    {\n%s%s" + indent + "        final int bytesCopied = Math.min(length, %d);\n" + indent + "        buffer.getBytes(offset + %d, dst, dstOffset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), this.fqMutableBuffer, JavaGenerator.generateArrayFieldNotPresentCondition(inComposite, propertyToken.version(), indent), accessOrderListenerCall, fieldLength, offset);
            new Formatter(sb).format("\n" + indent + "    public void wrap%s(final %s wrapBuffer)\n" + indent + "    {\n%s%s" + indent + "        wrapBuffer.wrap(buffer, offset + %d, %d);\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), this.readOnlyBuffer, this.generateWrapFieldNotPresentCondition(inComposite, propertyToken.version(), indent), accessOrderListenerCall, offset, fieldLength);
        }
        return sb;
    }

    private static void generateArrayLengthMethod(String propertyName, String indent, int fieldLength, StringBuilder sb) {
        String formatPropertyName = JavaUtil.formatPropertyName(propertyName);
        sb.append("\n").append(indent).append("    public static int ").append(formatPropertyName).append("Length()\n").append(indent).append("    {\n").append(indent).append("        return ").append(fieldLength).append(";\n").append(indent).append("    }\n\n");
    }

    private String byteOrderString(Encoding encoding) {
        return JavaGenerator.sizeOfPrimitive(encoding) == 1 ? BASE_INDENT : ", BYTE_ORDER";
    }

    private CharSequence generatePrimitiveArrayPropertyEncode(String containingClassName, String propertyName, CharSequence accessOrderListenerCall, Token typeToken, String indent) {
        Encoding encoding = typeToken.encoding();
        PrimitiveType primitiveType = encoding.primitiveType();
        String javaTypeName = JavaUtil.javaTypeName(primitiveType);
        int offset = typeToken.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        int arrayLength = typeToken.arrayLength();
        int typeSize = JavaGenerator.sizeOfPrimitive(encoding);
        StringBuilder sb = new StringBuilder();
        String className = JavaUtil.formatClassName(containingClassName);
        JavaGenerator.generateArrayLengthMethod(propertyName, indent, arrayLength, sb);
        new Formatter(sb).format("\n" + indent + "    public %s %s(final int index, final %s value)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n%s" + indent + "        final int pos = offset + %d + (index * %d);\n" + indent + "        %s;\n\n" + indent + "        return this;\n" + indent + "    }\n", className, propertyName, javaTypeName, arrayLength, accessOrderListenerCall, offset, typeSize, this.generatePut(primitiveType, "pos", "value", byteOrderStr));
        if (arrayLength > 1 && arrayLength <= 4) {
            int i;
            sb.append(indent).append("    public ").append(className).append(" put").append(Generators.toUpperFirstChar(propertyName)).append("(final ").append(javaTypeName).append(" value0");
            for (i = 1; i < arrayLength; ++i) {
                sb.append(", final ").append(javaTypeName).append(" value").append(i);
            }
            sb.append(")\n");
            sb.append(indent).append("    {\n");
            sb.append(accessOrderListenerCall);
            for (i = 0; i < arrayLength; ++i) {
                String indexStr = "offset + " + (offset + typeSize * i);
                sb.append(indent).append("        ").append(this.generatePut(primitiveType, indexStr, "value" + i, byteOrderStr)).append(";\n");
            }
            sb.append("\n");
            sb.append(indent).append("        return this;\n");
            sb.append(indent).append("    }\n");
        }
        if (primitiveType == PrimitiveType.CHAR) {
            this.generateCharArrayEncodeMethods(containingClassName, propertyName, indent, accessOrderListenerCall, encoding, offset, arrayLength, sb);
        } else if (primitiveType == PrimitiveType.UINT8) {
            this.generateByteArrayEncodeMethods(containingClassName, propertyName, indent, accessOrderListenerCall, offset, arrayLength, sb);
        }
        return sb;
    }

    private void generateCharArrayEncodeMethods(String containingClassName, String propertyName, String indent, CharSequence accessOrderListenerCall, Encoding encoding, int offset, int fieldLength, StringBuilder sb) {
        JavaGenerator.generateCharacterEncodingMethod(sb, propertyName, encoding.characterEncoding(), indent);
        new Formatter(sb).format("\n" + indent + "    public %s put%s(final byte[] src, final int srcOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (srcOffset < 0 || srcOffset > (src.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"Copy will go out of range: offset=\" + srcOffset);\n" + indent + "        }\n\n%s" + indent + "        buffer.putBytes(offset + %d, src, srcOffset, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), Generators.toUpperFirstChar(propertyName), fieldLength, accessOrderListenerCall, offset);
        if (JavaUtil.isAsciiEncoding(encoding.characterEncoding())) {
            new Formatter(sb).format("\n" + indent + "    public %1$s %2$s(final String src)\n" + indent + "    {\n" + indent + "        final int length = %3$d;\n" + indent + "        final int srcLength = null == src ? 0 : src.length();\n" + indent + "        if (srcLength > length)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"String too large for copy: byte length=\" + srcLength);\n" + indent + "        }\n\n%5$s" + indent + "        buffer.putStringWithoutLengthAscii(offset + %4$d, src);\n\n" + indent + "        for (int start = srcLength; start < length; ++start)\n" + indent + "        {\n" + indent + "            buffer.putByte(offset + %4$d + start, (byte)0);\n" + indent + "        }\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, fieldLength, offset, accessOrderListenerCall);
            new Formatter(sb).format("\n" + indent + "    public %1$s %2$s(final CharSequence src)\n" + indent + "    {\n" + indent + "        final int length = %3$d;\n" + indent + "        final int srcLength = null == src ? 0 : src.length();\n" + indent + "        if (srcLength > length)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"CharSequence too large for copy: byte length=\" + srcLength);\n" + indent + "        }\n\n%5$s" + indent + "        buffer.putStringWithoutLengthAscii(offset + %4$d, src);\n\n" + indent + "        for (int start = srcLength; start < length; ++start)\n" + indent + "        {\n" + indent + "            buffer.putByte(offset + %4$d + start, (byte)0);\n" + indent + "        }\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, fieldLength, offset, accessOrderListenerCall);
        } else {
            new Formatter(sb).format("\n" + indent + "    public %s %s(final String src)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        final byte[] bytes = (null == src || src.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : src.getBytes(%s);\n" + indent + "        if (bytes.length > length)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"String too large for copy: byte length=\" + bytes.length);\n" + indent + "        }\n\n%s" + indent + "        buffer.putBytes(offset + %d, bytes, 0, bytes.length);\n\n" + indent + "        for (int start = bytes.length; start < length; ++start)\n" + indent + "        {\n" + indent + "            buffer.putByte(offset + %d + start, (byte)0);\n" + indent + "        }\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, fieldLength, JavaUtil.charset(encoding.characterEncoding()), accessOrderListenerCall, offset, offset);
        }
    }

    private void generateByteArrayEncodeMethods(String containingClassName, String propertyName, String indent, CharSequence accessOrderListenerCall, int offset, int fieldLength, StringBuilder sb) {
        new Formatter(sb).format("\n" + indent + "    public %s put%s(final byte[] src, final int srcOffset, final int length)\n" + indent + "    {\n" + indent + "        if (length > %d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%s" + indent + "        buffer.putBytes(offset + %d, src, srcOffset, length);\n" + indent + "        for (int i = length; i < %d; i++)\n" + indent + "        {\n" + indent + "            buffer.putByte(offset + %d + i, (byte)0);\n" + indent + "        }\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), Generators.toUpperFirstChar(propertyName), fieldLength, accessOrderListenerCall, offset, fieldLength, offset);
        new Formatter(sb).format("\n" + indent + "    public %s put%s(final %s src, final int srcOffset, final int length)\n" + indent + "    {\n" + indent + "        if (length > %d)\n" + indent + "        {\n" + indent + "            throw new IllegalStateException(\"length > maxValue for type: \" + length);\n" + indent + "        }\n\n%s" + indent + "        buffer.putBytes(offset + %d, src, srcOffset, length);\n" + indent + "        for (int i = length; i < %d; i++)\n" + indent + "        {\n" + indent + "            buffer.putByte(offset + %d + i, (byte)0);\n" + indent + "        }\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), Generators.toUpperFirstChar(propertyName), this.fqReadOnlyBuffer, fieldLength, accessOrderListenerCall, offset, fieldLength, offset);
    }

    private static int sizeOfPrimitive(Encoding encoding) {
        return encoding.primitiveType().size();
    }

    private static void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String characterEncoding, String indent) {
        if (null != characterEncoding) {
            String propName = JavaUtil.formatPropertyName(propertyName);
            sb.append("\n").append(indent).append("    public static String ").append(propName).append("CharacterEncoding()\n").append(indent).append("    {\n").append(indent).append("        return ").append(JavaUtil.charsetName(characterEncoding)).append(";\n").append(indent).append("    }\n");
        }
    }

    private void generateConstPropertyMethods(StringBuilder sb, String propertyName, Token token, String indent) {
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        Encoding encoding = token.encoding();
        if (encoding.primitiveType() != PrimitiveType.CHAR) {
            new Formatter(sb).format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", JavaUtil.javaTypeName(encoding.primitiveType()), formattedPropertyName, JavaUtil.generateLiteral(encoding.primitiveType(), encoding.constValue().toString()));
            return;
        }
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        byte[] constBytes = encoding.constValue().byteArrayValue(encoding.primitiveType());
        CharSequence values = JavaGenerator.generateByteLiteralList(encoding.constValue().byteArrayValue(encoding.primitiveType()));
        new Formatter(sb).format("\n\n" + indent + "    private static final byte[] %s_VALUE = { %s };\n", propertyName.toUpperCase(), values);
        JavaGenerator.generateArrayLengthMethod(formattedPropertyName, indent, constBytes.length, sb);
        new Formatter(sb).format("\n" + indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        return %s_VALUE[index];\n" + indent + "    }\n\n", javaTypeName, formattedPropertyName, propertyName.toUpperCase());
        sb.append(String.format(indent + "    public int get%s(final byte[] dst, final int offset, final int length)\n" + indent + "    {\n" + indent + "        final int bytesCopied = Math.min(length, %d);\n" + indent + "        System.arraycopy(%s_VALUE, 0, dst, offset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), constBytes.length, propertyName.toUpperCase()));
        if (constBytes.length > 1) {
            new Formatter(sb).format("\n" + indent + "    public String %s()\n" + indent + "    {\n" + indent + "        return \"%s\";\n" + indent + "    }\n\n", formattedPropertyName, encoding.constValue());
        } else {
            new Formatter(sb).format("\n" + indent + "    public byte %s()\n" + indent + "    {\n" + indent + "        return (byte)%s;\n" + indent + "    }\n\n", formattedPropertyName, encoding.constValue());
        }
    }

    private static CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private CharSequence generateFixedFlyweightCode(String className, int size, String bufferImplementation) {
        String schemaIdType = JavaUtil.javaTypeName(this.ir.headerStructure().schemaIdType());
        String schemaIdAccessorType = this.shouldGenerateInterfaces ? "int" : schemaIdType;
        String schemaVersionType = JavaUtil.javaTypeName(this.ir.headerStructure().schemaVersionType());
        String schemaVersionAccessorType = this.shouldGenerateInterfaces ? "int" : schemaVersionType;
        String semanticVersion = this.ir.semanticVersion() == null ? BASE_INDENT : this.ir.semanticVersion();
        return String.format("    public static final %5$s SCHEMA_ID = %6$s;\n    public static final %7$s SCHEMA_VERSION = %8$s;\n    public static final String SEMANTIC_VERSION = \"%11$s\";\n    public static final int ENCODED_LENGTH = %2$d;\n    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.%4$s;\n\n    private int offset;\n    private %3$s buffer;\n\n    public %1$s wrap(final %3$s buffer, final int offset)\n    {\n        if (buffer != this.buffer)\n        {\n            this.buffer = buffer;\n        }\n        this.offset = offset;\n\n        return this;\n    }\n\n    public %3$s buffer()\n    {\n        return buffer;\n    }\n\n    public int offset()\n    {\n        return offset;\n    }\n\n    public int encodedLength()\n    {\n        return ENCODED_LENGTH;\n    }\n\n    public %9$s sbeSchemaId()\n    {\n        return SCHEMA_ID;\n    }\n\n    public %10$s sbeSchemaVersion()\n    {\n        return SCHEMA_VERSION;\n    }\n", className, size, bufferImplementation, this.ir.byteOrder(), schemaIdType, JavaUtil.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, JavaUtil.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), schemaIdAccessorType, schemaVersionAccessorType, semanticVersion);
    }

    private CharSequence generateDecoderFlyweightCode(FieldPrecedenceModel fieldPrecedenceModel, String className, Token token) {
        String headerClassName = JavaUtil.formatClassName(this.ir.headerStructure().tokens().get(0).applicableTypeName());
        StringBuilder methods = new StringBuilder();
        methods.append(JavaGenerator.generateDecoderWrapListener(fieldPrecedenceModel, INDENT));
        methods.append("    public ").append(className).append(" wrap(\n").append("        final ").append(this.readOnlyBuffer).append(" buffer,\n").append("        final int offset,\n").append("        final int actingBlockLength,\n").append("        final int actingVersion)\n").append("    {\n").append("        if (buffer != this.buffer)\n").append("        {\n").append("            this.buffer = buffer;\n").append("        }\n").append("        this.offset = offset;\n").append("        this.actingBlockLength = actingBlockLength;\n").append("        this.actingVersion = actingVersion;\n").append("        limit(offset + actingBlockLength);\n\n").append(this.generateAccessOrderListenerCall(fieldPrecedenceModel, "        ", "onWrap", "actingVersion")).append("        return this;\n").append("    }\n\n");
        methods.append("    public ").append(className).append(" wrapAndApplyHeader(\n").append("        final ").append(this.readOnlyBuffer).append(" buffer,\n").append("        final int offset,\n").append("        final ").append(headerClassName).append("Decoder headerDecoder)\n").append("    {\n").append("        headerDecoder.wrap(buffer, offset);\n\n").append("        final int templateId = headerDecoder.templateId();\n").append("        if (TEMPLATE_ID != templateId)\n").append("        {\n").append("            throw new IllegalStateException(\"Invalid TEMPLATE_ID: \" + templateId);\n").append("        }\n\n").append("        return wrap(\n").append("            buffer,\n").append("            offset + ").append(headerClassName).append("Decoder.ENCODED_LENGTH,\n").append("            headerDecoder.blockLength(),\n").append("            headerDecoder.version());\n").append("    }\n\n");
        methods.append("    public ").append(className).append(" sbeRewind()\n").append("    {\n").append("        return wrap(buffer, offset, actingBlockLength, actingVersion);\n").append("    }\n\n");
        methods.append("    public int sbeDecodedLength()\n").append("    {\n").append("        final int currentLimit = limit();\n");
        if (null != fieldPrecedenceModel) {
            methods.append("        final int currentCodecState = codecState();\n");
        }
        methods.append("        sbeSkip();\n").append("        final int decodedLength = encodedLength();\n").append("        limit(currentLimit);\n\n");
        if (null != fieldPrecedenceModel) {
            methods.append("        if (").append(this.precedenceChecksFlagName).append(")\n").append("        {\n").append("            codecState(currentCodecState);\n").append("        }\n\n");
        }
        methods.append("        return decodedLength;\n").append("    }\n\n");
        methods.append("    public int actingVersion()\n").append("    {\n").append("        return actingVersion;\n").append("    }\n\n");
        return this.generateFlyweightCode(CodecType.DECODER, className, token, methods.toString(), this.readOnlyBuffer);
    }

    private CharSequence generateFlyweightCode(CodecType codecType, String className, Token token, String wrapMethod, String bufferImplementation) {
        HeaderStructure headerStructure = this.ir.headerStructure();
        String blockLengthType = JavaUtil.javaTypeName(headerStructure.blockLengthType());
        String blockLengthAccessorType = this.shouldGenerateInterfaces ? "int" : blockLengthType;
        String templateIdType = JavaUtil.javaTypeName(headerStructure.templateIdType());
        String templateIdAccessorType = this.shouldGenerateInterfaces ? "int" : templateIdType;
        String schemaIdType = JavaUtil.javaTypeName(headerStructure.schemaIdType());
        String schemaIdAccessorType = this.shouldGenerateInterfaces ? "int" : schemaIdType;
        String schemaVersionType = JavaUtil.javaTypeName(headerStructure.schemaVersionType());
        String schemaVersionAccessorType = this.shouldGenerateInterfaces ? "int" : schemaVersionType;
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        String semanticVersion = this.ir.semanticVersion() == null ? BASE_INDENT : this.ir.semanticVersion();
        String actingFields = codecType == CodecType.ENCODER ? BASE_INDENT : "    int actingBlockLength;\n    int actingVersion;\n";
        return String.format("    public static final %1$s BLOCK_LENGTH = %2$s;\n    public static final %3$s TEMPLATE_ID = %4$s;\n    public static final %5$s SCHEMA_ID = %6$s;\n    public static final %7$s SCHEMA_VERSION = %8$s;\n    public static final String SEMANTIC_VERSION = \"%19$s\";\n    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.%14$s;\n\n    private final %9$s parentMessage = this;\n    private %11$s buffer;\n    private int offset;\n    private int limit;\n%13$s\n    public %15$s sbeBlockLength()\n    {\n        return BLOCK_LENGTH;\n    }\n\n    public %16$s sbeTemplateId()\n    {\n        return TEMPLATE_ID;\n    }\n\n    public %17$s sbeSchemaId()\n    {\n        return SCHEMA_ID;\n    }\n\n    public %18$s sbeSchemaVersion()\n    {\n        return SCHEMA_VERSION;\n    }\n\n    public String sbeSemanticType()\n    {\n        return \"%10$s\";\n    }\n\n    public %11$s buffer()\n    {\n        return buffer;\n    }\n\n    public int offset()\n    {\n        return offset;\n    }\n\n%12$s    public int encodedLength()\n    {\n        return limit - offset;\n    }\n\n    public int limit()\n    {\n        return limit;\n    }\n\n    public void limit(final int limit)\n    {\n        this.limit = limit;\n    }\n", blockLengthType, JavaUtil.generateLiteral(headerStructure.blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, JavaUtil.generateLiteral(headerStructure.templateIdType(), Integer.toString(token.id())), schemaIdType, JavaUtil.generateLiteral(headerStructure.schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, JavaUtil.generateLiteral(headerStructure.schemaVersionType(), Integer.toString(this.ir.version())), className, semanticType, bufferImplementation, wrapMethod, actingFields, this.ir.byteOrder(), blockLengthAccessorType, templateIdAccessorType, schemaIdAccessorType, schemaVersionAccessorType, semanticVersion);
    }

    private CharSequence generateEncoderFlyweightCode(String className, FieldPrecedenceModel fieldPrecedenceModel, Token token) {
        String wrapMethod = "    public " + className + " wrap(final " + this.mutableBuffer + " buffer, final int offset)\n    {\n        if (buffer != this.buffer)\n        {\n            this.buffer = buffer;\n        }\n        this.offset = offset;\n        limit(offset + BLOCK_LENGTH);\n\n" + String.valueOf(this.generateEncoderWrapListener(fieldPrecedenceModel, "        ")) + "        return this;\n    }\n\n";
        StringBuilder builder = new StringBuilder("    public %1$s wrapAndApplyHeader(\n        final %2$s buffer, final int offset, final %3$s headerEncoder)\n    {\n        headerEncoder\n            .wrap(buffer, offset)");
        for (Token headerToken : this.ir.headerStructure().tokens()) {
            if (headerToken.isConstantEncoding()) continue;
            switch (headerToken.name()) {
                case "blockLength": {
                    builder.append("\n            .blockLength(BLOCK_LENGTH)");
                    break;
                }
                case "templateId": {
                    builder.append("\n            .templateId(TEMPLATE_ID)");
                    break;
                }
                case "schemaId": {
                    builder.append("\n            .schemaId(SCHEMA_ID)");
                    break;
                }
                case "version": {
                    builder.append("\n            .version(SCHEMA_VERSION)");
                }
            }
        }
        builder.append(";\n\n        return wrap(buffer, offset + %3$s.ENCODED_LENGTH);\n    }\n\n");
        String wrapAndApplyMethod = String.format(builder.toString(), className, this.mutableBuffer, JavaUtil.formatClassName(this.ir.headerStructure().tokens().get(0).applicableTypeName() + "Encoder"));
        return this.generateFlyweightCode(CodecType.ENCODER, className, token, wrapMethod + wrapAndApplyMethod, this.mutableBuffer);
    }

    private void generateEncoderFields(StringBuilder sb, String containingClassName, FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        Generators.forEachField(tokens, (fieldToken, typeToken) -> {
            String propertyName = JavaUtil.formatPropertyName(fieldToken.name());
            String typeName = JavaUtil.encoderName(typeToken.name());
            JavaGenerator.generateFieldIdMethod(sb, fieldToken, indent);
            JavaGenerator.generateFieldSinceVersionMethod(sb, fieldToken, indent);
            JavaGenerator.generateEncodingOffsetMethod(sb, propertyName, fieldToken.offset(), indent);
            JavaGenerator.generateEncodingLengthMethod(sb, propertyName, typeToken.encodedLength(), indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, fieldToken, indent);
            JavaGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent + INDENT, fieldToken);
            CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", (Token)fieldToken, new String[0]);
            switch (typeToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveEncoder(sb, containingClassName, propertyName, accessOrderListenerCall, (Token)typeToken, indent);
                    break;
                }
                case BEGIN_ENUM: {
                    this.generateEnumEncoder(sb, containingClassName, accessOrderListenerCall, (Token)fieldToken, propertyName, (Token)typeToken, indent);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSetProperty(sb, false, CodecType.ENCODER, propertyName, accessOrderListenerCall, (Token)fieldToken, (Token)typeToken, indent, typeName);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateCompositeProperty(sb, false, CodecType.ENCODER, propertyName, accessOrderListenerCall, (Token)fieldToken, (Token)typeToken, indent, typeName);
                    break;
                }
            }
        });
    }

    private void generateDecoderFields(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        Generators.forEachField(tokens, (fieldToken, typeToken) -> {
            String propertyName = JavaUtil.formatPropertyName(fieldToken.name());
            String typeName = JavaUtil.decoderName(typeToken.name());
            JavaGenerator.generateFieldIdMethod(sb, fieldToken, indent);
            JavaGenerator.generateFieldSinceVersionMethod(sb, fieldToken, indent);
            JavaGenerator.generateEncodingOffsetMethod(sb, propertyName, fieldToken.offset(), indent);
            JavaGenerator.generateEncodingLengthMethod(sb, propertyName, typeToken.encodedLength(), indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, fieldToken, indent);
            JavaGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent + INDENT, fieldToken);
            CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "        ", (Token)fieldToken, new String[0]);
            switch (typeToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveDecoder(sb, false, propertyName, accessOrderListenerCall, (Token)fieldToken, (Token)typeToken, indent);
                    break;
                }
                case BEGIN_ENUM: {
                    this.generateEnumDecoder(sb, false, accessOrderListenerCall, (Token)fieldToken, propertyName, (Token)typeToken, indent);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSetProperty(sb, false, CodecType.DECODER, propertyName, accessOrderListenerCall, (Token)fieldToken, (Token)typeToken, indent, typeName);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateCompositeProperty(sb, false, CodecType.DECODER, propertyName, accessOrderListenerCall, (Token)fieldToken, (Token)typeToken, indent, typeName);
                    break;
                }
            }
        });
    }

    private static void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        String propertyName = JavaUtil.formatPropertyName(token.name());
        sb.append("\n").append(indent).append("    public static int ").append(propertyName).append("Id()\n").append(indent).append("    {\n").append(indent).append("        return ").append(token.id()).append(";\n").append(indent).append("    }\n");
    }

    private static void generateEncodingOffsetMethod(StringBuilder sb, String name, int offset, String indent) {
        String propertyName = JavaUtil.formatPropertyName(name);
        sb.append("\n").append(indent).append("    public static int ").append(propertyName).append("EncodingOffset()\n").append(indent).append("    {\n").append(indent).append("        return ").append(offset).append(";\n").append(indent).append("    }\n");
    }

    private static void generateEncodingLengthMethod(StringBuilder sb, String name, int length, String indent) {
        String propertyName = JavaUtil.formatPropertyName(name);
        sb.append("\n").append(indent).append("    public static int ").append(propertyName).append("EncodingLength()\n").append(indent).append("    {\n").append(indent).append("        return ").append(length).append(";\n").append(indent).append("    }\n");
    }

    private static void generateFieldSinceVersionMethod(StringBuilder sb, Token token, String indent) {
        String propertyName = JavaUtil.formatPropertyName(token.name());
        sb.append("\n").append(indent).append("    public static int ").append(propertyName).append("SinceVersion()\n").append(indent).append("    {\n").append(indent).append("        return ").append(token.version()).append(";\n").append(indent).append("    }\n");
    }

    private static void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        String presence = encoding.presence().toString().toLowerCase();
        String propertyName = JavaUtil.formatPropertyName(token.name());
        sb.append("\n").append(indent).append("    public static String ").append(propertyName).append("MetaAttribute(final MetaAttribute metaAttribute)\n").append(indent).append("    {\n").append(indent).append("        if (MetaAttribute.PRESENCE == metaAttribute)\n").append(indent).append("        {\n").append(indent).append("            return \"").append(presence).append("\";\n").append(indent).append("        }\n");
        if (!Strings.isEmpty(epoch)) {
            sb.append(indent).append("        if (MetaAttribute.EPOCH == metaAttribute)\n").append(indent).append("        {\n").append(indent).append("            return \"").append(epoch).append("\";\n").append(indent).append("        }\n");
        }
        if (!Strings.isEmpty(timeUnit)) {
            sb.append(indent).append("        if (MetaAttribute.TIME_UNIT == metaAttribute)\n").append(indent).append("        {\n").append(indent).append("            return \"").append(timeUnit).append("\";\n").append(indent).append("        }\n");
        }
        if (!Strings.isEmpty(semanticType)) {
            sb.append(indent).append("        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute)\n").append(indent).append("        {\n").append(indent).append("            return \"").append(semanticType).append("\";\n").append(indent).append("        }\n");
        }
        sb.append("\n").append(indent).append("        return \"\";\n").append(indent).append("    }\n");
    }

    private void generateEnumDecoder(StringBuilder sb, boolean inComposite, CharSequence accessOrderListenerCall, Token fieldToken, String propertyName, Token typeToken, String indent) {
        String enumName = JavaUtil.formatClassName(typeToken.applicableTypeName());
        Encoding encoding = typeToken.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        if (fieldToken.isConstantEncoding()) {
            String enumValueStr = JavaUtil.formatClassName(fieldToken.encoding().constValue().toString());
            new Formatter(sb).format("\n" + indent + "    public %s %sRaw()\n" + indent + "    {\n" + indent + "        return %s.value();\n" + indent + "    }\n\n", javaTypeName, propertyName, enumValueStr);
            new Formatter(sb).format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n\n", enumName, propertyName, enumValueStr);
        } else {
            String rawGetStr = this.generateGet(encoding.primitiveType(), "offset + " + typeToken.offset(), this.byteOrderString(encoding));
            new Formatter(sb).format("\n" + indent + "    public %s %sRaw()\n" + indent + "    {\n%s%s" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, JavaUtil.formatPropertyName(propertyName), this.generateFieldNotPresentCondition(inComposite, fieldToken.version(), encoding, indent), accessOrderListenerCall, rawGetStr);
            new Formatter(sb).format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s%s" + indent + "        return %s.get(%s);\n" + indent + "    }\n\n", enumName, propertyName, JavaGenerator.generatePropertyNotPresentCondition(inComposite, CodecType.DECODER, fieldToken, enumName, indent), accessOrderListenerCall, enumName, rawGetStr);
        }
    }

    private void generateEnumEncoder(StringBuilder sb, String containingClassName, CharSequence accessOrderListenerCall, Token fieldToken, String propertyName, Token typeToken, String indent) {
        if (!fieldToken.isConstantEncoding()) {
            String enumName = JavaUtil.formatClassName(typeToken.applicableTypeName());
            Encoding encoding = typeToken.encoding();
            int offset = typeToken.offset();
            String byteOrderString = this.byteOrderString(encoding);
            new Formatter(sb).format("\n" + indent + "    public %s %s(final %s value)\n" + indent + "    {\n%s" + indent + "        %s;\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, enumName, accessOrderListenerCall, this.generatePut(encoding.primitiveType(), "offset + " + offset, "value.value()", byteOrderString));
        }
    }

    private void generateBitSetProperty(StringBuilder sb, boolean inComposite, CodecType codecType, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token bitsetToken, String indent, String bitSetName) {
        new Formatter(sb).format("\n" + indent + "    private final %s %s = new %s();\n", bitSetName, propertyName, bitSetName);
        JavaUtil.generateFlyweightPropertyJavadoc(sb, indent + INDENT, propertyToken, bitSetName);
        new Formatter(sb).format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s%s" + indent + "        %s.wrap(buffer, offset + %d);\n" + indent + "        return %s;\n" + indent + "    }\n", bitSetName, propertyName, JavaGenerator.generatePropertyNotPresentCondition(inComposite, codecType, propertyToken, null, indent), accessOrderListenerCall, propertyName, bitsetToken.offset(), propertyName);
    }

    private void generateCompositeProperty(StringBuilder sb, boolean inComposite, CodecType codecType, String propertyName, CharSequence accessOrderListenerCall, Token propertyToken, Token compositeToken, String indent, String compositeName) {
        new Formatter(sb).format("\n" + indent + "    private final %s %s = new %s();\n", compositeName, propertyName, compositeName);
        JavaUtil.generateFlyweightPropertyJavadoc(sb, indent + INDENT, propertyToken, compositeName);
        new Formatter(sb).format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s%s" + indent + "        %s.wrap(buffer, offset + %d);\n" + indent + "        return %s;\n" + indent + "    }\n", compositeName, propertyName, JavaGenerator.generatePropertyNotPresentCondition(inComposite, codecType, propertyToken, null, indent), accessOrderListenerCall, propertyName, compositeToken.offset(), propertyName);
    }

    private String generateGet(PrimitiveType type, String index, String byteOrder) {
        switch (type) {
            case CHAR: 
            case INT8: {
                return "buffer.getByte(" + index + ")";
            }
            case UINT8: {
                return "((short)(buffer.getByte(" + index + ") & 0xFF))";
            }
            case INT16: {
                return "buffer.getShort(" + index + byteOrder + ")";
            }
            case UINT16: {
                return "(buffer.getShort(" + index + byteOrder + ") & 0xFFFF)";
            }
            case INT32: {
                return "buffer.getInt(" + index + byteOrder + ")";
            }
            case UINT32: {
                return "(buffer.getInt(" + index + byteOrder + ") & 0xFFFF_FFFFL)";
            }
            case FLOAT: {
                return "buffer.getFloat(" + index + byteOrder + ")";
            }
            case UINT64: 
            case INT64: {
                return "buffer.getLong(" + index + byteOrder + ")";
            }
            case DOUBLE: {
                return "buffer.getDouble(" + index + byteOrder + ")";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generatePut(PrimitiveType type, String index, String value, String byteOrder) {
        switch (type) {
            case CHAR: 
            case INT8: {
                return "buffer.putByte(" + index + ", " + value + ")";
            }
            case UINT8: {
                return "buffer.putByte(" + index + ", (byte)" + value + ")";
            }
            case INT16: {
                return "buffer.putShort(" + index + ", " + value + byteOrder + ")";
            }
            case UINT16: {
                return "buffer.putShort(" + index + ", (short)" + value + byteOrder + ")";
            }
            case INT32: {
                return "buffer.putInt(" + index + ", " + value + byteOrder + ")";
            }
            case UINT32: {
                return "buffer.putInt(" + index + ", (int)" + value + byteOrder + ")";
            }
            case FLOAT: {
                return "buffer.putFloat(" + index + ", " + value + byteOrder + ")";
            }
            case UINT64: 
            case INT64: {
                return "buffer.putLong(" + index + ", " + value + byteOrder + ")";
            }
            case DOUBLE: {
                return "buffer.putDouble(" + index + ", " + value + byteOrder + ")";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generateChoiceIsEmpty(PrimitiveType type) {
        return "\n    public boolean isEmpty()\n    {\n        return " + this.generateChoiceIsEmptyInner(type) + ";\n    }\n";
    }

    private String generateChoiceIsEmptyInner(PrimitiveType type) {
        switch (type) {
            case UINT8: {
                return "0 == buffer.getByte(offset)";
            }
            case UINT16: {
                return "0 == buffer.getShort(offset)";
            }
            case UINT32: {
                return "0 == buffer.getInt(offset)";
            }
            case UINT64: {
                return "0 == buffer.getLong(offset)";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generateChoiceGet(PrimitiveType type, String bitIndex, String byteOrder) {
        switch (type) {
            case UINT8: {
                return "0 != (buffer.getByte(offset) & (1 << " + bitIndex + "))";
            }
            case UINT16: {
                return "0 != (buffer.getShort(offset" + byteOrder + ") & (1 << " + bitIndex + "))";
            }
            case UINT32: {
                return "0 != (buffer.getInt(offset" + byteOrder + ") & (1 << " + bitIndex + "))";
            }
            case UINT64: {
                return "0 != (buffer.getLong(offset" + byteOrder + ") & (1L << " + bitIndex + "))";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generateStaticChoiceGet(PrimitiveType type, String bitIndex) {
        switch (type) {
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return "0 != (value & (1 << " + bitIndex + "))";
            }
            case UINT64: {
                return "0 != (value & (1L << " + bitIndex + "))";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generateChoicePut(PrimitiveType type, String bitIdx, String byteOrder) {
        switch (type) {
            case UINT8: {
                return "        byte bits = buffer.getByte(offset);\n        bits = (byte)(value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + "));\n        buffer.putByte(offset, bits);";
            }
            case UINT16: {
                return "        short bits = buffer.getShort(offset" + byteOrder + ");\n        bits = (short)(value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + "));\n        buffer.putShort(offset, bits" + byteOrder + ");";
            }
            case UINT32: {
                return "        int bits = buffer.getInt(offset" + byteOrder + ");\n        bits = value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + ");\n        buffer.putInt(offset, bits" + byteOrder + ");";
            }
            case UINT64: {
                return "        long bits = buffer.getLong(offset" + byteOrder + ");\n        bits = value ? bits | (1L << " + bitIdx + ") : bits & ~(1L << " + bitIdx + ");\n        buffer.putLong(offset, bits" + byteOrder + ");";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private String generateStaticChoicePut(PrimitiveType type, String bitIdx) {
        switch (type) {
            case UINT8: {
                return "        return (byte)(value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + "));\n";
            }
            case UINT16: {
                return "        return (short)(value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + "));\n";
            }
            case UINT32: {
                return "        return value ? bits | (1 << " + bitIdx + ") : bits & ~(1 << " + bitIdx + ");\n";
            }
            case UINT64: {
                return "        return value ? bits | (1L << " + bitIdx + ") : bits & ~(1L << " + bitIdx + ");\n";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + String.valueOf((Object)type));
    }

    private void generateEncoderDisplay(StringBuilder sb, String decoderName) {
        this.appendToString(sb);
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return builder;");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    final " + decoderName + " decoder = new " + decoderName + "();");
        JavaUtil.append(sb, INDENT, "    decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return decoder.appendTo(builder);");
        JavaUtil.append(sb, INDENT, "}");
    }

    private CharSequence generateCompositeEncoderDisplay(String decoderName) {
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb);
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return builder;");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    final " + decoderName + " decoder = new " + decoderName + "();");
        JavaUtil.append(sb, INDENT, "    decoder.wrap(buffer, offset);");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return decoder.appendTo(builder);");
        JavaUtil.append(sb, INDENT, "}");
        return sb;
    }

    private CharSequence generateCompositeDecoderDisplay(List<Token> tokens) {
        Token encodingToken;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb);
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return builder;");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.Separator.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, "        ");
        int lengthBeforeLastGeneratedSeparator = -1;
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            String propertyName = JavaUtil.formatPropertyName(encodingToken.name());
            lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(propertyName, encodingToken, sb, "        ");
        }
        if (-1 != lengthBeforeLastGeneratedSeparator) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
        JavaUtil.Separator.END_COMPOSITE.appendToGeneratedBuilder(sb, "        ");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return builder;");
        JavaUtil.append(sb, INDENT, "}");
        return sb;
    }

    private CharSequence generateChoiceDisplay(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb);
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.Separator.BEGIN_SET.appendToGeneratedBuilder(sb, "        ");
        JavaUtil.append(sb, INDENT, "    boolean atLeastOne = false;");
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = JavaUtil.formatPropertyName(token.name());
            JavaUtil.append(sb, INDENT, "    if (" + choiceName + "())");
            JavaUtil.append(sb, INDENT, "    {");
            JavaUtil.append(sb, INDENT, "        if (atLeastOne)");
            JavaUtil.append(sb, INDENT, "        {");
            JavaUtil.Separator.ENTRY.appendToGeneratedBuilder(sb, "                ");
            JavaUtil.append(sb, INDENT, "        }");
            JavaUtil.append(sb, INDENT, "        builder.append(\"" + choiceName + "\");");
            JavaUtil.append(sb, INDENT, "        atLeastOne = true;");
            JavaUtil.append(sb, INDENT, "    }");
        }
        JavaUtil.Separator.END_SET.appendToGeneratedBuilder(sb, "        ");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return builder;");
        JavaUtil.append(sb, INDENT, "}");
        return sb;
    }

    private void generateDecoderDisplay(StringBuilder sb, String name, List<Token> tokens, List<Token> groups, List<Token> varData) {
        this.appendMessageToString(sb, JavaUtil.decoderName(name));
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return builder;");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    final int originalLimit = limit();");
        JavaUtil.append(sb, INDENT, "    limit(offset + actingBlockLength);");
        JavaUtil.append(sb, INDENT, "    builder.append(\"[" + name + "](sbeTemplateId=\");");
        JavaUtil.append(sb, INDENT, "    builder.append(TEMPLATE_ID);");
        JavaUtil.append(sb, INDENT, "    builder.append(\"|sbeSchemaId=\");");
        JavaUtil.append(sb, INDENT, "    builder.append(SCHEMA_ID);");
        JavaUtil.append(sb, INDENT, "    builder.append(\"|sbeSchemaVersion=\");");
        JavaUtil.append(sb, INDENT, "    if (parentMessage.actingVersion != SCHEMA_VERSION)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        builder.append(parentMessage.actingVersion);");
        JavaUtil.append(sb, INDENT, "        builder.append('/');");
        JavaUtil.append(sb, INDENT, "    }");
        JavaUtil.append(sb, INDENT, "    builder.append(SCHEMA_VERSION);");
        JavaUtil.append(sb, INDENT, "    builder.append(\"|sbeBlockLength=\");");
        JavaUtil.append(sb, INDENT, "    if (actingBlockLength != BLOCK_LENGTH)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        builder.append(actingBlockLength);");
        JavaUtil.append(sb, INDENT, "        builder.append('/');");
        JavaUtil.append(sb, INDENT, "    }");
        JavaUtil.append(sb, INDENT, "    builder.append(BLOCK_LENGTH);");
        JavaUtil.append(sb, INDENT, "    builder.append(\"):\");");
        this.appendDecoderDisplay(sb, tokens, groups, varData, "        ");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    limit(originalLimit);");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return builder;");
        JavaUtil.append(sb, INDENT, "}");
    }

    private void appendGroupInstanceDecoderDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String baseIndent) {
        String indent = baseIndent + INDENT;
        sb.append('\n');
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.append(sb, indent, "    if (null == buffer)");
        JavaUtil.append(sb, indent, "    {");
        JavaUtil.append(sb, indent, "        return builder;");
        JavaUtil.append(sb, indent, "    }");
        sb.append('\n');
        JavaUtil.Separator.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT);
        this.appendDecoderDisplay(sb, fields, groups, varData, indent + INDENT);
        JavaUtil.Separator.END_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT);
        sb.append('\n');
        JavaUtil.append(sb, indent, "    return builder;");
        JavaUtil.append(sb, indent, "}");
    }

    private void appendDecoderDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        Token varDataToken;
        int lengthBeforeLastGeneratedSeparator = -1;
        int i = 0;
        int size = fields.size();
        while (i < size) {
            Token fieldToken = fields.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                Token encodingToken = fields.get(i + 1);
                String fieldName = JavaUtil.formatPropertyName(fieldToken.name());
                lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(fieldName, encodingToken, sb, indent);
                i += fieldToken.componentTokenCount();
                continue;
            }
            ++i;
        }
        size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + String.valueOf(groupToken));
            }
            String groupName = JavaUtil.formatPropertyName(groupToken.name());
            String groupDecoderName = JavaUtil.decoderName(groupToken.name());
            JavaUtil.append(sb, indent, "builder.append(\"" + groupName + String.valueOf((Object)JavaUtil.Separator.KEY_VALUE) + String.valueOf((Object)JavaUtil.Separator.BEGIN_GROUP) + "\");");
            JavaUtil.append(sb, indent, "final int " + groupName + "OriginalOffset = " + groupName + ".offset;");
            JavaUtil.append(sb, indent, "final int " + groupName + "OriginalIndex = " + groupName + ".index;");
            JavaUtil.append(sb, indent, "final " + groupDecoderName + " " + groupName + " = this." + groupName + "();");
            JavaUtil.append(sb, indent, "if (" + groupName + ".count() > 0)");
            JavaUtil.append(sb, indent, "{");
            JavaUtil.append(sb, indent, "    while (" + groupName + ".hasNext())");
            JavaUtil.append(sb, indent, "    {");
            JavaUtil.append(sb, indent, "        " + groupName + ".next().appendTo(builder);");
            JavaUtil.Separator.ENTRY.appendToGeneratedBuilder(sb, indent + "        ");
            JavaUtil.append(sb, indent, "    }");
            JavaUtil.append(sb, indent, "    builder.setLength(builder.length() - 1);");
            JavaUtil.append(sb, indent, "}");
            JavaUtil.append(sb, indent, groupName + ".offset = " + groupName + "OriginalOffset;");
            JavaUtil.append(sb, indent, groupName + ".index = " + groupName + "OriginalIndex;");
            JavaUtil.Separator.END_GROUP.appendToGeneratedBuilder(sb, indent);
            lengthBeforeLastGeneratedSeparator = sb.length();
            JavaUtil.Separator.FIELD.appendToGeneratedBuilder(sb, indent);
            i = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + String.valueOf(varDataToken));
            }
            String characterEncoding = varData.get(i + 3).encoding().characterEncoding();
            String varDataName = JavaUtil.formatPropertyName(varDataToken.name());
            JavaUtil.append(sb, indent, "builder.append(\"" + varDataName + String.valueOf((Object)JavaUtil.Separator.KEY_VALUE) + "\");");
            if (null == characterEncoding) {
                String name = Generators.toUpperFirstChar(varDataToken.name());
                JavaUtil.append(sb, indent, "builder.append(skip" + name + "()).append(\" bytes of raw data\");");
            } else if (JavaUtil.isAsciiEncoding(characterEncoding)) {
                JavaUtil.append(sb, indent, "builder.append('\\'');");
                JavaUtil.append(sb, indent, JavaUtil.formatGetterName(varDataToken.name()) + "(builder);");
                JavaUtil.append(sb, indent, "builder.append('\\'');");
            } else {
                JavaUtil.append(sb, indent, "builder.append('\\'').append(" + varDataName + "()).append('\\'');");
            }
            lengthBeforeLastGeneratedSeparator = sb.length();
            JavaUtil.Separator.FIELD.appendToGeneratedBuilder(sb, indent);
        }
        if (-1 != lengthBeforeLastGeneratedSeparator) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
    }

    private int writeTokenDisplay(String fieldName, Token typeToken, StringBuilder sb, String indent) {
        if (typeToken.encodedLength() <= 0 || typeToken.isConstantEncoding()) {
            return -1;
        }
        JavaUtil.append(sb, indent, "builder.append(\"" + fieldName + String.valueOf((Object)JavaUtil.Separator.KEY_VALUE) + "\");");
        switch (typeToken.signal()) {
            case ENCODING: {
                if (typeToken.arrayLength() > 1) {
                    if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                        JavaUtil.append(sb, indent, "for (int i = 0; i < " + fieldName + "Length() && this." + fieldName + "(i) > 0; i++)");
                        JavaUtil.append(sb, indent, "{");
                        JavaUtil.append(sb, indent, "    builder.append((char)this." + fieldName + "(i));");
                        JavaUtil.append(sb, indent, "}");
                        break;
                    }
                    JavaUtil.Separator.BEGIN_ARRAY.appendToGeneratedBuilder(sb, indent);
                    JavaUtil.append(sb, indent, "if (" + fieldName + "Length() > 0)");
                    JavaUtil.append(sb, indent, "{");
                    JavaUtil.append(sb, indent, "    for (int i = 0; i < " + fieldName + "Length(); i++)");
                    JavaUtil.append(sb, indent, "    {");
                    JavaUtil.append(sb, indent, "        builder.append(this." + fieldName + "(i));");
                    JavaUtil.Separator.ENTRY.appendToGeneratedBuilder(sb, indent + "        ");
                    JavaUtil.append(sb, indent, "    }");
                    JavaUtil.append(sb, indent, "    builder.setLength(builder.length() - 1);");
                    JavaUtil.append(sb, indent, "}");
                    JavaUtil.Separator.END_ARRAY.appendToGeneratedBuilder(sb, indent);
                    break;
                }
                JavaUtil.append(sb, indent, "builder.append(this." + fieldName + "());");
                break;
            }
            case BEGIN_ENUM: {
                JavaUtil.append(sb, indent, "builder.append(this." + fieldName + "());");
                break;
            }
            case BEGIN_SET: 
            case BEGIN_COMPOSITE: {
                String typeName = JavaUtil.formatClassName(JavaUtil.decoderName(typeToken.applicableTypeName()));
                JavaUtil.append(sb, indent, "final " + typeName + " " + fieldName + " = this." + fieldName + "();");
                JavaUtil.append(sb, indent, "if (null != " + fieldName + ")");
                JavaUtil.append(sb, indent, "{");
                JavaUtil.append(sb, indent, INDENT + fieldName + ".appendTo(builder);");
                JavaUtil.append(sb, indent, "}");
                JavaUtil.append(sb, indent, "else");
                JavaUtil.append(sb, indent, "{");
                JavaUtil.append(sb, indent, "    builder.append(\"null\");");
                JavaUtil.append(sb, indent, "}");
                break;
            }
        }
        int lengthBeforeFieldSeparator = sb.length();
        JavaUtil.Separator.FIELD.appendToGeneratedBuilder(sb, indent);
        return lengthBeforeFieldSeparator;
    }

    private void appendToString(StringBuilder sb) {
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public String toString()");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return \"\";");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return appendTo(new StringBuilder()).toString();");
        JavaUtil.append(sb, INDENT, "}");
    }

    private void appendMessageToString(StringBuilder sb, String decoderName) {
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public String toString()");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.append(sb, INDENT, "    if (null == buffer)");
        JavaUtil.append(sb, INDENT, "    {");
        JavaUtil.append(sb, INDENT, "        return \"\";");
        JavaUtil.append(sb, INDENT, "    }");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    final " + decoderName + " decoder = new " + decoderName + "();");
        JavaUtil.append(sb, INDENT, "    decoder.wrap(buffer, offset, actingBlockLength, actingVersion);");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return decoder.appendTo(new StringBuilder()).toString();");
        JavaUtil.append(sb, INDENT, "}");
    }

    private void generateMessageLength(StringBuilder sb, String className, boolean isParent, List<Token> groups, List<Token> varData, String baseIndent) {
        Token varDataToken;
        int i;
        String methodIndent = baseIndent + INDENT;
        String bodyIndent = methodIndent + INDENT;
        JavaUtil.append(sb, methodIndent, BASE_INDENT);
        JavaUtil.append(sb, methodIndent, "public " + className + " sbeSkip()");
        JavaUtil.append(sb, methodIndent, "{");
        if (isParent) {
            JavaUtil.append(sb, bodyIndent, "sbeRewind();");
        }
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + String.valueOf(groupToken));
            }
            String groupName = JavaUtil.formatPropertyName(groupToken.name());
            String groupDecoderName = JavaUtil.decoderName(groupToken.name());
            JavaUtil.append(sb, bodyIndent, groupDecoderName + " " + groupName + " = this." + groupName + "();");
            JavaUtil.append(sb, bodyIndent, "if (" + groupName + ".count() > 0)");
            JavaUtil.append(sb, bodyIndent, "{");
            JavaUtil.append(sb, bodyIndent, "    while (" + groupName + ".hasNext())");
            JavaUtil.append(sb, bodyIndent, "    {");
            JavaUtil.append(sb, bodyIndent, "        " + groupName + ".next();");
            JavaUtil.append(sb, bodyIndent, "        " + groupName + ".sbeSkip();");
            JavaUtil.append(sb, bodyIndent, "    }");
            JavaUtil.append(sb, bodyIndent, "}");
            i = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + String.valueOf(varDataToken));
            }
            String varDataName = JavaUtil.formatPropertyName(varDataToken.name());
            JavaUtil.append(sb, bodyIndent, "skip" + Generators.toUpperFirstChar(varDataName) + "();");
        }
        sb.append('\n');
        JavaUtil.append(sb, bodyIndent, "return this;");
        JavaUtil.append(sb, methodIndent, "}");
    }

    private static String validateBufferImplementation(String fullyQualifiedBufferImplementation, Class<?> bufferClass) {
        Verify.notNull(fullyQualifiedBufferImplementation, "fullyQualifiedBufferImplementation");
        try {
            Class<?> clazz = Class.forName(fullyQualifiedBufferImplementation);
            if (!bufferClass.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(fullyQualifiedBufferImplementation + " doesn't implement " + bufferClass.getName());
            }
            return clazz.getSimpleName();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Unable to find " + fullyQualifiedBufferImplementation, ex);
        }
    }

    private String implementsInterface(String interfaceName) {
        return this.shouldGenerateInterfaces ? " implements " + interfaceName : BASE_INDENT;
    }

    static enum CodecType {
        DECODER,
        ENCODER;

    }
}

