/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntObjConsumer;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public final class FieldPrecedenceModel {
    private final Map<Token, String> groupPathsByField = new HashMap<Token, String>();
    private final Set<Token> topLevelBlockFields = new HashSet<Token>();
    private final CodecInteraction.CodecInteractionFactory interactionFactory = new CodecInteraction.CodecInteractionFactory(this.groupPathsByField, this.topLevelBlockFields);
    private final Map<CodecInteraction, List<TransitionGroup>> transitionsByInteraction = new LinkedHashMap<CodecInteraction, List<TransitionGroup>>();
    private final Map<State, List<TransitionGroup>> transitionsByState = new HashMap<State, List<TransitionGroup>>();
    private final TreeMap<Integer, State> versionWrappedStates = new TreeMap();
    private final State notWrappedState = this.allocateState("NOT_WRAPPED");
    private final String generatedRepresentationClassName;
    private State encoderWrappedState;
    private Set<State> terminalEncoderStates;

    private FieldPrecedenceModel(String generatedRepresentationClassName) {
        this.generatedRepresentationClassName = generatedRepresentationClassName;
    }

    public static FieldPrecedenceModel newInstance(String stateClassName, Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData, Function<IntStream, IntStream> versionsSelector) {
        FieldPrecedenceModel model = new FieldPrecedenceModel(stateClassName);
        model.findTransitions(msgToken, fields, groups, varData, versionsSelector);
        return model;
    }

    public State notWrappedState() {
        return this.notWrappedState;
    }

    public State latestVersionWrappedState() {
        return this.encoderWrappedState;
    }

    public void forEachWrappedStateByVersionDesc(IntObjConsumer<State> consumer) {
        for (Map.Entry entry : this.versionWrappedStates.descendingMap().entrySet()) {
            consumer.accept((Integer)entry.getKey(), (State)entry.getValue());
        }
    }

    public int versionCount() {
        return this.versionWrappedStates.size();
    }

    public void forEachTerminalEncoderState(Consumer<State> consumer) {
        this.terminalEncoderStates.forEach(consumer);
    }

    public void forEachStateOrderedByStateNumber(Consumer<State> consumer) {
        this.transitionsByState.keySet().stream().sorted(Comparator.comparingInt(s -> s.number)).forEach(consumer);
    }

    public int stateCount() {
        return this.transitionsByState.size();
    }

    public CodecInteraction.CodecInteractionFactory interactionFactory() {
        return this.interactionFactory;
    }

    public String generatedRepresentationClassName() {
        return this.generatedRepresentationClassName;
    }

    public void forEachTransition(CodecInteraction interaction, Consumer<TransitionGroup> consumer) {
        List<TransitionGroup> transitionsForContext = this.transitionsByInteraction.get(interaction);
        if (null != transitionsForContext) {
            transitionsForContext.forEach(consumer);
        }
    }

    public void forEachTransitionFrom(State state, Consumer<TransitionGroup> consumer) {
        List<TransitionGroup> transitionGroups = this.transitionsByState.get(state);
        if (null != transitionGroups) {
            transitionGroups.forEach(consumer);
        }
    }

    public void generateGraph(StringBuilder sb, String indent) {
        sb.append(indent).append("digraph G {\n");
        this.transitionsByInteraction.values().forEach(transitionsForContext -> transitionsForContext.forEach(transition -> transition.forEachStartState(startState -> {
            sb.append(indent).append("    ").append(startState.name).append(" -> ").append(transition.endState().name).append(" [label=\"  ").append(transition.interaction.exampleCode());
            if (!transition.interaction.exampleConditions().isEmpty()) {
                sb.append("\\n").append("  where ").append(transition.interaction.exampleConditions());
            }
            sb.append("  \"];\n");
        })));
        sb.append(indent).append("}\n");
    }

    private void findTransitions(Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData, Function<IntStream, IntStream> versionsSelector) {
        IntHashSet versions = new IntHashSet();
        versions.add(msgToken.version());
        FieldPrecedenceModel.walkSchemaLevel(new VersionCollector(versions), fields, groups, varData);
        FieldPrecedenceModel.walkSchemaLevel(new PathCollector(this.topLevelBlockFields, this.groupPathsByField), fields, groups, varData);
        IntStream selectedVersions = versionsSelector.apply(versions.stream().mapToInt(i -> i));
        selectedVersions.sorted().forEach(version -> {
            State versionWrappedState = this.allocateState("V" + version + "_BLOCK");
            this.versionWrappedStates.put(version, versionWrappedState);
            CodecInteraction wrapInteraction = this.interactionFactory.wrap(version);
            this.allocateTransitions(wrapInteraction, Collections.singletonList(this.notWrappedState), versionWrappedState);
            TransitionCollector transitionCollector = new TransitionCollector("V" + version + "_", Collections.singleton(versionWrappedState), versionWrappedState, token -> token.version() <= version);
            FieldPrecedenceModel.walkSchemaLevel(transitionCollector, fields, groups, varData);
            this.encoderWrappedState = versionWrappedState;
            this.terminalEncoderStates = transitionCollector.exitStates();
        });
    }

    private State allocateState(String name) {
        State state = new State(this.transitionsByState.size(), name);
        this.transitionsByState.put(state, new ArrayList());
        return state;
    }

    private void allocateTransitions(CodecInteraction interaction, Collection<State> from, State to) {
        TransitionGroup transitionGroup = new TransitionGroup(interaction, from, to);
        List transitionsForInteraction = this.transitionsByInteraction.computeIfAbsent(interaction, ignored -> new ArrayList());
        boolean duplicateEndState = transitionsForInteraction.stream().anyMatch(t -> t.to.number == transitionGroup.to.number);
        if (duplicateEndState) {
            throw new IllegalStateException("Duplicate end state: " + transitionGroup.to.name);
        }
        Optional<TransitionGroup> conflictingTransition = transitionsForInteraction.stream().filter(t -> t.from.stream().anyMatch(transitionGroup.from::contains)).findAny();
        if (conflictingTransition.isPresent()) {
            throw new IllegalStateException("Conflicting transition: " + String.valueOf(transitionGroup) + " conflicts with " + String.valueOf(conflictingTransition.get()));
        }
        transitionsForInteraction.add(transitionGroup);
        from.forEach(fromState -> this.transitionsByState.get(fromState).add(transitionGroup));
    }

    private static void walkSchemaLevel(SchemaConsumer consumer, List<Token> fields, List<Token> groups, List<Token> varData) {
        Token token2;
        int i;
        Generators.forEachField(fields, (token, ignored) -> consumer.onBlockField((Token)token));
        for (i = 0; i < groups.size(); ++i) {
            token2 = groups.get(i);
            if (token2.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + String.valueOf(token2));
            }
            int groupHeaderTokenCount = groups.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> groupFields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(groups, i, groupFields);
            ArrayList<Token> groupGroups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(groups, i, groupGroups);
            ArrayList<Token> groupVarData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(groups, i, groupVarData);
            consumer.onEnterRepeatingGroup(token2, groupFields, groupGroups, groupVarData);
        }
        for (i = 0; i < varData.size(); i += token2.componentTokenCount()) {
            token2 = varData.get(i);
            if (token2.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + String.valueOf(token2));
            }
            consumer.onVarData(token2);
        }
    }

    public static abstract class CodecInteraction {
        public abstract String groupQualifiedName();

        abstract String exampleCode();

        abstract String exampleConditions();

        public final boolean isTopLevelBlockFieldAccess() {
            if (this instanceof AccessField) {
                AccessField accessField = (AccessField)this;
                return accessField.isTopLevelBlockField();
            }
            return false;
        }

        private static final class AccessField
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;
            private final boolean isTopLevelBlockField;

            private AccessField(String groupPath, Token token, boolean isTopLevelBlockField) {
                this.isTopLevelBlockField = isTopLevelBlockField;
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_FIELD || token.signal() == Signal.BEGIN_VAR_DATA);
                this.groupPath = groupPath;
                this.token = token;
            }

            boolean isTopLevelBlockField() {
                return this.isTopLevelBlockField;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            public String exampleCode() {
                return this.groupPath + this.token.name() + "(?)";
            }

            @Override
            public String exampleConditions() {
                return "";
            }
        }

        public static final class CodecInteractionFactory {
            private final Int2ObjectHashMap<CodecInteraction> wrapInteractions = new Int2ObjectHashMap();
            private final Map<Token, CodecInteraction> accessFieldInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> determineGroupIsEmptyInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> determineGroupHasElementsInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> moveToNextElementInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> moveToLastElementInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> resetCountToIndexInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, CodecInteraction> accessVarDataLengthInteractions = new HashMap<Token, CodecInteraction>();
            private final Map<Token, String> groupPathsByField;
            private final Set<Token> topLevelBlockFields;

            CodecInteractionFactory(Map<Token, String> groupPathsByField, Set<Token> topLevelBlockFields) {
                this.groupPathsByField = groupPathsByField;
                this.topLevelBlockFields = topLevelBlockFields;
            }

            public CodecInteraction wrap(int version) {
                return this.wrapInteractions.computeIfAbsent(version, Wrap::new);
            }

            public CodecInteraction accessField(Token token) {
                return this.accessFieldInteractions.computeIfAbsent(token, t -> new AccessField(this.groupPathsByField.get(t), (Token)t, this.topLevelBlockFields.contains(t)));
            }

            public CodecInteraction determineGroupIsEmpty(Token token) {
                return this.determineGroupIsEmptyInteractions.computeIfAbsent(token, t -> new DetermineGroupIsEmpty(this.groupPathsByField.get(t), (Token)t));
            }

            public CodecInteraction determineGroupHasElements(Token token) {
                return this.determineGroupHasElementsInteractions.computeIfAbsent(token, t -> new DetermineGroupHasElements(this.groupPathsByField.get(t), (Token)t));
            }

            public CodecInteraction moveToNextElement(Token token) {
                return this.moveToNextElementInteractions.computeIfAbsent(token, t -> new MoveToNextElement(this.groupPathsByField.get(t), (Token)t));
            }

            public CodecInteraction moveToLastElement(Token token) {
                return this.moveToLastElementInteractions.computeIfAbsent(token, t -> new MoveToLastElement(this.groupPathsByField.get(t), (Token)t));
            }

            public CodecInteraction resetCountToIndex(Token token) {
                return this.resetCountToIndexInteractions.computeIfAbsent(token, t -> new ResetCountToIndex(this.groupPathsByField.get(t), (Token)t));
            }

            public CodecInteraction accessVarDataLength(Token token) {
                return this.accessVarDataLengthInteractions.computeIfAbsent(token, t -> new AccessVarDataLength(this.groupPathsByField.get(t), (Token)t));
            }
        }

        private static final class AccessVarDataLength
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private AccessVarDataLength(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_VAR_DATA);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + "Length()";
            }

            @Override
            String exampleConditions() {
                return "";
            }
        }

        private static final class ResetCountToIndex
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private ResetCountToIndex(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_GROUP);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + ".resetCountToIndex()";
            }

            @Override
            String exampleConditions() {
                return "";
            }
        }

        private static final class MoveToLastElement
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private MoveToLastElement(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_GROUP);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + ".next()";
            }

            @Override
            String exampleConditions() {
                return "count - newIndex == 1";
            }
        }

        private static final class MoveToNextElement
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private MoveToNextElement(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_GROUP);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + ".next()";
            }

            @Override
            String exampleConditions() {
                return "count - newIndex > 1";
            }
        }

        private static final class DetermineGroupHasElements
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private DetermineGroupHasElements(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_GROUP);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + "Count(>0)";
            }

            @Override
            String exampleConditions() {
                return "";
            }
        }

        private static final class DetermineGroupIsEmpty
        extends CodecInteraction {
            private final String groupPath;
            private final Token token;

            private DetermineGroupIsEmpty(String groupPath, Token token) {
                assert (groupPath != null);
                assert (token.signal() == Signal.BEGIN_GROUP);
                this.groupPath = groupPath;
                this.token = token;
            }

            @Override
            public String groupQualifiedName() {
                return this.groupPath + this.token.name();
            }

            @Override
            String exampleCode() {
                return this.groupPath + this.token.name() + "Count(0)";
            }

            @Override
            String exampleConditions() {
                return "";
            }
        }

        private static final class Wrap
        extends CodecInteraction {
            private final int version;

            Wrap(int version) {
                this.version = version;
            }

            @Override
            public String groupQualifiedName() {
                return "wrap";
            }

            @Override
            public String exampleCode() {
                return "wrap(version=" + this.version + ")";
            }

            @Override
            public String exampleConditions() {
                return "";
            }
        }
    }

    public static final class State {
        private final int number;
        private final String name;

        private State(int number, String name) {
            this.number = number;
            this.name = name;
        }

        public int number() {
            return this.number;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return "State{number=" + this.number + ", name='" + this.name + "'}";
        }
    }

    private static final class VersionCollector
    implements SchemaConsumer {
        private final IntHashSet versions;

        VersionCollector(IntHashSet versions) {
            this.versions = versions;
        }

        @Override
        public void onBlockField(Token token) {
            this.versions.add(token.version());
        }

        @Override
        public void onEnterRepeatingGroup(Token token, List<Token> groupFields, List<Token> groupGroups, List<Token> groupVarData) {
            this.versions.add(token.version());
            FieldPrecedenceModel.walkSchemaLevel(this, groupFields, groupGroups, groupVarData);
        }

        @Override
        public void onVarData(Token token) {
            this.versions.add(token.version());
        }
    }

    private static interface SchemaConsumer {
        public void onBlockField(Token var1);

        public void onEnterRepeatingGroup(Token var1, List<Token> var2, List<Token> var3, List<Token> var4);

        public void onVarData(Token var1);
    }

    private static final class PathCollector
    implements SchemaConsumer {
        private final ArrayDeque<Token> groupPath = new ArrayDeque();
        private final Set<Token> topLevelBlockFields;
        private final Map<Token, String> groupPathsByField;

        private PathCollector(Set<Token> topLevelBlockFields, Map<Token, String> groupPathsByField) {
            this.topLevelBlockFields = topLevelBlockFields;
            this.groupPathsByField = groupPathsByField;
        }

        @Override
        public void onBlockField(Token token) {
            if (this.groupPath.isEmpty()) {
                this.topLevelBlockFields.add(token);
            }
            this.groupPathsByField.put(token, this.currentGroupPath());
        }

        @Override
        public void onEnterRepeatingGroup(Token token, List<Token> groupFields, List<Token> groupGroups, List<Token> groupVarData) {
            this.groupPathsByField.put(token, this.currentGroupPath());
            this.groupPath.addLast(token);
            FieldPrecedenceModel.walkSchemaLevel(this, groupFields, groupGroups, groupVarData);
            this.groupPath.removeLast();
        }

        @Override
        public void onVarData(Token token) {
            this.groupPathsByField.put(token, this.currentGroupPath());
        }

        private String currentGroupPath() {
            StringBuilder sb = new StringBuilder();
            this.groupPath.forEach(token -> sb.append(token.name()).append('.'));
            return sb.toString();
        }
    }

    public static final class TransitionGroup {
        private final CodecInteraction interaction;
        private final Set<State> from;
        private final State to;

        private TransitionGroup(CodecInteraction interaction, Collection<State> from, State to) {
            this.interaction = interaction;
            this.from = new HashSet<State>(from);
            this.to = to;
        }

        public void forEachStartState(Consumer<State> consumer) {
            this.from.forEach(consumer);
        }

        public State endState() {
            return this.to;
        }

        public boolean alwaysEndsInStartState() {
            return this.from.size() == 1 && this.from.contains(this.to);
        }

        public String exampleCode() {
            return this.interaction.exampleCode();
        }

        public String toString() {
            return "Transition{interaction='" + this.exampleCode() + "', from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + "}";
        }
    }

    private final class TransitionCollector
    implements SchemaConsumer {
        private final String statePrefix;
        private final HashSet<State> currentStates;
        private final State blockState;
        private final Predicate<Token> filter;

        private TransitionCollector(String statePrefix, Set<State> fromStates, State blockState, Predicate<Token> filter) {
            this.statePrefix = statePrefix;
            this.currentStates = new HashSet<State>(fromStates);
            this.blockState = blockState;
            this.filter = filter;
            this.currentStates.add(blockState);
        }

        @Override
        public void onBlockField(Token token) {
            if (this.filter.test(token)) {
                CodecInteraction codecInteraction = FieldPrecedenceModel.this.interactionFactory.accessField(token);
                FieldPrecedenceModel.this.allocateTransitions(codecInteraction, this.currentStates, this.blockState);
            }
        }

        @Override
        public void onEnterRepeatingGroup(Token token, List<Token> groupFields, List<Token> groupGroups, List<Token> groupVarData) {
            if (this.filter.test(token)) {
                String groupName = token.name().toUpperCase();
                String groupPrefix = this.statePrefix + groupName + "_";
                State nRemainingGroup = FieldPrecedenceModel.this.allocateState(groupPrefix + "N");
                State nRemainingGroupElement = FieldPrecedenceModel.this.allocateState(groupPrefix + "N_BLOCK");
                State oneRemainingGroupElement = FieldPrecedenceModel.this.allocateState(groupPrefix + "1_BLOCK");
                State doneGroup = FieldPrecedenceModel.this.allocateState(groupPrefix + "DONE");
                HashSet<State> beginGroupStates = new HashSet<State>(this.currentStates);
                CodecInteraction emptyGroupInteraction = FieldPrecedenceModel.this.interactionFactory.determineGroupIsEmpty(token);
                FieldPrecedenceModel.this.allocateTransitions(emptyGroupInteraction, beginGroupStates, doneGroup);
                CodecInteraction nonEmptyGroupInteraction = FieldPrecedenceModel.this.interactionFactory.determineGroupHasElements(token);
                FieldPrecedenceModel.this.allocateTransitions(nonEmptyGroupInteraction, beginGroupStates, nRemainingGroup);
                this.currentStates.clear();
                this.currentStates.add(nRemainingGroupElement);
                TransitionCollector nRemainingCollector = new TransitionCollector(groupPrefix + "N_", this.currentStates, nRemainingGroupElement, this.filter);
                FieldPrecedenceModel.walkSchemaLevel(nRemainingCollector, groupFields, groupGroups, groupVarData);
                this.currentStates.clear();
                this.currentStates.add(nRemainingGroup);
                this.currentStates.addAll(nRemainingCollector.exitStates());
                CodecInteraction nextGroupElementInteraction = FieldPrecedenceModel.this.interactionFactory.moveToNextElement(token);
                FieldPrecedenceModel.this.allocateTransitions(nextGroupElementInteraction, this.currentStates, nRemainingGroupElement);
                this.currentStates.clear();
                this.currentStates.add(nRemainingGroup);
                this.currentStates.addAll(nRemainingCollector.exitStates());
                CodecInteraction lastGroupElementInteraction = FieldPrecedenceModel.this.interactionFactory.moveToLastElement(token);
                FieldPrecedenceModel.this.allocateTransitions(lastGroupElementInteraction, this.currentStates, oneRemainingGroupElement);
                this.currentStates.clear();
                this.currentStates.add(oneRemainingGroupElement);
                TransitionCollector oneRemainingCollector = new TransitionCollector(groupPrefix + "1_", this.currentStates, oneRemainingGroupElement, this.filter);
                FieldPrecedenceModel.walkSchemaLevel(oneRemainingCollector, groupFields, groupGroups, groupVarData);
                CodecInteraction resetCountToIndexInteraction = FieldPrecedenceModel.this.interactionFactory.resetCountToIndex(token);
                this.currentStates.clear();
                this.currentStates.add(doneGroup);
                this.currentStates.add(nRemainingGroup);
                this.currentStates.addAll(nRemainingCollector.exitStates());
                this.currentStates.addAll(oneRemainingCollector.exitStates());
                FieldPrecedenceModel.this.allocateTransitions(resetCountToIndexInteraction, this.currentStates, doneGroup);
                this.currentStates.clear();
                this.currentStates.add(doneGroup);
                this.currentStates.addAll(oneRemainingCollector.exitStates());
            }
        }

        @Override
        public void onVarData(Token token) {
            if (this.filter.test(token)) {
                CodecInteraction lengthAccessInteraction = FieldPrecedenceModel.this.interactionFactory.accessVarDataLength(token);
                this.currentStates.forEach(state -> FieldPrecedenceModel.this.allocateTransitions(lengthAccessInteraction, (Collection<State>)Collections.singleton(state), (State)state));
                CodecInteraction codecInteraction = FieldPrecedenceModel.this.interactionFactory.accessField(token);
                State accessedState = FieldPrecedenceModel.this.allocateState(this.statePrefix + token.name().toUpperCase() + "_DONE");
                FieldPrecedenceModel.this.allocateTransitions(codecInteraction, this.currentStates, accessedState);
                this.currentStates.clear();
                this.currentStates.add(accessedState);
            }
        }

        private Set<State> exitStates() {
            return this.currentStates;
        }
    }
}

