/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.common;

import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Token;

public final class DtoValidationUtil {
    private DtoValidationUtil() {
    }

    public static boolean nativeTypeRepresentsValuesLessThanValidRange(Token fieldToken, Encoding encoding, NativeIntegerSupport integerSupport) {
        PrimitiveType primitiveType = encoding.primitiveType();
        PrimitiveValue minValue = encoding.applicableMinValue();
        switch (minValue.representation()) {
            case LONG: {
                long nativeMinValue = DtoValidationUtil.nativeTypeMinValue(primitiveType, integerSupport);
                PrimitiveValue nullValue = encoding.applicableNullValue();
                boolean gapBefore = minValue.longValue() > nativeMinValue;
                boolean nullFillsGap = fieldToken.isOptionalEncoding() && nullValue.longValue() == nativeMinValue && minValue.longValue() == nativeMinValue + 1L;
                return gapBefore && !nullFillsGap;
            }
            case DOUBLE: {
                switch (primitiveType) {
                    case FLOAT: {
                        return minValue.doubleValue() > -3.4028234663852886E38;
                    }
                    case DOUBLE: {
                        return minValue.doubleValue() > -1.7976931348623157E308;
                    }
                }
                throw new IllegalArgumentException("Type did not have a double representation: " + String.valueOf((Object)primitiveType));
            }
        }
        throw new IllegalArgumentException("Cannot understand the range of a type with representation: " + String.valueOf((Object)minValue.representation()));
    }

    public static boolean nativeTypeRepresentsValuesGreaterThanValidRange(Token fieldToken, Encoding encoding, NativeIntegerSupport integerSupport) {
        PrimitiveType primitiveType = encoding.primitiveType();
        PrimitiveValue maxValue = encoding.applicableMaxValue();
        switch (maxValue.representation()) {
            case LONG: {
                long nativeMaxValue = DtoValidationUtil.nativeTypeMaxValue(primitiveType, integerSupport);
                PrimitiveValue nullValue = encoding.applicableNullValue();
                boolean gapAfter = maxValue.longValue() < nativeMaxValue;
                boolean nullFillsGap = fieldToken.isOptionalEncoding() && nullValue.longValue() == nativeMaxValue && maxValue.longValue() + 1L == nativeMaxValue;
                return gapAfter && !nullFillsGap;
            }
            case DOUBLE: {
                switch (primitiveType) {
                    case FLOAT: {
                        return maxValue.doubleValue() < 3.4028234663852886E38;
                    }
                    case DOUBLE: {
                        return maxValue.doubleValue() < Double.MAX_VALUE;
                    }
                }
                throw new IllegalArgumentException("Type did not have a double representation: " + String.valueOf((Object)primitiveType));
            }
        }
        throw new IllegalArgumentException("Cannot understand the range of a type with representation: " + String.valueOf((Object)maxValue.representation()));
    }

    private static long nativeTypeMinValue(PrimitiveType primitiveType, NativeIntegerSupport integerSupport) {
        switch (primitiveType) {
            case CHAR: {
                return 0L;
            }
            case INT8: {
                return -128L;
            }
            case INT16: {
                return -32768L;
            }
            case INT32: {
                return Integer.MIN_VALUE;
            }
            case INT64: {
                return Long.MIN_VALUE;
            }
            case UINT8: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return -32768L;
                }
                return 0L;
            }
            case UINT16: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return Integer.MIN_VALUE;
                }
                return 0L;
            }
            case UINT32: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return Long.MIN_VALUE;
                }
                return 0L;
            }
            case UINT64: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("Type did not have a long representation: " + String.valueOf((Object)primitiveType));
    }

    private static long nativeTypeMaxValue(PrimitiveType primitiveType, NativeIntegerSupport integerSupport) {
        switch (primitiveType) {
            case CHAR: {
                return 65535L;
            }
            case INT8: {
                return 127L;
            }
            case INT16: {
                return 32767L;
            }
            case INT32: {
                return Integer.MAX_VALUE;
            }
            case INT64: {
                return Long.MAX_VALUE;
            }
            case UINT8: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return 32767L;
                }
                return 255L;
            }
            case UINT16: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return Integer.MAX_VALUE;
                }
                return 65535L;
            }
            case UINT32: {
                if (integerSupport == NativeIntegerSupport.SIGNED_ONLY) {
                    return Long.MAX_VALUE;
                }
                return 0xFFFFFFFFL;
            }
            case UINT64: {
                return -1L;
            }
        }
        throw new IllegalArgumentException("Type did not have a long representation: " + String.valueOf((Object)primitiveType));
    }

    public static enum NativeIntegerSupport {
        SIGNED_AND_UNSIGNED,
        SIGNED_ONLY;

    }
}

