/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class Field {
    public static final int INVALID_ID = Integer.MAX_VALUE;
    private final String name;
    private final String description;
    private final int id;
    private final Type type;
    private final int offset;
    private final String semanticType;
    private final Presence presence;
    private final String valueRef;
    private final int blockLength;
    private final CompositeType dimensionType;
    private final boolean variableLength;
    private final int sinceVersion;
    private final int deprecated;
    private List<Field> groupFieldList;
    private int computedOffset;
    private int computedBlockLength;
    private final String epoch;
    private final String timeUnit;

    Field(String name, String description, int id, Type type, int offset, String semanticType, Presence presence, String valueRef, int blockLength, CompositeType dimensionType, boolean variableLength, int sinceVersion, int deprecated, String epoch, String timeUnit) {
        this.name = name;
        this.description = description;
        this.id = id;
        this.type = type;
        this.offset = offset;
        this.semanticType = semanticType;
        this.presence = presence;
        this.valueRef = valueRef;
        this.blockLength = blockLength;
        this.dimensionType = dimensionType;
        this.variableLength = variableLength;
        this.sinceVersion = sinceVersion;
        this.deprecated = deprecated;
        this.groupFieldList = null;
        this.computedOffset = 0;
        this.computedBlockLength = 0;
        this.epoch = epoch;
        this.timeUnit = timeUnit;
    }

    Field(Field field, List<Field> groupFieldList) {
        this(field.name, field.description, field.id, field.type, field.offset, field.semanticType, field.presence, field.valueRef, field.blockLength, field.dimensionType, field.variableLength, field.sinceVersion, field.deprecated, field.epoch, field.timeUnit);
        this.groupFieldList = groupFieldList;
    }

    public void validate(Node node, Map<String, Type> typeByNameMap) {
        if (this.type != null && this.semanticType != null && this.type.semanticType() != null && !this.semanticType.equals(this.type.semanticType())) {
            XmlSchemaParser.handleError(node, "Mismatched semanticType on type and field: " + this.name);
        }
        XmlSchemaParser.checkForValidName(node, this.name);
        if (null != this.valueRef) {
            this.validateValueRef(node, typeByNameMap);
        }
        if (this.type instanceof EnumType && this.presence == Presence.CONSTANT && null == this.valueRef) {
            XmlSchemaParser.handleError(node, "valueRef not set for constant enum");
        }
        if (null != this.valueRef && this.presence == Presence.CONSTANT) {
            String valueRefType = this.valueRef.substring(0, this.valueRef.indexOf(46));
            if (!(this.type instanceof EnumType)) {
                if (this.type instanceof EncodedDataType) {
                    EnumType enumType = (EnumType)typeByNameMap.get(valueRefType);
                    if (((EncodedDataType)this.type).primitiveType() != enumType.encodingType()) {
                        XmlSchemaParser.handleError(node, "valueRef does not match field type: " + this.valueRef);
                    }
                } else {
                    XmlSchemaParser.handleError(node, "valueRef does not match field type: " + this.valueRef);
                }
            } else if (!valueRefType.equals(this.type.name())) {
                XmlSchemaParser.handleError(node, "valueRef for enum name not found: " + valueRefType);
            }
        }
    }

    public void groupFields(List<Field> fields) {
        this.groupFieldList = fields;
    }

    public List<Field> groupFields() {
        return this.groupFieldList;
    }

    public void computedOffset(int offset) {
        this.computedOffset = offset;
    }

    public int computedOffset() {
        return this.computedOffset;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public int id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public int offset() {
        return this.offset;
    }

    public int blockLength() {
        return this.blockLength;
    }

    public void computedBlockLength(int length) {
        this.computedBlockLength = length;
    }

    public int computedBlockLength() {
        return this.computedBlockLength;
    }

    public Presence presence() {
        return this.presence;
    }

    public String valueRef() {
        return this.valueRef;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public CompositeType dimensionType() {
        return this.dimensionType;
    }

    public boolean isVariableLength() {
        return this.variableLength;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public int deprecated() {
        return this.deprecated;
    }

    public String epoch() {
        return this.epoch;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return "Field{name='" + this.name + "', description='" + this.description + "', id=" + this.id + ", type=" + this.type + ", offset=" + this.offset + ", semanticType='" + this.semanticType + "', presence=" + this.presence + ", valueRef='" + this.valueRef + "', blockLength=" + this.blockLength + ", dimensionType=" + this.dimensionType + ", variableLength=" + this.variableLength + ", sinceVersion=" + this.sinceVersion + ", deprecated=" + this.deprecated + ", groupFieldList=" + this.groupFieldList + ", computedOffset=" + this.computedOffset + ", computedBlockLength=" + this.computedBlockLength + ", epoch='" + this.epoch + "', timeUnit=" + this.timeUnit + "}";
    }

    private void validateValueRef(Node node, Map<String, Type> typeByNameMap) {
        String valueRefType;
        Type valueType;
        int periodIndex = this.valueRef.indexOf(46);
        if (periodIndex < 1 || periodIndex == this.valueRef.length() - 1) {
            XmlSchemaParser.handleError(node, "valueRef format not valid (enum-name.valid-value-name): " + this.valueRef);
        }
        if (null == (valueType = typeByNameMap.get(valueRefType = this.valueRef.substring(0, periodIndex)))) {
            XmlSchemaParser.handleError(node, "valueRef for enum name not found: " + valueRefType);
        }
        if (valueType instanceof EnumType) {
            EnumType enumType = (EnumType)valueType;
            String validValueName = this.valueRef.substring(periodIndex + 1);
            if (null == enumType.getValidValue(validValueName)) {
                XmlSchemaParser.handleError(node, "valueRef for validValue name not found: " + validValueName);
            }
        } else {
            XmlSchemaParser.handleError(node, "valueRef for is not of type enum: " + valueRefType);
        }
    }

    static class Builder {
        private String name;
        private String description;
        private int id = Integer.MAX_VALUE;
        private Type type;
        private int offset;
        private String semanticType;
        private Presence presence;
        private String refValue;
        private int blockLength;
        private CompositeType dimensionType;
        private boolean variableLength;
        private int sinceVersion = 0;
        private int deprecated = 0;
        private String epoch;
        private String timeUnit;

        Builder() {
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder description(String description) {
            this.description = description;
            return this;
        }

        Builder id(int id) {
            this.id = id;
            return this;
        }

        Builder type(Type type) {
            this.type = type;
            return this;
        }

        Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        Builder semanticType(String semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        Builder presence(Presence presence) {
            this.presence = presence;
            return this;
        }

        Builder valueRef(String refValue) {
            this.refValue = refValue;
            return this;
        }

        Builder blockLength(int blockLength) {
            this.blockLength = blockLength;
            return this;
        }

        Builder dimensionType(CompositeType dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        Builder variableLength(boolean variableLength) {
            this.variableLength = variableLength;
            return this;
        }

        Builder sinceVersion(int sinceVersion) {
            this.sinceVersion = sinceVersion;
            return this;
        }

        Builder deprecated(int deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        Field build() {
            return new Field(this.name, this.description, this.id, this.type, this.offset, this.semanticType, this.presence, this.refValue, this.blockLength, this.dimensionType, this.variableLength, this.sinceVersion, this.deprecated, this.epoch, this.timeUnit);
        }
    }
}

