/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongObjConsumer;
import org.agrona.collections.LongObjectToObjectFunction;

public class Long2ObjectCache<V>
implements Map<Long, V> {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int setSizeShift;
    private final int mask;
    private final long[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Long2ObjectCache(int numSets, int setSize, Consumer<V> evictionConsumer) {
        CollectionUtil.validatePositivePowerOfTwo(numSets);
        CollectionUtil.validatePositivePowerOfTwo(setSize);
        Objects.requireNonNull(evictionConsumer, "null values are not permitted");
        if ((long)numSets * (long)setSize > 0x7FFFFFFFFFFFFFF7L) {
            throw new IllegalArgumentException("total capacity must be <= max array size: numSets=" + numSets + " setSize=" + setSize);
        }
        this.setSize = setSize;
        this.setSizeShift = Long.numberOfTrailingZeros(setSize);
        this.capacity = numSets << this.setSizeShift;
        this.mask = numSets - 1;
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = evictionConsumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    public boolean containsKey(long key) {
        boolean found = false;
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        long[] keys = this.keys;
        Object[] values = this.values;
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < setEndIndex && null != values[i]; ++i) {
            if (key != keys[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            Object[] values;
            for (Object v : values = this.values) {
                if (!Objects.equals(v, value)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Long)key);
    }

    public V get(long key) {
        Object value;
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        long[] keys = this.keys;
        Object[] values = this.values;
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < setEndIndex && null != (value = values[i]); ++i) {
            if (key != keys[i]) continue;
            ++this.cacheHits;
            return (V)value;
        }
        ++this.cacheMisses;
        return null;
    }

    public V getOrDefault(long key, V defaultValue) {
        V value = this.get(key);
        return null != value ? value : defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super V> action) {
        this.forEachLong(action::accept);
    }

    public void forEachLong(LongObjConsumer<? super V> consumer) {
        Objects.requireNonNull(consumer);
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            Object value = values[index];
            if (null == value) continue;
            consumer.accept(keys[index], value);
            --remaining;
        }
    }

    @Override
    public V computeIfAbsent(Long key, Function<? super Long, ? extends V> mappingFunction) {
        return (V)this.computeIfAbsent((long)key, mappingFunction::apply);
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        V value = this.get(key);
        if (null == value && null != (value = mappingFunction.apply(key))) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V computeIfPresent(Long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        return (V)this.computeIfPresent((long)key, remappingFunction::apply);
    }

    public V computeIfPresent(long key, LongObjectToObjectFunction<? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        V oldValue = this.get(key);
        if (null != oldValue) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (null != newValue) {
                this.put(key, newValue);
                return newValue;
            }
            this.remove(key);
            return null;
        }
        return null;
    }

    @Override
    public V compute(Long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        return (V)this.compute((long)key, remappingFunction::apply);
    }

    public V compute(long key, LongObjectToObjectFunction<? super V, ? extends V> remappingFunction) {
        V oldValue = this.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (null != newValue) {
            this.put(key, newValue);
            return newValue;
        }
        if (null != oldValue) {
            this.remove(key);
        }
        return null;
    }

    @Override
    public V merge(Long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge((long)key, value, remappingFunction);
    }

    @Override
    public V merge(long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        V oldValue = this.get(key);
        V v = newValue = null == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (null != newValue) {
            this.put(key, newValue);
            return newValue;
        }
        this.remove(key);
        return null;
    }

    @Override
    public V putIfAbsent(Long key, V value) {
        return this.putIfAbsent((long)key, value);
    }

    @Override
    public V putIfAbsent(long key, V value) {
        V existingValue = this.get(key);
        if (null == existingValue) {
            this.put(key, value);
            return null;
        }
        return existingValue;
    }

    @Override
    public V put(Long key, V value) {
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        int setBeginIndex;
        Objects.requireNonNull(value, "null values are not supported");
        int setNumber = Hashing.hash(key, this.mask);
        Object[] values = this.values;
        long[] keys = this.keys;
        Object evictedValue = null;
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < nextSetIndex && null != (evictedValue = values[i]); ++i) {
            if (key != keys[i]) continue;
            this.shuffleUp(i, nextSetIndex - 1);
            break;
        }
        if (null == evictedValue) {
            evictedValue = values[setBeginIndex + (this.setSize - 1)];
        }
        this.shuffleDown(setBeginIndex);
        keys[setBeginIndex] = key;
        values[setBeginIndex] = value;
        ++this.cachePuts;
        if (null != evictedValue) {
            this.evictionConsumer.accept(evictedValue);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, value);
    }

    public boolean remove(long key, V value) {
        V existingValue = this.get(key);
        if (null != existingValue && Objects.equals(existingValue, value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Long)key);
    }

    public V remove(long key) {
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        long[] keys = this.keys;
        Object[] values = this.values;
        Object value = null;
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < nextSetIndex && null != (value = values[i]); ++i) {
            if (key != keys[i]) continue;
            this.shuffleUp(i, nextSetIndex - 1);
            --this.size;
            this.evictionConsumer.accept(value);
            break;
        }
        return (V)value;
    }

    @Override
    public boolean replace(Long key, V oldValue, V newValue) {
        return this.replace((long)key, oldValue, newValue);
    }

    @Override
    public boolean replace(long key, V oldValue, V newValue) {
        V existingValue = this.get(key);
        if (null != existingValue && Objects.equals(existingValue, oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(Long key, V value) {
        return this.replace((long)key, value);
    }

    @Override
    public V replace(long key, V value) {
        V oldValue = this.get(key);
        if (null != oldValue) {
            this.put(key, value);
        }
        return oldValue;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super V, ? extends V> function) {
        this.replaceAllLong(function::apply);
    }

    public void replaceAllLong(LongObjectToObjectFunction<? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            Object oldValue = values[index];
            if (null == oldValue) continue;
            V newValue = function.apply(keys[index], oldValue);
            Objects.requireNonNull(newValue, "null values are not supported");
            values[index] = newValue;
            --remaining;
        }
    }

    private void shuffleUp(int fromIndex, int toIndex) {
        long[] keys = this.keys;
        Object[] values = this.values;
        for (int i = fromIndex; i < toIndex; ++i) {
            values[i] = values[i + 1];
            keys[i] = keys[i + 1];
        }
        values[toIndex] = null;
    }

    private void shuffleDown(int setBeginIndex) {
        long[] keys = this.keys;
        Object[] values = this.values;
        for (int i = setBeginIndex + (this.setSize - 1); i > setBeginIndex; --i) {
            values[i] = values[i - 1];
            keys[i] = keys[i - 1];
        }
        values[setBeginIndex] = null;
    }

    @Override
    public void clear() {
        for (Object value : this.values) {
            if (null == value) continue;
            values[i] = null;
            --this.size;
            this.evictionConsumer.accept(value);
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Long2ObjectCache<? extends V> map) {
        EntryIterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.findNext();
            this.put(iterator.getLongKey(), (V)iterator.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            sb.append(keys[i]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = values[i];
            if (null == thisValue || thisValue.equals(thatValue = that.get(keys[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            result += Long.hashCode(keys[i]) ^ value.hashCode();
        }
        return result;
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private final EntryIterator iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        public EntryIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<Long, V>> filter) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Long, V>>
    implements Map.Entry<Long, V> {
        @Override
        public Map.Entry<Long, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2ObjectCache.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Long2ObjectCache.this.values[this.position()];
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("no set on this iterator");
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectCache.this.containsKey(o);
        }

        public boolean contains(long key) {
            return Long2ObjectCache.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectCache.this.containsValue(o);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectCache.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Long2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected final int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            boolean found = false;
            Object[] values = Long2ObjectCache.this.values;
            int size = Long2ObjectCache.this.capacity;
            for (int i = this.position + 1; i < size; ++i) {
                if (null == values[i]) continue;
                found = true;
                this.position = i;
                --this.remaining;
                break;
            }
            if (!found) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Long2ObjectCache.this.size;
            this.position = -1;
        }
    }
}

