/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.HashMap;
import java.util.Map;
import uk.co.real_logic.sbe.xml.IdKeyedSchemaTransformer;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.SchemaTransformer;
import uk.co.real_logic.sbe.xml.SinceVersionSchemaTransformer;

public class SchemaTransformerFactory
implements SchemaTransformer {
    private final SchemaTransformer transformer;

    public SchemaTransformerFactory(String schemaTransformConfig) {
        this.transformer = SchemaTransformerFactory.parse(schemaTransformConfig);
    }

    @Override
    public MessageSchema transform(MessageSchema originalSchema) {
        return this.transformer.transform(originalSchema);
    }

    static SchemaTransformer parse(String configuration) {
        if (null == configuration || configuration.isEmpty()) {
            return IDENTITY_TRANSFORMER;
        }
        String[] split = configuration.split(",");
        if (0 == split.length) {
            return IDENTITY_TRANSFORMER;
        }
        HashMap<Integer, SchemaTransformer> transformerBySchemaId = new HashMap<Integer, SchemaTransformer>();
        SchemaTransformerFactory.parseComponents(split, transformerBySchemaId);
        SchemaTransformer defaultTransformer = transformerBySchemaId.remove(-1);
        defaultTransformer = null != defaultTransformer ? defaultTransformer : IDENTITY_TRANSFORMER;
        return transformerBySchemaId.isEmpty() ? defaultTransformer : new IdKeyedSchemaTransformer(transformerBySchemaId, defaultTransformer);
    }

    private static void parseComponents(String[] configuration, Map<Integer, SchemaTransformer> transformerBySchemaId) {
        for (String field : configuration) {
            String[] fieldParts = field.split(":");
            if (2 != fieldParts.length) {
                throw new IllegalArgumentException("version transformation property part '" + field + "' is invalid");
            }
            int schemaId = "*".equals(fieldParts[0]) ? -1 : Integer.parseInt(fieldParts[0].trim());
            int sinceVersion = Integer.parseInt(fieldParts[1].trim());
            transformerBySchemaId.put(schemaId, new SinceVersionSchemaTransformer(sinceVersion));
        }
    }

    SchemaTransformer delegate() {
        return this.transformer;
    }
}

