/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.agrona.CloseHelper;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrUtil;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.ir.generated.FrameCodecDecoder;
import uk.co.real_logic.sbe.ir.generated.TokenCodecDecoder;

public class IrDecoder
implements AutoCloseable {
    private static final int CAPACITY = 4096;
    private final FileChannel channel;
    private final MutableDirectBuffer directBuffer;
    private final FrameCodecDecoder frameDecoder = new FrameCodecDecoder();
    private final TokenCodecDecoder tokenDecoder = new TokenCodecDecoder();
    private int offset;
    private final int length;
    private String irPackageName = null;
    private String irNamespaceName = null;
    private String semanticVersion = null;
    private List<Token> irHeader = null;
    private int irId;
    private int irVersion = 0;
    private final byte[] valArray = new byte[4096];
    private final MutableDirectBuffer valBuffer = new UnsafeBuffer(this.valArray);

    public IrDecoder(String fileName) {
        try {
            this.channel = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
            long fileLength = this.channel.size();
            if (fileLength > Integer.MAX_VALUE) {
                throw new IllegalStateException("Invalid IR file: length=" + fileLength + " > Integer.MAX_VALUE");
            }
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
            this.directBuffer = new UnsafeBuffer(buffer);
            this.length = (int)fileLength;
            this.offset = 0;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public IrDecoder(ByteBuffer buffer) {
        this.channel = null;
        this.length = buffer.limit();
        this.directBuffer = new UnsafeBuffer(buffer);
        this.offset = 0;
    }

    @Override
    public void close() {
        CloseHelper.quietClose(this.channel);
    }

    public Ir decode() {
        this.decodeFrame();
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (this.offset < this.length) {
            tokens.add(this.decodeToken());
        }
        int i = 0;
        if (((Token)tokens.get(0)).signal() == Signal.BEGIN_COMPOSITE) {
            i = this.captureHeader(tokens);
        }
        ByteOrder byteOrder = null;
        for (int j = 0; j < tokens.size(); ++j) {
            if (((Token)tokens.get(j)).signal() != Signal.ENCODING) continue;
            byteOrder = ((Token)tokens.get(j)).encoding().byteOrder();
            break;
        }
        Ir ir = new Ir(this.irPackageName, this.irNamespaceName, this.irId, this.irVersion, null, this.semanticVersion, byteOrder, this.irHeader);
        int size = tokens.size();
        while (i < size) {
            if (((Token)tokens.get(i)).signal() == Signal.BEGIN_MESSAGE) {
                i = IrDecoder.captureMessage(tokens, i, ir);
            }
            ++i;
        }
        return ir;
    }

    private int captureHeader(List<Token> tokens) {
        ArrayList<Token> headerTokens = new ArrayList<Token>();
        int index = 0;
        Token token = tokens.get(index);
        String headerName = token.name();
        headerTokens.add(token);
        do {
            token = tokens.get(++index);
            headerTokens.add(token);
        } while (Signal.END_COMPOSITE != token.signal() || !headerName.equals(token.name()));
        this.irHeader = headerTokens;
        return index;
    }

    private static int captureMessage(List<Token> tokens, int index, Ir ir) {
        ArrayList<Token> messageTokens = new ArrayList<Token>();
        int i = index;
        Token token = tokens.get(i);
        messageTokens.add(token);
        do {
            token = tokens.get(++i);
            messageTokens.add(token);
        } while (Signal.END_MESSAGE != token.signal());
        ir.addMessage(tokens.get(i).id(), messageTokens);
        return i;
    }

    private void decodeFrame() {
        this.frameDecoder.wrap(this.directBuffer, this.offset, this.frameDecoder.sbeBlockLength(), 0);
        this.irId = this.frameDecoder.irId();
        if (this.frameDecoder.irVersion() != 0) {
            throw new IllegalStateException("Unknown SBE version: " + this.frameDecoder.irVersion());
        }
        this.irVersion = this.frameDecoder.schemaVersion();
        this.irPackageName = this.frameDecoder.packageName();
        this.irNamespaceName = this.frameDecoder.namespaceName();
        if (this.irNamespaceName.isEmpty()) {
            this.irNamespaceName = null;
        }
        this.semanticVersion = this.frameDecoder.semanticVersion();
        if (this.semanticVersion.isEmpty()) {
            this.semanticVersion = null;
        }
        this.offset += this.frameDecoder.encodedLength();
    }

    private Token decodeToken() {
        Token.Builder tokenBuilder = new Token.Builder();
        Encoding.Builder encBuilder = new Encoding.Builder();
        this.tokenDecoder.wrap(this.directBuffer, this.offset, this.tokenDecoder.sbeBlockLength(), 0);
        tokenBuilder.offset(this.tokenDecoder.tokenOffset()).size(this.tokenDecoder.tokenSize()).id(this.tokenDecoder.fieldId()).version(this.tokenDecoder.tokenVersion()).componentTokenCount(this.tokenDecoder.componentTokenCount()).signal(IrUtil.mapSignal(this.tokenDecoder.signal()));
        PrimitiveType type = IrUtil.mapPrimitiveType(this.tokenDecoder.primitiveType());
        encBuilder.primitiveType(IrUtil.mapPrimitiveType(this.tokenDecoder.primitiveType())).byteOrder(IrUtil.mapByteOrder(this.tokenDecoder.byteOrder())).presence(IrUtil.mapPresence(this.tokenDecoder.presence()));
        tokenBuilder.name(this.tokenDecoder.name());
        encBuilder.constValue(IrUtil.get(this.valBuffer, type, this.tokenDecoder.getConstValue(this.valArray, 0, this.valArray.length)));
        encBuilder.minValue(IrUtil.get(this.valBuffer, type, this.tokenDecoder.getMinValue(this.valArray, 0, this.valArray.length)));
        encBuilder.maxValue(IrUtil.get(this.valBuffer, type, this.tokenDecoder.getMaxValue(this.valArray, 0, this.valArray.length)));
        encBuilder.nullValue(IrUtil.get(this.valBuffer, type, this.tokenDecoder.getNullValue(this.valArray, 0, this.valArray.length)));
        String characterEncoding = this.tokenDecoder.characterEncoding();
        encBuilder.characterEncoding(characterEncoding.isEmpty() ? null : characterEncoding);
        String epoch = this.tokenDecoder.epoch();
        encBuilder.epoch(epoch.isEmpty() ? null : epoch);
        String timeUnit = this.tokenDecoder.timeUnit();
        encBuilder.timeUnit(timeUnit.isEmpty() ? null : timeUnit);
        String semanticType = this.tokenDecoder.semanticType();
        encBuilder.semanticType(semanticType.isEmpty() ? null : semanticType);
        String description = this.tokenDecoder.description();
        tokenBuilder.description(description.isEmpty() ? null : description);
        String referencedName = this.tokenDecoder.referencedName();
        tokenBuilder.referencedName(referencedName.isEmpty() ? null : referencedName);
        this.offset += this.tokenDecoder.encodedLength();
        return tokenBuilder.encoding(encBuilder.build()).build();
    }
}

