/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.agrona.Strings;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.java.JavaUtil;
import uk.co.real_logic.sbe.generation.rust.LibRsDef;
import uk.co.real_logic.sbe.generation.rust.MessageCoderDef;
import uk.co.real_logic.sbe.generation.rust.RustOutputManager;
import uk.co.real_logic.sbe.generation.rust.RustUtil;
import uk.co.real_logic.sbe.generation.rust.SubGroup;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class RustGenerator
implements CodeGenerator {
    static final String WRITE_BUF_TYPE = "WriteBuf";
    static final String READ_BUF_TYPE = "ReadBuf";
    static final String BUF_LIFETIME = "'a";
    private final Ir ir;
    private final RustOutputManager outputManager;
    private final String crateVersion;

    public RustGenerator(Ir ir, String crateVersion, OutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(crateVersion, "crateVersion");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.crateVersion = crateVersion;
        this.outputManager = (RustOutputManager)outputManager;
    }

    @Override
    public void generate() throws IOException {
        try (Writer writer = this.outputManager.createCargoToml();){
            String packageName = RustUtil.toLowerSnakeCase(this.ir.packageName()).replaceAll("[.-]", "_");
            String namespace = this.ir.namespaceName() == null || this.ir.namespaceName().equalsIgnoreCase(packageName) ? packageName.toLowerCase() : (this.ir.namespaceName() + "_" + packageName).toLowerCase();
            RustUtil.indent(writer, 0, "[package]\n", new Object[0]);
            RustUtil.indent(writer, 0, "name = \"%s\"\n", namespace);
            RustUtil.indent(writer, 0, "version = \"%s\"\n", this.crateVersion);
            RustUtil.indent(writer, 0, "authors = [\"sbetool\"]\n", new Object[0]);
            RustUtil.indent(writer, 0, "description = \"%s\"\n", this.ir.description());
            RustUtil.indent(writer, 0, "edition = \"2021\"\n\n", new Object[0]);
            RustUtil.indent(writer, 0, "[lib]\n", new Object[0]);
            RustUtil.indent(writer, 0, "name = \"%s\"\n", namespace);
            RustUtil.indent(writer, 0, "path = \"src/lib.rs\"\n", new Object[0]);
        }
        LibRsDef libRsDef = new LibRsDef(this.outputManager, this.ir.byteOrder(), this.schemaVersionType());
        RustGenerator.generateEnums(this.ir, this.outputManager);
        RustGenerator.generateBitSets(this.ir, this.outputManager);
        RustGenerator.generateComposites(this.schemaVersionType(), this.ir, this.outputManager);
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String codecModName = RustUtil.codecModName(msgToken.name());
            List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
            int i = 0;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(messageBody, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(messageBody, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, i, varData);
            Writer out = this.outputManager.createOutput(codecModName);
            try {
                RustUtil.indent(out, 0, "use crate::*;\n\n", new Object[0]);
                RustUtil.indent(out, 0, "pub use decoder::%sDecoder;\n", RustUtil.formatStructName(msgToken.name()));
                RustUtil.indent(out, 0, "pub use encoder::%sEncoder;\n\n", RustUtil.formatStructName(msgToken.name()));
                RustUtil.indent(out, 0, "pub use crate::SBE_SCHEMA_ID;\n", new Object[0]);
                RustUtil.indent(out, 0, "pub use crate::SBE_SCHEMA_VERSION;\n", new Object[0]);
                RustUtil.indent(out, 0, "pub use crate::SBE_SEMANTIC_VERSION;\n\n", new Object[0]);
                String blockLengthType = this.blockLengthType();
                String templateIdType = RustUtil.rustTypeName(this.ir.headerStructure().templateIdType());
                RustUtil.indent(out, 0, "pub const SBE_BLOCK_LENGTH: %s = %d;\n", blockLengthType, msgToken.encodedLength());
                RustUtil.indent(out, 0, "pub const SBE_TEMPLATE_ID: %s = %d;\n\n", templateIdType, msgToken.id());
                MessageCoderDef.generateEncoder(this.ir, out, msgToken, fields, groups, varData);
                MessageCoderDef.generateDecoder(this.ir, out, msgToken, fields, groups, varData);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
        libRsDef.generate(this.ir);
    }

    String blockLengthType() {
        return RustUtil.rustTypeName(this.ir.headerStructure().blockLengthType());
    }

    String schemaVersionType() {
        return RustUtil.rustTypeName(this.ir.headerStructure().schemaVersionType());
    }

    static String withLifetime(String typeName) {
        return String.format("%s<%s>", typeName, BUF_LIFETIME);
    }

    static void appendImplWithLifetimeHeader(Appendable appendable, String typeName) throws IOException {
        RustUtil.indent(appendable, 1, "impl<%s> %s<%s> {\n", BUF_LIFETIME, typeName, BUF_LIFETIME);
    }

    static String getBufOffset(Token token) {
        int offset = token.offset();
        if (offset > 0) {
            return "offset + " + offset;
        }
        return "offset";
    }

    static void generateEncoderFields(StringBuilder sb, List<Token> tokens, int level) {
        Generators.forEachField(tokens, (fieldToken, typeToken) -> {
            try {
                String name = fieldToken.name();
                switch (typeToken.signal()) {
                    case ENCODING: {
                        RustGenerator.generatePrimitiveEncoder(sb, level, typeToken, name);
                        break;
                    }
                    case BEGIN_ENUM: {
                        RustGenerator.generateEnumEncoder(sb, level, fieldToken, typeToken, name);
                        break;
                    }
                    case BEGIN_SET: {
                        RustGenerator.generateBitSetEncoder(sb, level, typeToken, name);
                        break;
                    }
                    case BEGIN_COMPOSITE: {
                        RustGenerator.generateCompositeEncoder(sb, level, typeToken, name);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    static void generateEncoderGroups(StringBuilder sb, List<Token> tokens, int level, ParentDef parentDef) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            int index = ++i;
            int groupHeaderTokenCount = tokens.get(i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            String groupName = RustUtil.encoderName(RustUtil.formatStructName(groupToken.name()));
            Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
            PrimitiveType numInGroupPrimitiveType = numInGroupToken.encoding().primitiveType();
            String description = groupToken.description();
            if (!Strings.isEmpty(description)) {
                RustUtil.indent(sb, level, "/// GROUP ENCODER (id=%s, description='%s')\n", groupToken.id(), description);
            } else {
                RustUtil.indent(sb, level, "/// GROUP ENCODER (id=%s)\n", groupToken.id());
            }
            assert (4 == groupHeaderTokenCount);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(self, count: %s, %1$s: %3$s<Self>) -> %3$s<Self> {\n", RustUtil.formatFunctionName(groupName), RustUtil.rustTypeName(numInGroupPrimitiveType), groupName);
            RustUtil.indent(sb, level + 1, "%s.wrap(self, count)\n", RustUtil.toLowerSnakeCase(groupName));
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
            SubGroup subGroup = parentDef.addSubGroup(groupName, level, groupToken);
            subGroup.generateEncoder(tokens, fields, groups, varData, index);
        }
    }

    static void generateEncoderVarData(StringBuilder sb, List<Token> tokens, int level) throws IOException {
        Token varDataToken;
        int size = tokens.size();
        for (int i = 0; i < size; i += varDataToken.componentTokenCount()) {
            String toBytesFn;
            String varDataType;
            varDataToken = tokens.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            String characterEncoding = RustUtil.characterEncoding(tokens.get(i + 3).encoding());
            String propertyName = RustUtil.toLowerSnakeCase(varDataToken.name());
            Token lengthToken = tokens.get(i + 2);
            Encoding lengthEncoding = lengthToken.encoding();
            PrimitiveType lengthType = lengthEncoding.primitiveType();
            if (JavaUtil.isUtf8Encoding(characterEncoding)) {
                varDataType = "&str";
                toBytesFn = ".as_bytes()";
            } else {
                varDataType = "&[u8]";
                toBytesFn = "";
            }
            RustUtil.indent(sb, level, "/// VAR_DATA ENCODER - character encoding: '%s'\n", characterEncoding);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&mut self, value: %s) {\n", propertyName, varDataType);
            RustUtil.indent(sb, level + 1, "let limit = self.get_limit();\n", new Object[0]);
            RustUtil.indent(sb, level + 1, "let data_length = value.len();\n", new Object[0]);
            RustUtil.indent(sb, level + 1, "self.set_limit(limit + %d + data_length);\n", lengthType.size());
            RustUtil.indent(sb, level + 1, "self.get_buf_mut().put_%s_at(limit, data_length as %1$s);\n", RustUtil.rustTypeName(lengthType));
            RustUtil.indent(sb, level + 1, "self.get_buf_mut().put_slice_at(limit + %d, value%s);\n", lengthType.size(), toBytesFn);
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    private static void generatePrimitiveEncoder(StringBuilder sb, int level, Token typeToken, String name) throws IOException {
        Encoding encoding = typeToken.encoding();
        PrimitiveType primitiveType = encoding.primitiveType();
        String rustPrimitiveType = RustUtil.rustTypeName(primitiveType);
        int arrayLength = typeToken.arrayLength();
        if (arrayLength > 1) {
            RustUtil.indent(sb, level, "/// primitive array field '%s'\n", name);
            RustUtil.indent(sb, level, "/// - min value: %s\n", encoding.applicableMinValue());
            RustUtil.indent(sb, level, "/// - max value: %s\n", encoding.applicableMaxValue());
            RustUtil.indent(sb, level, "/// - null value: %s\n", encoding.applicableNullValue());
            RustUtil.indent(sb, level, "/// - characterEncoding: %s\n", encoding.characterEncoding());
            RustUtil.indent(sb, level, "/// - semanticType: %s\n", encoding.semanticType());
            RustUtil.indent(sb, level, "/// - encodedOffset: %d\n", typeToken.offset());
            RustUtil.indent(sb, level, "/// - encodedLength: %d\n", typeToken.encodedLength());
            RustUtil.indent(sb, level, "/// - version: %d\n", typeToken.version());
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&mut self, value: &[%s; %d]) {\n", RustUtil.formatFunctionName(name), rustPrimitiveType, arrayLength);
            RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(typeToken));
            RustUtil.indent(sb, level + 1, "let buf = self.get_buf_mut();\n", new Object[0]);
            if (rustPrimitiveType.equals("u8")) {
                RustUtil.indent(sb, level + 1, "buf.put_bytes_at(offset, value);\n", new Object[0]);
                RustUtil.indent(sb, level, "}\n\n", new Object[0]);
                return;
            }
            for (int i = 0; i < arrayLength; ++i) {
                if (i == 0) {
                    RustUtil.indent(sb, level + 1, "buf.put_%s_at(offset, value[%d]);\n", rustPrimitiveType, i);
                    continue;
                }
                RustUtil.indent(sb, level + 1, "buf.put_%s_at(offset + %d, value[%d]);\n", rustPrimitiveType, i * primitiveType.size(), i);
            }
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        } else if (encoding.presence() == Encoding.Presence.CONSTANT) {
            RustUtil.indent(sb, level, "// skipping CONSTANT %s\n\n", name);
        } else {
            RustUtil.indent(sb, level, "/// primitive field '%s'\n", name);
            RustUtil.indent(sb, level, "/// - min value: %s\n", encoding.applicableMinValue());
            RustUtil.indent(sb, level, "/// - max value: %s\n", encoding.applicableMaxValue());
            RustUtil.indent(sb, level, "/// - null value: %s\n", encoding.applicableNullValue());
            RustUtil.indent(sb, level, "/// - characterEncoding: %s\n", encoding.characterEncoding());
            RustUtil.indent(sb, level, "/// - semanticType: %s\n", encoding.semanticType());
            RustUtil.indent(sb, level, "/// - encodedOffset: %d\n", typeToken.offset());
            RustUtil.indent(sb, level, "/// - encodedLength: %d\n", typeToken.encodedLength());
            RustUtil.indent(sb, level, "/// - version: %d\n", typeToken.version());
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&mut self, value: %s) {\n", RustUtil.formatFunctionName(name), rustPrimitiveType);
            RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(typeToken));
            RustUtil.indent(sb, level + 1, "self.get_buf_mut().put_%s_at(offset, value);\n", rustPrimitiveType);
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    private static void generateEnumEncoder(StringBuilder sb, int level, Token fieldToken, Token typeToken, String name) throws IOException {
        String referencedName = typeToken.referencedName();
        String enumType = String.format("%s::%s", RustUtil.toLowerSnakeCase(referencedName == null ? typeToken.name() : referencedName), RustUtil.formatStructName(referencedName == null ? typeToken.name() : referencedName));
        if (fieldToken.isConstantEncoding()) {
            RustUtil.indent(sb, level, "// skipping CONSTANT enum '%s'\n\n", name);
        } else {
            Encoding encoding = typeToken.encoding();
            String rustPrimitiveType = RustUtil.rustTypeName(encoding.primitiveType());
            RustUtil.indent(sb, level, "/// REQUIRED enum\n", new Object[0]);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&mut self, value: %s) {\n", RustUtil.formatFunctionName(name), enumType);
            RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(typeToken));
            RustUtil.indent(sb, level + 1, "self.get_buf_mut().put_%s_at(offset, value as %1$s)\n", rustPrimitiveType);
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    private static void generateBitSetEncoder(StringBuilder sb, int level, Token bitsetToken, String name) throws IOException {
        Encoding encoding = bitsetToken.encoding();
        String rustPrimitiveType = RustUtil.rustTypeName(encoding.primitiveType());
        String referencedName = bitsetToken.referencedName();
        String structTypeName = String.format("%s::%s", RustUtil.toLowerSnakeCase(referencedName == null ? bitsetToken.name() : referencedName), RustUtil.formatStructName(bitsetToken.applicableTypeName()));
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(&mut self, value: %s) {\n", RustUtil.formatFunctionName(name), structTypeName);
        RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(bitsetToken));
        RustUtil.indent(sb, level + 1, "self.get_buf_mut().put_%s_at(offset, value.0)\n", rustPrimitiveType);
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generateCompositeEncoder(StringBuilder sb, int level, Token typeToken, String name) throws IOException {
        String encoderName = RustUtil.toLowerSnakeCase(RustUtil.encoderName(name));
        String encoderTypeName = String.format("%s::%s", RustUtil.codecModName(typeToken.referencedName() == null ? typeToken.name() : typeToken.referencedName()), RustUtil.encoderName(RustUtil.formatStructName(typeToken.applicableTypeName())));
        RustUtil.indent(sb, level, "/// COMPOSITE ENCODER\n", new Object[0]);
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(self) -> %2$s<Self> {\n", encoderName, encoderTypeName);
        RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(typeToken));
        RustUtil.indent(sb, level + 1, "%s::default().wrap(self, offset)\n", encoderTypeName);
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    static void generateDecoderFields(StringBuilder sb, List<Token> tokens, int level) {
        Generators.forEachField(tokens, (fieldToken, typeToken) -> {
            try {
                String name = fieldToken.name();
                Encoding encoding = typeToken.encoding();
                switch (typeToken.signal()) {
                    case ENCODING: {
                        RustGenerator.generatePrimitiveDecoder(sb, level, fieldToken, typeToken, name, encoding);
                        break;
                    }
                    case BEGIN_ENUM: {
                        RustGenerator.generateEnumDecoder(sb, level, fieldToken, typeToken, name);
                        break;
                    }
                    case BEGIN_SET: {
                        RustGenerator.generateBitSetDecoder(sb, level, typeToken, name);
                        break;
                    }
                    case BEGIN_COMPOSITE: {
                        RustGenerator.generateCompositeDecoder(sb, level, fieldToken, typeToken, name);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unable to handle: " + typeToken);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    private static void generateCompositeDecoder(StringBuilder sb, int level, Token fieldToken, Token typeToken, String name) throws IOException {
        String decoderName = RustUtil.toLowerSnakeCase(RustUtil.decoderName(name));
        String referencedName = typeToken.referencedName();
        String decoderTypeName = String.format("%s::%s", RustUtil.codecModName(referencedName == null ? typeToken.name() : referencedName), RustUtil.decoderName(RustUtil.formatStructName(typeToken.applicableTypeName())));
        RustUtil.indent(sb, level, "/// COMPOSITE DECODER\n", new Object[0]);
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        if (fieldToken.version() > 0) {
            RustUtil.indent(sb, level, "pub fn %s(self) -> Either<Self, %2$s<Self>> {\n", decoderName, decoderTypeName);
            RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", fieldToken.version());
            RustUtil.indent(sb, level + 2, "return Either::Left(self);\n", new Object[0]);
            RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
            RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(fieldToken));
            RustUtil.indent(sb, level + 1, "Either::Right(%s::default().wrap(self, offset))\n", decoderTypeName);
        } else {
            RustUtil.indent(sb, level, "pub fn %s(self) -> %s<Self> {\n", decoderName, decoderTypeName);
            RustUtil.indent(sb, level + 1, "let offset = self.%s;\n", RustGenerator.getBufOffset(fieldToken));
            RustUtil.indent(sb, level + 1, "%s::default().wrap(self, offset)\n", decoderTypeName);
        }
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generateBitSetDecoder(StringBuilder sb, int level, Token bitsetToken, String name) throws IOException {
        Encoding encoding = bitsetToken.encoding();
        String rustPrimitiveType = RustUtil.rustTypeName(encoding.primitiveType());
        String referencedName = bitsetToken.referencedName();
        String structTypeName = String.format("%s::%s", RustUtil.toLowerSnakeCase(referencedName == null ? bitsetToken.name() : referencedName), RustUtil.formatStructName(bitsetToken.applicableTypeName()));
        RustUtil.indent(sb, level, "/// BIT SET DECODER\n", new Object[0]);
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(&self) -> %s {\n", RustUtil.formatFunctionName(name), structTypeName);
        if (bitsetToken.version() > 0) {
            RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", bitsetToken.version());
            RustUtil.indent(sb, level + 2, "return %s::default();\n", structTypeName);
            RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
        }
        RustUtil.indent(sb, level + 1, "%s::new(self.get_buf().get_%s_at(self.%s))\n", structTypeName, rustPrimitiveType, RustGenerator.getBufOffset(bitsetToken));
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generatePrimitiveDecoder(StringBuilder sb, int level, Token fieldToken, Token typeToken, String name, Encoding encoding) throws IOException {
        if (typeToken.arrayLength() > 1) {
            RustGenerator.generatePrimitiveArrayDecoder(sb, level, fieldToken, typeToken, name, encoding);
        } else if (encoding.presence() == Encoding.Presence.CONSTANT) {
            RustGenerator.generatePrimitiveConstantDecoder(sb, level, name, encoding);
        } else if (encoding.presence() == Encoding.Presence.OPTIONAL) {
            RustGenerator.generatePrimitiveOptionalDecoder(sb, level, fieldToken, name, encoding);
        } else {
            RustGenerator.generatePrimitiveRequiredDecoder(sb, level, fieldToken, name, encoding);
        }
    }

    private static void generatePrimitiveArrayDecoder(StringBuilder sb, int level, Token fieldToken, Token typeToken, String name, Encoding encoding) throws IOException {
        PrimitiveType primitiveType = encoding.primitiveType();
        String rustPrimitiveType = RustUtil.rustTypeName(primitiveType);
        int arrayLength = typeToken.arrayLength();
        assert (arrayLength > 1);
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(&self) -> [%s; %d] {\n", RustUtil.formatFunctionName(name), rustPrimitiveType, arrayLength);
        if (fieldToken.version() > 0) {
            RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", fieldToken.version());
            RustUtil.indent(sb, level + 2, "return [%s; %d];\n", encoding.applicableNullValue(), arrayLength);
            RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
        }
        RustUtil.indent(sb, level + 1, "let buf = self.get_buf();\n", new Object[0]);
        if (rustPrimitiveType.equals("u8")) {
            RustUtil.indent(sb, level + 1, "ReadBuf::get_bytes_at(buf.data, self.%s)\n", RustGenerator.getBufOffset(typeToken));
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
            return;
        }
        RustUtil.indent(sb, level + 1, "[\n", new Object[0]);
        for (int i = 0; i < arrayLength; ++i) {
            if (i == 0) {
                RustUtil.indent(sb, level + 2, "buf.get_%s_at(self.%s),\n", rustPrimitiveType, RustGenerator.getBufOffset(typeToken));
                continue;
            }
            RustUtil.indent(sb, level + 2, "buf.get_%s_at(self.%s + %d),\n", rustPrimitiveType, RustGenerator.getBufOffset(typeToken), i * primitiveType.size());
        }
        RustUtil.indent(sb, level + 1, "]\n", new Object[0]);
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generatePrimitiveConstantDecoder(StringBuilder sb, int level, String name, Encoding encoding) throws IOException {
        assert (encoding.presence() == Encoding.Presence.CONSTANT);
        PrimitiveType primitiveType = encoding.primitiveType();
        String rustPrimitiveType = RustUtil.rustTypeName(primitiveType);
        String characterEncoding = encoding.characterEncoding();
        RustUtil.indent(sb, level, "/// CONSTANT \n", new Object[0]);
        String rawConstValue = encoding.constValue().toString();
        if (characterEncoding != null) {
            RustUtil.indent(sb, level, "/// characterEncoding: '%s'\n", characterEncoding);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            if (JavaUtil.isAsciiEncoding(characterEncoding)) {
                RustUtil.indent(sb, level, "pub fn %s(&self) -> &'static [u8] {\n", RustUtil.formatFunctionName(name));
                RustUtil.indent(sb, level + 1, "b\"%s\"\n", rawConstValue);
            } else if (JavaUtil.isUtf8Encoding(characterEncoding)) {
                RustUtil.indent(sb, level, "pub fn %s(&self) -> &'static str {\n", RustUtil.formatFunctionName(name));
                RustUtil.indent(sb, level + 1, "\"%s\"\n", rawConstValue);
            } else {
                throw new IllegalArgumentException("Unsupported encoding: " + characterEncoding);
            }
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        } else {
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&self) -> %s {\n", RustUtil.formatFunctionName(name), rustPrimitiveType);
            RustUtil.indent(sb, level + 1, "%s\n", rawConstValue);
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    private static void generatePrimitiveOptionalDecoder(StringBuilder sb, int level, Token fieldToken, String name, Encoding encoding) throws IOException {
        assert (encoding.presence() == Encoding.Presence.OPTIONAL);
        PrimitiveType primitiveType = encoding.primitiveType();
        String rustPrimitiveType = RustUtil.rustTypeName(primitiveType);
        String characterEncoding = encoding.characterEncoding();
        RustUtil.indent(sb, level, "/// primitive field - '%s' { null_value: '%s' }\n", new Object[]{encoding.presence(), encoding.applicableNullValue()});
        if (characterEncoding != null) {
            RustUtil.indent(sb, level, "/// characterEncoding: '%s'\n", characterEncoding);
        }
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(&self) -> Option<%s> {\n", RustUtil.formatFunctionName(name), rustPrimitiveType);
        RustUtil.indent(sb, level + 1, "let value = self.get_buf().get_%s_at(self.%s);\n", rustPrimitiveType, RustGenerator.getBufOffset(fieldToken));
        String literal = RustUtil.generateRustLiteral(primitiveType, encoding.applicableNullValue().toString());
        if (literal.endsWith("::NAN")) {
            RustUtil.indent(sb, level + 1, "if value.is_nan() {\n", new Object[0]);
        } else {
            RustUtil.indent(sb, level + 1, "if value == %s {\n", literal);
        }
        RustUtil.indent(sb, level + 2, "None\n", new Object[0]);
        RustUtil.indent(sb, level + 1, "} else {\n", new Object[0]);
        RustUtil.indent(sb, level + 2, "Some(value)\n", new Object[0]);
        RustUtil.indent(sb, level + 1, "}\n", new Object[0]);
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generatePrimitiveRequiredDecoder(StringBuilder sb, int level, Token fieldToken, String name, Encoding encoding) throws IOException {
        assert (encoding.presence() == Encoding.Presence.REQUIRED);
        PrimitiveType primitiveType = encoding.primitiveType();
        String rustPrimitiveType = RustUtil.rustTypeName(primitiveType);
        String characterEncoding = encoding.characterEncoding();
        RustUtil.indent(sb, level, "/// primitive field - '%s'\n", new Object[]{encoding.presence()});
        if (characterEncoding != null) {
            RustUtil.indent(sb, level, "/// characterEncoding: '%s'\n", characterEncoding);
        }
        RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(sb, level, "pub fn %s(&self) -> %s {\n", RustUtil.formatFunctionName(name), rustPrimitiveType);
        if (fieldToken.version() > 0) {
            RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", fieldToken.version());
            RustUtil.indent(sb, level + 2, "return %s;\n", RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
            RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
        }
        RustUtil.indent(sb, level + 1, "self.get_buf().get_%s_at(self.%s)\n", rustPrimitiveType, RustGenerator.getBufOffset(fieldToken));
        RustUtil.indent(sb, level, "}\n\n", new Object[0]);
    }

    private static void generateEnumDecoder(StringBuilder sb, int level, Token fieldToken, Token typeToken, String name) throws IOException {
        String referencedName = typeToken.referencedName();
        String enumType = String.format("%s::%s", RustUtil.toLowerSnakeCase(referencedName == null ? typeToken.name() : referencedName), RustUtil.formatStructName(referencedName == null ? typeToken.name() : referencedName));
        if (fieldToken.isConstantEncoding()) {
            RustUtil.indent(sb, level, "/// CONSTANT enum\n", new Object[0]);
            Encoding encoding = fieldToken.encoding();
            String rawConstValueName = encoding.constValue().toString();
            int indexOfDot = rawConstValueName.indexOf(46);
            String constValueName = -1 == indexOfDot ? rawConstValueName : rawConstValueName.substring(indexOfDot + 1);
            String constantRustExpression = enumType + "::" + constValueName;
            RustGenerator.appendConstAccessor(sb, name, enumType, constantRustExpression, level);
        } else {
            Encoding encoding = typeToken.encoding();
            String rustPrimitiveType = RustUtil.rustTypeName(encoding.primitiveType());
            RustUtil.indent(sb, level, "/// REQUIRED enum\n", new Object[0]);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s(&self) -> %s {\n", RustUtil.formatFunctionName(name), enumType);
            if (fieldToken.version() > 0) {
                RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", fieldToken.version());
                RustUtil.indent(sb, level + 2, "return %s::default();\n", enumType);
                RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
            }
            RustUtil.indent(sb, level + 1, "self.get_buf().get_%s_at(self.%s).into()\n", rustPrimitiveType, RustGenerator.getBufOffset(typeToken));
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    static void generateDecoderGroups(String schemaVersionType, StringBuilder sb, List<Token> tokens, int level, ParentDef parentDef) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            int index = ++i;
            int groupHeaderTokenCount = tokens.get(i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            String groupName = RustUtil.decoderName(RustUtil.formatStructName(groupToken.name()));
            String description = groupToken.description();
            if (!Strings.isEmpty(description)) {
                RustUtil.indent(sb, level, "/// GROUP DECODER (id=%s, description='%s')\n", groupToken.id(), description);
            } else {
                RustUtil.indent(sb, level, "/// GROUP DECODER (id=%s)\n", groupToken.id());
            }
            assert (4 == groupHeaderTokenCount);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            if (groupToken.version() > 0) {
                RustUtil.indent(sb, level, "pub fn %s(self) -> Option<%2$s<Self>> {\n", RustUtil.formatFunctionName(groupName), groupName);
                RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", groupToken.version());
                RustUtil.indent(sb, level + 2, "return None;\n", new Object[0]);
                RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
                RustUtil.indent(sb, level + 1, "Some(%s::default().wrap(self))\n", groupName);
            } else {
                RustUtil.indent(sb, level, "pub fn %s(self) -> %2$s<Self> {\n", RustUtil.formatFunctionName(groupName), groupName);
                RustUtil.indent(sb, level + 1, "%s::default().wrap(self)\n", groupName);
            }
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
            SubGroup subGroup = parentDef.addSubGroup(groupName, level, groupToken);
            subGroup.generateDecoder(schemaVersionType, tokens, fields, groups, varData, index);
        }
    }

    static void generateDecoderVarData(StringBuilder sb, List<Token> tokens, int level, boolean isSubGroup) throws IOException {
        Token varDataToken;
        int size = tokens.size();
        for (int i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = tokens.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            String characterEncoding = RustUtil.characterEncoding(tokens.get(i + 3).encoding());
            String propertyName = RustUtil.toLowerSnakeCase(varDataToken.name());
            Token lengthToken = tokens.get(i + 2);
            Encoding lengthEncoding = lengthToken.encoding();
            PrimitiveType lengthType = lengthEncoding.primitiveType();
            RustUtil.indent(sb, level, "/// VAR_DATA DECODER - character encoding: '%s'\n", characterEncoding);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s_decoder(&mut self) -> (usize, usize) {\n", propertyName);
            if (isSubGroup) {
                if (varDataToken.version() > 0) {
                    RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", varDataToken.version());
                    RustUtil.indent(sb, level + 2, "return (self.parent.as_ref().unwrap().get_limit(), 0);\n", new Object[0]);
                    RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
                }
                RustUtil.indent(sb, level + 1, "let offset = self.parent.as_ref().expect(\"parent missing\").get_limit();\n", new Object[0]);
                RustUtil.indent(sb, level + 1, "let data_length = self.get_buf().get_%s_at(offset) as usize;\n", RustUtil.rustTypeName(lengthType));
                RustUtil.indent(sb, level + 1, "self.parent.as_mut().unwrap().set_limit(offset + %d + data_length);\n", lengthType.size());
            } else {
                if (varDataToken.version() > 0) {
                    RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", varDataToken.version());
                    RustUtil.indent(sb, level + 2, "return (self.get_limit(), 0);\n", new Object[0]);
                    RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
                }
                RustUtil.indent(sb, level + 1, "let offset = self.get_limit();\n", new Object[0]);
                RustUtil.indent(sb, level + 1, "let data_length = self.get_buf().get_%s_at(offset) as usize;\n", RustUtil.rustTypeName(lengthType));
                RustUtil.indent(sb, level + 1, "self.set_limit(offset + %d + data_length);\n", lengthType.size());
            }
            RustUtil.indent(sb, level + 1, "(offset + %d, data_length)\n", lengthType.size());
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
            RustUtil.indent(sb, level, "#[inline]\n", new Object[0]);
            RustUtil.indent(sb, level, "pub fn %s_slice(&'a self, coordinates: (usize, usize)) -> &'a [u8] {\n", propertyName);
            if (varDataToken.version() > 0) {
                RustUtil.indent(sb, level + 1, "if self.acting_version() < %d {\n", varDataToken.version());
                RustUtil.indent(sb, level + 2, "return &[] as &[u8];\n", new Object[0]);
                RustUtil.indent(sb, level + 1, "}\n\n", new Object[0]);
            }
            RustUtil.indent(sb, level + 1, "debug_assert!(self.get_limit() >= coordinates.0 + coordinates.1);\n", new Object[0]);
            RustUtil.indent(sb, level + 1, "self.get_buf().get_slice_at(coordinates.0, coordinates.1)\n", new Object[0]);
            RustUtil.indent(sb, level, "}\n\n", new Object[0]);
        }
    }

    private static void generateBitSets(Ir ir, RustOutputManager outputManager) throws IOException {
        for (List<Token> tokens : ir.types()) {
            if (tokens.isEmpty() || tokens.get(0).signal() != Signal.BEGIN_SET) continue;
            Token beginToken = tokens.get(0);
            String bitSetType = RustUtil.formatStructName(beginToken.applicableTypeName());
            Writer out = outputManager.createOutput(bitSetType);
            try {
                RustGenerator.generateSingleBitSet(bitSetType, tokens, out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private static void generateSingleBitSet(String bitSetType, List<Token> tokens, Appendable writer) throws IOException {
        Token beginToken = tokens.get(0);
        String rustPrimitiveType = RustUtil.rustTypeName(beginToken.encoding().primitiveType());
        RustUtil.indent(writer, 0, "#[derive(Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub struct %s(pub %s);\n", bitSetType, rustPrimitiveType);
        RustUtil.indent(writer, 0, "impl %s {\n", bitSetType);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn new(value: %s) -> Self {\n", rustPrimitiveType);
        RustUtil.indent(writer, 2, "%s(value)\n", bitSetType);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn clear(&mut self) -> &mut Self {\n", new Object[0]);
        RustUtil.indent(writer, 2, "self.0 = 0;\n", new Object[0]);
        RustUtil.indent(writer, 2, "self\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        for (Token token : tokens) {
            if (Signal.CHOICE != token.signal()) continue;
            String choiceName = RustUtil.formatFunctionName(token.name());
            Encoding encoding = token.encoding();
            String choiceBitIndex = encoding.constValue().toString();
            RustUtil.indent(writer, 0, "\n", new Object[0]);
            RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
            RustUtil.indent(writer, 1, "pub fn get_%s(&self) -> bool {\n", choiceName);
            RustUtil.indent(writer, 2, "0 != self.0 & (1 << %s)\n", choiceBitIndex);
            RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
            RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
            RustUtil.indent(writer, 1, "pub fn set_%s(&mut self, value: bool) -> &mut Self {\n", choiceName);
            RustUtil.indent(writer, 2, "self.0 = if value {\n", new Object[0]);
            RustUtil.indent(writer, 3, "self.0 | (1 << %s)\n", choiceBitIndex);
            RustUtil.indent(writer, 2, "} else {\n", new Object[0]);
            RustUtil.indent(writer, 3, "self.0 & !(1 << %s)\n", choiceBitIndex);
            RustUtil.indent(writer, 2, "};\n", new Object[0]);
            RustUtil.indent(writer, 2, "self\n", new Object[0]);
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
        }
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl core::fmt::Debug for %s {\n", bitSetType);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn fmt(&self, fmt: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {\n", new Object[0]);
        RustUtil.indent(writer, 2, "write!(fmt, \"%s[", bitSetType);
        StringBuilder builder = new StringBuilder();
        StringBuilder arguments = new StringBuilder();
        boolean comma = false;
        for (Token token : tokens) {
            if (Signal.CHOICE != token.signal()) continue;
            String choiceName = RustUtil.formatFunctionName(token.name());
            String choiceBitIndex = token.encoding().constValue().toString();
            if (comma) {
                builder.append(",");
            }
            builder.append(choiceName).append("(").append(choiceBitIndex).append(")={}");
            arguments.append("self.get_").append(choiceName).append("(),");
            comma = true;
        }
        writer.append(builder.toString()).append("]\",\n");
        RustUtil.indent(writer, 3, arguments + ")\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
    }

    static void appendImplEncoderTrait(Appendable out, String typeName) throws IOException {
        RustUtil.indent(out, 1, "impl<%s> %s for %s {\n", BUF_LIFETIME, RustGenerator.withLifetime("Writer"), RustGenerator.withLifetime(typeName));
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn get_buf_mut(&mut self) -> &mut WriteBuf<'a> {\n", new Object[0]);
        RustUtil.indent(out, 3, "&mut self.buf\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
        RustUtil.indent(out, 1, "impl<%s> %s for %s {\n", BUF_LIFETIME, RustGenerator.withLifetime("Encoder"), RustGenerator.withLifetime(typeName));
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn get_limit(&self) -> usize {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.limit\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn set_limit(&mut self, limit: usize) {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.limit = limit;\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
    }

    static void appendImplDecoderTrait(String schemaVersionType, Appendable out, String typeName) throws IOException {
        RustUtil.indent(out, 1, "impl<%s> %s for %s {\n", BUF_LIFETIME, "ActingVersion", RustGenerator.withLifetime(typeName));
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn acting_version(&self) -> %s {\n", schemaVersionType);
        RustUtil.indent(out, 3, "self.acting_version\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
        RustUtil.indent(out, 1, "impl<%s> %s for %s {\n", BUF_LIFETIME, RustGenerator.withLifetime("Reader"), RustGenerator.withLifetime(typeName));
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn get_buf(&self) -> &ReadBuf<'a> {\n", new Object[0]);
        RustUtil.indent(out, 3, "&self.buf\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
        RustUtil.indent(out, 1, "impl<%s> %s for %s {\n", BUF_LIFETIME, RustGenerator.withLifetime("Decoder"), RustGenerator.withLifetime(typeName));
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn get_limit(&self) -> usize {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.limit\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "fn set_limit(&mut self, limit: usize) {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.limit = limit;\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
    }

    private static void generateEnums(Ir ir, RustOutputManager outputManager) throws IOException {
        HashSet<String> enumTypeNames = new HashSet<String>();
        for (List<Token> tokens : ir.types()) {
            String typeName;
            Token beginToken;
            if (tokens.isEmpty() || (beginToken = tokens.get(0)).signal() != Signal.BEGIN_ENUM || !enumTypeNames.add(typeName = beginToken.applicableTypeName())) continue;
            Writer out = outputManager.createOutput(typeName);
            try {
                RustGenerator.generateEnum(tokens, out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private static void generateEnum(List<Token> enumTokens, Appendable writer) throws IOException {
        String originalEnumName = enumTokens.get(0).applicableTypeName();
        String enumRustName = RustUtil.formatStructName(originalEnumName);
        List<Token> messageBody = enumTokens.subList(1, enumTokens.size() - 1);
        if (messageBody.isEmpty()) {
            throw new IllegalArgumentException("No valid values provided for enum " + originalEnumName);
        }
        RustUtil.indent(writer, 0, "#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]\n", new Object[0]);
        String primitiveType = RustUtil.rustTypeName(messageBody.get(0).encoding().primitiveType());
        RustUtil.indent(writer, 0, "#[repr(%s)]\n", primitiveType);
        RustUtil.indent(writer, 0, "pub enum %s {\n", enumRustName);
        for (Token token : messageBody) {
            Encoding encoding = token.encoding();
            String literal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.constValue().toString());
            RustUtil.indent(writer, 1, "%s = %s, \n", token.name(), literal);
        }
        Encoding encoding = messageBody.get(0).encoding();
        String nullVal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        RustUtil.indent(writer, 1, "#[default]\n", new Object[0]);
        RustUtil.indent(writer, 1, "NullVal = %s, \n", nullVal);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustGenerator.generateFromPrimitiveForEnum(enumRustName, primitiveType, messageBody, writer);
        RustGenerator.generateFromEnumForPrimitive(enumRustName, primitiveType, messageBody, writer);
        RustGenerator.generateFromStrImplForEnum(enumRustName, messageBody, writer);
        RustGenerator.generateDisplayImplForEnum(enumRustName, primitiveType, messageBody, writer);
    }

    private static void generateFromPrimitiveForEnum(String enumRustName, String primitiveType, List<Token> messageBody, Appendable writer) throws IOException {
        RustUtil.indent(writer, 0, "impl From<%s> for %s {\n", primitiveType, enumRustName);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn from(v: %s) -> Self {\n", primitiveType);
        RustUtil.indent(writer, 2, "match v {\n", new Object[0]);
        for (Token token : messageBody) {
            Encoding encoding = token.encoding();
            String literal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.constValue().toString());
            RustUtil.indent(writer, 3, "%s => Self::%s, \n", literal, token.name());
        }
        RustUtil.indent(writer, 3, "_ => Self::NullVal,\n", new Object[0]);
        RustUtil.indent(writer, 2, "}\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
    }

    private static void generateFromEnumForPrimitive(String enumRustName, String primitiveType, List<Token> messageBody, Appendable writer) throws IOException {
        RustUtil.indent(writer, 0, "impl From<%s> for %s {\n", enumRustName, primitiveType);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn from(v: %s) -> Self {\n", enumRustName);
        RustUtil.indent(writer, 2, "match v {\n", new Object[0]);
        for (Token token : messageBody) {
            Encoding encoding = token.encoding();
            String literal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.constValue().toString());
            RustUtil.indent(writer, 3, "%s::%s => %s, \n", enumRustName, token.name(), literal);
        }
        Encoding encoding = messageBody.get(0).encoding();
        String nullVal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        RustUtil.indent(writer, 3, "%s::NullVal => %s,\n", enumRustName, nullVal);
        RustUtil.indent(writer, 2, "}\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
    }

    private static void generateFromStrImplForEnum(String enumRustName, List<Token> messageBody, Appendable writer) throws IOException {
        RustUtil.indent(writer, 0, "impl core::str::FromStr for %s {\n", enumRustName);
        RustUtil.indent(writer, 1, "type Err = ();\n\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn from_str(v: &str) -> core::result::Result<Self, Self::Err> {\n", new Object[0]);
        RustUtil.indent(writer, 2, "match v {\n", new Object[0]);
        for (Token token : messageBody) {
            RustUtil.indent(writer, 3, "\"%1$s\" => Ok(Self::%1$s), \n", token.name());
        }
        RustUtil.indent(writer, 3, "_ => Ok(Self::NullVal),\n", new Object[0]);
        RustUtil.indent(writer, 2, "}\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
    }

    private static void generateDisplayImplForEnum(String enumRustName, String primitiveType, List<Token> messageBody, Appendable writer) throws IOException {
        RustUtil.indent(writer, 0, "impl core::fmt::Display for %s {\n", enumRustName);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {\n", new Object[0]);
        RustUtil.indent(writer, 2, "match self {\n", new Object[0]);
        for (Token token : messageBody) {
            RustUtil.indent(writer, 3, "Self::%1$s => write!(f, \"%1$s\"), \n", token.name());
        }
        RustUtil.indent(writer, 3, "Self::NullVal => write!(f, \"NullVal\"),\n", new Object[0]);
        RustUtil.indent(writer, 2, "}\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
    }

    private static void generateComposites(String schemaVersionType, Ir ir, RustOutputManager outputManager) throws IOException {
        for (List<Token> tokens : ir.types()) {
            if (tokens.isEmpty() || tokens.get(0).signal() != Signal.BEGIN_COMPOSITE) continue;
            RustGenerator.generateComposite(schemaVersionType, tokens, outputManager);
        }
    }

    private static void generateComposite(String schemaVersionType, List<Token> tokens, RustOutputManager outputManager) throws IOException {
        Token token = tokens.get(0);
        String compositeName = token.applicableTypeName();
        String compositeModName = RustUtil.codecModName(compositeName);
        try (Writer out = outputManager.createOutput(compositeModName);){
            RustUtil.indent(out, 0, "use crate::*;\n\n", new Object[0]);
            RustUtil.indent(out, 0, "pub use encoder::%sEncoder;\n", RustUtil.formatStructName(compositeName));
            RustUtil.indent(out, 0, "pub use decoder::%sDecoder;\n\n", RustUtil.formatStructName(compositeName));
            int encodedLength = tokens.get(0).encodedLength();
            if (encodedLength > 0) {
                RustUtil.indent(out, 0, "pub const ENCODED_LENGTH: usize = %d;\n\n", encodedLength);
            }
            RustGenerator.generateCompositeEncoder(tokens, RustUtil.encoderName(compositeName), out);
            RustUtil.indent(out, 0, "\n", new Object[0]);
            RustGenerator.generateCompositeDecoder(schemaVersionType, tokens, RustUtil.decoderName(compositeName), out);
        }
    }

    static void appendImplWriterForComposite(Appendable out, int level, String name) throws IOException {
        RustUtil.indent(out, level, "impl<'a, P> Writer<'a> for %s<P> where P: Writer<'a> + Default {\n", name);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn get_buf_mut(&mut self) -> &mut WriteBuf<'a> {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "if let Some(parent) = self.parent.as_mut() {\n", new Object[0]);
        RustUtil.indent(out, level + 3, "parent.get_buf_mut()\n", new Object[0]);
        RustUtil.indent(out, level + 2, "} else {\n", new Object[0]);
        RustUtil.indent(out, level + 3, "panic!(\"parent was None\")\n", new Object[0]);
        RustUtil.indent(out, level + 2, "}\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n", new Object[0]);
        RustUtil.indent(out, level, "}\n\n", new Object[0]);
    }

    static void appendImplEncoderForComposite(Appendable out, int level, String name) throws IOException {
        RustGenerator.appendImplWriterForComposite(out, level, name);
        RustUtil.indent(out, level, "impl<'a, P> Encoder<'a> for %s<P> where P: Encoder<'a> + Default {\n", name);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn get_limit(&self) -> usize {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "self.parent.as_ref().expect(\"parent missing\").get_limit()\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n\n", new Object[0]);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn set_limit(&mut self, limit: usize) {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "self.parent.as_mut().expect(\"parent missing\").set_limit(limit);\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n", new Object[0]);
        RustUtil.indent(out, level, "}\n\n", new Object[0]);
    }

    static void appendImplReaderForComposite(String schemaVersionType, int version, Appendable out, int level, String name) throws IOException {
        RustUtil.indent(out, level, "impl<'a, P> ActingVersion for %s<P> where P: Reader<'a> + ActingVersion + Default {\n", name);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn acting_version(&self) -> %s {\n", schemaVersionType);
        RustUtil.indent(out, level + 2, "self.parent.as_ref().unwrap().acting_version()\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n", new Object[0]);
        RustUtil.indent(out, level, "}\n\n", new Object[0]);
        RustUtil.indent(out, level, "impl<'a, P> Reader<'a> for %s<P> where P: Reader<'a> %s+ Default {\n", name, version > 0 ? "+ ActingVersion " : "");
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn get_buf(&self) -> &ReadBuf<'a> {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "self.parent.as_ref().expect(\"parent missing\").get_buf()\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n", new Object[0]);
        RustUtil.indent(out, level, "}\n\n", new Object[0]);
    }

    static void appendImplDecoderForComposite(String schemaVersionType, int version, Appendable out, int level, String name) throws IOException {
        RustGenerator.appendImplReaderForComposite(schemaVersionType, version, out, level, name);
        RustUtil.indent(out, level, "impl<'a, P> Decoder<'a> for %s<P> where P: Decoder<'a> + ActingVersion + Default {\n", name);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn get_limit(&self) -> usize {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "self.parent.as_ref().expect(\"parent missing\").get_limit()\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n\n", new Object[0]);
        RustUtil.indent(out, level + 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, level + 1, "fn set_limit(&mut self, limit: usize) {\n", new Object[0]);
        RustUtil.indent(out, level + 2, "self.parent.as_mut().expect(\"parent missing\").set_limit(limit);\n", new Object[0]);
        RustUtil.indent(out, level + 1, "}\n", new Object[0]);
        RustUtil.indent(out, level, "}\n\n", new Object[0]);
    }

    private static void generateCompositeEncoder(List<Token> tokens, String encoderName, Writer out) throws IOException {
        Token encodingToken;
        RustUtil.indent(out, 0, "pub mod encoder {\n", new Object[0]);
        RustUtil.indent(out, 1, "use super::*;\n\n", new Object[0]);
        RustUtil.indent(out, 1, "#[derive(Debug, Default)]\n", new Object[0]);
        RustUtil.indent(out, 1, "pub struct %s<P> {\n", encoderName);
        RustUtil.indent(out, 2, "parent: Option<P>,\n", new Object[0]);
        RustUtil.indent(out, 2, "offset: usize,\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
        RustGenerator.appendImplWriterForComposite(out, 1, encoderName);
        RustUtil.indent(out, 1, "impl<'a, P> %s<P> where P: Writer<'a> + Default {\n", encoderName);
        RustUtil.indent(out, 2, "pub fn wrap(mut self, parent: P, offset: usize) -> Self {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.parent = Some(parent);\n", new Object[0]);
        RustUtil.indent(out, 3, "self.offset = offset;\n", new Object[0]);
        RustUtil.indent(out, 3, "self\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "pub fn parent(&mut self) -> SbeResult<P> {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.parent.take().ok_or(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            StringBuilder sb = new StringBuilder();
            switch (encodingToken.signal()) {
                case ENCODING: {
                    RustGenerator.generatePrimitiveEncoder(sb, 2, encodingToken, encodingToken.name());
                    break;
                }
                case BEGIN_ENUM: {
                    RustGenerator.generateEnumEncoder(sb, 2, encodingToken, encodingToken, encodingToken.name());
                    break;
                }
                case BEGIN_SET: {
                    RustGenerator.generateBitSetEncoder(sb, 2, encodingToken, encodingToken.name());
                    break;
                }
                case BEGIN_COMPOSITE: {
                    RustGenerator.generateCompositeEncoder(sb, 2, encodingToken, encodingToken.name());
                    break;
                }
            }
            out.append(sb);
        }
        RustUtil.indent(out, 1, "}\n", new Object[0]);
        RustUtil.indent(out, 0, "} // end encoder mod \n", new Object[0]);
    }

    private static void generateCompositeDecoder(String schemaVersionType, List<Token> tokens, String decoderName, Writer out) throws IOException {
        Token encodingToken;
        RustUtil.indent(out, 0, "pub mod decoder {\n", new Object[0]);
        RustUtil.indent(out, 1, "use super::*;\n\n", new Object[0]);
        RustUtil.indent(out, 1, "#[derive(Debug, Default)]\n", new Object[0]);
        RustUtil.indent(out, 1, "pub struct %s<P> {\n", decoderName);
        RustUtil.indent(out, 2, "parent: Option<P>,\n", new Object[0]);
        RustUtil.indent(out, 2, "offset: usize,\n", new Object[0]);
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
        int version = tokens.get(1).version();
        RustGenerator.appendImplReaderForComposite(schemaVersionType, version, out, 1, decoderName);
        RustUtil.indent(out, 1, "impl<'a, P> %s<P> where P: Reader<'a> %s+ Default {\n", decoderName, version > 0 ? "+ ActingVersion " : "");
        RustUtil.indent(out, 2, "pub fn wrap(mut self, parent: P, offset: usize) -> Self {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.parent = Some(parent);\n", new Object[0]);
        RustUtil.indent(out, 3, "self.offset = offset;\n", new Object[0]);
        RustUtil.indent(out, 3, "self\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        RustUtil.indent(out, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(out, 2, "pub fn parent(&mut self) -> SbeResult<P> {\n", new Object[0]);
        RustUtil.indent(out, 3, "self.parent.take().ok_or(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            StringBuilder sb = new StringBuilder();
            switch (encodingToken.signal()) {
                case ENCODING: {
                    RustGenerator.generatePrimitiveDecoder(sb, 2, encodingToken, encodingToken, encodingToken.name(), encodingToken.encoding());
                    break;
                }
                case BEGIN_ENUM: {
                    RustGenerator.generateEnumDecoder(sb, 2, encodingToken, encodingToken, encodingToken.name());
                    break;
                }
                case BEGIN_SET: {
                    RustGenerator.generateBitSetDecoder(sb, 2, encodingToken, encodingToken.name());
                    break;
                }
                case BEGIN_COMPOSITE: {
                    RustGenerator.generateCompositeDecoder(sb, 2, encodingToken, encodingToken, encodingToken.name());
                    break;
                }
            }
            out.append(sb);
        }
        RustUtil.indent(out, 1, "}\n", new Object[0]);
        RustUtil.indent(out, 0, "} // end decoder mod \n", new Object[0]);
    }

    private static void appendConstAccessor(Appendable writer, String name, String rustTypeName, String rustExpression, int level) throws IOException {
        RustUtil.indent(writer, level, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, level, "pub fn %s(&self) -> %s {\n", RustUtil.formatFunctionName(name), rustTypeName);
        RustUtil.indent(writer, level + 1, rustExpression + "\n", new Object[0]);
        RustUtil.indent(writer, level, "}\n\n", new Object[0]);
    }

    static interface ParentDef {
        public SubGroup addSubGroup(String var1, int var2, Token var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum CodecType {
        Decoder{

            @Override
            String bufType() {
                return RustGenerator.READ_BUF_TYPE;
            }
        }
        ,
        Encoder{

            @Override
            String bufType() {
                return RustGenerator.WRITE_BUF_TYPE;
            }
        };


        abstract String bufType();
    }
}

