/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.cpp.CppUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CppDtoGenerator
implements CodeGenerator {
    private static final String INDENT = "    ";
    private static final String BASE_INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public CppDtoGenerator(Ir ir, OutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    @Override
    public void generate() throws IOException {
        this.generateDtosForTypes();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String codecClassName = CppUtil.formatClassName(msgToken.name());
            String className = CppDtoGenerator.formatDtoClassName(msgToken.name());
            List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
            int offset = 0;
            ClassBuilder classBuilder = new ClassBuilder(className, "    ");
            ArrayList<Token> fields = new ArrayList<Token>();
            offset = GenerationUtil.collectFields(messageBody, offset, fields);
            this.generateFields(classBuilder, codecClassName, fields, "        ");
            ArrayList<Token> groups = new ArrayList<Token>();
            offset = GenerationUtil.collectGroups(messageBody, offset, groups);
            this.generateGroups(classBuilder, className, codecClassName, groups, "        ");
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, offset, varData);
            this.generateVarData(classBuilder, varData, "        ");
            this.generateDecodeWith(classBuilder, className, codecClassName, fields, groups, varData, "        ");
            CppDtoGenerator.generateDecodeFrom(classBuilder, className, codecClassName, "        ");
            this.generateEncodeWith(classBuilder, className, codecClassName, fields, groups, varData, "        ");
            CppDtoGenerator.generateEncodeInto(classBuilder, className, codecClassName, "        ");
            this.generateComputeEncodedLength(classBuilder, codecClassName, groups, varData, "        ");
            this.generateDisplay(classBuilder, className, codecClassName, "dto.computeEncodedLength()", "wrapForEncode", null, "        ");
            Writer out = this.outputManager.createOutput(className);
            try {
                List<Token> beginTypeTokensInSchema = this.ir.types().stream().map(t -> (Token)t.get(0)).collect(Collectors.toList());
                Set<String> referencedTypes = CppDtoGenerator.generateTypesToIncludes(beginTypeTokensInSchema);
                referencedTypes.add(codecClassName);
                out.append(CppDtoGenerator.generateDtoFileHeader(this.ir.namespaces(), className, referencedTypes));
                out.append(CppDtoGenerator.generateDocumentation("    ", msgToken));
                classBuilder.appendTo(out);
                out.append(CppUtil.closingBraces(this.ir.namespaces().length));
                out.append("#endif\n");
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private void generateGroups(ClassBuilder classBuilder, String qualifiedParentDtoClassName, String qualifiedParentCodecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String groupClassName = CppDtoGenerator.formatDtoClassName(groupName);
            String qualifiedDtoClassName = qualifiedParentDtoClassName + "::" + groupClassName;
            String fieldName = "m_" + Generators.toLowerFirstChar(groupName);
            String formattedPropertyName = CppUtil.formatPropertyName(groupName);
            classBuilder.appendField().append(indent).append("std::vector<").append(qualifiedDtoClassName).append("> ").append(fieldName).append(";\n");
            ClassBuilder groupClassBuilder = new ClassBuilder(groupClassName, indent);
            ++i;
            i += tokens.get(i).componentTokenCount();
            String qualifiedCodecClassName = qualifiedParentCodecClassName + "::" + CppUtil.formatClassName(groupName);
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            this.generateFields(groupClassBuilder, qualifiedCodecClassName, fields, indent + "    ");
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(groupClassBuilder, qualifiedDtoClassName, qualifiedCodecClassName, groups, indent + "    ");
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateVarData(groupClassBuilder, varData, indent + "    ");
            this.generateDecodeListFrom(groupClassBuilder, groupClassName, qualifiedCodecClassName, indent + "    ");
            this.generateDecodeWith(groupClassBuilder, groupClassName, qualifiedCodecClassName, fields, groups, varData, indent + "    ");
            this.generateEncodeWith(groupClassBuilder, groupClassName, qualifiedCodecClassName, fields, groups, varData, indent + "    ");
            this.generateComputeEncodedLength(groupClassBuilder, qualifiedCodecClassName, groups, varData, indent + "    ");
            groupClassBuilder.appendTo(classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, groupToken)));
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("[[nodiscard]] const std::vector<").append(qualifiedDtoClassName).append(">& ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("[[nodiscard]] std::vector<").append(qualifiedDtoClassName).append(">& ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append("const std::vector<").append(qualifiedDtoClassName).append(">& values)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = values;\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append("std::vector<").append(qualifiedDtoClassName).append(">&& values)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = std::move(values);\n").append(indent).append("}\n");
        }
    }

    private void generateComputeEncodedLength(ClassBuilder classBuilder, String qualifiedCodecClassName, List<Token> groupTokens, List<Token> varDataTokens, String indent) {
        int i;
        StringBuilder lengthBuilder = classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] std::size_t computeEncodedLength() const\n").append(indent).append("{\n");
        lengthBuilder.append(indent).append("    ").append("std::size_t encodedLength = 0;\n");
        lengthBuilder.append(indent).append("    ").append("encodedLength += ").append(qualifiedCodecClassName).append("::sbeBlockLength();\n\n");
        int size = groupTokens.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groupTokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            ++i;
            i += groupTokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(groupTokens, i, fields);
            ArrayList<Token> subGroups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(groupTokens, i, subGroups);
            ArrayList<Token> subVarData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(groupTokens, i, subVarData);
            String groupName = groupToken.name();
            String fieldName = "m_" + Generators.toLowerFirstChar(groupName);
            String groupCodecClassName = qualifiedCodecClassName + "::" + CppUtil.formatClassName(groupName);
            lengthBuilder.append(indent).append("    ").append("encodedLength += ").append(groupCodecClassName).append("::sbeHeaderSize();\n\n").append(indent).append("    ").append("for (auto& group : ").append(fieldName).append(")\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("encodedLength += group.computeEncodedLength();\n").append(indent).append("    ").append("}\n\n");
        }
        size = varDataTokens.size();
        for (i = 0; i < size; ++i) {
            Token token = varDataTokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            Token varDataToken = Generators.findFirst("varData", varDataTokens, i);
            String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
            lengthBuilder.append(indent).append("    ").append("encodedLength += ").append(qualifiedCodecClassName).append("::").append(CppUtil.formatPropertyName(propertyName)).append("HeaderLength();\n");
            lengthBuilder.append(indent).append("    ").append("encodedLength += ").append(fieldName).append(".size() * sizeof(").append(CppUtil.cppTypeName(varDataToken.encoding().primitiveType())).append(");\n\n");
        }
        lengthBuilder.append(indent).append("    ").append("return encodedLength;\n").append(indent).append("}\n");
    }

    private void generateCompositeDecodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> tokens, String indent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void decodeWith(").append(codecClassName).append("& codec, ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldDecodeWith(decodeBuilder, token, token, codecClassName, indent + "    ");
        }
        decodeBuilder.append(indent).append("}\n");
    }

    private void generateCompositeEncodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> tokens, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void encodeWith(").append(codecClassName).append("& codec,").append("const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldEncodeWith(encodeBuilder, codecClassName, token, token, indent + "    ");
        }
        encodeBuilder.append(indent).append("}\n");
    }

    private void generateDecodeListFrom(ClassBuilder classBuilder, String dtoClassName, String codecClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("static std::vector<").append(dtoClassName).append("> decodeManyWith(").append(codecClassName).append("& codec)\n").append(indent).append("{\n").append(indent).append("    ").append("std::vector<").append(dtoClassName).append("> dtos(codec.count());\n").append(indent).append("    ").append("for (std::size_t i = 0; i < dtos.size(); i++)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append(dtoClassName).append(" dto;\n").append(indent).append("    ").append("    ").append(dtoClassName).append("::decodeWith(codec.next(), dto);\n").append(indent).append("    ").append("    ").append("dtos[i] = dto;\n").append(indent).append("    ").append("}\n").append(indent).append("    ").append("return dtos;\n").append(indent).append("}\n");
    }

    private void generateDecodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void decodeWith(").append(codecClassName).append("& codec, ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        this.generateMessageFieldsDecodeWith(decodeBuilder, fields, codecClassName, indent + "    ");
        this.generateGroupsDecodeWith(decodeBuilder, groups, indent + "    ");
        this.generateVarDataDecodeWith(decodeBuilder, varData, indent + "    ");
        decodeBuilder.append(indent).append("}\n");
    }

    private static void generateDecodeFrom(ClassBuilder classBuilder, String dtoClassName, String codecClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("static ").append(dtoClassName).append(" decodeFrom(").append("char* buffer, std::uint64_t offset, ").append("std::uint64_t actingBlockLength, std::uint64_t actingVersion, ").append("std::uint64_t bufferLength)\n").append(indent).append("{\n").append(indent).append("    ").append(codecClassName).append(" codec;\n").append(indent).append("    ").append("codec.wrapForDecode(buffer, offset, actingBlockLength, actingVersion, bufferLength);\n").append(indent).append("    ").append(dtoClassName).append(" dto;\n").append(indent).append("    ").append(dtoClassName).append("::decodeWith(codec, dto);\n").append(indent).append("    ").append("return dto;\n").append(indent).append("}\n");
    }

    private void generateMessageFieldsDecodeWith(StringBuilder sb, List<Token> tokens, String codecClassName, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldDecodeWith(sb, signalToken, encodingToken, codecClassName, indent);
        }
    }

    private void generateFieldDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String codecClassName, String indent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveDecodeWith(sb, fieldToken, typeToken, codecClassName, indent);
                break;
            }
            case BEGIN_SET: {
                String bitSetName = CppDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
                this.generateBitSetDecodeWith(sb, fieldToken, bitSetName, indent);
                break;
            }
            case BEGIN_ENUM: {
                this.generateEnumDecodeWith(sb, fieldToken, indent);
                break;
            }
            case BEGIN_COMPOSITE: {
                this.generateCompositePropertyDecodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String codecClassName, String indent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            String typeName = CppUtil.cppTypeName(typeToken.encoding().primitiveType());
            String codecNullValue = codecClassName + "::" + CppUtil.formatPropertyName(fieldToken.name()) + "NullValue()";
            if (fieldToken.isConstantEncoding()) {
                return;
            }
            String propertyName = fieldToken.name();
            String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, "codec." + formattedPropertyName + "()", codecNullValue, typeName);
        } else if (arrayLength > 1) {
            this.generateArrayDecodeWith(sb, fieldToken, typeToken, codecClassName, indent);
        }
    }

    private void generateArrayDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String codecClassName, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, "std::string(codec." + formattedPropertyName + "(), " + codecClassName + "::" + formattedPropertyName + "Length())", null, "std::string");
        } else {
            StringBuilder initializerList = new StringBuilder();
            initializerList.append("{ ");
            int arrayLength = typeToken.arrayLength();
            for (int i = 0; i < arrayLength; ++i) {
                initializerList.append("codec.").append(formattedPropertyName).append("(").append(i).append("),");
            }
            assert (arrayLength > 0);
            initializerList.setLength(initializerList.length() - 1);
            initializerList.append(" }");
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, initializerList, null, "std::vector<" + CppUtil.cppTypeName(typeToken.encoding().primitiveType()) + ">");
        }
    }

    private void generateBitSetDecodeWith(StringBuilder sb, Token fieldToken, String dtoTypeName, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        if (fieldToken.isOptionalEncoding()) {
            sb.append(indent).append("if (codec.").append(formattedPropertyName).append("InActingVersion()");
            sb.append(")\n").append(indent).append("{\n");
            sb.append(indent).append("    ").append(dtoTypeName).append("::decodeWith(codec.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
            sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append("    ").append("dto.").append(formattedPropertyName).append("().clear();\n").append(indent).append("}\n");
        } else {
            sb.append(indent).append(dtoTypeName).append("::decodeWith(codec.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
        }
    }

    private void generateEnumDecodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append("codec.").append(formattedPropertyName).append("());\n");
    }

    private void generateCompositePropertyDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String dtoClassName = CppDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(dtoClassName).append("::decodeWith(codec.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateGroupsDecodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = CppUtil.formatPropertyName(groupName);
            String groupDtoClassName = CppDtoGenerator.formatDtoClassName(groupName);
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(groupDtoClassName).append("::decodeManyWith(codec.").append(formattedPropertyName).append("()));\n");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataDecodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
            boolean isOptional = token.version() > 0;
            String dataVar = Generators.toLowerFirstChar(propertyName) + "Data";
            String lengthVar = Generators.toLowerFirstChar(propertyName) + "Length";
            Object blockIndent = isOptional ? indent + "    " : indent;
            StringBuilder codecValueExtraction = new StringBuilder().append((String)blockIndent).append("std::size_t ").append(lengthVar).append(" = codec.").append(formattedPropertyName).append("Length();\n").append((String)blockIndent).append("const char* ").append(dataVar).append(" = codec.").append(formattedPropertyName).append("();\n");
            String dtoValue = "std::string(" + dataVar + ", " + lengthVar + ")";
            String nullDtoValue = "\"\"";
            if (isOptional) {
                sb.append(indent).append("if (codec.").append(formattedPropertyName).append("InActingVersion()");
                sb.append(")\n").append(indent).append("{\n");
                sb.append((CharSequence)codecValueExtraction);
                sb.append(indent).append("    ").append("dto.").append(formattedPropertyName).append("(").append(dtoValue).append(");\n");
                sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append("    ").append("dto.").append(formattedPropertyName).append("(").append("\"\"").append(");\n").append(indent).append("}\n");
                continue;
            }
            sb.append((CharSequence)codecValueExtraction);
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(dtoValue).append(");\n");
        }
    }

    private void generateRecordPropertyAssignment(StringBuilder sb, Token token, String indent, CharSequence presentExpression, String nullCodecValueOrNull, String dtoTypeName) {
        String propertyName = token.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        if (token.isOptionalEncoding()) {
            sb.append(indent).append("if (codec.").append(formattedPropertyName).append("InActingVersion()");
            if (null != nullCodecValueOrNull) {
                sb.append(" && codec.").append(formattedPropertyName).append("() != ").append(nullCodecValueOrNull);
            }
            sb.append(")\n").append(indent).append("{\n");
            sb.append(indent).append("    ").append("dto.").append(formattedPropertyName).append("(std::make_optional<").append(dtoTypeName).append(">(").append(presentExpression).append("));\n");
            sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append("    ").append("dto.").append(formattedPropertyName).append("(std::nullopt);\n").append(indent).append("}\n");
        } else {
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(presentExpression).append(");\n");
        }
    }

    private void generateEncodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void encodeWith(").append(codecClassName).append("& codec, const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        this.generateFieldsEncodeWith(encodeBuilder, codecClassName, fields, indent + "    ");
        this.generateGroupsEncodeWith(encodeBuilder, groups, indent + "    ");
        this.generateVarDataEncodeWith(encodeBuilder, varData, indent + "    ");
        encodeBuilder.append(indent).append("}\n");
    }

    private static void generateEncodeInto(ClassBuilder classBuilder, String dtoClassName, String codecClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("static std::size_t encodeInto(const ").append(dtoClassName).append("& dto, ").append("char *buffer, std::uint64_t offset, std::uint64_t bufferLength)\n").append(indent).append("{\n").append(indent).append("    ").append(codecClassName).append(" codec;\n").append(indent).append("    ").append("codec.wrapForEncode(buffer, offset, bufferLength);\n").append(indent).append("    ").append(dtoClassName).append("::encodeWith(codec, dto);\n").append(indent).append("    ").append("return codec.encodedLength();\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("static std::size_t encodeWithHeaderInto(const ").append(dtoClassName).append("& dto, ").append("char *buffer, std::uint64_t offset, std::uint64_t bufferLength)\n").append(indent).append("{\n").append(indent).append("    ").append(codecClassName).append(" codec;\n").append(indent).append("    ").append("codec.wrapAndApplyHeader(buffer, offset, bufferLength);\n").append(indent).append("    ").append(dtoClassName).append("::encodeWith(codec, dto);\n").append(indent).append("    ").append("return codec.sbePosition() - offset;\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] static std::vector<std::uint8_t> bytes(const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n").append(indent).append("    ").append("std::vector<std::uint8_t> bytes(dto.computeEncodedLength());\n").append(indent).append("    ").append(dtoClassName).append("::encodeInto(dto, reinterpret_cast<char *>(bytes.data()), 0, bytes.size());\n").append(indent).append("    ").append("return bytes;\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] static std::vector<std::uint8_t> bytesWithHeader(const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n").append(indent).append("    ").append("std::vector<std::uint8_t> bytes(dto.computeEncodedLength() + ").append("MessageHeader::encodedLength());\n").append(indent).append("    ").append(dtoClassName).append("::encodeWithHeaderInto(dto, reinterpret_cast<char *>(bytes.data()), 0, bytes.size());\n").append(indent).append("    ").append("return bytes;\n").append(indent).append("}\n");
    }

    private void generateFieldsEncodeWith(StringBuilder sb, String codecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldEncodeWith(sb, codecClassName, signalToken, encodingToken, indent);
        }
    }

    private void generateFieldEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, Token typeToken, String indent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveEncodeWith(sb, codecClassName, fieldToken, typeToken, indent);
                break;
            }
            case BEGIN_ENUM: {
                this.generateEnumEncodeWith(sb, fieldToken, indent);
                break;
            }
            case BEGIN_SET: 
            case BEGIN_COMPOSITE: {
                this.generateComplexPropertyEncodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generatePrimitiveValueEncodeWith(sb, codecClassName, fieldToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayEncodeWith(sb, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            String accessor = "dto." + formattedPropertyName + "()";
            String value = fieldToken.isOptionalEncoding() ? accessor + ".value_or(\"\")" : accessor;
            sb.append(indent).append("codec.put").append(Generators.toUpperFirstChar(propertyName)).append("(").append(value).append(".c_str());\n");
        } else {
            String typeName = CppUtil.cppTypeName(typeToken.encoding().primitiveType());
            String vectorVar = Generators.toLowerFirstChar(propertyName) + "Vector";
            String accessor = "dto." + formattedPropertyName + "()";
            String value = fieldToken.isOptionalEncoding() ? accessor + ".value_or(std::vector<" + typeName + ">())" : accessor;
            sb.append(indent).append("std::vector<").append(typeName).append("> ").append(vectorVar).append(" = ").append(value).append(";\n\n");
            sb.append(indent).append("if (").append(vectorVar).append(".size() != ").append(typeToken.arrayLength()).append(")\n").append(indent).append("{\n").append(indent).append("    ").append("throw std::invalid_argument(\"").append(propertyName).append(": array length != ").append(typeToken.arrayLength()).append("\");\n").append(indent).append("}\n\n");
            sb.append(indent).append("for (std::uint64_t i = 0; i < ").append(typeToken.arrayLength()).append("; i++)\n").append(indent).append("{\n").append(indent).append("    ").append("codec.").append(formattedPropertyName).append("(i, ").append(vectorVar).append("[i]);\n").append(indent).append("}\n");
        }
    }

    private void generatePrimitiveValueEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String nullValue = codecClassName + "::" + formattedPropertyName + "NullValue()";
        String accessor = "dto." + formattedPropertyName + "()";
        String value = fieldToken.isOptionalEncoding() ? accessor + ".value_or(" + nullValue + ")" : accessor;
        sb.append(indent).append("codec.").append(formattedPropertyName).append("(").append(value).append(");\n");
    }

    private void generateEnumEncodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        sb.append(indent).append("codec.").append(formattedPropertyName).append("(dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateComplexPropertyEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String typeName = CppDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(typeName).append("::encodeWith(codec.").append(formattedPropertyName).append("(), dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateGroupsEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = CppUtil.formatPropertyName(groupName);
            String groupCodecVarName = groupName + "Codec";
            String groupDtoTypeName = CppDtoGenerator.formatDtoClassName(groupName);
            sb.append("\n").append(indent).append("const std::vector<").append(groupDtoTypeName).append(">& ").append(formattedPropertyName).append(" = dto.").append(formattedPropertyName).append("();\n\n").append(indent).append("auto&").append(" ").append(groupCodecVarName).append(" = codec.").append(formattedPropertyName).append("Count(").append(formattedPropertyName).append(".size());\n\n").append(indent).append("for (const auto& group: ").append(formattedPropertyName).append(")\n").append(indent).append("{\n").append(indent).append("    ").append(groupDtoTypeName).append("::encodeWith(").append(groupCodecVarName).append(".next(), group);\n").append(indent).append("}\n\n");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
            String varName = Generators.toLowerFirstChar(propertyName) + "Vector";
            sb.append(indent).append("auto& ").append(varName).append(" = dto.").append(formattedPropertyName).append("();\n").append(indent).append("codec.put").append(Generators.toUpperFirstChar(propertyName)).append("(").append(varName).append(");\n");
        }
    }

    private void generateDisplay(ClassBuilder classBuilder, String dtoClassName, String codecClassName, String lengthExpression, String wrapMethod, String actingVersion, String indent) {
        StringBuilder streamBuilder = classBuilder.appendPublic().append("\n").append(indent).append("friend std::ostream& operator << (std::ostream& stream, const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n").append(indent).append("    ").append(codecClassName).append(" codec;\n").append(indent).append("    ").append("const std::size_t length = ").append(lengthExpression).append(";\n").append(indent).append("    ").append("std::vector<char> buffer(length);\n").append(indent).append("    ").append("codec.").append(wrapMethod).append("(buffer.data(), 0");
        if (null != actingVersion) {
            streamBuilder.append(", ").append(actingVersion);
        }
        streamBuilder.append(", ").append("length);\n");
        streamBuilder.append(indent).append("    ").append("encodeWith(codec, dto);\n").append(indent).append("    ").append("stream << codec;\n").append(indent).append("    ").append("return stream;\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] std::string string() const\n").append(indent).append("{\n").append(indent).append("    ").append("std::ostringstream stream;\n").append(indent).append("    ").append("stream << *this;\n").append(indent).append("    ").append("return stream.str();\n").append(indent).append("}\n");
    }

    private void generateFields(ClassBuilder classBuilder, String codecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        block5: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            switch (encodingToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(classBuilder, codecClassName, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(classBuilder, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    this.generateComplexProperty(classBuilder, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
            }
        }
    }

    private void generateComplexProperty(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String typeName = CppDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
        classBuilder.appendField().append(indent).append(typeName).append(" ").append(fieldName).append(";\n");
        classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] const ").append(typeName).append("& ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] ").append(typeName).append("& ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
    }

    private void generateEnumProperty(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String enumName = CppUtil.formatClassName(typeToken.applicableTypeName()) + "::Value";
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        if (fieldToken.isConstantEncoding()) {
            String constValue = fieldToken.encoding().constValue().toString();
            String caseName = constValue.substring(constValue.indexOf(".") + 1);
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] static ").append(enumName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(enumName).append("::").append(caseName).append(";\n").append(indent).append("}\n");
        } else {
            String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
            classBuilder.appendField().append(indent).append(enumName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] ").append(enumName).append(" ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append(enumName).append(" value)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = value;\n").append(indent).append("}\n");
        }
    }

    private void generatePrimitiveProperty(ClassBuilder classBuilder, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            this.generateConstPropertyMethods(classBuilder, propertyName, fieldToken, typeToken, indent);
        } else {
            this.generatePrimitivePropertyMethods(classBuilder, codecClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generatePrimitivePropertyMethods(ClassBuilder classBuilder, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generateSingleValueProperty(classBuilder, codecClassName, propertyName, fieldToken, typeToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayProperty(classBuilder, codecClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayProperty(ClassBuilder classBuilder, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String validateMethod = "validate" + Generators.toUpperFirstChar(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            CharSequence typeName = CppDtoGenerator.typeWithFieldOptionality(fieldToken, "std::string");
            classBuilder.appendField().append(indent).append(typeName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] const ").append(typeName).append("& ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(const ").append(typeName).append("& borrowedValue)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = borrowedValue;\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append(typeName).append("&& ownedValue)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = std::move(ownedValue);\n").append(indent).append("}\n");
            CppDtoGenerator.generateArrayValidateMethod(classBuilder, codecClassName, fieldToken, indent, validateMethod, typeName, "std::string", formattedPropertyName);
        } else {
            String elementTypeName = CppUtil.cppTypeName(typeToken.encoding().primitiveType());
            String vectorTypeName = "std::vector<" + elementTypeName + ">";
            CharSequence typeName = CppDtoGenerator.typeWithFieldOptionality(fieldToken, vectorTypeName);
            classBuilder.appendField().append(indent).append(typeName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] ").append(typeName).append(" ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append(typeName).append("& borrowedValue").append(")\n").append(indent).append("{\n").append(indent).append("    ").append(validateMethod).append("(borrowedValue);\n").append(indent).append("    ").append(fieldName).append(" = borrowedValue;\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append(typeName).append("&& ownedValue").append(")\n").append(indent).append("{\n").append(indent).append("    ").append(validateMethod).append("(ownedValue);\n").append(indent).append("    ").append(fieldName).append(" = std::move(ownedValue);\n").append(indent).append("}\n");
            CppDtoGenerator.generateArrayValidateMethod(classBuilder, codecClassName, fieldToken, indent, validateMethod, typeName, vectorTypeName, formattedPropertyName);
        }
    }

    private static void generateArrayValidateMethod(ClassBuilder classBuilder, String codecClassName, Token fieldToken, String indent, String validateMethod, CharSequence typeName, String vectorTypeName, String formattedPropertyName) {
        StringBuilder validateBuilder = classBuilder.appendPrivate().append("\n").append(indent).append("static void ").append(validateMethod).append("(").append(typeName).append(" value)\n").append(indent).append("{\n");
        String value = "value";
        if (fieldToken.isOptionalEncoding()) {
            validateBuilder.append(indent).append("    ").append("if (!value.has_value())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("return;\n").append(indent).append("    ").append("}\n");
            validateBuilder.append(indent).append("    ").append(vectorTypeName).append(" actualValue = value.value();\n");
            value = "actualValue";
        }
        validateBuilder.append(indent).append("    ").append("if (").append(value).append(".size() > ").append(codecClassName).append("::").append(formattedPropertyName).append("Length())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw std::invalid_argument(\"").append(formattedPropertyName).append(": too many elements: \" + std::to_string(").append(value).append(".size()));\n").append(indent).append("    ").append("}\n").append(indent).append("}\n");
    }

    private void generateSingleValueProperty(ClassBuilder classBuilder, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        Encoding encoding = typeToken.encoding();
        String elementTypeName = CppUtil.cppTypeName(encoding.primitiveType());
        CharSequence typeName = CppDtoGenerator.typeWithFieldOptionality(fieldToken, elementTypeName);
        String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
        String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
        String validateMethod = "validate" + Generators.toUpperFirstChar(propertyName);
        classBuilder.appendField().append(indent).append(typeName).append(" ").append(fieldName).append(";\n");
        classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] ").append(typeName).append(" ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append(typeName).append(" value)\n").append(indent).append("{\n").append(indent).append("    ").append(validateMethod).append("(value);\n").append(indent).append("    ").append(fieldName).append(" = value;\n").append(indent).append("}\n");
        CppDtoGenerator.generateSingleValuePropertyValidateMethod(classBuilder, codecClassName, propertyName, fieldToken, indent, validateMethod, typeName, formattedPropertyName, elementTypeName, encoding);
    }

    private static void generateSingleValuePropertyValidateMethod(ClassBuilder classBuilder, String codecClassName, String propertyName, Token fieldToken, String indent, String validateMethod, CharSequence typeName, String formattedPropertyName, String elementTypeName, Encoding encoding) {
        boolean mustPreventGreater;
        StringBuilder validateBuilder = classBuilder.appendPrivate().append("\n").append(indent).append("static void ").append(validateMethod).append("(").append(typeName).append(" value)\n").append(indent).append("{\n");
        String value = "value";
        boolean mustPreventLesser = !encoding.applicableMinValue().equals(encoding.primitiveType().minValue());
        boolean bl = mustPreventGreater = !encoding.applicableMaxValue().equals(encoding.primitiveType().maxValue());
        if (fieldToken.isOptionalEncoding()) {
            validateBuilder.append(indent).append("    ").append("if (!value.has_value())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("return;\n").append(indent).append("    ").append("}\n");
            validateBuilder.append(indent).append("    ").append("if (value.value() == ").append(codecClassName).append("::").append(formattedPropertyName).append("NullValue())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw std::invalid_argument(\"").append(propertyName).append(": null value is reserved: \" + std::to_string(value.value()));\n").append(indent).append("    ").append("}\n");
            if (mustPreventLesser || mustPreventGreater) {
                validateBuilder.append(indent).append("    ").append(elementTypeName).append(" actualValue = value.value();\n");
                value = "actualValue";
            }
        }
        if (mustPreventLesser) {
            validateBuilder.append(indent).append("    ").append("if (").append(value).append(" < ").append(codecClassName).append("::").append(formattedPropertyName).append("MinValue())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw std::invalid_argument(\"").append(propertyName).append(": value is less than allowed minimum: \" + std::to_string(").append(value).append("));\n").append(indent).append("    ").append("}\n");
        }
        if (mustPreventGreater) {
            validateBuilder.append(indent).append("    ").append("if (").append(value).append(" > ").append(codecClassName).append("::").append(formattedPropertyName).append("MaxValue())\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw std::invalid_argument(\"").append(propertyName).append(": value is greater than allowed maximum: \" + std::to_string(").append(value).append("));\n").append(indent).append("    ").append("}\n");
        }
        validateBuilder.append(indent).append("}\n");
    }

    private void generateConstPropertyMethods(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("static std::string ").append(Generators.toLowerFirstChar(propertyName)).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return \"").append(typeToken.encoding().constValue().toString()).append("\";\n").append(indent).append("}\n");
        } else {
            CharSequence literalValue = CppUtil.generateLiteral(typeToken.encoding().primitiveType(), typeToken.encoding().constValue().toString());
            classBuilder.appendPublic().append("\n").append(CppDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("[[nodiscard]] static ").append(CppUtil.cppTypeName(typeToken.encoding().primitiveType())).append(" ").append(CppUtil.formatPropertyName(propertyName)).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(literalValue).append(";\n").append(indent).append("}\n");
        }
    }

    private void generateVarData(ClassBuilder classBuilder, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String dtoType = "std::string";
            String fieldName = "m_" + Generators.toLowerFirstChar(propertyName);
            String formattedPropertyName = CppUtil.formatPropertyName(propertyName);
            classBuilder.appendField().append(indent).append("std::string").append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] const ").append("std::string").append("& ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] ").append("std::string").append("& ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append("void ").append(formattedPropertyName).append("(const ").append("std::string").append("& borrowedValue)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = borrowedValue;\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append("void ").append(formattedPropertyName).append("(").append("std::string").append("&& ownedValue)\n").append(indent).append("{\n").append(indent).append("    ").append(fieldName).append(" = std::move(ownedValue);\n").append(indent).append("}\n");
        }
    }

    private static String formatDtoClassName(String name) {
        return CppUtil.formatClassName(name + "Dto");
    }

    private void generateDtosForTypes() throws IOException {
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
            }
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String name = tokens.get(0).applicableTypeName();
        String className = CppDtoGenerator.formatDtoClassName(name);
        String codecClassName = CppUtil.formatClassName(name);
        try (Writer out = this.outputManager.createOutput(className);){
            List<Token> compositeTokens = tokens.subList(1, tokens.size() - 1);
            Set<String> referencedTypes = CppDtoGenerator.generateTypesToIncludes(compositeTokens);
            referencedTypes.add(codecClassName);
            out.append(CppDtoGenerator.generateDtoFileHeader(this.ir.namespaces(), className, referencedTypes));
            out.append(CppDtoGenerator.generateDocumentation("    ", tokens.get(0)));
            ClassBuilder classBuilder = new ClassBuilder(className, "    ");
            this.generateCompositePropertyElements(classBuilder, codecClassName, compositeTokens, "        ");
            this.generateCompositeDecodeWith(classBuilder, className, codecClassName, compositeTokens, "        ");
            this.generateCompositeEncodeWith(classBuilder, className, codecClassName, compositeTokens, "        ");
            this.generateDisplay(classBuilder, className, codecClassName, codecClassName + "::encodedLength()", "wrap", codecClassName + "::sbeSchemaVersion()", "        ");
            classBuilder.appendTo(out);
            out.append(CppUtil.closingBraces(this.ir.namespaces().length));
            out.append("#endif\n");
        }
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        String name = tokens.get(0).applicableTypeName();
        String className = CppDtoGenerator.formatDtoClassName(name);
        String codecClassName = CppUtil.formatClassName(name);
        try (Writer out = this.outputManager.createOutput(className);){
            List<Token> setTokens = tokens.subList(1, tokens.size() - 1);
            Set<String> referencedTypes = CppDtoGenerator.generateTypesToIncludes(setTokens);
            referencedTypes.add(codecClassName);
            out.append(CppDtoGenerator.generateDtoFileHeader(this.ir.namespaces(), className, referencedTypes));
            out.append(CppDtoGenerator.generateDocumentation("    ", tokens.get(0)));
            ClassBuilder classBuilder = new ClassBuilder(className, "    ");
            this.generateChoices(classBuilder, className, setTokens, "        ");
            this.generateChoiceSetDecodeWith(classBuilder, className, codecClassName, setTokens, "        ");
            this.generateChoiceSetEncodeWith(classBuilder, className, codecClassName, setTokens, "        ");
            classBuilder.appendTo(out);
            out.append(CppUtil.closingBraces(this.ir.namespaces().length));
            out.append("#endif\n");
        }
    }

    private void generateChoiceSetEncodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> setTokens, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void encodeWith(\n").append(indent).append("    ").append(codecClassName).append("& codec, ").append("const ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        encodeBuilder.append(indent).append("    ").append("codec.clear();\n");
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String formattedPropertyName = CppUtil.formatPropertyName(token.name());
            encodeBuilder.append(indent).append("    ").append("codec.").append(formattedPropertyName).append("(dto.").append(formattedPropertyName).append("());\n");
        }
        encodeBuilder.append(indent).append("}\n");
    }

    private void generateChoiceSetDecodeWith(ClassBuilder classBuilder, String dtoClassName, String codecClassName, List<Token> setTokens, String indent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("static void decodeWith(\n").append(indent).append("    ").append("const ").append(codecClassName).append("& codec, ").append(dtoClassName).append("& dto)\n").append(indent).append("{\n");
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String formattedPropertyName = CppUtil.formatPropertyName(token.name());
            decodeBuilder.append(indent).append("    ").append("dto.").append(formattedPropertyName).append("(codec.").append(formattedPropertyName).append("());\n");
        }
        decodeBuilder.append(indent).append("}\n");
    }

    private void generateChoices(ClassBuilder classBuilder, String dtoClassName, List<Token> setTokens, String indent) {
        ArrayList<CallSite> fields = new ArrayList<CallSite>();
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String string = "m_" + Generators.toLowerFirstChar(token.name());
            String formattedPropertyName = CppUtil.formatPropertyName(token.name());
            fields.add((CallSite)((Object)string));
            classBuilder.appendField().append(indent).append("bool ").append(string).append(";\n");
            classBuilder.appendPublic().append("\n").append(indent).append("[[nodiscard]] bool ").append(formattedPropertyName).append("() const\n").append(indent).append("{\n").append(indent).append("    ").append("return ").append(string).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append(dtoClassName).append("& ").append(formattedPropertyName).append("(bool value)\n").append(indent).append("{\n").append(indent).append("    ").append(string).append(" = value;\n").append(indent).append("    ").append("return *this;\n").append(indent).append("}\n");
        }
        StringBuilder clearBuilder = classBuilder.appendPublic().append(indent).append(dtoClassName).append("& clear()\n").append(indent).append("{\n");
        for (String string : fields) {
            clearBuilder.append(indent).append("    ").append(string).append(" = false;\n");
        }
        clearBuilder.append(indent).append("    ").append("return *this;\n").append(indent).append("}\n");
    }

    private void generateCompositePropertyElements(ClassBuilder classBuilder, String codecClassName, List<Token> tokens, String indent) {
        block5: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = CppUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(classBuilder, codecClassName, propertyName, token, token, indent);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(classBuilder, propertyName, token, token, indent);
                    continue block5;
                }
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    this.generateComplexProperty(classBuilder, propertyName, token, token, indent);
                    continue block5;
                }
            }
        }
    }

    private static Set<String> generateTypesToIncludes(List<Token> tokens) {
        HashSet<String> typesToInclude = new HashSet<String>();
        for (Token token : tokens) {
            switch (token.signal()) {
                case BEGIN_ENUM: {
                    typesToInclude.add(CppUtil.formatClassName(token.applicableTypeName()));
                    break;
                }
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    typesToInclude.add(CppDtoGenerator.formatDtoClassName(token.applicableTypeName()));
                    break;
                }
            }
        }
        return typesToInclude;
    }

    private static CharSequence typeWithFieldOptionality(Token fieldToken, String typeName) {
        if (fieldToken.isOptionalEncoding()) {
            return "std::optional<" + typeName + ">";
        }
        return typeName;
    }

    private static CharSequence generateDtoFileHeader(CharSequence[] namespaces, String className, Collection<String> typesToInclude) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated SBE (Simple Binary Encoding) message DTO */\n");
        sb.append(String.format("#ifndef _%1$s_%2$s_CXX_H_\n#define _%1$s_%2$s_CXX_H_\n\n", String.join((CharSequence)"_", namespaces).toUpperCase(), className.toUpperCase()));
        sb.append("#if (defined(_MSVC_LANG) && _MSVC_LANG < 201703L) || ").append("(!defined(_MSVC_LANG) && defined(__cplusplus) && __cplusplus < 201703L)\n").append("#error DTO code requires at least C++17.\n").append("#endif\n\n");
        sb.append("#include <cstdint>\n").append("#include <limits>\n").append("#include <cstring>\n").append("#include <iomanip>\n").append("#include <ostream>\n").append("#include <stdexcept>\n").append("#include <sstream>\n").append("#include <string>\n").append("#include <vector>\n").append("#include <tuple>\n").append("#include <optional>\n");
        if (typesToInclude != null && !typesToInclude.isEmpty()) {
            sb.append("\n");
            for (String incName : typesToInclude) {
                sb.append("#include \"").append(incName).append(".h\"\n");
            }
        }
        sb.append("\nnamespace ");
        sb.append(String.join((CharSequence)" {\nnamespace ", namespaces));
        sb.append(" {\n\n");
        return sb;
    }

    private static String generateDocumentation(String indent, Token token) {
        String description = token.description();
        if (null == description || description.isEmpty()) {
            return "";
        }
        return indent + "/**\n" + indent + " * " + description + "\n" + indent + " */\n";
    }

    private static final class ClassBuilder {
        private final StringBuilder publicSb = new StringBuilder();
        private final StringBuilder privateSb = new StringBuilder();
        private final StringBuilder fieldSb = new StringBuilder();
        private final String className;
        private final String indent;

        private ClassBuilder(String className, String indent) {
            this.className = className;
            this.indent = indent;
        }

        public StringBuilder appendPublic() {
            return this.publicSb;
        }

        public StringBuilder appendPrivate() {
            return this.privateSb;
        }

        public StringBuilder appendField() {
            return this.fieldSb;
        }

        public void appendTo(Appendable out) {
            try {
                out.append(this.indent).append("class ").append(this.className).append("\n").append(this.indent).append("{\n").append(this.indent).append("private:\n").append(this.privateSb).append("\n").append(this.indent).append("public:\n").append(this.publicSb).append("\n").append(this.indent).append("private:\n").append(this.fieldSb).append(this.indent).append("};\n");
            }
            catch (IOException exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }
}

