/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.generation.rust.RustUtil;
import uk.co.real_logic.sbe.generation.rust.SubGroup;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Token;

class MessageCoderDef
implements RustGenerator.ParentDef {
    private final StringBuilder sb = new StringBuilder();
    private final ArrayList<SubGroup> subGroups = new ArrayList();
    private final Ir ir;
    private final Token msgToken;
    final String name;
    final RustGenerator.CodecType codecType;

    MessageCoderDef(Ir ir, Token msgToken, RustGenerator.CodecType codecType) {
        this.ir = ir;
        this.msgToken = msgToken;
        this.name = RustUtil.formatStructName(msgToken.name());
        this.codecType = codecType;
    }

    String blockLengthType() {
        return RustUtil.rustTypeName(this.ir.headerStructure().blockLengthType());
    }

    String schemaVersionType() {
        return RustUtil.rustTypeName(this.ir.headerStructure().schemaVersionType());
    }

    void generate(List<Token> fields, List<Token> groups, List<Token> varData) throws IOException {
        RustUtil.indent(this.sb, 0, "pub mod %s {\n", this.codecType.toString().toLowerCase());
        RustUtil.indent(this.sb, 1, "use super::*;\n", new Object[0]);
        RustUtil.indent(this.sb, 1, "use message_header_codec::*;\n\n", new Object[0]);
        String msgTypeName = RustUtil.formatStructName(this.msgToken.name()) + this.codecType.name();
        this.appendMessageStruct(this.sb, msgTypeName);
        if (this.codecType == RustGenerator.CodecType.Encoder) {
            RustGenerator.appendImplEncoderTrait(this.sb, msgTypeName);
        } else {
            RustGenerator.appendImplDecoderTrait(this.schemaVersionType(), this.sb, msgTypeName);
        }
        RustGenerator.appendImplWithLifetimeHeader(this.sb, msgTypeName);
        this.appendWrapFn(this.sb);
        RustUtil.indent(this.sb, 2, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, 2, "pub fn encoded_length(&self) -> usize {\n", new Object[0]);
        RustUtil.indent(this.sb, 3, "self.limit - self.offset\n", new Object[0]);
        RustUtil.indent(this.sb, 2, "}\n\n", new Object[0]);
        if (this.codecType == RustGenerator.CodecType.Decoder) {
            this.appendMessageHeaderDecoderFn(this.sb);
            RustGenerator.generateDecoderFields(this.sb, fields, 2);
            RustGenerator.generateDecoderGroups(this.schemaVersionType(), this.sb, groups, 2, this);
            RustGenerator.generateDecoderVarData(this.sb, varData, 2, false);
        } else {
            this.appendMessageHeaderEncoderFn(this.sb);
            RustGenerator.generateEncoderFields(this.sb, fields, 2);
            RustGenerator.generateEncoderGroups(this.sb, groups, 2, this);
            RustGenerator.generateEncoderVarData(this.sb, varData, 2);
        }
        RustUtil.indent(this.sb, 1, "}\n\n", new Object[0]);
        for (SubGroup subGroup : this.subGroups) {
            subGroup.appendTo(this.sb);
        }
        RustUtil.indent(this.sb, 0, "} // end %s\n\n", this.codecType.toString().toLowerCase());
    }

    void appendTo(Appendable dest) throws IOException {
        dest.append(this.sb);
    }

    @Override
    public SubGroup addSubGroup(String name, int level, Token groupToken) {
        SubGroup subGroup = new SubGroup(name, level, groupToken);
        this.subGroups.add(subGroup);
        return subGroup;
    }

    void appendMessageHeaderEncoderFn(Appendable out) throws IOException {
        RustUtil.indent(out, 2, "pub fn header(self, offset: usize) -> MessageHeaderEncoder<Self> {\n", new Object[0]);
        RustUtil.indent(out, 3, "let mut header = MessageHeaderEncoder::default().wrap(self, offset);\n", new Object[0]);
        RustUtil.indent(out, 3, "header.block_length(SBE_BLOCK_LENGTH);\n", new Object[0]);
        RustUtil.indent(out, 3, "header.template_id(SBE_TEMPLATE_ID);\n", new Object[0]);
        RustUtil.indent(out, 3, "header.schema_id(SBE_SCHEMA_ID);\n", new Object[0]);
        RustUtil.indent(out, 3, "header.version(SBE_SCHEMA_VERSION);\n", new Object[0]);
        RustUtil.indent(out, 3, "header\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
    }

    void appendMessageHeaderDecoderFn(Appendable out) throws IOException {
        RustUtil.indent(out, 2, "pub fn header(self, mut header: MessageHeaderDecoder<ReadBuf<'a>>) -> Self {\n", new Object[0]);
        RustUtil.indent(out, 3, "debug_assert_eq!(SBE_TEMPLATE_ID, header.template_id());\n", new Object[0]);
        RustUtil.indent(out, 3, "let acting_block_length = header.block_length();\n", new Object[0]);
        RustUtil.indent(out, 3, "let acting_version = header.version();\n\n", new Object[0]);
        RustUtil.indent(out, 3, "self.wrap(\n", new Object[0]);
        RustUtil.indent(out, 4, "header.parent().unwrap(),\n", new Object[0]);
        RustUtil.indent(out, 4, "message_header_codec::ENCODED_LENGTH,\n", new Object[0]);
        RustUtil.indent(out, 4, "acting_block_length,\n", new Object[0]);
        RustUtil.indent(out, 4, "acting_version,\n", new Object[0]);
        RustUtil.indent(out, 3, ")\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
    }

    void appendMessageStruct(Appendable out, String structName) throws IOException {
        if (this.codecType == RustGenerator.CodecType.Decoder) {
            RustUtil.indent(out, 1, "#[derive(Clone, Copy, Debug, Default)]\n", new Object[0]);
        } else {
            RustUtil.indent(out, 1, "#[derive(Debug, Default)]\n", new Object[0]);
        }
        RustUtil.indent(out, 1, "pub struct %s {\n", RustGenerator.withLifetime(structName));
        RustUtil.indent(out, 2, "buf: %s,\n", RustGenerator.withLifetime(this.codecType.bufType()));
        RustUtil.indent(out, 2, "initial_offset: usize,\n", new Object[0]);
        RustUtil.indent(out, 2, "offset: usize,\n", new Object[0]);
        RustUtil.indent(out, 2, "limit: usize,\n", new Object[0]);
        if (this.codecType == RustGenerator.CodecType.Decoder) {
            RustUtil.indent(out, 2, "pub acting_block_length: %s,\n", this.blockLengthType());
            RustUtil.indent(out, 2, "pub acting_version: %s,\n", this.schemaVersionType());
        }
        RustUtil.indent(out, 1, "}\n\n", new Object[0]);
    }

    void appendWrapFn(Appendable out) throws IOException {
        if (this.codecType == RustGenerator.CodecType.Decoder) {
            RustUtil.indent(out, 2, "pub fn wrap(\n", new Object[0]);
            RustUtil.indent(out, 3, "mut self,\n", new Object[0]);
            RustUtil.indent(out, 3, "buf: %s,\n", RustGenerator.withLifetime(this.codecType.bufType()));
            RustUtil.indent(out, 3, "offset: usize,\n", new Object[0]);
            RustUtil.indent(out, 3, "acting_block_length: %s,\n", this.blockLengthType());
            RustUtil.indent(out, 3, "acting_version: %s,\n", this.schemaVersionType());
            RustUtil.indent(out, 2, ") -> Self {\n", new Object[0]);
            RustUtil.indent(out, 3, "let limit = offset + acting_block_length as usize;\n", new Object[0]);
        } else {
            RustUtil.indent(out, 2, "pub fn wrap(mut self, buf: %s, offset: usize) -> Self {\n", RustGenerator.withLifetime(this.codecType.bufType()));
            RustUtil.indent(out, 3, "let limit = offset + SBE_BLOCK_LENGTH as usize;\n", new Object[0]);
        }
        RustUtil.indent(out, 3, "self.buf = buf;\n", new Object[0]);
        RustUtil.indent(out, 3, "self.initial_offset = offset;\n", new Object[0]);
        RustUtil.indent(out, 3, "self.offset = offset;\n", new Object[0]);
        RustUtil.indent(out, 3, "self.limit = limit;\n", new Object[0]);
        if (this.codecType == RustGenerator.CodecType.Decoder) {
            RustUtil.indent(out, 3, "self.acting_block_length = acting_block_length;\n", new Object[0]);
            RustUtil.indent(out, 3, "self.acting_version = acting_version;\n", new Object[0]);
        }
        RustUtil.indent(out, 3, "self\n", new Object[0]);
        RustUtil.indent(out, 2, "}\n\n", new Object[0]);
    }

    static void generateEncoder(Ir ir, Writer out, Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData) throws IOException {
        MessageCoderDef coderDef = new MessageCoderDef(ir, msgToken, RustGenerator.CodecType.Encoder);
        coderDef.generate(fields, groups, varData);
        coderDef.appendTo(out);
    }

    static void generateDecoder(Ir ir, Writer out, Token msgToken, List<Token> fields, List<Token> groups, List<Token> varData) throws IOException {
        MessageCoderDef coderDef = new MessageCoderDef(ir, msgToken, RustGenerator.CodecType.Decoder);
        coderDef.generate(fields, groups, varData);
        coderDef.appendTo(out);
    }
}

