/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import uk.co.real_logic.sbe.generation.rust.RustOutputManager;
import uk.co.real_logic.sbe.generation.rust.RustUtil;

class LibRsDef {
    private final RustOutputManager outputManager;
    private final ByteOrder byteOrder;

    LibRsDef(RustOutputManager outputManager, ByteOrder byteOrder) {
        this.outputManager = outputManager;
        this.byteOrder = byteOrder;
    }

    void generate() throws IOException {
        try (Writer libRs = this.outputManager.createOutput("lib");){
            RustUtil.indent(libRs, 0, "#![forbid(unsafe_code)]\n", new Object[0]);
            RustUtil.indent(libRs, 0, "#![allow(clippy::upper_case_acronyms)]\n", new Object[0]);
            RustUtil.indent(libRs, 0, "#![allow(non_camel_case_types)]\n\n", new Object[0]);
            RustUtil.indent(libRs, 0, "use ::core::{convert::TryInto};\n\n", new Object[0]);
            ArrayList modules = new ArrayList();
            try (Stream<Path> walk = Files.walk(this.outputManager.getSrcDirPath(), new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).filter(fileName -> fileName.endsWith(".rs")).filter(fileName -> !fileName.equals("lib.rs")).map(fileName -> fileName.substring(0, fileName.length() - 3)).forEach(modules::add);
            }
            for (String mod : modules) {
                RustUtil.indent(libRs, 0, "pub mod %s;\n", RustUtil.toLowerSnakeCase(mod));
            }
            RustUtil.indent(libRs, 0, "\n", new Object[0]);
            LibRsDef.generateSbeErrorEnum(libRs);
            LibRsDef.generateEitherEnum(libRs);
            LibRsDef.generateEncoderTraits(libRs);
            LibRsDef.generateDecoderTraits(libRs);
            LibRsDef.generateReadBuf(libRs, this.byteOrder);
            LibRsDef.generateWriteBuf(libRs, this.byteOrder);
        }
    }

    static void generateEncoderTraits(Writer writer) throws IOException {
        RustUtil.indent(writer, 0, "pub trait Writer<'a>: Sized {\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_buf_mut(&mut self) -> &mut WriteBuf<'a>;\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub trait Encoder<'a>: Writer<'a> {\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_limit(&self) -> usize;\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn set_limit(&mut self, limit: usize);\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
    }

    static void generateDecoderTraits(Writer writer) throws IOException {
        RustUtil.indent(writer, 0, "pub trait Reader<'a>: Sized {\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_buf(&self) -> &ReadBuf<'a>;\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub trait Decoder<'a>: Reader<'a> {\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_limit(&self) -> usize;\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn set_limit(&mut self, limit: usize);\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
    }

    static void generateSbeErrorEnum(Writer writer) throws IOException {
        RustUtil.indent(writer, 0, "pub type SbeResult<T> = core::result::Result<T, SbeErr>;\n\n", new Object[0]);
        RustUtil.indent(writer, 0, "#[derive(Clone, Copy, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub enum SbeErr {\n", new Object[0]);
        RustUtil.indent(writer, 1, "ParentNotSet,\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl core::fmt::Display for SbeErr {\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {\n", new Object[0]);
        RustUtil.indent(writer, 2, "write!(f, \"{self:?}\")\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl std::error::Error for SbeErr {}\n\n", new Object[0]);
    }

    static void generateEitherEnum(Writer writer) throws IOException {
        RustUtil.indent(writer, 0, "#[derive(Clone, Copy, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub enum Either<L, R> {\n", new Object[0]);
        RustUtil.indent(writer, 1, "Left(L),\n", new Object[0]);
        RustUtil.indent(writer, 1, "Right(R),\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
    }

    static void generateReadBuf(Appendable writer, ByteOrder byteOrder) throws IOException {
        RustUtil.indent(writer, 0, "#[derive(Clone, Copy, Debug, Default)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub struct %s<%s> {\n", "ReadBuf", "'a");
        RustUtil.indent(writer, 1, "data: &%s [u8],\n", "'a");
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl<%s> Reader<%1$s> for %2$s<%1$s> {\n", "'a", "ReadBuf");
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_buf(&self) -> &ReadBuf<%s> {\n", "'a");
        RustUtil.indent(writer, 2, "self\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "#[allow(dead_code)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl<%s> %s<%s> {\n", "'a", "ReadBuf", "'a");
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn new(data: &%s [u8]) -> Self {\n", "'a");
        RustUtil.indent(writer, 2, "Self { data }\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "fn get_bytes<const COUNT: usize>(slice: &[u8]) -> [u8; COUNT] {\n", new Object[0]);
        RustUtil.indent(writer, 2, "slice.try_into().expect(\"slice with incorrect length\")\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub(crate) fn get_bytes_at<const N: usize>(slice: &[u8], index: usize) -> [u8; N] {\n", new Object[0]);
        RustUtil.indent(writer, 2, "slice[index..index+N].try_into().expect(\"slice with incorrect length\")\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        LinkedHashSet<String> uniquePrimitiveTypes = new LinkedHashSet<String>(RustUtil.TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.values());
        String endianness = byteOrder == ByteOrder.LITTLE_ENDIAN ? "le" : "be";
        uniquePrimitiveTypes.remove("u8");
        RustUtil.indent(writer, 0, "\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn get_u8_at(&self, index: usize) -> u8 {\n", new Object[0]);
        RustUtil.indent(writer, 2, "self.data[index]\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        for (String primitiveType : uniquePrimitiveTypes) {
            RustUtil.indent(writer, 0, "\n", new Object[0]);
            RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
            RustUtil.indent(writer, 1, "pub fn get_%1$s_at(&self, index: usize) -> %1$s {\n", primitiveType);
            RustUtil.indent(writer, 2, "%s::from_%s_bytes(Self::get_bytes_at(self.data, index))\n", primitiveType, endianness);
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
        }
        RustUtil.indent(writer, 0, "\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn get_slice_at(&self, index: usize, len: usize) -> &[u8] {\n", new Object[0]);
        RustUtil.indent(writer, 2, "&self.data[index..index+len]\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        writer.append("}\n");
    }

    static void generateWriteBuf(Writer writer, ByteOrder byteOrder) throws IOException {
        RustUtil.indent(writer, 0, "\n", new Object[0]);
        RustUtil.indent(writer, 0, "#[derive(Debug, Default)]\n", new Object[0]);
        RustUtil.indent(writer, 0, "pub struct %s<%s> {\n", "WriteBuf", "'a");
        RustUtil.indent(writer, 1, "data: &%s mut [u8],\n", "'a");
        RustUtil.indent(writer, 0, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "impl<%s> %s<%s> {\n", "'a", "WriteBuf", "'a");
        RustUtil.indent(writer, 1, "pub fn new(data: &%s mut [u8]) -> Self {\n", "'a");
        RustUtil.indent(writer, 2, "Self { data }\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn put_bytes_at<const COUNT: usize>(&mut self, index: usize, bytes: &[u8; COUNT]) -> usize {\n", new Object[0]);
        RustUtil.indent(writer, 2, "self.data[index..index + COUNT].copy_from_slice(bytes);\n", new Object[0]);
        RustUtil.indent(writer, 2, "COUNT\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        LinkedHashSet<String> uniquePrimitiveTypes = new LinkedHashSet<String>(RustUtil.TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.values());
        String endianness = byteOrder == ByteOrder.LITTLE_ENDIAN ? "le" : "be";
        uniquePrimitiveTypes.remove("u8");
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn put_u8_at(&mut self, index: usize, value: u8) {\n", new Object[0]);
        RustUtil.indent(writer, 2, "self.data[index] = value;\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        for (String primitiveType : uniquePrimitiveTypes) {
            RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
            RustUtil.indent(writer, 1, "pub fn put_%1$s_at(&mut self, index: usize, value: %1$s) {\n", primitiveType);
            RustUtil.indent(writer, 2, "self.put_bytes_at(index, &%s::to_%s_bytes(value));\n", primitiveType, endianness);
            RustUtil.indent(writer, 1, "}\n\n", new Object[0]);
        }
        RustUtil.indent(writer, 1, "#[inline]\n", new Object[0]);
        RustUtil.indent(writer, 1, "pub fn put_slice_at(&mut self, index: usize, src: &[u8]) -> usize {\n", new Object[0]);
        RustUtil.indent(writer, 2, "let len = src.len();\n", new Object[0]);
        RustUtil.indent(writer, 2, "let dest = self.data.split_at_mut(index).1.split_at_mut(len).0;\n", new Object[0]);
        RustUtil.indent(writer, 2, "dest.clone_from_slice(src);\n", new Object[0]);
        RustUtil.indent(writer, 2, "len\n", new Object[0]);
        RustUtil.indent(writer, 1, "}\n", new Object[0]);
        RustUtil.indent(writer, 0, "}\n\n", new Object[0]);
    }
}

