/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.ringbuffer;

public class RecordDescriptor {
    public static final int HEADER_LENGTH = 8;
    public static final int ALIGNMENT = 8;

    public static int lengthOffset(int recordOffset) {
        return recordOffset;
    }

    public static int typeOffset(int recordOffset) {
        return recordOffset + 4;
    }

    public static int encodedMsgOffset(int recordOffset) {
        return recordOffset + 8;
    }

    public static long makeHeader(int length, int msgTypeId) {
        return ((long)msgTypeId & 0xFFFFFFFFL) << 32 | (long)length & 0xFFFFFFFFL;
    }

    public static int recordLength(long header) {
        return (int)header;
    }

    public static int messageTypeId(long header) {
        return (int)(header >>> 32);
    }

    public static void checkTypeId(int msgTypeId) {
        if (msgTypeId < 1) {
            String msg = String.format("Message type id must be greater than zero, msgTypeId=%d", msgTypeId);
            throw new IllegalArgumentException(msg);
        }
    }
}

