/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.collections.CollectionUtil;
import uk.co.real_logic.agrona.collections.Hashing;
import uk.co.real_logic.agrona.collections.LongLongConsumer;
import uk.co.real_logic.agrona.collections.MapDelegatingSet;
import uk.co.real_logic.agrona.generation.DoNotSub;

public class Long2LongHashMap
implements Map<Long, Long> {
    @DoNotSub
    private final double loadFactor;
    private final long missingValue;
    @DoNotSub
    private int resizeThreshold;
    @DoNotSub
    private int size = 0;
    private long[] entries;
    private final KeySet keySet;
    private final Values values;
    private final Set<Map.Entry<Long, Long>> entrySet;

    public Long2LongHashMap(long missingValue) {
        this(16, 0.67, missingValue);
    }

    public Long2LongHashMap(@DoNotSub int initialCapacity, @DoNotSub double loadFactor, long missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(initialCapacity));
        this.keySet = new KeySet();
        this.values = new Values();
        this.entrySet = new EntrySet();
    }

    public long missingValue() {
        return this.missingValue;
    }

    @Override
    @DoNotSub
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(long key) {
        long candidateKey;
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long value = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                value = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public long put(long key, long value) {
        long candidateKey;
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(@DoNotSub int newCapacity) {
        long[] oldEntries = this.entries;
        long missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int i = 0; i < length; i += 2) {
            long key = oldEntries[i];
            if (key == missingValue) continue;
            this.put(key, oldEntries[i + 1]);
        }
    }

    public void longForEach(LongLongConsumer consumer) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            long key = entries[i];
            if (key == missingValue) continue;
            consumer.accept(entries[i], entries[i + 1]);
        }
    }

    public boolean containsKey(long key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(long value) {
        long[] entries = this.entries;
        int length = entries.length;
        boolean found = false;
        for (int i = 1; i < length; i += 2) {
            if (value != entries[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, this.missingValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public Long get(Object key) {
        return this.get((Long)key);
    }

    @Override
    public Long put(Long key, Long value) {
        return this.put((long)key, (long)value);
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> action) {
        this.longForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        for (Map.Entry<? extends Long, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        return this.keySet;
    }

    public Values values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Long remove(Object key) {
        return this.remove((Long)key);
    }

    public long remove(long key) {
        long candidateKey;
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                int valueIndex = index + 1;
                oldValue = entries[valueIndex];
                entries[index] = missingValue;
                entries[valueIndex] = missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        return oldValue;
    }

    private void compactChain(@DoNotSub int deleteIndex) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = deleteIndex;
        while (entries[index = Long2LongHashMap.next(index, mask)] != missingValue) {
            int hash = Hashing.evenHash(entries[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            entries[deleteIndex] = entries[index];
            entries[deleteIndex + 1] = entries[index + 1];
            entries[index] = missingValue;
            entries[index + 1] = missingValue;
            deleteIndex = index;
        }
    }

    public long minValue() {
        long missingValue = this.missingValue;
        long min = this.size == 0 ? missingValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public long maxValue() {
        long missingValue = this.missingValue;
        long max = this.size == 0 ? missingValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<Long, Long> entry : this.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @DoNotSub
    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(@DoNotSub int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.missingValue);
    }

    private final class EntrySet
    extends MapDelegatingSet<Map.Entry<Long, Long>> {
        private final EntryIterator entryIterator;

        private EntrySet() {
            super(Long2LongHashMap.this);
            this.entryIterator = new EntryIterator();
        }

        @Override
        public Iterator<Map.Entry<Long, Long>> iterator() {
            return this.entryIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return Long2LongHashMap.this.containsKey(((Map.Entry)o).getKey());
        }
    }

    public final class Values
    extends AbstractCollection<Long> {
        private final LongIterator valueIterator;

        private Values() {
            this.valueIterator = new LongIterator(1);
        }

        public LongIterator iterator() {
            return this.valueIterator.reset();
        }

        @Override
        @DoNotSub
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends MapDelegatingSet<Long> {
        private final LongIterator keyIterator;

        private KeySet() {
            super(Long2LongHashMap.this);
            this.keyIterator = new LongIterator(0);
        }

        public LongIterator iterator() {
            return this.keyIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsKey(key);
        }
    }

    final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Long, Long>>,
    Map.Entry<Long, Long> {
        private long key;
        private long value;

        private EntryIterator() {
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public Long setValue(Long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<Long, Long> next() {
            this.findNext();
            int keyPosition = this.keyPosition();
            this.key = Long2LongHashMap.this.entries[keyPosition];
            this.value = Long2LongHashMap.this.entries[keyPosition + 1];
            return this;
        }

        public EntryIterator reset() {
            ((AbstractIterator)this).reset();
            this.key = Long2LongHashMap.this.missingValue;
            this.value = Long2LongHashMap.this.missingValue;
            return this;
        }
    }

    public final class LongIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @DoNotSub
        private final int offset;

        private LongIterator(int offset) {
            this.offset = offset;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition() + this.offset];
        }

        public LongIterator reset() {
            ((AbstractIterator)this).reset();
            return this;
        }
    }

    abstract class AbstractIterator {
        @DoNotSub
        private int positionCounter;
        @DoNotSub
        private int stopCounter;

        AbstractIterator() {
            this.reset();
        }

        private void reset() {
            int capacity;
            long missingValue = Long2LongHashMap.this.missingValue;
            long[] entries = Long2LongHashMap.this.entries;
            int i = capacity = entries.length;
            if (entries[capacity - 2] != missingValue) {
                int size = capacity;
                for (i = 0; i < size && entries[i] != missingValue; i += 2) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + capacity;
        }

        @DoNotSub
        protected int keyPosition() {
            return this.positionCounter & Long2LongHashMap.this.entries.length - 1;
        }

        public boolean hasNext() {
            long[] entries = Long2LongHashMap.this.entries;
            long missingValue = Long2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            boolean hasNext = false;
            for (int i = this.positionCounter - 2; i >= this.stopCounter; i -= 2) {
                int index = i & mask;
                if (entries[index] == missingValue) continue;
                hasNext = true;
                break;
            }
            return hasNext;
        }

        protected void findNext() {
            long[] entries = Long2LongHashMap.this.entries;
            long missingValue = Long2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int i = this.positionCounter - 2; i >= this.stopCounter; i -= 2) {
                int index = i & mask;
                if (entries[index] == missingValue) continue;
                this.positionCounter = i;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

