/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.json;

import java.io.UnsupportedEncodingException;
import java.util.List;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class JsonTokenListener
implements TokenListener {
    private final byte[] tempBuffer = new byte[1024];
    private final StringBuilder output;
    private int indentation = 0;

    public JsonTokenListener(StringBuilder output) {
        this.output = output;
    }

    @Override
    public void onBeginMessage(Token token) {
        this.startObject();
    }

    @Override
    public void onEndMessage(Token token) {
        this.endObject();
    }

    @Override
    public void onEncoding(Token fieldToken, DirectBuffer buffer, int bufferIndex, Token typeToken, int actingVersion) {
        this.property(fieldToken);
        this.appendEncodingAsString(buffer, bufferIndex, typeToken, actingVersion);
        this.next();
    }

    @Override
    public void onEnum(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
    }

    @Override
    public void onBitSet(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
    }

    @Override
    public void onBeginComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
    }

    @Override
    public void onEndComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
    }

    @Override
    public void onGroupHeader(Token token, int numInGroup) {
        this.property(token);
        this.output.append("[\n");
    }

    @Override
    public void onBeginGroup(Token token, int groupIndex, int numInGroup) {
        this.startObject();
    }

    @Override
    public void onEndGroup(Token token, int groupIndex, int numInGroup) {
        this.endObject();
        if (this.isLastGroup(groupIndex, numInGroup)) {
            this.backup();
            this.output.append("],\n");
        }
    }

    @Override
    public void onVarData(Token fieldToken, DirectBuffer buffer, int bufferIndex, int length, Token typeToken) {
        try {
            this.property(fieldToken);
            this.doubleQuote();
            buffer.getBytes(bufferIndex, this.tempBuffer, 0, length);
            this.output.append(new String(this.tempBuffer, 0, length, typeToken.encoding().characterEncoding()));
            this.doubleQuote();
            this.next();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    private boolean isLastGroup(int groupIndex, int numInGroup) {
        return groupIndex == numInGroup - 1;
    }

    private void next() {
        this.output.append(",\n");
    }

    private void property(Token token) {
        this.indent();
        this.doubleQuote();
        this.output.append(token.name());
        this.output.append("\": ");
    }

    private void appendEncodingAsString(DirectBuffer buffer, int index, Token typeToken, int actingVersion) {
        PrimitiveValue constOrNotPresentValue = JsonTokenListener.constOrNotPresentValue(typeToken, actingVersion);
        if (null != constOrNotPresentValue) {
            this.output.append(constOrNotPresentValue.toString());
            return;
        }
        Encoding encoding = typeToken.encoding();
        int elementSize = encoding.primitiveType().size();
        int size = typeToken.arrayLength();
        if (size > 1 && encoding.primitiveType() == PrimitiveType.CHAR) {
            this.doubleQuote();
            for (int i = 0; i < size; ++i) {
                this.output.append((char)buffer.getByte(index + i * elementSize));
            }
            this.doubleQuote();
        } else {
            if (size > 1) {
                this.output.append('[');
            }
            for (int i = 0; i < size; ++i) {
                Types.appendAsString(this.output, buffer, index + i * elementSize, encoding);
                this.output.append(", ");
            }
            this.backup();
            if (size > 1) {
                this.output.append(']');
            }
        }
    }

    private void backup() {
        this.output.setLength(this.output.length() - 2);
    }

    private static PrimitiveValue constOrNotPresentValue(Token token, int actingVersion) {
        Encoding encoding = token.encoding();
        if (token.isConstantEncoding()) {
            return encoding.constValue();
        }
        if (token.isOptionalEncoding() && actingVersion < token.version()) {
            return encoding.applicableNullValue();
        }
        return null;
    }

    private void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.append("    ");
        }
    }

    private void doubleQuote() {
        this.output.append('\"');
    }

    private void startObject() {
        this.indent();
        this.output.append("{\n");
        ++this.indentation;
    }

    private void endObject() {
        this.backup();
        this.output.append('\n');
        --this.indentation;
        this.indent();
        this.output.append('}');
        if (this.indentation > 0) {
            this.next();
        }
    }
}

