/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class CollectionUtil {
    public static <K, V> V getOrDefault(Map<K, V> map, K key, Function<K, V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    public static <V> int sum(List<V> values, ToIntFunction<V> function) {
        int total = 0;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            V value = values.get(i);
            total += function.applyAsInt(value);
        }
        return total;
    }

    public static void validateLoadFactor(double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("Load factors must be > 0.0 and < 1.0");
        }
    }

    public static void validatePowerOfTwo(int value) {
        if (1 != Integer.bitCount(value)) {
            throw new IllegalStateException("Value must be a power of two");
        }
    }
}

