/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.collections.CollectionUtil;
import uk.co.real_logic.agrona.collections.Hashing;

public class BiInt2ObjectMap<V> {
    private final double loadFactor;
    private int resizeThreshold;
    private int size;
    private long[] keys;
    private Object[] values;

    public BiInt2ObjectMap() {
        this(8, 0.6);
    }

    public BiInt2ObjectMap(int initialCapacity, double loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((double)capacity * loadFactor);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
    }

    public int capacity() {
        return this.values.length;
    }

    public double loadFactor() {
        return this.loadFactor;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    public V put(int keyPartA, int keyPartB, V value) {
        long key = BiInt2ObjectMap.compoundKey(keyPartA, keyPartB);
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(keyPartA, keyPartB, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return (V)oldValue;
    }

    public V get(int keyPartA, int keyPartB) {
        Object value;
        long key = BiInt2ObjectMap.compoundKey(keyPartA, keyPartB);
        int mask = this.values.length - 1;
        int index = Hashing.hash(keyPartA, keyPartB, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V remove(int keyPartA, int keyPartB) {
        Object value;
        long key = BiInt2ObjectMap.compoundKey(keyPartA, keyPartB);
        int mask = this.values.length - 1;
        int index = Hashing.hash(keyPartA, keyPartB, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(int keyPartA, int keyPartB, EntryFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        V value = this.get(keyPartA, keyPartB);
        if (value == null && (value = mappingFunction.apply(keyPartA, keyPartB)) != null) {
            this.put(keyPartA, keyPartB, value);
        }
        return value;
    }

    public void forEach(Consumer<V> consumer) {
        for (Object value : this.values) {
            if (null == value) continue;
            consumer.accept(value);
        }
    }

    public void forEach(EntryConsumer<V> consumer) {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            long compoundKey = this.keys[i];
            int keyPartA = (int)(compoundKey >>> 32);
            int keyPartB = (int)(compoundKey & 0xFFFFFFFFL);
            consumer.accept(keyPartA, keyPartB, value);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    private static long compoundKey(int keyPartA, int keyPartB) {
        return (long)keyPartA << 32 | (long)keyPartB;
    }

    private void rehash(int newCapacity) {
        if (1 != Integer.bitCount(newCapacity)) {
            throw new IllegalStateException("New capacity must be a power of two");
        }
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        long[] tempKeys = new long[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            long key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            long key = this.keys[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = key;
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    public static interface EntryFunction<V> {
        public V apply(int var1, int var2);
    }

    public static interface EntryConsumer<V> {
        public void accept(int var1, int var2, V var3);
    }
}

