/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public final class BitUtil {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int CACHE_LINE_LENGTH = 64;
    private static final byte[] HEX_DIGIT_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] FROM_HEX_DIGIT_TABLE = new byte[128];
    private static final int LAST_DIGIT_MASK = 1;

    private BitUtil() {
    }

    public static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static long findNextPositivePowerOfTwo(long value) {
        return 1L << 64 - Long.numberOfLeadingZeros(value - 1L);
    }

    public static int align(int value, int alignment) {
        return value + (alignment - 1) & -alignment;
    }

    public static long align(long value, long alignment) {
        return value + (alignment - 1L) & -alignment;
    }

    public static byte[] fromHexByteArray(byte[] buffer) {
        byte[] outputBuffer = new byte[buffer.length >> 1];
        for (int i = 1; i < buffer.length; i += 2) {
            int hi = FROM_HEX_DIGIT_TABLE[buffer[i - 1]] << 4;
            byte lo = FROM_HEX_DIGIT_TABLE[buffer[i]];
            outputBuffer[i - 1 >> 1] = (byte)(hi | lo);
        }
        return outputBuffer;
    }

    public static byte[] toHexByteArray(byte[] buffer) {
        return BitUtil.toHexByteArray(buffer, 0, buffer.length);
    }

    public static byte[] toHexByteArray(byte[] buffer, int offset, int length) {
        byte[] outputBuffer = new byte[length << 1];
        for (int i = 0; i < length << 1; i += 2) {
            byte b = buffer[offset + (i >> 1)];
            outputBuffer[i] = HEX_DIGIT_TABLE[b >> 4 & 0xF];
            outputBuffer[i + 1] = HEX_DIGIT_TABLE[b & 0xF];
        }
        return outputBuffer;
    }

    public static byte[] toHexByteArray(CharSequence charSequence, int offset, int length) {
        byte[] outputBuffer = new byte[length << 1];
        for (int i = 0; i < length << 1; i += 2) {
            byte b = (byte)charSequence.charAt(offset + (i >> 1));
            outputBuffer[i] = HEX_DIGIT_TABLE[b >> 4 & 0xF];
            outputBuffer[i + 1] = HEX_DIGIT_TABLE[b & 0xF];
        }
        return outputBuffer;
    }

    public static byte[] fromHex(String string) {
        int length = string.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        return BitUtil.fromHexByteArray(bytes);
    }

    public static String toHex(byte[] buffer, int offset, int length) {
        return new String(BitUtil.toHexByteArray(buffer, offset, length), StandardCharsets.US_ASCII);
    }

    public static String toHex(byte[] buffer) {
        return new String(BitUtil.toHexByteArray(buffer), StandardCharsets.US_ASCII);
    }

    public static boolean isEven(int value) {
        return (value & 1) == 0;
    }

    public static boolean isEven(long value) {
        return (value & 1L) == 0L;
    }

    public static boolean isPowerOfTwo(int value) {
        return value > 0 && (value & ~value + 1) == value;
    }

    public static boolean isPowerOfTwo(long value) {
        return value > 0L && (value & (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L) == value;
    }

    public static int next(int current, int max) {
        int next = current + 1;
        if (next == max) {
            next = 0;
        }
        return next;
    }

    public static int previous(int current, int max) {
        if (0 == current) {
            return max - 1;
        }
        return current - 1;
    }

    public static int calculateShiftForScale(int scale) {
        if (4 == scale) {
            return 2;
        }
        if (8 == scale) {
            return 3;
        }
        throw new IllegalArgumentException("unknown pointer size for scale=" + scale);
    }

    public static int generateRandomisedId() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static boolean isAligned(long address, int alignment) {
        if (!BitUtil.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("alignment must be a power of 2: alignment=" + alignment);
        }
        return (address & (long)(alignment - 1)) == 0L;
    }

    static {
        BitUtil.FROM_HEX_DIGIT_TABLE[48] = 0;
        BitUtil.FROM_HEX_DIGIT_TABLE[49] = 1;
        BitUtil.FROM_HEX_DIGIT_TABLE[50] = 2;
        BitUtil.FROM_HEX_DIGIT_TABLE[51] = 3;
        BitUtil.FROM_HEX_DIGIT_TABLE[52] = 4;
        BitUtil.FROM_HEX_DIGIT_TABLE[53] = 5;
        BitUtil.FROM_HEX_DIGIT_TABLE[54] = 6;
        BitUtil.FROM_HEX_DIGIT_TABLE[55] = 7;
        BitUtil.FROM_HEX_DIGIT_TABLE[56] = 8;
        BitUtil.FROM_HEX_DIGIT_TABLE[57] = 9;
        BitUtil.FROM_HEX_DIGIT_TABLE[97] = 10;
        BitUtil.FROM_HEX_DIGIT_TABLE[65] = 10;
        BitUtil.FROM_HEX_DIGIT_TABLE[98] = 11;
        BitUtil.FROM_HEX_DIGIT_TABLE[66] = 11;
        BitUtil.FROM_HEX_DIGIT_TABLE[99] = 12;
        BitUtil.FROM_HEX_DIGIT_TABLE[67] = 12;
        BitUtil.FROM_HEX_DIGIT_TABLE[100] = 13;
        BitUtil.FROM_HEX_DIGIT_TABLE[68] = 13;
        BitUtil.FROM_HEX_DIGIT_TABLE[101] = 14;
        BitUtil.FROM_HEX_DIGIT_TABLE[69] = 14;
        BitUtil.FROM_HEX_DIGIT_TABLE[102] = 15;
        BitUtil.FROM_HEX_DIGIT_TABLE[70] = 15;
    }
}

