/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.agrona.Strings;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.cpp.CppUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CppGenerator
implements CodeGenerator {
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;
    private final boolean shouldDecodeUnknownEnumValues;

    public CppGenerator(Ir ir, boolean shouldDecodeUnknownEnumValues, OutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.shouldDecodeUnknownEnumValues = shouldDecodeUnknownEnumValues;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        this.generateComposite(this.ir.headerStructure().tokens());
    }

    private List<String> generateTypeStubs() throws IOException {
        ArrayList<String> typesToInclude = new ArrayList<String>();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
            typesToInclude.add(tokens.get(0).applicableTypeName());
        }
        return typesToInclude;
    }

    private List<String> generateTypesToIncludes(List<Token> tokens) {
        ArrayList<String> typesToInclude = new ArrayList<String>();
        for (Token token : tokens) {
            switch (token.signal()) {
                case BEGIN_ENUM: 
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    typesToInclude.add(token.applicableTypeName());
                }
            }
        }
        return typesToInclude;
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        List<String> typesToInclude = this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = CppUtil.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), className, typesToInclude));
                out.append(CppGenerator.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int i = 0;
                ArrayList<Token> fields = new ArrayList<Token>();
                i = GenerationUtil.collectFields(messageBody, i, fields);
                ArrayList<Token> groups = new ArrayList<Token>();
                i = GenerationUtil.collectGroups(messageBody, i, groups);
                ArrayList<Token> varData = new ArrayList<Token>();
                GenerationUtil.collectVarData(messageBody, i, varData);
                StringBuilder sb = new StringBuilder();
                this.generateFields(sb, className, fields, BASE_INDENT);
                this.generateGroups(sb, groups, BASE_INDENT);
                this.generateVarData(sb, className, varData, BASE_INDENT);
                this.generateDisplay(sb, msgToken.name(), fields, groups, varData);
                sb.append(this.generateMessageLength(groups, varData, BASE_INDENT));
                sb.append("};\n");
                sb.append(CppUtil.closingBraces(this.ir.namespaces().length)).append("#endif\n");
                out.append(sb);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            Token numInGroupToken = Generators.findFirst("numInGroup", tokens, i);
            String cppTypeForNumInGroup = CppUtil.cppTypeName(numInGroupToken.encoding().primitiveType());
            CppGenerator.generateGroupClassHeader(sb, groupName, tokens, i, indent + INDENT);
            int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            this.generateFields(sb, CppUtil.formatClassName(groupName), fields, indent + INDENT);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(sb, groups, indent + INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateVarData(sb, CppUtil.formatClassName(groupName), varData, indent + INDENT);
            sb.append(this.generateGroupDisplay(groupName, fields, groups, varData, indent + INDENT + INDENT));
            sb.append(this.generateMessageLength(groups, varData, indent + INDENT + INDENT));
            sb.append(indent).append("    };\n");
            CppGenerator.generateGroupProperty(sb, groupName, groupToken, cppTypeForNumInGroup, indent);
        }
    }

    private static void generateGroupClassHeader(StringBuilder sb, String groupName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = CppUtil.formatClassName(tokens.get(index + 1).name());
        int dimensionHeaderLength = tokens.get(index + 1).encodedLength();
        int blockLength = tokens.get(index).encodedLength();
        Token blockLengthToken = Generators.findFirst("blockLength", tokens, index);
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        String cppTypeBlockLength = CppUtil.cppTypeName(blockLengthToken.encoding().primitiveType());
        String cppTypeNumInGroup = CppUtil.cppTypeName(numInGroupToken.encoding().primitiveType());
        new Formatter(sb).format("\n" + indent + "class %1$s\n" + indent + "{\n" + indent + "private:\n" + indent + "    char *m_buffer = nullptr;\n" + indent + "    std::uint64_t m_bufferLength = 0;\n" + indent + "    std::uint64_t m_initialPosition = 0;\n" + indent + "    std::uint64_t *m_positionPtr = nullptr;\n" + indent + "    std::uint64_t m_blockLength = 0;\n" + indent + "    std::uint64_t m_count = 0;\n" + indent + "    std::uint64_t m_index = 0;\n" + indent + "    std::uint64_t m_offset = 0;\n" + indent + "    std::uint64_t m_actingVersion = 0;\n\n" + indent + "    SBE_NODISCARD std::uint64_t *sbePositionPtr() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return m_positionPtr;\n" + indent + "    }\n\n" + indent + "public:\n", CppUtil.formatClassName(groupName));
        new Formatter(sb).format(indent + "    inline void wrapForDecode(\n" + indent + "        char *buffer,\n" + indent + "        std::uint64_t *pos,\n" + indent + "        const std::uint64_t actingVersion,\n" + indent + "        const std::uint64_t bufferLength)\n" + indent + "    {\n" + indent + "        %2$s dimensions(buffer, *pos, bufferLength, actingVersion);\n" + indent + "        m_buffer = buffer;\n" + indent + "        m_bufferLength = bufferLength;\n" + indent + "        m_blockLength = dimensions.blockLength();\n" + indent + "        m_count = dimensions.numInGroup();\n" + indent + "        m_index = 0;\n" + indent + "        m_actingVersion = actingVersion;\n" + indent + "        m_initialPosition = *pos;\n" + indent + "        m_positionPtr = pos;\n" + indent + "        *m_positionPtr = *m_positionPtr + %1$d;\n" + indent + "    }\n", dimensionHeaderLength, dimensionsClassName);
        long minCount = numInGroupToken.encoding().applicableMinValue().longValue();
        String minCheck = minCount > 0L ? "count < " + minCount + " || " : BASE_INDENT;
        new Formatter(sb).format("\n" + indent + "    inline void wrapForEncode(\n" + indent + "        char *buffer,\n" + indent + "        const %3$s count,\n" + indent + "        std::uint64_t *pos,\n" + indent + "        const std::uint64_t actingVersion,\n" + indent + "        const std::uint64_t bufferLength)\n" + indent + "    {\n" + indent + "#if defined(__GNUG__) && !defined(__clang__)\n" + indent + "#pragma GCC diagnostic push\n" + indent + "#pragma GCC diagnostic ignored \"-Wtype-limits\"\n" + indent + "#endif\n" + indent + "        if (%5$scount > %6$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"count outside of allowed range [E110]\");\n" + indent + "        }\n" + indent + "#if defined(__GNUG__) && !defined(__clang__)\n" + indent + "#pragma GCC diagnostic pop\n" + indent + "#endif\n" + indent + "        m_buffer = buffer;\n" + indent + "        m_bufferLength = bufferLength;\n" + indent + "        %7$s dimensions(buffer, *pos, bufferLength, actingVersion);\n" + indent + "        dimensions.blockLength(static_cast<%1$s>(%2$d));\n" + indent + "        dimensions.numInGroup(static_cast<%3$s>(count));\n" + indent + "        m_index = 0;\n" + indent + "        m_count = count;\n" + indent + "        m_blockLength = %2$d;\n" + indent + "        m_actingVersion = actingVersion;\n" + indent + "        m_initialPosition = *pos;\n" + indent + "        m_positionPtr = pos;\n" + indent + "        *m_positionPtr = *m_positionPtr + %4$d;\n" + indent + "    }\n", cppTypeBlockLength, blockLength, cppTypeNumInGroup, dimensionHeaderLength, minCheck, numInGroupToken.encoding().applicableMaxValue().longValue(), dimensionsClassName);
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint64_t sbeHeaderSize() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %1$d;\n" + indent + "    }\n\n" + indent + "    static SBE_CONSTEXPR std::uint64_t sbeBlockLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n" + indent + "    SBE_NODISCARD std::uint64_t sbePosition() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return *m_positionPtr;\n" + indent + "    }\n\n" + indent + "    // NOLINTNEXTLINE(readability-convert-member-functions-to-static)\n" + indent + "    std::uint64_t sbeCheckPosition(const std::uint64_t position)\n" + indent + "    {\n" + indent + "        if (SBE_BOUNDS_CHECK_EXPECT((position > m_bufferLength), false))\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"buffer too short [E100]\");\n" + indent + "        }\n" + indent + "        return position;\n" + indent + "    }\n\n" + indent + "    void sbePosition(const std::uint64_t position)\n" + indent + "    {\n" + indent + "        *m_positionPtr = sbeCheckPosition(position);\n" + indent + "    }\n\n" + indent + "    SBE_NODISCARD inline std::uint64_t count() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return m_count;\n" + indent + "    }\n\n" + indent + "    SBE_NODISCARD inline bool hasNext() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return m_index < m_count;\n" + indent + "    }\n\n" + indent + "    inline %3$s &next()\n" + indent + "    {\n" + indent + "        if (m_index >= m_count)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"index >= count [E108]\");\n" + indent + "        }\n" + indent + "        m_offset = *m_positionPtr;\n" + indent + "        if (SBE_BOUNDS_CHECK_EXPECT(((m_offset + m_blockLength) > m_bufferLength), false))\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"buffer too short for next group index [E108]\");\n" + indent + "        }\n" + indent + "        *m_positionPtr = m_offset + m_blockLength;\n" + indent + "        ++m_index;\n\n" + indent + "        return *this;\n" + indent + "    }\n", dimensionHeaderLength, blockLength, CppUtil.formatClassName(groupName));
        sb.append("\n").append(indent).append("    inline std::uint64_t resetCountToIndex()\n").append(indent).append("    {\n").append(indent).append("        m_count = m_index;\n").append(indent).append("        ").append(dimensionsClassName).append(" dimensions(m_buffer, m_initialPosition, m_bufferLength, m_actingVersion);\n").append(indent).append("        dimensions.numInGroup(static_cast<").append(cppTypeNumInGroup).append(">(m_count));\n").append(indent).append("        return m_count;\n").append(indent).append("    }\n");
        sb.append("\n").append(indent).append("#if __cplusplus < 201103L\n").append(indent).append("    template<class Func> inline void forEach(Func &func)\n").append(indent).append("    {\n").append(indent).append("        while (hasNext())\n").append(indent).append("        {\n").append(indent).append("            next();\n").append(indent).append("            func(*this);\n").append(indent).append("        }\n").append(indent).append("    }\n\n").append(indent).append("#else\n").append(indent).append("    template<class Func> inline void forEach(Func &&func)\n").append(indent).append("    {\n").append(indent).append("        while (hasNext())\n").append(indent).append("        {\n").append(indent).append("            next();\n").append(indent).append("            func(*this);\n").append(indent).append("        }\n").append(indent).append("    }\n\n").append(indent).append("#endif\n");
    }

    private static void generateGroupProperty(StringBuilder sb, String groupName, Token token, String cppTypeForNumInGroup, String indent) {
        String className = CppUtil.formatClassName(groupName);
        String propertyName = CppUtil.formatPropertyName(groupName);
        new Formatter(sb).format("\nprivate:\n" + indent + "    %1$s m_%2$s;\n\npublic:\n", className, propertyName);
        new Formatter(sb).format(indent + "    SBE_NODISCARD static SBE_CONSTEXPR std::uint16_t %1$sId() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", groupName, token.id());
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD inline %1$s &%2$s()\n" + indent + "    {\n" + indent + "        m_%2$s.wrapForDecode(m_buffer, sbePositionPtr(), m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", className, propertyName);
        new Formatter(sb).format("\n" + indent + "    %1$s &%2$sCount(const %3$s count)\n" + indent + "    {\n" + indent + "        m_%2$s.wrapForEncode(m_buffer, count, sbePositionPtr(), m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", className, propertyName, cppTypeForNumInGroup);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR std::uint64_t %1$sSinceVersion() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n" + indent + "    SBE_NODISCARD bool %1$sInActingVersion() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic push\n" + indent + "#pragma clang diagnostic ignored \"-Wtautological-compare\"\n" + indent + "#endif\n" + indent + "        return m_actingVersion >= %1$sSinceVersion();\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic pop\n" + indent + "#endif\n" + indent + "    }\n", propertyName, token.version());
    }

    private void generateVarData(StringBuilder sb, String className, List<Token> tokens, String indent) {
        Token token;
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + token);
            }
            String propertyName = Generators.toUpperFirstChar(token.name());
            Token lengthToken = Generators.findFirst("length", tokens, i);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            int lengthOfLengthField = lengthToken.encodedLength();
            String lengthCppType = CppUtil.cppTypeName(lengthToken.encoding().primitiveType());
            String lengthByteOrderStr = CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType());
            CppGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            this.generateVarDataDescriptors(sb, token, propertyName, characterEncoding, lengthToken, lengthOfLengthField, lengthCppType, indent);
            new Formatter(sb).format("\n" + indent + "    std::uint64_t skip%1$s()\n" + indent + "    {\n%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = sbePosition();\n" + indent + "        %5$s lengthFieldValue;\n" + indent + "        std::memcpy(&lengthFieldValue, m_buffer + lengthPosition, sizeof(%5$s));\n" + indent + "        std::uint64_t dataLength = %4$s(lengthFieldValue);\n" + indent + "        sbePosition(lengthPosition + lengthOfLengthField + dataLength);\n" + indent + "        return dataLength;\n" + indent + "    }\n", propertyName, CppGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), lengthOfLengthField, lengthByteOrderStr, lengthCppType);
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD const char *%1$s()\n" + indent + "    {\n%2$s" + indent + "        %4$s lengthFieldValue;\n" + indent + "        std::memcpy(&lengthFieldValue, m_buffer + sbePosition(), sizeof(%4$s));\n" + indent + "        const char *fieldPtr = m_buffer + sbePosition() + %3$d;\n" + indent + "        sbePosition(sbePosition() + %3$d + %5$s(lengthFieldValue));\n" + indent + "        return fieldPtr;\n" + indent + "    }\n", CppUtil.formatPropertyName(propertyName), CppGenerator.generateTypeFieldNotPresentCondition(token.version(), indent), lengthOfLengthField, lengthCppType, lengthByteOrderStr);
            new Formatter(sb).format("\n" + indent + "    std::uint64_t get%1$s(char *dst, const std::uint64_t length)\n" + indent + "    {\n%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = sbePosition();\n" + indent + "        sbePosition(lengthPosition + lengthOfLengthField);\n" + indent + "        %5$s lengthFieldValue;\n" + indent + "        std::memcpy(&lengthFieldValue, m_buffer + lengthPosition, sizeof(%5$s));\n" + indent + "        std::uint64_t dataLength = %4$s(lengthFieldValue);\n" + indent + "        std::uint64_t bytesToCopy = length < dataLength ? length : dataLength;\n" + indent + "        std::uint64_t pos = sbePosition();\n" + indent + "        sbePosition(pos + dataLength);\n" + indent + "        std::memcpy(dst, m_buffer + pos, static_cast<std::size_t>(bytesToCopy));\n" + indent + "        return bytesToCopy;\n" + indent + "    }\n", propertyName, CppGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), lengthOfLengthField, lengthByteOrderStr, lengthCppType);
            new Formatter(sb).format("\n" + indent + "    %5$s &put%1$s(const char *src, const %3$s length)\n" + indent + "    {\n" + indent + "        std::uint64_t lengthOfLengthField = %2$d;\n" + indent + "        std::uint64_t lengthPosition = sbePosition();\n" + indent + "        %3$s lengthFieldValue = %4$s(length);\n" + indent + "        sbePosition(lengthPosition + lengthOfLengthField);\n" + indent + "        std::memcpy(m_buffer + lengthPosition, &lengthFieldValue, sizeof(%3$s));\n" + indent + "        if (length != %3$s(0))\n" + indent + "        {\n" + indent + "            std::uint64_t pos = sbePosition();\n" + indent + "            sbePosition(pos + length);\n" + indent + "            std::memcpy(m_buffer + pos, src, length);\n" + indent + "        }\n" + indent + "        return *this;\n" + indent + "    }\n", propertyName, lengthOfLengthField, lengthCppType, lengthByteOrderStr, className);
            new Formatter(sb).format("\n" + indent + "    std::string get%1$sAsString()\n" + indent + "    {\n%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = sbePosition();\n" + indent + "        sbePosition(lengthPosition + lengthOfLengthField);\n" + indent + "        %5$s lengthFieldValue;\n" + indent + "        std::memcpy(&lengthFieldValue, m_buffer + lengthPosition, sizeof(%5$s));\n" + indent + "        std::uint64_t dataLength = %4$s(lengthFieldValue);\n" + indent + "        std::uint64_t pos = sbePosition();\n" + indent + "        const std::string result(m_buffer + pos, dataLength);\n" + indent + "        sbePosition(pos + dataLength);\n" + indent + "        return result;\n" + indent + "    }\n", propertyName, CppGenerator.generateStringNotPresentCondition(token.version(), indent), lengthOfLengthField, lengthByteOrderStr, lengthCppType);
            this.generateJsonEscapedStringGetter(sb, token, indent, propertyName);
            new Formatter(sb).format("\n" + indent + "    #if __cplusplus >= 201703L\n" + indent + "    std::string_view get%1$sAsStringView()\n" + indent + "    {\n%2$s" + indent + "        std::uint64_t lengthOfLengthField = %3$d;\n" + indent + "        std::uint64_t lengthPosition = sbePosition();\n" + indent + "        sbePosition(lengthPosition + lengthOfLengthField);\n" + indent + "        %5$s lengthFieldValue;\n" + indent + "        std::memcpy(&lengthFieldValue, m_buffer + lengthPosition, sizeof(%5$s));\n" + indent + "        std::uint64_t dataLength = %4$s(lengthFieldValue);\n" + indent + "        std::uint64_t pos = sbePosition();\n" + indent + "        const std::string_view result(m_buffer + pos, dataLength);\n" + indent + "        sbePosition(pos + dataLength);\n" + indent + "        return result;\n" + indent + "    }\n" + indent + "    #endif\n", propertyName, CppGenerator.generateStringViewNotPresentCondition(token.version(), indent), lengthOfLengthField, lengthByteOrderStr, lengthCppType);
            new Formatter(sb).format("\n" + indent + "    %1$s &put%2$s(const std::string &str)\n" + indent + "    {\n" + indent + "        if (str.length() > %4$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"std::string too long for length type [E109]\");\n" + indent + "        }\n" + indent + "        return put%2$s(str.data(), static_cast<%3$s>(str.length()));\n" + indent + "    }\n", className, propertyName, lengthCppType, lengthToken.encoding().applicableMaxValue().longValue());
            new Formatter(sb).format("\n" + indent + "    #if __cplusplus >= 201703L\n" + indent + "    %1$s &put%2$s(const std::string_view str)\n" + indent + "    {\n" + indent + "        if (str.length() > %4$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"std::string too long for length type [E109]\");\n" + indent + "        }\n" + indent + "        return put%2$s(str.data(), static_cast<%3$s>(str.length()));\n" + indent + "    }\n" + indent + "    #endif\n", className, propertyName, lengthCppType, lengthToken.encoding().applicableMaxValue().longValue());
        }
    }

    private void generateVarDataDescriptors(StringBuilder sb, Token token, String propertyName, String characterEncoding, Token lengthToken, Integer sizeOfLengthField, String lengthCppType, String indent) {
        new Formatter(sb).format("\n" + indent + "    static const char *%1$sCharacterEncoding() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return \"%2$s\";\n" + indent + "    }\n", Generators.toLowerFirstChar(propertyName), characterEncoding);
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint64_t %1$sSinceVersion() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n" + indent + "    bool %1$sInActingVersion() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic push\n" + indent + "#pragma clang diagnostic ignored \"-Wtautological-compare\"\n" + indent + "#endif\n" + indent + "        return m_actingVersion >= %1$sSinceVersion();\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic pop\n" + indent + "#endif\n" + indent + "    }\n\n" + indent + "    static SBE_CONSTEXPR std::uint16_t %1$sId() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %3$d;\n" + indent + "    }\n", Generators.toLowerFirstChar(propertyName), token.version(), token.id());
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint64_t %sHeaderLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", Generators.toLowerFirstChar(propertyName), sizeOfLengthField);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %4$s %1$sLength() const\n" + indent + "    {\n%2$s" + indent + "        %4$s length;\n" + indent + "        std::memcpy(&length, m_buffer + sbePosition(), sizeof(%4$s));\n" + indent + "        return %3$s(length);\n" + indent + "    }\n", Generators.toLowerFirstChar(propertyName), CppGenerator.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), CppUtil.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCppType);
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        String bitSetName = CppUtil.formatClassName(tokens.get(0).applicableTypeName());
        try (Writer out = this.outputManager.createOutput(bitSetName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), bitSetName, null));
            out.append(CppGenerator.generateClassDeclaration(bitSetName));
            out.append(this.generateFixedFlyweightCode(bitSetName, tokens.get(0).encodedLength()));
            new Formatter(out).format("\n    %1$s &clear()\n    {\n        %2$s zero = 0;\n        std::memcpy(m_buffer + m_offset, &zero, sizeof(%2$s));\n        return *this;\n    }\n", bitSetName, CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType()));
            new Formatter(out).format("\n    SBE_NODISCARD bool isEmpty() const\n    {\n        %1$s val;\n        std::memcpy(&val, m_buffer + m_offset, sizeof(%1$s));\n        return 0 == val;\n    }\n", CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType()));
            new Formatter(out).format("\n    SBE_NODISCARD %1$s rawValue() const\n    {\n        %1$s val;\n        std::memcpy(&val, m_buffer + m_offset, sizeof(%1$s));\n        return val;\n    }\n", CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType()));
            new Formatter(out).format("\n    %1$s &rawValue(%2$s value)\n    {\n        std::memcpy(m_buffer + m_offset, &value, sizeof(%2$s));\n        return *this;\n    }\n", bitSetName, CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType()));
            out.append(this.generateChoices(bitSetName, tokens.subList(1, tokens.size() - 1)));
            out.append(this.generateChoicesDisplay(bitSetName, tokens.subList(1, tokens.size() - 1)));
            out.append("};\n");
            out.append(CppUtil.closingBraces(this.ir.namespaces().length)).append("#endif\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CppUtil.formatClassName(tokens.get(0).applicableTypeName());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), enumName, null));
            out.append(CppGenerator.generateEnumDeclaration(enumName));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(this.generateEnumLookupMethod(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(this.generateEnumDisplay(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append("};\n\n");
            out.append(CppUtil.closingBraces(this.ir.namespaces().length)).append("\n#endif\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = CppUtil.formatClassName(tokens.get(0).applicableTypeName());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(CppGenerator.generateFileHeader(this.ir.namespaces(), compositeName, this.generateTypesToIncludes(tokens.subList(1, tokens.size() - 1))));
            out.append(CppGenerator.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(compositeName, tokens.get(0).encodedLength()));
            out.append(this.generateCompositePropertyElements(compositeName, tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append(this.generateCompositeDisplay(tokens.get(0).applicableTypeName(), tokens.subList(1, tokens.size() - 1)));
            out.append("};\n\n");
            out.append(CppUtil.closingBraces(this.ir.namespaces().length)).append("\n#endif\n");
        }
    }

    private static CharSequence generateChoiceNotPresentCondition(int sinceVersion) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format("        if (m_actingVersion < %1$d)\n        {\n            return false;\n        }\n\n", sinceVersion);
    }

    private CharSequence generateChoices(String bitsetClassName, List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        tokens.stream().filter(token -> token.signal() == Signal.CHOICE).forEach(token -> {
            String choiceName = CppUtil.formatPropertyName(token.name());
            PrimitiveType type = token.encoding().primitiveType();
            String typeName = CppUtil.cppTypeName(type);
            String choiceBitPosition = token.encoding().constValue().toString();
            String byteOrderStr = CppUtil.formatByteOrderEncoding(token.encoding().byteOrder(), type);
            CharSequence constantOne = CppGenerator.generateLiteral(type, "1");
            new Formatter(sb).format("\n    static bool %1$s(const %2$s bits)\n    {\n        return (bits & (%4$s << %3$su)) != 0;\n    }\n", choiceName, typeName, choiceBitPosition, constantOne);
            new Formatter(sb).format("\n    static %2$s %1$s(const %2$s bits, const bool value)\n    {\n        return value ? static_cast<%2$s>(bits | (%4$s << %3$su)) : static_cast<%2$s>(bits & ~(%4$s << %3$su));\n    }\n", choiceName, typeName, choiceBitPosition, constantOne);
            new Formatter(sb).format("\n    SBE_NODISCARD bool %1$s() const\n    {\n%2$s        %4$s val;\n        std::memcpy(&val, m_buffer + m_offset, sizeof(%4$s));\n        return (%3$s(val) & (%6$s << %5$su)) != 0;\n    }\n", choiceName, CppGenerator.generateChoiceNotPresentCondition(token.version()), byteOrderStr, typeName, choiceBitPosition, constantOne);
            new Formatter(sb).format("\n    %1$s &%2$s(const bool value)\n    {\n        %3$s bits;\n        std::memcpy(&bits, m_buffer + m_offset, sizeof(%3$s));\n        bits = %4$s(value ? static_cast<%3$s>(%4$s(bits) | (%6$s << %5$su)) : static_cast<%3$s>(%4$s(bits) & ~(%6$s << %5$su)));\n        std::memcpy(m_buffer + m_offset, &bits, sizeof(%3$s));\n        return *this;\n    }\n", bitsetClassName, choiceName, typeName, byteOrderStr, choiceBitPosition, constantOne);
        });
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        sb.append("    enum Value\n    {\n");
        for (Token token : tokens) {
            CharSequence constVal = CppGenerator.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString());
            sb.append("        ").append(token.name()).append(" = ").append(constVal).append(",\n");
        }
        CharSequence nullLiteral = CppGenerator.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        if (this.shouldDecodeUnknownEnumValues) {
            sb.append("        SBE_UNKNOWN = ").append(nullLiteral).append(",\n");
        }
        sb.append("        NULL_VALUE = ").append(nullLiteral);
        sb.append("\n    };\n\n");
        return sb;
    }

    private CharSequence generateEnumLookupMethod(List<Token> tokens, Token encodingToken) {
        String enumName = CppUtil.formatClassName(encodingToken.applicableTypeName());
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format("    static %1$s::Value get(const %2$s value)\n    {\n        switch (value)\n        {\n", enumName, CppUtil.cppTypeName(tokens.get(0).encoding().primitiveType()));
        for (Token token : tokens) {
            CharSequence constVal = CppGenerator.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString());
            sb.append("            case ").append(constVal).append(": return ").append(token.name()).append(";\n");
        }
        CharSequence nullVal = CppGenerator.generateLiteral(encodingToken.encoding().primitiveType(), encodingToken.encoding().applicableNullValue().toString());
        sb.append("            case ").append(nullVal).append(": return NULL_VALUE;\n").append("        }\n\n");
        if (this.shouldDecodeUnknownEnumValues) {
            sb.append("        return SBE_UNKNOWN;\n").append("    }\n");
        } else {
            new Formatter(sb).format("        throw std::runtime_error(\"unknown value for enum %s [E103]\");\n    }\n", enumName);
        }
        return sb;
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s;\n" + indent + "        }\n\n", sinceVersion, CppGenerator.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
    }

    private static CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateStringNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return std::string(\"\");\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateStringViewNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return std::string_view(\"\");\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return nullptr;\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateFileHeader(CharSequence[] namespaces, String className, List<String> typesToInclude) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated SBE (Simple Binary Encoding) message codec */\n");
        sb.append(String.format("#ifndef _%1$s_%2$s_H_\n#define _%1$s_%2$s_H_\n\n#if defined(SBE_HAVE_CMATH)\n/* cmath needed for std::numeric_limits<double>::quiet_NaN() */\n#  include <cmath>\n#  define SBE_FLOAT_NAN std::numeric_limits<float>::quiet_NaN()\n#  define SBE_DOUBLE_NAN std::numeric_limits<double>::quiet_NaN()\n#else\n/* math.h needed for NAN */\n#  include <math.h>\n#  define SBE_FLOAT_NAN NAN\n#  define SBE_DOUBLE_NAN NAN\n#endif\n\n#if __cplusplus >= 201103L\n#  define SBE_CONSTEXPR constexpr\n#  define SBE_NOEXCEPT noexcept\n#else\n#  define SBE_CONSTEXPR\n#  define SBE_NOEXCEPT\n#endif\n\n#if __cplusplus >= 201703L\n#  include <string_view>\n#  define SBE_NODISCARD [[nodiscard]]\n#else\n#  define SBE_NODISCARD\n#endif\n\n#if !defined(__STDC_LIMIT_MACROS)\n#  define __STDC_LIMIT_MACROS 1\n#endif\n\n#include <cstdint>\n#include <cstring>\n#include <iomanip>\n#include <limits>\n#include <ostream>\n#include <stdexcept>\n#include <sstream>\n#include <string>\n#include <vector>\n#include <tuple>\n\n#if defined(WIN32) || defined(_WIN32)\n#  define SBE_BIG_ENDIAN_ENCODE_16(v) _byteswap_ushort(v)\n#  define SBE_BIG_ENDIAN_ENCODE_32(v) _byteswap_ulong(v)\n#  define SBE_BIG_ENDIAN_ENCODE_64(v) _byteswap_uint64(v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_16(v) (v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_32(v) (v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_64(v) (v)\n#elif __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__\n#  define SBE_BIG_ENDIAN_ENCODE_16(v) __builtin_bswap16(v)\n#  define SBE_BIG_ENDIAN_ENCODE_32(v) __builtin_bswap32(v)\n#  define SBE_BIG_ENDIAN_ENCODE_64(v) __builtin_bswap64(v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_16(v) (v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_32(v) (v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_64(v) (v)\n#elif __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__\n#  define SBE_LITTLE_ENDIAN_ENCODE_16(v) __builtin_bswap16(v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_32(v) __builtin_bswap32(v)\n#  define SBE_LITTLE_ENDIAN_ENCODE_64(v) __builtin_bswap64(v)\n#  define SBE_BIG_ENDIAN_ENCODE_16(v) (v)\n#  define SBE_BIG_ENDIAN_ENCODE_32(v) (v)\n#  define SBE_BIG_ENDIAN_ENCODE_64(v) (v)\n#else\n#  error \"Byte Ordering of platform not determined. Set __BYTE_ORDER__ manually before including this file.\"\n#endif\n\n#if defined(SBE_NO_BOUNDS_CHECK)\n#  define SBE_BOUNDS_CHECK_EXPECT(exp, c) (false)\n#elif defined(_MSC_VER)\n#  define SBE_BOUNDS_CHECK_EXPECT(exp, c) (exp)\n#else\n#  define SBE_BOUNDS_CHECK_EXPECT(exp, c) (__builtin_expect(exp, c))\n#endif\n\n#define SBE_NULLVALUE_INT8 (std::numeric_limits<std::int8_t>::min)()\n#define SBE_NULLVALUE_INT16 (std::numeric_limits<std::int16_t>::min)()\n#define SBE_NULLVALUE_INT32 (std::numeric_limits<std::int32_t>::min)()\n#define SBE_NULLVALUE_INT64 (std::numeric_limits<std::int64_t>::min)()\n#define SBE_NULLVALUE_UINT8 (std::numeric_limits<std::uint8_t>::max)()\n#define SBE_NULLVALUE_UINT16 (std::numeric_limits<std::uint16_t>::max)()\n#define SBE_NULLVALUE_UINT32 (std::numeric_limits<std::uint32_t>::max)()\n#define SBE_NULLVALUE_UINT64 (std::numeric_limits<std::uint64_t>::max)()\n\n", String.join((CharSequence)"_", namespaces).toUpperCase(), className.toUpperCase()));
        if (typesToInclude != null && typesToInclude.size() != 0) {
            sb.append("\n");
            for (String incName : typesToInclude) {
                sb.append(String.format("#include \"%1$s.h\"\n", Generators.toUpperFirstChar(incName)));
            }
        }
        sb.append("\nnamespace ");
        sb.append(String.join((CharSequence)" {\nnamespace ", namespaces));
        sb.append(" {\n\n");
        return sb;
    }

    private static CharSequence generateClassDeclaration(String className) {
        return "class " + className + "\n{\n";
    }

    private static CharSequence generateEnumDeclaration(String name) {
        return "class " + name + "\n{\npublic:\n";
    }

    private CharSequence generateCompositePropertyElements(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token fieldToken = tokens.get(i);
            String propertyName = CppUtil.formatPropertyName(fieldToken.name());
            CppGenerator.generateFieldMetaAttributeMethod(sb, fieldToken, indent);
            this.generateFieldCommonMethods(indent, sb, fieldToken, fieldToken, propertyName);
            switch (fieldToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(sb, containingClassName, propertyName, fieldToken, fieldToken, indent);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(sb, containingClassName, fieldToken, propertyName, fieldToken, indent);
                    continue block6;
                }
                case BEGIN_SET: {
                    CppGenerator.generateBitsetProperty(sb, propertyName, fieldToken, indent);
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    CppGenerator.generateCompositeProperty(sb, propertyName, fieldToken, indent);
                }
            }
        }
        return sb;
    }

    private void generatePrimitiveProperty(StringBuilder sb, String containingClassName, String propertyName, Token propertyToken, Token encodingToken, String indent) {
        this.generatePrimitiveFieldMetaData(sb, propertyName, encodingToken, indent);
        if (encodingToken.isConstantEncoding()) {
            this.generateConstPropertyMethods(sb, propertyName, encodingToken, indent);
        } else {
            this.generatePrimitivePropertyMethods(sb, containingClassName, propertyName, propertyToken, encodingToken, indent);
        }
    }

    private void generatePrimitivePropertyMethods(StringBuilder sb, String containingClassName, String propertyName, Token propertyToken, Token encodingToken, String indent) {
        int arrayLength = encodingToken.arrayLength();
        if (arrayLength == 1) {
            this.generateSingleValueProperty(sb, containingClassName, propertyName, propertyToken, encodingToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayProperty(sb, containingClassName, propertyName, propertyToken, encodingToken, indent);
        }
    }

    private void generatePrimitiveFieldMetaData(StringBuilder sb, String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        PrimitiveType primitiveType = encoding.primitiveType();
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        CharSequence nullValueString = this.generateNullValueLiteral(primitiveType, encoding);
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR %1$s %2$sNullValue() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, nullValueString);
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR %1$s %2$sMinValue() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, CppGenerator.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString()));
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR %1$s %2$sMaxValue() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, CppGenerator.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString()));
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::size_t %1$sEncodingLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, token.encoding().primitiveType().size() * token.arrayLength());
    }

    private CharSequence generateLoadValue(PrimitiveType primitiveType, String offsetStr, ByteOrder byteOrder, String indent) {
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        String byteOrderStr = CppUtil.formatByteOrderEncoding(byteOrder, primitiveType);
        StringBuilder sb = new StringBuilder();
        if (primitiveType == PrimitiveType.FLOAT || primitiveType == PrimitiveType.DOUBLE) {
            String stackUnion = primitiveType == PrimitiveType.FLOAT ? "union sbe_float_as_uint_u" : "union sbe_double_as_uint_u";
            new Formatter(sb).format(indent + "        %1$s val;\n" + indent + "        std::memcpy(&val, m_buffer + m_offset + %2$s, sizeof(%3$s));\n" + indent + "        val.uint_value = %4$s(val.uint_value);\n" + indent + "        return val.fp_value;\n", stackUnion, offsetStr, cppTypeName, byteOrderStr);
        } else {
            new Formatter(sb).format(indent + "        %1$s val;\n" + indent + "        std::memcpy(&val, m_buffer + m_offset + %2$s, sizeof(%1$s));\n" + indent + "        return %3$s(val);\n", cppTypeName, offsetStr, byteOrderStr);
        }
        return sb;
    }

    private CharSequence generateStoreValue(PrimitiveType primitiveType, String valueSuffix, String offsetStr, ByteOrder byteOrder, String indent) {
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        String byteOrderStr = CppUtil.formatByteOrderEncoding(byteOrder, primitiveType);
        StringBuilder sb = new StringBuilder();
        if (primitiveType == PrimitiveType.FLOAT || primitiveType == PrimitiveType.DOUBLE) {
            String stackUnion = primitiveType == PrimitiveType.FLOAT ? "union sbe_float_as_uint_u" : "union sbe_double_as_uint_u";
            new Formatter(sb).format(indent + "        %1$s val%2$s;\n" + indent + "        val%2$s.fp_value = value%2$s;\n" + indent + "        val%2$s.uint_value = %3$s(val%2$s.uint_value);\n" + indent + "        std::memcpy(m_buffer + m_offset + %4$s, &val%2$s, sizeof(%5$s));\n", stackUnion, valueSuffix, byteOrderStr, offsetStr, cppTypeName);
        } else {
            new Formatter(sb).format(indent + "        %1$s val%2$s = %3$s(value%2$s);\n" + indent + "        std::memcpy(m_buffer + m_offset + %4$s, &val%2$s, sizeof(%1$s));\n", cppTypeName, valueSuffix, byteOrderStr, offsetStr);
        }
        return sb;
    }

    private void generateSingleValueProperty(StringBuilder sb, String containingClassName, String propertyName, Token propertyToken, Token encodingToken, String indent) {
        PrimitiveType primitiveType = encodingToken.encoding().primitiveType();
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        int offset = encodingToken.offset();
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s %2$s() const SBE_NOEXCEPT\n" + indent + "    {\n%3$s%4$s" + indent + "    }\n", cppTypeName, propertyName, this.generateFieldNotPresentCondition(propertyToken.version(), encodingToken.encoding(), indent), this.generateLoadValue(primitiveType, Integer.toString(offset), encodingToken.encoding().byteOrder(), indent));
        CharSequence storeValue = this.generateStoreValue(primitiveType, BASE_INDENT, Integer.toString(offset), encodingToken.encoding().byteOrder(), indent);
        new Formatter(sb).format("\n" + indent + "    %1$s &%2$s(const %3$s value) SBE_NOEXCEPT\n" + indent + "    {\n%4$s" + indent + "        return *this;\n" + indent + "    }\n", CppUtil.formatClassName(containingClassName), propertyName, cppTypeName, storeValue);
    }

    private void generateArrayProperty(StringBuilder sb, String containingClassName, String propertyName, Token propertyToken, Token encodingToken, String indent) {
        PrimitiveType primitiveType = encodingToken.encoding().primitiveType();
        String cppTypeName = CppUtil.cppTypeName(primitiveType);
        int offset = encodingToken.offset();
        int arrayLength = encodingToken.arrayLength();
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint64_t %1$sLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, arrayLength);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD const char *%1$s() const SBE_NOEXCEPT\n" + indent + "    {\n%2$s" + indent + "        return m_buffer + m_offset + %3$d;\n" + indent + "    }\n", propertyName, CppGenerator.generateTypeFieldNotPresentCondition(propertyToken.version(), indent), offset);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD char *%1$s() SBE_NOEXCEPT\n" + indent + "    {\n%2$s" + indent + "        return m_buffer + m_offset + %3$d;\n" + indent + "    }\n", propertyName, CppGenerator.generateTypeFieldNotPresentCondition(propertyToken.version(), indent), offset);
        CharSequence loadValue = this.generateLoadValue(primitiveType, String.format("%d + (index * %d)", offset, primitiveType.size()), encodingToken.encoding().byteOrder(), indent);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s %2$s(const std::uint64_t index) const\n" + indent + "    {\n" + indent + "        if (index >= %3$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"index out of range for %2$s [E104]\");\n" + indent + "        }\n\n%4$s%5$s" + indent + "    }\n", cppTypeName, propertyName, arrayLength, this.generateFieldNotPresentCondition(propertyToken.version(), encodingToken.encoding(), indent), loadValue);
        CharSequence storeValue = this.generateStoreValue(primitiveType, BASE_INDENT, String.format("%d + (index * %d)", offset, primitiveType.size()), encodingToken.encoding().byteOrder(), indent);
        new Formatter(sb).format("\n" + indent + "    %1$s &%2$s(const std::uint64_t index, const %3$s value)\n" + indent + "    {\n" + indent + "        if (index >= %4$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"index out of range for %2$s [E105]\");\n" + indent + "        }\n\n%5$s" + indent + "        return *this;\n" + indent + "    }\n", containingClassName, propertyName, cppTypeName, arrayLength, storeValue);
        new Formatter(sb).format("\n" + indent + "    std::uint64_t get%1$s(char *const dst, const std::uint64_t length) const\n" + indent + "    {\n" + indent + "        if (length > %2$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"length too large for get%1$s [E106]\");\n" + indent + "        }\n\n%3$s" + indent + "        std::memcpy(dst, m_buffer + m_offset + %4$d, sizeof(%5$s) * static_cast<std::size_t>(length));\n" + indent + "        return length;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), arrayLength, CppGenerator.generateArrayFieldNotPresentCondition(propertyToken.version(), indent), offset, cppTypeName);
        new Formatter(sb).format("\n" + indent + "    %1$s &put%2$s(const char *const src) SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        std::memcpy(m_buffer + m_offset + %3$d, src, sizeof(%4$s) * %5$d);\n" + indent + "        return *this;\n" + indent + "    }\n", containingClassName, Generators.toUpperFirstChar(propertyName), offset, cppTypeName, arrayLength);
        if (arrayLength > 1 && arrayLength <= 4) {
            int i;
            sb.append("\n").append(indent).append(INDENT).append(containingClassName).append(" &put").append(Generators.toUpperFirstChar(propertyName)).append("(\n");
            for (i = 0; i < arrayLength; ++i) {
                sb.append(indent).append("        ").append("const ").append(cppTypeName).append(" value").append(i);
                if (i >= arrayLength - 1) continue;
                sb.append(",\n");
            }
            sb.append(") SBE_NOEXCEPT\n");
            sb.append(indent).append("    {\n");
            for (i = 0; i < arrayLength; ++i) {
                sb.append(this.generateStoreValue(primitiveType, Integer.toString(i), Integer.toString(offset + i * primitiveType.size()), encodingToken.encoding().byteOrder(), indent));
            }
            sb.append("\n");
            sb.append(indent).append("        return *this;\n");
            sb.append(indent).append("    }\n");
        }
        if (encodingToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD std::string get%1$sAsString() const\n" + indent + "    {\n" + indent + "        const char *buffer = m_buffer + m_offset + %2$d;\n" + indent + "        std::size_t length = 0;\n\n" + indent + "        for (; length < %3$d && *(buffer + length) != '\\0'; ++length);\n" + indent + "        std::string result(buffer, length);\n\n" + indent + "        return result;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), offset, arrayLength);
            this.generateJsonEscapedStringGetter(sb, encodingToken, indent, propertyName);
            new Formatter(sb).format("\n" + indent + "    #if __cplusplus >= 201703L\n" + indent + "    SBE_NODISCARD std::string_view get%1$sAsStringView() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        const char *buffer = m_buffer + m_offset + %2$d;\n" + indent + "        std::size_t length = 0;\n\n" + indent + "        for (; length < %3$d && *(buffer + length) != '\\0'; ++length);\n" + indent + "        std::string_view result(buffer, length);\n\n" + indent + "        return result;\n" + indent + "    }\n" + indent + "    #endif\n", Generators.toUpperFirstChar(propertyName), offset, arrayLength);
            new Formatter(sb).format("\n" + indent + "    #if __cplusplus >= 201703L\n" + indent + "    %1$s &put%2$s(const std::string_view str)\n" + indent + "    {\n" + indent + "        const std::size_t srcLength = str.length();\n" + indent + "        if (srcLength > %4$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"string too large for put%2$s [E106]\");\n" + indent + "        }\n\n" + indent + "        std::memcpy(m_buffer + m_offset + %3$d, str.data(), srcLength);\n" + indent + "        for (std::size_t start = srcLength; start < %4$d; ++start)\n" + indent + "        {\n" + indent + "            m_buffer[m_offset + %3$d + start] = 0;\n" + indent + "        }\n\n" + indent + "        return *this;\n" + indent + "    }\n" + indent + "    #else\n" + indent + "    %1$s &put%2$s(const std::string &str)\n" + indent + "    {\n" + indent + "        const std::size_t srcLength = str.length();\n" + indent + "        if (srcLength > %4$d)\n" + indent + "        {\n" + indent + "            throw std::runtime_error(\"string too large for put%2$s [E106]\");\n" + indent + "        }\n\n" + indent + "        std::memcpy(m_buffer + m_offset + %3$d, str.c_str(), srcLength);\n" + indent + "        for (std::size_t start = srcLength; start < %4$d; ++start)\n" + indent + "        {\n" + indent + "            m_buffer[m_offset + %3$d + start] = 0;\n" + indent + "        }\n\n" + indent + "        return *this;\n" + indent + "    }\n" + indent + "    #endif\n", containingClassName, Generators.toUpperFirstChar(propertyName), offset, arrayLength);
        }
    }

    private void generateJsonEscapedStringGetter(StringBuilder sb, Token token, String indent, String propertyName) {
        new Formatter(sb).format("\n" + indent + "    std::string get%1$sAsJsonEscapedString()\n" + indent + "    {\n%2$s" + indent + "        std::ostringstream oss;\n" + indent + "        std::string s = get%1$sAsString();\n\n" + indent + "        for (const auto c : s)\n" + indent + "        {\n" + indent + "            switch (c)\n" + indent + "            {\n" + indent + "                case '\"': oss << \"\\\\\\\"\"; break;\n" + indent + "                case '\\\\': oss << \"\\\\\\\\\"; break;\n" + indent + "                case '\\b': oss << \"\\\\b\"; break;\n" + indent + "                case '\\f': oss << \"\\\\f\"; break;\n" + indent + "                case '\\n': oss << \"\\\\n\"; break;\n" + indent + "                case '\\r': oss << \"\\\\r\"; break;\n" + indent + "                case '\\t': oss << \"\\\\t\"; break;\n\n" + indent + "                default:\n" + indent + "                    if ('\\x00' <= c && c <= '\\x1f')\n" + indent + "                    {\n" + indent + "                        oss << \"\\\\u\" << std::hex << std::setw(4)\n" + indent + "                            << std::setfill('0') << (int)(c);\n" + indent + "                    }\n" + indent + "                    else\n" + indent + "                    {\n" + indent + "                        oss << c;\n" + indent + "                    }\n" + indent + "            }\n" + indent + "        }\n\n" + indent + "        return oss.str();\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), CppGenerator.generateStringNotPresentCondition(token.version(), indent));
    }

    private void generateConstPropertyMethods(StringBuilder sb, String propertyName, Token token, String indent) {
        String cppTypeName = CppUtil.cppTypeName(token.encoding().primitiveType());
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR %1$s %2$s() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cppTypeName, propertyName, CppGenerator.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
            return;
        }
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        StringBuilder values = new StringBuilder();
        for (byte b : constantValue) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint64_t %1$sLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, constantValue.length);
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD const char *%1$s() const\n" + indent + "    {\n" + indent + "        static const std::uint8_t %1$sValues[] = { %2$s, 0 };\n\n" + indent + "        return (const char *)%1$sValues;\n" + indent + "    }\n", propertyName, values);
        sb.append(String.format("\n" + indent + "    SBE_NODISCARD %1$s %2$s(const std::uint64_t index) const\n" + indent + "    {\n" + indent + "        static const std::uint8_t %2$sValues[] = { %3$s, 0 };\n\n" + indent + "        return (char)%2$sValues[index];\n" + indent + "    }\n", cppTypeName, propertyName, values));
        new Formatter(sb).format("\n" + indent + "    std::uint64_t get%1$s(char *dst, const std::uint64_t length) const\n" + indent + "    {\n" + indent + "        static std::uint8_t %2$sValues[] = { %3$s };\n" + indent + "        std::uint64_t bytesToCopy = length < sizeof(%2$sValues) ? length : sizeof(%2$sValues);\n\n" + indent + "        std::memcpy(dst, %2$sValues, static_cast<std::size_t>(bytesToCopy));\n" + indent + "        return bytesToCopy;\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), propertyName, values);
        new Formatter(sb).format("\n" + indent + "    std::string get%1$sAsString() const\n" + indent + "    {\n" + indent + "        static const std::uint8_t %1$sValues[] = { %2$s };\n\n" + indent + "        return std::string((const char *)%1$sValues, %3$s);\n" + indent + "    }\n", Generators.toUpperFirstChar(propertyName), values, constantValue.length);
        this.generateJsonEscapedStringGetter(sb, token, indent, propertyName);
    }

    private CharSequence generateFixedFlyweightCode(String className, int size) {
        String schemaIdType = CppUtil.cppTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CppUtil.cppTypeName(this.ir.headerStructure().schemaVersionType());
        return String.format("private:\n    char *m_buffer = nullptr;\n    std::uint64_t m_bufferLength = 0;\n    std::uint64_t m_offset = 0;\n    std::uint64_t m_actingVersion = 0;\n\npublic:\n    enum MetaAttribute\n    {\n        EPOCH, TIME_UNIT, SEMANTIC_TYPE, PRESENCE\n    };\n\n    union sbe_float_as_uint_u\n    {\n        float fp_value;\n        std::uint32_t uint_value;\n    };\n\n    union sbe_double_as_uint_u\n    {\n        double fp_value;\n        std::uint64_t uint_value;\n    };\n\n    %1$s() = default;\n\n    %1$s(\n        char *buffer,\n        const std::uint64_t offset,\n        const std::uint64_t bufferLength,\n        const std::uint64_t actingVersion) :\n        m_buffer(buffer),\n        m_bufferLength(bufferLength),\n        m_offset(offset),\n        m_actingVersion(actingVersion)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT(((m_offset + %2$s) > m_bufferLength), false))\n        {\n            throw std::runtime_error(\"buffer too short for flyweight [E107]\");\n        }\n    }\n\n    %1$s(\n        char *buffer,\n        const std::uint64_t bufferLength,\n        const std::uint64_t actingVersion) :\n        %1$s(buffer, 0, bufferLength, actingVersion)\n    {\n    }\n\n    %1$s(\n        char *buffer,\n        const std::uint64_t bufferLength) :\n        %1$s(buffer, 0, bufferLength, sbeSchemaVersion())\n    {\n    }\n\n    %1$s &wrap(\n        char *buffer,\n        const std::uint64_t offset,\n        const std::uint64_t actingVersion,\n        const std::uint64_t bufferLength)\n    {\n        return *this = %1$s(buffer, offset, bufferLength, actingVersion);\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR std::uint64_t encodedLength() SBE_NOEXCEPT\n    {\n        return %2$s;\n    }\n\n    SBE_NODISCARD std::uint64_t offset() const SBE_NOEXCEPT\n    {\n        return m_offset;\n    }\n\n    SBE_NODISCARD const char *buffer() const SBE_NOEXCEPT\n    {\n        return m_buffer;\n    }\n\n    SBE_NODISCARD char *buffer() SBE_NOEXCEPT\n    {\n        return m_buffer;\n    }\n\n    SBE_NODISCARD std::uint64_t bufferLength() const SBE_NOEXCEPT\n    {\n        return m_bufferLength;\n    }\n\n    SBE_NODISCARD std::uint64_t actingVersion() const SBE_NOEXCEPT\n    {\n        return m_actingVersion;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR %3$s sbeSchemaId() SBE_NOEXCEPT\n    {\n        return %4$s;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR %5$s sbeSchemaVersion() SBE_NOEXCEPT\n    {\n        return %6$s;\n    }\n", className, size, schemaIdType, CppGenerator.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, CppGenerator.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())));
    }

    private static CharSequence generateConstructorsAndOperators(String className) {
        return String.format("    %1$s() = default;\n\n    %1$s(\n        char *buffer,\n        const std::uint64_t offset,\n        const std::uint64_t bufferLength,\n        const std::uint64_t actingBlockLength,\n        const std::uint64_t actingVersion) :\n        m_buffer(buffer),\n        m_bufferLength(bufferLength),\n        m_offset(offset),\n        m_position(sbeCheckPosition(offset + actingBlockLength)),\n        m_actingBlockLength(actingBlockLength),\n        m_actingVersion(actingVersion)\n    {\n    }\n\n    %1$s(char *buffer, const std::uint64_t bufferLength) :\n        %1$s(buffer, 0, bufferLength, sbeBlockLength(), sbeSchemaVersion())\n    {\n    }\n\n    %1$s(\n        char *buffer,\n        const std::uint64_t bufferLength,\n        const std::uint64_t actingBlockLength,\n        const std::uint64_t actingVersion) :\n        %1$s(buffer, 0, bufferLength, actingBlockLength, actingVersion)\n    {\n    }\n\n", className);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token) {
        String blockLengthType = CppUtil.cppTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = CppUtil.cppTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = CppUtil.cppTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CppUtil.cppTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        String headerType = this.ir.headerStructure().tokens().get(0).name();
        return String.format("private:\n    char *m_buffer = nullptr;\n    std::uint64_t m_bufferLength = 0;\n    std::uint64_t m_offset = 0;\n    std::uint64_t m_position = 0;\n    std::uint64_t m_actingBlockLength = 0;\n    std::uint64_t m_actingVersion = 0;\n\n    inline std::uint64_t *sbePositionPtr() SBE_NOEXCEPT\n    {\n        return &m_position;\n    }\n\npublic:\n    static const %1$s SBE_BLOCK_LENGTH = %2$s;\n    static const %3$s SBE_TEMPLATE_ID = %4$s;\n    static const %5$s SBE_SCHEMA_ID = %6$s;\n    static const %7$s SBE_SCHEMA_VERSION = %8$s;\n\n    enum MetaAttribute\n    {\n        EPOCH, TIME_UNIT, SEMANTIC_TYPE, PRESENCE\n    };\n\n    union sbe_float_as_uint_u\n    {\n        float fp_value;\n        std::uint32_t uint_value;\n    };\n\n    union sbe_double_as_uint_u\n    {\n        double fp_value;\n        std::uint64_t uint_value;\n    };\n\n    using messageHeader = %12$s;\n\n%11$s    SBE_NODISCARD static SBE_CONSTEXPR %1$s sbeBlockLength() SBE_NOEXCEPT\n    {\n        return %2$s;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR std::uint64_t sbeBlockAndHeaderLength() SBE_NOEXCEPT\n    {\n        return messageHeader::encodedLength() + sbeBlockLength();\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR %3$s sbeTemplateId() SBE_NOEXCEPT\n    {\n        return %4$s;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR %5$s sbeSchemaId() SBE_NOEXCEPT\n    {\n        return %6$s;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR %7$s sbeSchemaVersion() SBE_NOEXCEPT\n    {\n        return %8$s;\n    }\n\n    SBE_NODISCARD static SBE_CONSTEXPR const char *sbeSemanticType() SBE_NOEXCEPT\n    {\n        return \"%9$s\";\n    }\n\n    SBE_NODISCARD std::uint64_t offset() const SBE_NOEXCEPT\n    {\n        return m_offset;\n    }\n\n    %10$s &wrapForEncode(char *buffer, const std::uint64_t offset, const std::uint64_t bufferLength)\n    {\n        return *this = %10$s(buffer, offset, bufferLength, sbeBlockLength(), sbeSchemaVersion());\n    }\n\n    %10$s &wrapAndApplyHeader(char *buffer, const std::uint64_t offset, const std::uint64_t bufferLength)\n    {\n        messageHeader hdr(buffer, offset, bufferLength, sbeSchemaVersion());\n\n        hdr\n            .blockLength(sbeBlockLength())\n            .templateId(sbeTemplateId())\n            .schemaId(sbeSchemaId())\n            .version(sbeSchemaVersion());\n\n        return *this = %10$s(\n            buffer,\n            offset + messageHeader::encodedLength(),\n            bufferLength,\n            sbeBlockLength(),\n            sbeSchemaVersion());\n    }\n\n    %10$s &wrapForDecode(\n        char *buffer,\n        const std::uint64_t offset,\n        const std::uint64_t actingBlockLength,\n        const std::uint64_t actingVersion,\n        const std::uint64_t bufferLength)\n    {\n        return *this = %10$s(buffer, offset, bufferLength, actingBlockLength, actingVersion);\n    }\n\n    SBE_NODISCARD std::uint64_t sbePosition() const SBE_NOEXCEPT\n    {\n        return m_position;\n    }\n\n    // NOLINTNEXTLINE(readability-convert-member-functions-to-static)\n    std::uint64_t sbeCheckPosition(const std::uint64_t position)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT((position > m_bufferLength), false))\n        {\n            throw std::runtime_error(\"buffer too short [E100]\");\n        }\n        return position;\n    }\n\n    void sbePosition(const std::uint64_t position)\n    {\n        m_position = sbeCheckPosition(position);\n    }\n\n    SBE_NODISCARD std::uint64_t encodedLength() const SBE_NOEXCEPT\n    {\n        return sbePosition() - m_offset;\n    }\n\n    SBE_NODISCARD std::uint64_t decodeLength() const\n    {\n        %10$s skipper(m_buffer, m_offset, m_bufferLength, sbeBlockLength(), m_actingVersion);\n        skipper.skip();\n        return skipper.encodedLength();\n    }\n\n    SBE_NODISCARD const char *buffer() const SBE_NOEXCEPT\n    {\n        return m_buffer;\n    }\n\n    SBE_NODISCARD char *buffer() SBE_NOEXCEPT\n    {\n        return m_buffer;\n    }\n\n    SBE_NODISCARD std::uint64_t bufferLength() const SBE_NOEXCEPT\n    {\n        return m_bufferLength;\n    }\n\n    SBE_NODISCARD std::uint64_t actingVersion() const SBE_NOEXCEPT\n    {\n        return m_actingVersion;\n    }\n", blockLengthType, CppGenerator.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, CppGenerator.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, CppGenerator.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, CppGenerator.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), semanticType, className, CppGenerator.generateConstructorsAndOperators(className), CppUtil.formatClassName(headerType));
    }

    private void generateFields(StringBuilder sb, String containingClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = CppUtil.formatPropertyName(signalToken.name());
            CppGenerator.generateFieldMetaAttributeMethod(sb, signalToken, indent);
            this.generateFieldCommonMethods(indent, sb, signalToken, encodingToken, propertyName);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(sb, containingClassName, propertyName, signalToken, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(sb, containingClassName, signalToken, propertyName, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_SET: {
                    CppGenerator.generateBitsetProperty(sb, propertyName, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    CppGenerator.generateCompositeProperty(sb, propertyName, encodingToken, indent);
                }
            }
        }
    }

    private void generateFieldCommonMethods(String indent, StringBuilder sb, Token fieldToken, Token encodingToken, String propertyName) {
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::uint16_t %1$sId() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, fieldToken.id());
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR std::uint64_t %1$sSinceVersion() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n" + indent + "    SBE_NODISCARD bool %1$sInActingVersion() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic push\n" + indent + "#pragma clang diagnostic ignored \"-Wtautological-compare\"\n" + indent + "#endif\n" + indent + "        return m_actingVersion >= %1$sSinceVersion();\n" + indent + "#if defined(__clang__)\n" + indent + "#pragma clang diagnostic pop\n" + indent + "#endif\n" + indent + "    }\n", propertyName, fieldToken.version());
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR std::size_t %1$sEncodingOffset() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, encodingToken.offset());
    }

    private static void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append("\n").append(indent).append("    SBE_NODISCARD static const char *").append(token.name()).append("MetaAttribute(const MetaAttribute metaAttribute) SBE_NOEXCEPT\n").append(indent).append("    {\n").append(indent).append("        switch (metaAttribute)\n").append(indent).append("        {\n");
        if (!Strings.isEmpty(epoch)) {
            sb.append(indent).append("            case MetaAttribute::EPOCH: return \"").append(epoch).append("\";\n");
        }
        if (!Strings.isEmpty(timeUnit)) {
            sb.append(indent).append("            case MetaAttribute::TIME_UNIT: return \"").append(timeUnit).append("\";\n");
        }
        if (!Strings.isEmpty(semanticType)) {
            sb.append(indent).append("            case MetaAttribute::SEMANTIC_TYPE: return \"").append(semanticType).append("\";\n");
        }
        sb.append(indent).append("            case MetaAttribute::PRESENCE: return \"").append(encoding.presence().toString().toLowerCase()).append("\";\n").append(indent).append("            default: return \"\";\n").append(indent).append("        }\n").append(indent).append("    }\n");
    }

    private static CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (m_actingVersion < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s::NULL_VALUE;\n" + indent + "        }\n\n", sinceVersion, enumName);
    }

    private void generateEnumProperty(StringBuilder sb, String containingClassName, Token fieldToken, String propertyName, Token encodingToken, String indent) {
        String enumName = CppUtil.formatClassName(encodingToken.applicableTypeName());
        PrimitiveType primitiveType = encodingToken.encoding().primitiveType();
        String typeName = CppUtil.cppTypeName(primitiveType);
        int offset = encodingToken.offset();
        new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR std::size_t %1$sEncodingLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, fieldToken.encodedLength());
        if (fieldToken.isConstantEncoding()) {
            String constValue = fieldToken.encoding().constValue().toString();
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD static SBE_CONSTEXPR %1$s::Value %2$sConstValue() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %1$s::Value::%3$s;\n" + indent + "    }\n", enumName, propertyName, constValue.substring(constValue.indexOf(".") + 1));
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s::Value %2$s() const\n" + indent + "    {\n%3$s" + indent + "        return %1$s::Value::%4$s;\n" + indent + "    }\n", enumName, propertyName, CppGenerator.generateEnumFieldNotPresentCondition(fieldToken.version(), enumName, indent), constValue.substring(constValue.indexOf(".") + 1));
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s %2$sRaw() const SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return static_cast<%1$s>(%3$s::Value::%4$s);\n" + indent + "    }\n", typeName, propertyName, enumName, constValue.substring(constValue.indexOf(".") + 1));
        } else {
            String offsetStr = Integer.toString(offset);
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s %2$sRaw() const SBE_NOEXCEPT\n" + indent + "    {\n%3$s%4$s" + indent + "    }\n", typeName, propertyName, this.generateFieldNotPresentCondition(fieldToken.version(), encodingToken.encoding(), indent), this.generateLoadValue(primitiveType, offsetStr, encodingToken.encoding().byteOrder(), indent));
            new Formatter(sb).format("\n" + indent + "    SBE_NODISCARD %1$s::Value %2$s() const\n" + indent + "    {\n%3$s" + indent + "        %5$s val;\n" + indent + "        std::memcpy(&val, m_buffer + m_offset + %6$d, sizeof(%5$s));\n" + indent + "        return %1$s::get(%4$s(val));\n" + indent + "    }\n", enumName, propertyName, CppGenerator.generateEnumFieldNotPresentCondition(fieldToken.version(), enumName, indent), CppUtil.formatByteOrderEncoding(encodingToken.encoding().byteOrder(), primitiveType), typeName, offset);
            new Formatter(sb).format("\n" + indent + "    %1$s &%2$s(const %3$s::Value value) SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        %4$s val = %6$s(value);\n" + indent + "        std::memcpy(m_buffer + m_offset + %5$d, &val, sizeof(%4$s));\n" + indent + "        return *this;\n" + indent + "    }\n", CppUtil.formatClassName(containingClassName), propertyName, enumName, typeName, offset, CppUtil.formatByteOrderEncoding(encodingToken.encoding().byteOrder(), primitiveType));
        }
    }

    private static void generateBitsetProperty(StringBuilder sb, String propertyName, Token token, String indent) {
        String bitsetName = CppUtil.formatClassName(token.applicableTypeName());
        int offset = token.offset();
        new Formatter(sb).format("\n" + indent + "private:\n" + indent + "    %1$s m_%2$s;\n\n" + indent + "public:\n", bitsetName, propertyName);
        new Formatter(sb).format(indent + "    SBE_NODISCARD %1$s &%2$s()\n" + indent + "    {\n" + indent + "        m_%2$s.wrap(m_buffer, m_offset + %3$d, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", bitsetName, propertyName, offset);
        new Formatter(sb).format("\n" + indent + "    static SBE_CONSTEXPR std::size_t %1$sEncodingLength() SBE_NOEXCEPT\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n", propertyName, token.encoding().primitiveType().size());
    }

    private static void generateCompositeProperty(StringBuilder sb, String propertyName, Token token, String indent) {
        String compositeName = CppUtil.formatClassName(token.applicableTypeName());
        new Formatter(sb).format("\nprivate:\n" + indent + "    %1$s m_%2$s;\n\npublic:\n", compositeName, propertyName);
        new Formatter(sb).format(indent + "    SBE_NODISCARD %1$s &%2$s()\n" + indent + "    {\n" + indent + "        m_%2$s.wrap(m_buffer, m_offset + %3$d, m_actingVersion, m_bufferLength);\n" + indent + "        return m_%2$s;\n" + indent + "    }\n", compositeName, propertyName, token.offset());
    }

    private CharSequence generateNullValueLiteral(PrimitiveType primitiveType, Encoding encoding) {
        if (null == encoding.nullValue()) {
            switch (primitiveType) {
                case CHAR: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                case INT8: {
                    return "SBE_NULLVALUE_INT8";
                }
                case INT16: {
                    return "SBE_NULLVALUE_INT16";
                }
                case INT32: {
                    return "SBE_NULLVALUE_INT32";
                }
                case INT64: {
                    return "SBE_NULLVALUE_INT64";
                }
                case UINT8: {
                    return "SBE_NULLVALUE_UINT8";
                }
                case UINT16: {
                    return "SBE_NULLVALUE_UINT16";
                }
                case UINT32: {
                    return "SBE_NULLVALUE_UINT32";
                }
                case UINT64: {
                    return "SBE_NULLVALUE_UINT64";
                }
            }
        }
        return CppGenerator.generateLiteral(primitiveType, encoding.applicableNullValue().toString());
    }

    private static CharSequence generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        switch (type) {
            case CHAR: 
            case INT8: 
            case INT16: 
            case UINT8: 
            case UINT16: {
                literal = "static_cast<" + CppUtil.cppTypeName(type) + ">(" + value + ")";
                break;
            }
            case UINT32: {
                literal = "UINT32_C(0x" + Integer.toHexString((int)Long.parseLong(value)) + ")";
                break;
            }
            case INT32: {
                long intValue = Long.parseLong(value);
                if (intValue == Integer.MIN_VALUE) {
                    literal = "INT32_MIN";
                    break;
                }
                literal = "INT32_C(" + value + ")";
                break;
            }
            case FLOAT: {
                literal = value.endsWith("NaN") ? "SBE_FLOAT_NAN" : value + "f";
                break;
            }
            case INT64: {
                long longValue = Long.parseLong(value);
                if (longValue == Long.MIN_VALUE) {
                    literal = "INT64_MIN";
                    break;
                }
                literal = "INT64_C(" + value + ")";
                break;
            }
            case UINT64: {
                literal = "UINT64_C(0x" + Long.toHexString(Long.parseLong(value)) + ")";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "SBE_DOUBLE_NAN" : value;
            }
        }
        return literal;
    }

    private void generateDisplay(StringBuilder sb, String name, List<Token> fields, List<Token> groups, List<Token> varData) {
        new Formatter(sb).format("\ntemplate<typename CharT, typename Traits>\nfriend std::basic_ostream<CharT, Traits> & operator << (\n    std::basic_ostream<CharT, Traits> &builder, %1$s _writer)\n{\n    %1$s writer(\n        _writer.m_buffer,\n        _writer.m_offset,\n        _writer.m_bufferLength,\n        _writer.m_actingBlockLength,\n        _writer.m_actingVersion);\n\n    builder << '{';\n    builder << R\"(\"Name\": \"%1$s\", )\";\n    builder << R\"(\"sbeTemplateId\": )\";\n    builder << writer.sbeTemplateId();\n    builder << \", \";\n\n%2$s    builder << '}';\n\n    return builder;\n}\n", CppUtil.formatClassName(name), this.appendDisplay(fields, groups, varData, INDENT));
    }

    private CharSequence generateGroupDisplay(String name, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        return String.format("\n" + indent + "template<typename CharT, typename Traits>\n" + indent + "friend std::basic_ostream<CharT, Traits> & operator << (\n" + indent + "    std::basic_ostream<CharT, Traits> &builder, %1$s writer)\n" + indent + "{\n" + indent + "    builder << '{';\n%2$s" + indent + "    builder << '}';\n\n" + indent + "    return builder;\n" + indent + "}\n", CppUtil.formatClassName(name), this.appendDisplay(fields, groups, varData, indent + INDENT));
    }

    private CharSequence generateCompositeDisplay(String name, List<Token> tokens) {
        return String.format("\ntemplate<typename CharT, typename Traits>\nfriend std::basic_ostream<CharT, Traits> & operator << (\n    std::basic_ostream<CharT, Traits> &builder, %1$s writer)\n{\n    builder << '{';\n%2$s    builder << '}';\n\n    return builder;\n}\n\n", CppUtil.formatClassName(name), this.appendDisplay(tokens, new ArrayList<Token>(), new ArrayList<Token>(), INDENT));
    }

    private CharSequence appendDisplay(List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        Token varDataToken;
        int i;
        Token fieldToken;
        StringBuilder sb = new StringBuilder();
        boolean[] atLeastOne = new boolean[]{false};
        int size = fields.size();
        for (i = 0; i < size; i += fieldToken.componentTokenCount()) {
            fieldToken = fields.get(i);
            Token encodingToken = fields.get(fieldToken.signal() == Signal.BEGIN_FIELD ? i + 1 : i);
            this.writeTokenDisplay(sb, fieldToken.name(), encodingToken, atLeastOne, indent);
        }
        size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            if (atLeastOne[0]) {
                sb.append(indent).append("builder << \", \";\n");
            }
            atLeastOne[0] = true;
            new Formatter(sb).format(indent + "{\n" + indent + "    bool atLeastOne = false;\n" + indent + "    builder << R\"(\"%3$s\": [)\";\n" + indent + "    writer.%2$s().forEach(\n" + indent + "        [&](%1$s &%2$s)\n" + indent + "        {\n" + indent + "            if (atLeastOne)\n" + indent + "            {\n" + indent + "                builder << \", \";\n" + indent + "            }\n" + indent + "            atLeastOne = true;\n" + indent + "            builder << %2$s;\n" + indent + "        });\n" + indent + "    builder << ']';\n" + indent + "}\n\n", CppUtil.formatClassName(groupToken.name()), CppUtil.formatPropertyName(groupToken.name()), groupToken.name());
            i = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            if (atLeastOne[0]) {
                sb.append(indent).append("builder << \", \";\n");
            }
            atLeastOne[0] = true;
            String characterEncoding = varData.get(i + 3).encoding().characterEncoding();
            sb.append(indent).append("builder << R\"(\"").append(varDataToken.name()).append("\": )\";\n");
            if (null == characterEncoding) {
                String skipFunction = "writer.skip" + Generators.toUpperFirstChar(varDataToken.name()) + "()";
                sb.append(indent).append("builder << '\"' <<\n").append(indent).append(INDENT).append(skipFunction).append(" << \" bytes of raw data\\\"\";\n");
                continue;
            }
            String getAsStringFunction = "writer.get" + Generators.toUpperFirstChar(varDataToken.name()) + "AsJsonEscapedString().c_str()";
            sb.append(indent).append("builder << '\"' <<\n").append(indent).append(INDENT).append(getAsStringFunction).append(" << '\"';\n\n");
        }
        return sb;
    }

    private void writeTokenDisplay(StringBuilder sb, String fieldTokenName, Token typeToken, boolean[] atLeastOne, String indent) {
        if (typeToken.encodedLength() <= 0 || typeToken.isConstantEncoding()) {
            return;
        }
        if (atLeastOne[0]) {
            sb.append(indent).append("builder << \", \";\n");
        } else {
            atLeastOne[0] = true;
        }
        sb.append(indent).append("builder << R\"(\"").append(fieldTokenName).append("\": )\";\n");
        String fieldName = "writer." + CppUtil.formatPropertyName(fieldTokenName);
        switch (typeToken.signal()) {
            case ENCODING: {
                if (typeToken.arrayLength() > 1) {
                    if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                        String getAsStringFunction = "writer.get" + Generators.toUpperFirstChar(fieldTokenName) + "AsJsonEscapedString().c_str()";
                        sb.append(indent).append("builder << '\"' <<\n").append(indent).append(INDENT).append(getAsStringFunction).append(" << '\"';\n");
                        break;
                    }
                    sb.append(indent + "builder << '[';\n" + indent + "for (std::size_t i = 0, length = " + fieldName + "Length(); i < length; i++)\n" + indent + "{\n" + indent + "    if (i)\n" + indent + "    {\n" + indent + "        builder << ',';\n" + indent + "    }\n" + indent + "    builder << +" + fieldName + "(i);\n" + indent + "}\n" + indent + "builder << ']';\n");
                    break;
                }
                if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                    sb.append(indent + "if (std::isprint(" + fieldName + "()))\n" + indent + "{\n" + indent + "    builder << '\"' << (char)" + fieldName + "() << '\"';\n" + indent + "}\n" + indent + "else\n" + indent + "{\n" + indent + "    builder << (int)" + fieldName + "();\n" + indent + "}\n");
                    break;
                }
                sb.append(indent).append("builder << +").append(fieldName).append("();\n");
                break;
            }
            case BEGIN_ENUM: {
                sb.append(indent).append("builder << '\"' << ").append(fieldName).append("() << '\"';\n");
                break;
            }
            case BEGIN_SET: 
            case BEGIN_COMPOSITE: {
                sb.append(indent).append("builder << ").append(fieldName).append("();\n");
            }
        }
        sb.append('\n');
    }

    private CharSequence generateChoicesDisplay(String name, List<Token> tokens) {
        String indent = INDENT;
        StringBuilder sb = new StringBuilder();
        ArrayList<Token> choiceTokens = new ArrayList<Token>();
        GenerationUtil.collect(Signal.CHOICE, tokens, 0, choiceTokens);
        new Formatter(sb).format("\n    template<typename CharT, typename Traits>\n    friend std::basic_ostream<CharT, Traits> & operator << (\n        std::basic_ostream<CharT, Traits> &builder, %1$s writer)\n    {\n        builder << '[';\n", name);
        if (choiceTokens.size() > 1) {
            sb.append("        bool atLeastOne = false;\n");
        }
        int size = choiceTokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = (Token)choiceTokens.get(i);
            String choiceName = "writer." + CppUtil.formatPropertyName(token.name());
            sb.append("        if (").append(choiceName).append("())\n").append(INDENT).append("    {\n");
            if (i > 0) {
                sb.append("            if (atLeastOne)\n            {\n                builder << \",\";\n            }\n");
            }
            sb.append("            builder << R\"(\"").append(CppUtil.formatPropertyName(token.name())).append("\")\";\n");
            if (i < size - 1) {
                sb.append("            atLeastOne = true;\n");
            }
            sb.append("        }\n");
        }
        sb.append("        builder << ']';\n        return builder;\n    }\n");
        return sb;
    }

    private CharSequence generateEnumDisplay(List<Token> tokens, Token encodingToken) {
        String enumName = CppUtil.formatClassName(encodingToken.applicableTypeName());
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format("\n    static const char *c_str(const %1$s::Value value)\n    {\n        switch (value)\n        {\n", enumName);
        for (Token token : tokens) {
            new Formatter(sb).format("            case %1$s: return \"%1$s\";\n", token.name());
        }
        sb.append("            case NULL_VALUE: return \"NULL_VALUE\";\n").append("        }\n\n");
        if (this.shouldDecodeUnknownEnumValues) {
            sb.append("        return \"SBE_UNKNOWN\";\n").append("    }\n\n");
        } else {
            new Formatter(sb).format("        throw std::runtime_error(\"unknown value for enum %1$s [E103]:\");\n    }\n\n", enumName);
        }
        new Formatter(sb).format("    template<typename CharT, typename Traits>\n    friend std::basic_ostream<CharT, Traits> & operator << (\n        std::basic_ostream<CharT, Traits> &os, %1$s::Value m)\n    {\n        return os << %1$s::c_str(m);\n    }\n", enumName);
        return sb;
    }

    private Object[] generateMessageLengthArgs(List<Token> groups, List<Token> varData, String indent, boolean withName) {
        Token varDataToken;
        int i;
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            List<Token> thisGroup;
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            int endSignal = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
            String groupName = CppUtil.formatPropertyName(groupToken.name());
            if (count > 0) {
                sb.append(",\n").append(indent);
            }
            if (this.isMessageConstLength(thisGroup = groups.subList(i, endSignal + 1))) {
                sb.append("std::size_t");
                if (withName) {
                    sb.append(" ").append(groupName).append("Length = 0");
                }
            } else {
                sb.append("const std::vector<std::tuple<");
                sb.append(this.generateMessageLengthArgs(thisGroup, indent + INDENT, false)[0]);
                sb.append(">> &");
                if (withName) {
                    sb.append(groupName).append("ItemLengths = {}");
                }
            }
            ++count;
            i = endSignal;
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            if (count > 0) {
                sb.append(",\n").append(indent);
            }
            sb.append("std::size_t");
            if (withName) {
                sb.append(" ").append(CppUtil.formatPropertyName(varDataToken.name())).append("Length = 0");
            }
            ++count;
        }
        CharSequence result = sb;
        if (count > 1) {
            result = "\n" + indent + result;
        }
        return new Object[]{result, count};
    }

    private Object[] generateMessageLengthArgs(List<Token> tokens, String indent, boolean withName) {
        int i = 0;
        Token groupToken = tokens.get(i);
        if (groupToken.signal() != Signal.BEGIN_GROUP) {
            throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
        }
        int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
        i += groupHeaderTokenCount;
        ArrayList<Token> fields = new ArrayList<Token>();
        i = GenerationUtil.collectFields(tokens, i, fields);
        ArrayList<Token> groups = new ArrayList<Token>();
        i = GenerationUtil.collectGroups(tokens, i, groups);
        ArrayList<Token> varData = new ArrayList<Token>();
        GenerationUtil.collectVarData(tokens, i, varData);
        return this.generateMessageLengthArgs(groups, varData, indent, withName);
    }

    private boolean isMessageConstLength(List<Token> tokens) {
        Integer count = (Integer)this.generateMessageLengthArgs(tokens, BASE_INDENT, false)[1];
        return count == 0;
    }

    private CharSequence generateMessageLengthCallPre17Helper(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        Integer count = (Integer)this.generateMessageLengthArgs(tokens, BASE_INDENT, false)[1];
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("std::get<").append(i).append(">(e)");
        }
        return sb;
    }

    private CharSequence generateMessageLength(List<Token> groups, List<Token> varData, String indent) {
        Token varDataToken;
        int i;
        StringBuilder sbEncode = new StringBuilder();
        StringBuilder sbSkip = new StringBuilder();
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            int endSignal = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
            List<Token> thisGroup = groups.subList(i, endSignal + 1);
            Token numInGroupToken = Generators.findFirst("numInGroup", groups, i);
            long minCount = numInGroupToken.encoding().applicableMinValue().longValue();
            long maxCount = numInGroupToken.encoding().applicableMaxValue().longValue();
            String countName = CppUtil.formatPropertyName(groupToken.name()) + (this.isMessageConstLength(thisGroup) ? "Length" : "ItemLengths.size()");
            String minCheck = minCount > 0L ? countName + " < " + minCount + "LL || " : BASE_INDENT;
            String maxCheck = countName + " > " + maxCount + "LL";
            new Formatter(sbEncode).format("\n" + indent + "    length += %1$s::sbeHeaderSize();\n", CppUtil.formatClassName(groupToken.name()));
            if (this.isMessageConstLength(thisGroup)) {
                new Formatter(sbEncode).format(indent + "    if (%3$s%4$s)\n" + indent + "    {\n" + indent + "        throw std::runtime_error(\"%5$s outside of allowed range [E110]\");\n" + indent + "    }\n" + indent + "    length += %1$sLength *%2$s::sbeBlockLength();\n", CppUtil.formatPropertyName(groupToken.name()), CppUtil.formatClassName(groupToken.name()), minCheck, maxCheck, countName);
            } else {
                new Formatter(sbEncode).format(indent + "    if (%3$s%4$s)\n" + indent + "    {\n" + indent + "        throw std::runtime_error(\"%5$s outside of allowed range [E110]\");\n" + indent + "    }\n\n" + indent + "    for (const auto &e: %1$sItemLengths)\n" + indent + "    {\n" + indent + "        #if __cplusplus >= 201703L\n" + indent + "        length += std::apply(%2$s::computeLength, e);\n" + indent + "        #else\n" + indent + "        length += %2$s::computeLength(%6$s);\n" + indent + "        #endif\n" + indent + "    }\n", CppUtil.formatPropertyName(groupToken.name()), CppUtil.formatClassName(groupToken.name()), minCheck, maxCheck, countName, this.generateMessageLengthCallPre17Helper(thisGroup));
            }
            new Formatter(sbSkip).format(indent + "    %2$s().forEach([](%1$s &e){ e.skip(); });\n", CppUtil.formatClassName(groupToken.name()), CppUtil.formatPropertyName(groupToken.name()));
            i = endSignal;
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            Token lengthToken = Generators.findFirst("length", varData, i);
            new Formatter(sbEncode).format("\n" + indent + "    length += %1$sHeaderLength();\n" + indent + "    if (%1$sLength > %2$dLL)\n" + indent + "    {\n" + indent + "        throw std::runtime_error(\"%1$sLength too long for length type [E109]\");\n" + indent + "    }\n" + indent + "    length += %1$sLength;\n", CppUtil.formatPropertyName(varDataToken.name()), lengthToken.encoding().applicableMaxValue().longValue());
            new Formatter(sbSkip).format(indent + "    skip%1$s();\n", Generators.toUpperFirstChar(varDataToken.name()));
        }
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format("\n" + indent + "void skip()\n" + indent + "{\n" + sbSkip + indent + "}\n\n" + indent + "SBE_NODISCARD static SBE_CONSTEXPR bool isConstLength() SBE_NOEXCEPT\n" + indent + "{\n" + indent + "    return " + (groups.isEmpty() && varData.isEmpty()) + ";\n" + indent + "}\n\n" + indent + "SBE_NODISCARD static std::size_t computeLength(%1$s)\n" + indent + "{\n#if defined(__GNUG__) && !defined(__clang__)\n#pragma GCC diagnostic push\n#pragma GCC diagnostic ignored \"-Wtype-limits\"\n#endif\n" + indent + "    std::size_t length = sbeBlockLength();\n" + sbEncode + "\n" + indent + "    return length;\n#if defined(__GNUG__) && !defined(__clang__)\n#pragma GCC diagnostic pop\n#endif\n" + indent + "}\n", this.generateMessageLengthArgs(groups, varData, indent + INDENT, true)[0]);
        return sb;
    }
}

