/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.agrona.collections.ObjectHashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.ErrorHandler;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;

public class XmlSchemaParser {
    public static final String ERROR_HANDLER_KEY = "SbeErrorHandler";
    public static final String TYPE_XPATH_EXPR = "/*[local-name() = 'messageSchema']/types/type";
    public static final String COMPOSITE_XPATH_EXPR = "/*[local-name() = 'messageSchema']/types/composite";
    public static final String ENUM_XPATH_EXPR = "/*[local-name() = 'messageSchema']/types/enum";
    public static final String SET_XPATH_EXPR = "/*[local-name() = 'messageSchema']/types/set";
    public static final String MESSAGE_SCHEMA_XPATH_EXPR = "/*[local-name() = 'messageSchema']";
    public static final String MESSAGE_XPATH_EXPR = "//*[local-name() = 'message']";

    public static void validate(String xsdFilename, InputSource is, ParserOptions options) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setSchema(schemaFactory.newSchema(new File(xsdFilename)));
        factory.setNamespaceAware(true);
        if (options.xIncludeAware()) {
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        }
        factory.newDocumentBuilder().parse(is);
    }

    public static void validate(String xsdFilename, InputStream in, ParserOptions options) throws Exception {
        XmlSchemaParser.validate(xsdFilename, new InputSource(in), options);
    }

    public static MessageSchema parse(InputSource is, ParserOptions options) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (options.xIncludeAware()) {
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        }
        Document document = factory.newDocumentBuilder().parse(is);
        XPath xPath = XPathFactory.newInstance().newXPath();
        ErrorHandler errorHandler = new ErrorHandler(options);
        document.setUserData(ERROR_HANDLER_KEY, errorHandler, null);
        Map<String, Type> typeByNameMap = XmlSchemaParser.findTypes(document, xPath);
        errorHandler.checkIfShouldExit();
        Map<Long, Message> messageByIdMap = XmlSchemaParser.findMessages(document, xPath, typeByNameMap);
        errorHandler.checkIfShouldExit();
        Node schemaNode = (Node)xPath.compile(MESSAGE_SCHEMA_XPATH_EXPR).evaluate(document, XPathConstants.NODE);
        MessageSchema messageSchema = new MessageSchema(schemaNode, typeByNameMap, messageByIdMap);
        errorHandler.checkIfShouldExit();
        return messageSchema;
    }

    public static MessageSchema parse(InputStream in, ParserOptions options) throws Exception {
        return XmlSchemaParser.parse(new InputSource(in), options);
    }

    public static Map<String, Type> findTypes(Document document, XPath xPath) throws Exception {
        HashMap<String, Type> typeByNameMap = new HashMap<String, Type>();
        typeByNameMap.put("char", new EncodedDataType("char", Presence.REQUIRED, null, null, PrimitiveType.CHAR, 1, false));
        typeByNameMap.put("int8", new EncodedDataType("int8", Presence.REQUIRED, null, null, PrimitiveType.INT8, 1, false));
        typeByNameMap.put("int16", new EncodedDataType("int16", Presence.REQUIRED, null, null, PrimitiveType.INT16, 1, false));
        typeByNameMap.put("int32", new EncodedDataType("int32", Presence.REQUIRED, null, null, PrimitiveType.INT32, 1, false));
        typeByNameMap.put("int64", new EncodedDataType("int64", Presence.REQUIRED, null, null, PrimitiveType.INT64, 1, false));
        typeByNameMap.put("uint8", new EncodedDataType("uint8", Presence.REQUIRED, null, null, PrimitiveType.UINT8, 1, false));
        typeByNameMap.put("uint16", new EncodedDataType("uint16", Presence.REQUIRED, null, null, PrimitiveType.UINT16, 1, false));
        typeByNameMap.put("uint32", new EncodedDataType("uint32", Presence.REQUIRED, null, null, PrimitiveType.UINT32, 1, false));
        typeByNameMap.put("uint64", new EncodedDataType("uint64", Presence.REQUIRED, null, null, PrimitiveType.UINT64, 1, false));
        typeByNameMap.put("float", new EncodedDataType("float", Presence.REQUIRED, null, null, PrimitiveType.FLOAT, 1, false));
        typeByNameMap.put("double", new EncodedDataType("double", Presence.REQUIRED, null, null, PrimitiveType.DOUBLE, 1, false));
        XmlSchemaParser.forEach((NodeList)xPath.compile(TYPE_XPATH_EXPR).evaluate(document, XPathConstants.NODESET), node -> XmlSchemaParser.addTypeWithNameCheck(typeByNameMap, new EncodedDataType(node), node));
        XmlSchemaParser.forEach((NodeList)xPath.compile(COMPOSITE_XPATH_EXPR).evaluate(document, XPathConstants.NODESET), node -> XmlSchemaParser.addTypeWithNameCheck(typeByNameMap, new CompositeType(node), node));
        XmlSchemaParser.forEach((NodeList)xPath.compile(ENUM_XPATH_EXPR).evaluate(document, XPathConstants.NODESET), node -> XmlSchemaParser.addTypeWithNameCheck(typeByNameMap, new EnumType(node), node));
        XmlSchemaParser.forEach((NodeList)xPath.compile(SET_XPATH_EXPR).evaluate(document, XPathConstants.NODESET), node -> XmlSchemaParser.addTypeWithNameCheck(typeByNameMap, new SetType(node), node));
        return typeByNameMap;
    }

    public static Map<Long, Message> findMessages(Document document, XPath xPath, Map<String, Type> typeByNameMap) throws Exception {
        HashMap<Long, Message> messageByIdMap = new HashMap<Long, Message>();
        ObjectHashSet distinctNames = new ObjectHashSet();
        XmlSchemaParser.forEach((NodeList)xPath.compile(MESSAGE_XPATH_EXPR).evaluate(document, XPathConstants.NODESET), node -> XmlSchemaParser.addMessageWithIdCheck(distinctNames, messageByIdMap, new Message(node, typeByNameMap), node));
        return messageByIdMap;
    }

    public static void handleError(Node node, String msg) {
        ErrorHandler handler = (ErrorHandler)node.getOwnerDocument().getUserData(ERROR_HANDLER_KEY);
        if (handler == null) {
            throw new IllegalStateException("ERROR: " + XmlSchemaParser.formatLocationInfo(node) + msg);
        }
        handler.error(XmlSchemaParser.formatLocationInfo(node) + msg);
    }

    public static void handleWarning(Node node, String msg) {
        ErrorHandler handler = (ErrorHandler)node.getOwnerDocument().getUserData(ERROR_HANDLER_KEY);
        if (handler == null) {
            throw new IllegalStateException("WARNING: " + XmlSchemaParser.formatLocationInfo(node) + msg);
        }
        handler.warning(XmlSchemaParser.formatLocationInfo(node) + msg);
    }

    public static String getAttributeValue(Node elementNode, String attrName) {
        Node attrNode = elementNode.getAttributes().getNamedItemNS(null, attrName);
        if (attrNode == null || "".equals(attrNode.getNodeValue())) {
            throw new IllegalStateException("Element '" + elementNode.getNodeName() + "' has empty or missing attribute: " + attrName);
        }
        return attrNode.getNodeValue();
    }

    public static String getAttributeValue(Node elementNode, String attrName, String defValue) {
        Node attrNode = elementNode.getAttributes().getNamedItemNS(null, attrName);
        if (attrNode == null) {
            return defValue;
        }
        return attrNode.getNodeValue();
    }

    public static String getAttributeValueOrNull(Node elementNode, String attrName) {
        if (null == elementNode || null == elementNode.getAttributes()) {
            return null;
        }
        Node attrNode = elementNode.getAttributes().getNamedItemNS(null, attrName);
        if (null == attrNode) {
            return null;
        }
        return attrNode.getNodeValue();
    }

    public static ByteOrder getByteOrder(String byteOrderName) {
        switch (byteOrderName) {
            case "littleEndian": {
                return ByteOrder.LITTLE_ENDIAN;
            }
            case "bigEndian": {
                return ByteOrder.BIG_ENDIAN;
            }
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public static void checkForValidName(Node node, String name) {
        if (!ValidationUtil.isSbeCppName(name)) {
            XmlSchemaParser.handleWarning(node, "name is not valid for C++: " + name);
        }
        if (!ValidationUtil.isSbeJavaName(name)) {
            XmlSchemaParser.handleWarning(node, "name is not valid for Java: " + name);
        }
        if (!ValidationUtil.isSbeGolangName(name)) {
            XmlSchemaParser.handleWarning(node, "name is not valid for Golang: " + name);
        }
        if (!ValidationUtil.isSbeCSharpName(name)) {
            XmlSchemaParser.handleWarning(node, "name is not valid for C#: " + name);
        }
    }

    private static void addTypeWithNameCheck(Map<String, Type> typeByNameMap, Type type, Node node) {
        if (typeByNameMap.get(type.name()) != null) {
            XmlSchemaParser.handleWarning(node, "type already exists for name: " + type.name());
        }
        XmlSchemaParser.checkForValidName(node, type.name());
        typeByNameMap.put(type.name(), type);
    }

    private static void addMessageWithIdCheck(ObjectHashSet<String> distinctNames, Map<Long, Message> messageByIdMap, Message message, Node node) {
        if (messageByIdMap.get(message.id()) != null) {
            XmlSchemaParser.handleError(node, "message template id already exists: " + message.id());
        }
        if (!distinctNames.add(message.name())) {
            XmlSchemaParser.handleError(node, "message name already exists: " + message.name());
        }
        XmlSchemaParser.checkForValidName(node, message.name());
        messageByIdMap.put(Long.valueOf(message.id()), message);
    }

    private static String formatLocationInfo(Node node) {
        Node parentNode = node.getParentNode();
        return "at <" + parentNode.getNodeName() + (XmlSchemaParser.getAttributeValueOrNull(parentNode, "name") == null ? ">" : " name=\"" + XmlSchemaParser.getAttributeValueOrNull(parentNode, "name") + "\"> ") + "<" + node.getNodeName() + (XmlSchemaParser.getAttributeValueOrNull(node, "name") == null ? ">" : " name=\"" + XmlSchemaParser.getAttributeValueOrNull(node, "name") + "\"> ");
    }

    static void forEach(NodeList nodeList, NodeFunction func) throws XPathExpressionException {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            func.execute(nodeList.item(i));
        }
    }

    @FunctionalInterface
    static interface NodeFunction {
        public void execute(Node var1) throws XPathExpressionException;
    }
}

