/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class AtomicCounter
implements AutoCloseable {
    private boolean isClosed = false;
    private final int id;
    private final long addressOffset;
    private final byte[] byteArray;
    private final CountersManager countersManager;
    private final ByteBuffer byteBuffer;

    public AtomicCounter(AtomicBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public AtomicCounter(AtomicBuffer buffer, int counterId, CountersManager countersManager) {
        this.id = counterId;
        this.countersManager = countersManager;
        this.byteBuffer = buffer.byteBuffer();
        this.byteArray = buffer.byteArray();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    public int id() {
        return this.id;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String label() {
        return null != this.countersManager ? this.countersManager.getCounterLabel(this.id) : null;
    }

    public void updateLabel(String newLabel) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterLabel(this.id, newLabel);
    }

    public void appendToLabel(String suffix) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.appendToLabel(this.id, suffix);
    }

    public long increment() {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset, 1L);
    }

    public long incrementOrdered() {
        long currentValue = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, currentValue + 1L);
        return currentValue;
    }

    public void set(long value) {
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset, value);
    }

    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, value);
    }

    public void setWeak(long value) {
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, value);
    }

    public long getAndAdd(long increment) {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset, increment);
    }

    public long getAndAddOrdered(long increment) {
        long currentValue = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, currentValue + increment);
        return currentValue;
    }

    public long getAndSet(long value) {
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset, value);
    }

    public boolean compareAndSet(long expectedValue, long updateValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset, expectedValue, updateValue);
    }

    public long get() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public long getWeak() {
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
    }

    public boolean proposeMax(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    public boolean proposeMaxOrdered(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.id);
            }
        }
    }

    public String toString() {
        return "AtomicCounter{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + (this.isClosed() ? -1L : this.get()) + '}';
    }
}

