/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.ArrayList;
import java.util.List;
import org.agrona.LangUtil;

public class CloseHelper {
    public static void quietClose(AutoCloseable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void quietCloseAll(List<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return;
        }
        int size = closeables.size();
        for (int i = 0; i < size; ++i) {
            AutoCloseable closeable = closeables.get(i);
            if (closeable == null) continue;
            try {
                closeable.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void quietCloseAll(AutoCloseable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked(e);
        }
    }

    public static void closeAll(List<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return;
        }
        ArrayList<Exception> exceptions = null;
        int size = closeables.size();
        for (int i = 0; i < size; ++i) {
            AutoCloseable closeable = closeables.get(i);
            if (closeable == null) continue;
            try {
                closeable.close();
                continue;
            }
            catch (Exception ex) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(ex);
            }
        }
        if (exceptions != null) {
            Exception exception = (Exception)exceptions.remove(0);
            exceptions.forEach(exception::addSuppressed);
            LangUtil.rethrowUnchecked(exception);
        }
    }

    public static void closeAll(AutoCloseable ... closeables) {
        if (closeables == null) {
            return;
        }
        ArrayList<Exception> exceptions = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception ex) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(ex);
            }
        }
        if (exceptions != null) {
            Exception exception = (Exception)exceptions.remove(0);
            exceptions.forEach(exception::addSuppressed);
            LangUtil.rethrowUnchecked(exception);
        }
    }
}

