/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.RecordDescriptor;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class OneToOneRingBuffer
implements RingBuffer {
    public static final int PADDING_MSG_TYPE_ID = -1;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailPositionIndex;
    private final int headCachePositionIndex;
    private final int headPositionIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;
    private final AtomicBuffer buffer;

    public OneToOneRingBuffer(AtomicBuffer buffer) {
        this.buffer = buffer;
        RingBufferDescriptor.checkCapacity(buffer.capacity());
        this.capacity = buffer.capacity() - RingBufferDescriptor.TRAILER_LENGTH;
        buffer.verifyAlignment();
        this.maxMsgLength = this.capacity >> 3;
        this.tailPositionIndex = this.capacity + RingBufferDescriptor.TAIL_POSITION_OFFSET;
        this.headCachePositionIndex = this.capacity + RingBufferDescriptor.HEAD_CACHE_POSITION_OFFSET;
        this.headPositionIndex = this.capacity + RingBufferDescriptor.HEAD_POSITION_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        RecordDescriptor.checkTypeId(msgTypeId);
        this.checkMsgLength(length);
        AtomicBuffer buffer = this.buffer;
        int recordLength = length + 8;
        int alignedRecordLength = BitUtil.align(recordLength, 8);
        int requiredCapacity = alignedRecordLength + 8;
        int capacity = this.capacity;
        int tailPositionIndex = this.tailPositionIndex;
        int headCachePositionIndex = this.headCachePositionIndex;
        int mask = capacity - 1;
        long head = buffer.getLong(headCachePositionIndex);
        long tail = buffer.getLong(tailPositionIndex);
        int availableCapacity = capacity - (int)(tail - head);
        if (requiredCapacity > availableCapacity) {
            head = buffer.getLongVolatile(this.headPositionIndex);
            if (requiredCapacity > capacity - (int)(tail - head)) {
                return false;
            }
            buffer.putLong(headCachePositionIndex, head);
        }
        int padding = 0;
        int recordIndex = (int)tail & mask;
        int toBufferEndLength = capacity - recordIndex;
        if (requiredCapacity > toBufferEndLength) {
            int headIndex = (int)head & mask;
            if (requiredCapacity > headIndex) {
                head = buffer.getLongVolatile(this.headPositionIndex);
                headIndex = (int)head & mask;
                if (requiredCapacity > headIndex) {
                    return false;
                }
                buffer.putLong(headCachePositionIndex, head);
            }
            padding = toBufferEndLength;
        }
        if (0 != padding) {
            buffer.putLong(0, 0L);
            buffer.putInt(RecordDescriptor.typeOffset(recordIndex), -1);
            buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), padding);
            recordIndex = 0;
        }
        buffer.putBytes(RecordDescriptor.encodedMsgOffset(recordIndex), srcBuffer, srcIndex, length);
        buffer.putLong(recordIndex + alignedRecordLength, 0L);
        buffer.putInt(RecordDescriptor.typeOffset(recordIndex), msgTypeId);
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), recordLength);
        buffer.putLongOrdered(tailPositionIndex, tail + (long)alignedRecordLength + (long)padding);
        return true;
    }

    @Override
    public int read(MessageHandler handler) {
        return this.read(handler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler handler, int messageCountLimit) {
        int bytesRead;
        int messagesRead = 0;
        AtomicBuffer buffer = this.buffer;
        int headPositionIndex = this.headPositionIndex;
        long head = buffer.getLong(headPositionIndex);
        int capacity = this.capacity;
        int headIndex = (int)head & capacity - 1;
        int contiguousBlockLength = capacity - headIndex;
        try {
            int recordLength;
            for (bytesRead = 0; bytesRead < contiguousBlockLength && messagesRead < messageCountLimit; bytesRead += BitUtil.align(recordLength, 8)) {
                int recordIndex = headIndex + bytesRead;
                recordLength = buffer.getIntVolatile(RecordDescriptor.lengthOffset(recordIndex));
                if (recordLength > 0) continue;
                break;
            }
        }
        finally {
            if (bytesRead != 0) {
                buffer.putLongOrdered(headPositionIndex, head + (long)bytesRead);
            }
        }
        return messagesRead;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTime(long time) {
        this.buffer.putLongOrdered(this.consumerHeartbeatIndex, time);
    }

    @Override
    public long consumerHeartbeatTime() {
        return this.buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    @Override
    public long producerPosition() {
        return this.buffer.getLongVolatile(this.tailPositionIndex);
    }

    @Override
    public long consumerPosition() {
        return this.buffer.getLongVolatile(this.headPositionIndex);
    }

    @Override
    public int size() {
        long tail;
        long headBefore;
        AtomicBuffer buffer = this.buffer;
        int headPositionIndex = this.headPositionIndex;
        int tailPositionIndex = this.tailPositionIndex;
        long headAfter = buffer.getLongVolatile(headPositionIndex);
        do {
            headBefore = headAfter;
            tail = buffer.getLongVolatile(tailPositionIndex);
        } while ((headAfter = buffer.getLongVolatile(headPositionIndex)) != headBefore);
        return (int)(tail - headAfter);
    }

    @Override
    public boolean unblock() {
        return false;
    }

    private void checkMsgLength(int length) {
        if (length > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength of " + this.maxMsgLength + ", length=" + length);
        }
    }
}

