/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class AsciiSequenceView
implements CharSequence {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public AsciiSequenceView() {
    }

    public AsciiSequenceView(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException("index=" + index + " length=" + this.length);
        }
        return (char)this.buffer.getByte(this.offset + index);
    }

    @Override
    public AsciiSequenceView subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException("start=" + start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException("end=" + end);
        }
        if (end - start < 0) {
            throw new StringIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        return new AsciiSequenceView(this.buffer, this.offset + start, end - start);
    }

    public AsciiSequenceView wrap(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public void reset() {
        this.buffer = null;
        this.offset = 0;
        this.length = 0;
    }

    public int getBytes(MutableDirectBuffer dstBuffer, int dstOffset) {
        dstBuffer.putBytes(dstOffset, this.buffer, this.offset, this.length);
        return this.length;
    }

    @Override
    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.buffer.getStringWithoutLengthAscii(this.offset, this.length);
    }
}

