/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.io.Writer;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.generation.rust.RustUtil;

enum RustCodecType {
    Decoder{

        @Override
        String scratchProperty() {
            return "scratch";
        }

        @Override
        String scratchType() {
            return "ScratchDecoderData";
        }

        @Override
        void appendDirectCodeMethods(Appendable appendable, String methodName, String representationType, String nextCoderType, int numBytes) throws IOException {
            RustUtil.indent(appendable, 1, "pub fn %s(mut self) -> CodecResult<(&%s %s, %s)> {\n", methodName, "'d", representationType, RustGenerator.withLifetime(nextCoderType));
            RustUtil.indent(appendable, 2, "let v = self.%s.read_type::<%s>(%s)?;\n", Decoder.scratchProperty(), representationType, numBytes);
            RustUtil.indent(appendable, 2, "Ok((v, %s::wrap(self.%s)))\n", nextCoderType, Decoder.scratchProperty());
            RustUtil.indent(appendable).append("}\n");
        }

        @Override
        String gerund() {
            return "decoding";
        }
    }
    ,
    Encoder{

        @Override
        String scratchProperty() {
            return "scratch";
        }

        @Override
        String scratchType() {
            return "ScratchEncoderData";
        }

        @Override
        void appendDirectCodeMethods(Appendable appendable, String methodName, String representationType, String nextCoderType, int numBytes) throws IOException {
            RustUtil.indent(appendable, 1, "\n/// Create a mutable struct reference overlaid atop the data buffer\n", new Object[0]);
            RustUtil.indent(appendable, 1, "/// such that changes to the struct directly edit the buffer. \n", new Object[0]);
            RustUtil.indent(appendable, 1, "/// Note that the initial content of the struct's fields may be garbage.\n", new Object[0]);
            RustUtil.indent(appendable, 1, "pub fn %s(mut self) -> CodecResult<(&%s mut %s, %s)> {\n", methodName, "'d", representationType, RustGenerator.withLifetime(nextCoderType));
            RustUtil.indent(appendable, 2, "let v = self.%s.writable_overlay::<%s>(%s)?;\n", Encoder.scratchProperty(), representationType, numBytes);
            RustUtil.indent(appendable, 2, "Ok((v, %s::wrap(self.%s)))\n", nextCoderType, Encoder.scratchProperty());
            RustUtil.indent(appendable).append("}\n\n");
            RustUtil.indent(appendable, 1, "/// Copy the bytes of a value into the data buffer\n", new Object[0]);
            RustUtil.indent(appendable).append(String.format("pub fn %s_copy(mut self, t: &%s) -> CodecResult<%s> {\n", methodName, representationType, RustGenerator.withLifetime(nextCoderType)));
            RustUtil.indent(appendable, 2).append(String.format("self.%s.write_type::<%s>(t, %s)?;\n", Encoder.scratchProperty(), representationType, numBytes));
            RustUtil.indent(appendable, 2).append(String.format("Ok(%s::wrap(self.%s))\n", nextCoderType, Encoder.scratchProperty()));
            RustUtil.indent(appendable).append("}\n");
        }

        @Override
        String gerund() {
            return "encoding";
        }
    };


    void appendScratchWrappingStruct(Appendable appendable, String structName) throws IOException {
        appendable.append(String.format("pub struct %s <%s> {\n", structName, "'d")).append("  ").append(String.format("%s: %s <%s>,%n", this.scratchProperty(), this.scratchType(), "'d")).append("}\n");
    }

    abstract String scratchProperty();

    abstract String scratchType();

    abstract void appendDirectCodeMethods(Appendable var1, String var2, String var3, String var4, int var5) throws IOException;

    abstract String gerund();

    String generateDoneCoderType(OutputManager outputManager, String messageTypeName) throws IOException {
        String doneTypeName = messageTypeName + this.name() + "Done";
        try (Writer writer = outputManager.createOutput(doneTypeName);){
            this.appendScratchWrappingStruct(writer, doneTypeName);
            RustGenerator.appendImplWithLifetimeHeader(writer, doneTypeName);
            RustUtil.indent(writer, 1, "/// Returns the number of bytes %s\n", this == Encoder ? "encoded" : "decoded");
            RustUtil.indent(writer, 1, "pub fn unwrap(self) -> usize {\n", new Object[0]);
            RustUtil.indent(writer, 2, "self.%s.pos\n", this.scratchProperty());
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
            this.appendWrapMethod(writer, doneTypeName);
            writer.append("}\n");
        }
        return doneTypeName;
    }

    void appendWrapMethod(Appendable appendable, String structName) throws IOException {
        appendable.append("\n").append("  ").append(String.format("fn wrap(%s: %s) -> %s {%n", this.scratchProperty(), RustGenerator.withLifetime(this.scratchType()), RustGenerator.withLifetime(structName)));
        RustUtil.indent(appendable, 2, "%s { %s: %s }\n", structName, this.scratchProperty(), this.scratchProperty());
        RustUtil.indent(appendable).append("}\n");
    }

    String generateMessageHeaderCoder(String messageTypeName, OutputManager outputManager, String topType, int headerSize) throws IOException {
        String messageHeaderRepresentation = "MessageHeader";
        String headerCoderType = messageTypeName + "MessageHeader" + this.name();
        try (Writer writer = outputManager.createOutput(headerCoderType);){
            this.appendScratchWrappingStruct(writer, headerCoderType);
            RustGenerator.appendImplWithLifetimeHeader(writer, headerCoderType);
            this.appendWrapMethod(writer, headerCoderType);
            this.appendDirectCodeMethods(writer, "header", "MessageHeader", topType, headerSize);
            writer.append("}\n");
        }
        return headerCoderType;
    }
}

