/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.system_tests;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.ExecType;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.OrdStatus;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.ExecutionReportEncoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.LogonEncoder;
import uk.co.real_logic.artio.builder.LogoutEncoder;
import uk.co.real_logic.artio.builder.ResendRequestEncoder;
import uk.co.real_logic.artio.builder.SequenceResetEncoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.builder.TestRequestEncoder;
import uk.co.real_logic.artio.decoder.BusinessMessageRejectDecoder;
import uk.co.real_logic.artio.decoder.ExecutionReportDecoder;
import uk.co.real_logic.artio.decoder.HeartbeatDecoder;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.decoder.LogoutDecoder;
import uk.co.real_logic.artio.decoder.NewOrderSingleDecoder;
import uk.co.real_logic.artio.decoder.RejectDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class TestFixConnection
implements AutoCloseable {
    public static final int BUFFER_SIZE = 8192;
    private static final int OFFSET = 0;
    public static final String PROXY_SOURCE_IP = "192.168.0.1";
    public static final int PROXY_SOURCE_PORT = 56324;
    public static final String LARGEST_PROXY_SOURCE_IP = "ffff:f...f:ffff";
    public static final int LARGEST_PROXY_SOURCE_PORT = 65535;
    public static final int PROXY_V2_SOURCE_PORT = 56546;
    public static final String PROXY_V2_IPV6_SOURCE_IP = "fdaa:bbcc:ddee:0:5e8:349b:d23d:f168";
    public static final int PROXY_V2_IPV6_SOURCE_PORT = 44858;
    private final ByteBuffer writeBuffer = ByteBuffer.allocateDirect(8192);
    private final MutableAsciiBuffer writeAsciiBuffer = new MutableAsciiBuffer(this.writeBuffer);
    private final UtcTimestampEncoder sendingTimeEncoder = new UtcTimestampEncoder();
    private final UtcTimestampEncoder origSendingTimeEncoder = new UtcTimestampEncoder();
    private final LogonEncoder logon = new LogonEncoder();
    private final LogoutEncoder logout = new LogoutEncoder();
    private final TestRequestEncoder testRequestEncoder = new TestRequestEncoder();
    private final SocketChannel socket;
    private final String senderCompID;
    private final String targetCompID;
    private int msgSeqNum = 1;
    private final ByteBuffer readBuffer = ByteBuffer.allocateDirect(8192);
    private final MutableAsciiBuffer asciiReadBuffer = new MutableAsciiBuffer(this.readBuffer);
    private int endOfMessage;
    private int bytesRemaining = 0;
    private String ascii;
    private String password;

    public TestFixConnection(SocketChannel socket, String senderCompID, String targetCompID) {
        this.socket = socket;
        this.senderCompID = senderCompID;
        this.targetCompID = targetCompID;
    }

    public boolean isConnected() {
        try {
            boolean isConnected;
            int read = this.socket.read(this.readBuffer);
            boolean bl = isConnected = read != -1;
            if (isConnected) {
                String ascii = this.asciiReadBuffer.getAscii(this.readBuffer.position() - read, read);
                DebugLogger.log((LogTag)LogTag.FIX_TEST, (String)("< [" + ascii + "] for isConnected()"));
            }
            return isConnected;
        }
        catch (IOException e) {
            return false;
        }
    }

    void sendProxyV1Line() {
        int length = this.writeAsciiBuffer.putAscii(0, "PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\r\n");
        this.send(0, length);
    }

    void sendProxyV1LargestLine() {
        int length = this.writeAsciiBuffer.putAscii(0, "PROXY UNKNOWN ffff:f...f:ffff ffff:f...f:ffff 65535 65535\r\n");
        this.send(0, length);
    }

    void sendProxyV2LineTcpV4() {
        byte[] bytes = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 17, 0, 12, -64, -88, 0, 1, -64, -88, 0, 1, -36, -30, 19, -120};
        this.sendBytes(bytes);
    }

    void sendProxyV2LineTcpV6() {
        byte[] bytes = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 33, 0, 36, -3, -86, -69, -52, -35, -18, 0, 0, 5, -24, 52, -101, -46, 61, -15, 104, -3, -86, -69, -52, -35, -18, 0, 0, 5, -24, 52, -101, -46, 61, -15, 104, -81, 58, 19, -120};
        this.sendBytes(bytes);
    }

    void sendProxyV2LineTcpV6Localhost() {
        byte[] bytes = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 33, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -81, 58, 19, -120};
        this.sendBytes(bytes);
    }

    public void sendBytes(byte[] bytes) {
        int length = bytes.length;
        this.writeAsciiBuffer.putBytes(0, bytes);
        this.send(0, length);
    }

    public void logon(boolean resetSeqNumFlag) {
        this.logon(resetSeqNumFlag, 30);
    }

    public void logon(boolean resetSeqNumFlag, int heartBtInt) {
        this.logon(resetSeqNumFlag, heartBtInt, false);
    }

    public void logon(boolean resetSeqNumFlag, int heartBtInt, boolean possDupFlag) {
        this.setupHeader((SessionHeaderEncoder)this.logon.header(), this.msgSeqNum++, possDupFlag);
        this.logon.resetSeqNumFlag(resetSeqNumFlag).encryptMethod(0).heartBtInt(heartBtInt).maxMessageSize(9999);
        if (this.password != null) {
            this.logon.password((CharSequence)this.password);
        }
        this.send((Encoder)this.logon);
    }

    public TestFixConnection msgSeqNum(int msgSeqNum) {
        this.msgSeqNum = msgSeqNum;
        return this;
    }

    public int acquireMsgSeqNum() {
        return this.msgSeqNum++;
    }

    public void logout() {
        this.setupHeader((SessionHeaderEncoder)this.logout.header(), this.msgSeqNum++, false);
        this.send((Encoder)this.logout);
    }

    public void password(String password) {
        this.password = password;
    }

    public void setupHeader(SessionHeaderEncoder header, int msgSeqNum, boolean possDupFlag) {
        long timestamp = System.currentTimeMillis();
        int timestampLength = this.sendingTimeEncoder.encode(timestamp);
        header.senderCompID((CharSequence)this.senderCompID).targetCompID((CharSequence)this.targetCompID).msgSeqNum(msgSeqNum).sendingTime(this.sendingTimeEncoder.buffer(), timestampLength);
        if (possDupFlag) {
            int origSendingTimeLength = this.origSendingTimeEncoder.encode(timestamp - 1000L);
            header.possDupFlag(true).origSendingTime(this.origSendingTimeEncoder.buffer(), origSendingTimeLength);
        }
    }

    public ExecutionReportDecoder readExecutionReport() {
        return this.readMessage(new ExecutionReportDecoder());
    }

    public ExecutionReportDecoder readExecutionReport(int msgSeqNum) {
        ExecutionReportDecoder executionReport = this.readExecutionReport();
        this.assertSeqNum(msgSeqNum, (Decoder)executionReport);
        return executionReport;
    }

    public <T extends Decoder> T readMessage(T decoder) {
        try {
            int bytesToParse = this.bytesRemaining == 0 ? this.socket.read(this.readBuffer) : this.bytesRemaining;
            this.ascii = this.asciiReadBuffer.getAscii(0, bytesToParse);
            DebugLogger.log((LogTag)LogTag.FIX_TEST, (String)("< [" + this.ascii + "] for attempted: " + decoder.getClass()));
            this.endOfMessage = this.ascii.indexOf("8=FIX.4.4", 9);
            if (this.endOfMessage == -1) {
                this.endOfMessage = bytesToParse;
            }
            decoder.decode((AsciiBuffer)this.asciiReadBuffer, 0, this.endOfMessage);
            if (!decoder.validate()) {
                // empty if block
            }
            try {
                Field messageTypeAsStringField = decoder.getClass().getDeclaredField("MESSAGE_TYPE_AS_STRING");
                String expectedMsgType = (String)messageTypeAsStringField.get(null);
                SessionHeaderDecoder header = decoder.header();
                String string = new String(header.msgType(), 0, header.msgTypeLength());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            this.readBuffer.clear();
            if (this.endOfMessage != -1) {
                this.bytesRemaining = bytesToParse - this.endOfMessage;
                this.asciiReadBuffer.putBytes(0, (DirectBuffer)this.asciiReadBuffer, this.endOfMessage, this.bytesRemaining);
            } else {
                this.bytesRemaining = 0;
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return decoder;
    }

    int pollData() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(buffer);
        this.socket.configureBlocking(false);
        int read = this.socket.read(buffer);
        this.socket.configureBlocking(true);
        if (read > 0) {
            DebugLogger.log((LogTag)LogTag.FIX_TEST, (String)("< [" + asciiBuffer.getAscii(0, read) + "] for poll"));
        }
        return read;
    }

    public void send(Encoder encoder) {
        long result = encoder.encode(this.writeAsciiBuffer, 0);
        int offset = Encoder.offset((long)result);
        int length = Encoder.length((long)result);
        encoder.reset();
        this.send(offset, length);
    }

    public void awaitDisconnect() {
        block3: {
            try {
                int read = this.socket.read(this.readBuffer);
                if (read > 0) {
                    this.awaitDisconnect();
                }
            }
            catch (IOException e) {
                if (!this.socket.isConnected()) break block3;
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
    }

    private void send(int offset, int length) {
        try {
            this.writeBuffer.position(offset).limit(offset + length);
            int written = this.socket.write(this.writeBuffer);
            if (length != written) {
                throw new IllegalStateException("TODO");
            }
            DebugLogger.log((LogTag)LogTag.FIX_TEST, (String)("> [" + this.writeAsciiBuffer.getAscii(offset, length) + "]"));
            this.writeBuffer.clear();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    public LogonDecoder readLogon() {
        return this.readMessage(new LogonDecoder());
    }

    public LogonDecoder readLogon(int msgSeqNum) {
        LogonDecoder logonReply = this.readLogon();
        this.assertSeqNum(msgSeqNum, (Decoder)logonReply);
        return logonReply;
    }

    private void assertSeqNum(int msgSeqNum, Decoder decoder) {
    }

    public RejectDecoder readReject() {
        return this.readMessage(new RejectDecoder());
    }

    public BusinessMessageRejectDecoder readBusinessReject() {
        return this.readMessage(new BusinessMessageRejectDecoder());
    }

    public NewOrderSingleDecoder readOrder() {
        return this.readMessage(new NewOrderSingleDecoder());
    }

    public void sendTestRequest(String testReqID) {
        this.setupHeader((SessionHeaderEncoder)this.testRequestEncoder.header(), this.msgSeqNum++, false);
        this.testRequestEncoder.testReqID((CharSequence)testReqID);
        this.send((Encoder)this.testRequestEncoder);
    }

    public String lastMessageAsString() {
        return this.asciiReadBuffer.getAscii(0, this.endOfMessage);
    }

    public String lastTotalBytesRead() {
        return this.ascii;
    }

    public HeartbeatDecoder readHeartbeat() {
        return this.readMessage(new HeartbeatDecoder());
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.socket);
    }

    public LogoutDecoder readLogout() {
        return this.readMessage(new LogoutDecoder());
    }

    public void sendGapFill(int msgSeqNum, int newMsgSeqNum) {
        SequenceResetEncoder sequenceResetEncoder = new SequenceResetEncoder();
        HeaderEncoder headerEncoder = sequenceResetEncoder.header();
        this.setupHeader((SessionHeaderEncoder)headerEncoder, msgSeqNum, true);
        sequenceResetEncoder.newSeqNo(newMsgSeqNum).gapFillFlag(true);
        this.send((Encoder)sequenceResetEncoder);
    }

    public void sendExecutionReport(int msgSeqNum, boolean possDupFlag) {
        ExecutionReportEncoder executionReportEncoder = new ExecutionReportEncoder();
        HeaderEncoder header = executionReportEncoder.header();
        this.setupHeader((SessionHeaderEncoder)header, msgSeqNum, possDupFlag);
        executionReportEncoder.orderID((CharSequence)"order").execID((CharSequence)"exec").execType(ExecType.FILL).ordStatus(OrdStatus.FILLED).side(Side.BUY);
        executionReportEncoder.instrument().symbol((CharSequence)"IBM");
        this.send((Encoder)executionReportEncoder);
    }

    public ResendRequestEncoder sendResendRequest(int beginSeqNo, int endSeqNo) {
        ResendRequestEncoder resendRequest = new ResendRequestEncoder();
        resendRequest.beginSeqNo(beginSeqNo).endSeqNo(endSeqNo);
        this.setupHeader((SessionHeaderEncoder)resendRequest.header(), this.msgSeqNum++, false);
        this.send((Encoder)resendRequest);
        return resendRequest;
    }

    public int msgSeqNum() {
        return this.msgSeqNum;
    }
}

