/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HopGrpEncoder {
    private static final int noHopsGroupCounterHeaderLength = 4;
    private static final byte[] noHopsGroupCounterHeader = new byte[]{54, 50, 55, 61};
    private int noHopsGroupCounter;
    private boolean hasNoHopsGroupCounter;
    private HopsGroupEncoder hopsGroup = null;

    public boolean hasNoHopsGroupCounter() {
        return this.hasNoHopsGroupCounter;
    }

    public HopGrpEncoder noHopsGroupCounter(int value) {
        this.noHopsGroupCounter = value;
        this.hasNoHopsGroupCounter = true;
        return this;
    }

    public int noHopsGroupCounter() {
        return this.noHopsGroupCounter;
    }

    public HopsGroupEncoder hopsGroup(int numberOfElements) {
        this.hasNoHopsGroupCounter = true;
        this.noHopsGroupCounter = numberOfElements;
        if (this.hopsGroup == null) {
            this.hopsGroup = new HopsGroupEncoder();
        }
        return this.hopsGroup;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasNoHopsGroupCounter) {
            buffer.putBytes(position, noHopsGroupCounterHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.noHopsGroupCounter);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hopsGroup != null) {
            position += this.hopsGroup.encode(buffer, position, this.noHopsGroupCounter);
        }
        return position - offset;
    }

    public void reset() {
        this.resetHopsGroup();
    }

    public void resetHopsGroup() {
        if (this.hopsGroup != null) {
            this.hopsGroup.reset();
        }
        this.noHopsGroupCounter = 0;
        this.hasNoHopsGroupCounter = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"HopGrp\",\n");
        if (this.hasNoHopsGroupCounter) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"HopsGroup\": [\n");
            int noHopsGroupCounter = this.noHopsGroupCounter;
            HopsGroupEncoder hopsGroup = this.hopsGroup;
            for (int i = 0; i < noHopsGroupCounter; ++i) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                hopsGroup.appendTo(builder, level + 1);
                if (i < noHopsGroupCounter - 1) {
                    builder.append(',');
                }
                builder.append('\n');
                hopsGroup = hopsGroup.next();
            }
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("],\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public HopGrpEncoder copyTo(Encoder encoder) {
        return this.copyTo((HopGrpEncoder)encoder);
    }

    public HopGrpEncoder copyTo(HopGrpEncoder encoder) {
        encoder.reset();
        if (this.hasNoHopsGroupCounter) {
            int size = this.noHopsGroupCounter;
            HopsGroupEncoder hopsGroup = this.hopsGroup;
            HopsGroupEncoder hopsGroupEncoder = encoder.hopsGroup(size);
            for (int i = 0; i < size; ++i) {
                if (hopsGroup == null) continue;
                hopsGroup.copyTo(hopsGroupEncoder);
                hopsGroup = hopsGroup.next();
                hopsGroupEncoder = hopsGroupEncoder.next();
            }
        }
        return encoder;
    }

    public static class HopsGroupEncoder {
        private HopsGroupEncoder next = null;
        private static final int hopCompIDHeaderLength = 4;
        private static final byte[] hopCompIDHeader = new byte[]{54, 50, 56, 61};
        private static final int hopSendingTimeHeaderLength = 4;
        private static final byte[] hopSendingTimeHeader = new byte[]{54, 50, 57, 61};
        private static final int hopRefIDHeaderLength = 4;
        private static final byte[] hopRefIDHeader = new byte[]{54, 51, 48, 61};
        private final MutableDirectBuffer hopCompID = new UnsafeBuffer();
        private int hopCompIDOffset = 0;
        private int hopCompIDLength = 0;
        private final MutableDirectBuffer hopSendingTime = new UnsafeBuffer();
        private int hopSendingTimeOffset = 0;
        private int hopSendingTimeLength = 0;
        private int hopRefID;
        private boolean hasHopRefID;

        public HopsGroupEncoder next() {
            if (this.next == null) {
                this.next = new HopsGroupEncoder();
            }
            return this.next;
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value, int offset, int length) {
            this.hopCompID.wrap(value);
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value) {
            return this.hopCompID(value, 0, value.capacity());
        }

        public HopsGroupEncoder hopCompID(byte[] value, int offset, int length) {
            this.hopCompID.wrap(value);
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompIDAsCopy(byte[] value, int offset, int length) {
            CodecUtil.copyInto((MutableDirectBuffer)this.hopCompID, (byte[])value, (int)offset, (int)length);
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(byte[] value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(byte[] value) {
            return this.hopCompID(value, 0, value.length);
        }

        public boolean hasHopCompID() {
            return this.hopCompIDLength > 0;
        }

        public MutableDirectBuffer hopCompID() {
            return this.hopCompID;
        }

        public String hopCompIDAsString() {
            return this.hopCompID.getStringWithoutLengthAscii(this.hopCompIDOffset, this.hopCompIDLength);
        }

        public HopsGroupEncoder hopCompID(CharSequence value) {
            CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.hopCompID);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = value.length();
            return this;
        }

        public HopsGroupEncoder hopCompID(AsciiSequenceView value) {
            DirectBuffer buffer = value.buffer();
            if (buffer != null) {
                this.hopCompID.wrap(buffer);
                this.hopCompIDOffset = value.offset();
                this.hopCompIDLength = value.length();
            }
            return this;
        }

        public HopsGroupEncoder hopCompID(char[] value) {
            return this.hopCompID(value, 0, value.length);
        }

        public HopsGroupEncoder hopCompID(char[] value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(char[] value, int offset, int length) {
            CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.hopCompID, (int)offset, (int)length);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value, int offset, int length) {
            this.hopSendingTime.wrap(value);
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value, int length) {
            return this.hopSendingTime(value, 0, length);
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value) {
            return this.hopSendingTime(value, 0, value.capacity());
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int offset, int length) {
            this.hopSendingTime.wrap(value);
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTimeAsCopy(byte[] value, int offset, int length) {
            CodecUtil.copyInto((MutableDirectBuffer)this.hopSendingTime, (byte[])value, (int)offset, (int)length);
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int length) {
            return this.hopSendingTime(value, 0, length);
        }

        public HopsGroupEncoder hopSendingTime(byte[] value) {
            return this.hopSendingTime(value, 0, value.length);
        }

        public boolean hasHopSendingTime() {
            return this.hopSendingTimeLength > 0;
        }

        public MutableDirectBuffer hopSendingTime() {
            return this.hopSendingTime;
        }

        public String hopSendingTimeAsString() {
            return this.hopSendingTime.getStringWithoutLengthAscii(this.hopSendingTimeOffset, this.hopSendingTimeLength);
        }

        public boolean hasHopRefID() {
            return this.hasHopRefID;
        }

        public HopsGroupEncoder hopRefID(int value) {
            this.hopRefID = value;
            this.hasHopRefID = true;
            return this;
        }

        public int hopRefID() {
            return this.hopRefID;
        }

        public int encode(MutableAsciiBuffer buffer, int offset, int remainingElements) {
            if (remainingElements == 0) {
                return 0;
            }
            int position = offset;
            if (this.hopCompIDLength > 0) {
                buffer.putBytes(position, hopCompIDHeader, 0, 4);
                buffer.putBytes(position += 4, (DirectBuffer)this.hopCompID, this.hopCompIDOffset, this.hopCompIDLength);
                buffer.putSeparator(position += this.hopCompIDLength);
                ++position;
            }
            if (this.hopSendingTimeLength > 0) {
                buffer.putBytes(position, hopSendingTimeHeader, 0, 4);
                buffer.putBytes(position += 4, (DirectBuffer)this.hopSendingTime, this.hopSendingTimeOffset, this.hopSendingTimeLength);
                buffer.putSeparator(position += this.hopSendingTimeLength);
                ++position;
            }
            if (this.hasHopRefID) {
                buffer.putBytes(position, hopRefIDHeader, 0, 4);
                position += 4;
                position += buffer.putIntAscii(position, this.hopRefID);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.next != null) {
                position += this.next.encode(buffer, position, remainingElements - 1);
            }
            return position - offset;
        }

        public void reset() {
            this.resetHopCompID();
            this.resetHopSendingTime();
            this.resetHopRefID();
            if (this.next != null) {
                this.next.reset();
            }
        }

        public void resetHopCompID() {
            this.hopCompIDLength = 0;
        }

        public void resetHopSendingTime() {
            this.hopSendingTimeLength = 0;
        }

        public void resetHopRefID() {
            this.hasHopRefID = false;
        }

        public String toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            return this.appendTo(builder, 1);
        }

        public StringBuilder appendTo(StringBuilder builder, int level) {
            builder.append("{\n");
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"MessageName\": \"HopsGroup\",\n");
            if (this.hasHopCompID()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopCompID\": \"");
                CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.hopCompID, (int)this.hopCompIDOffset, (int)this.hopCompIDLength);
                builder.append("\",\n");
            }
            if (this.hasHopSendingTime()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopSendingTime\": \"");
                CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.hopSendingTime, (int)this.hopSendingTimeOffset, (int)this.hopSendingTimeLength);
                builder.append("\",\n");
            }
            if (this.hasHopRefID()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopRefID\": \"");
                builder.append(this.hopRefID);
                builder.append("\",\n");
            }
            CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
            builder.append("}");
            return builder;
        }

        public HopsGroupEncoder copyTo(Encoder encoder) {
            return this.copyTo((HopsGroupEncoder)encoder);
        }

        public HopsGroupEncoder copyTo(HopsGroupEncoder encoder) {
            encoder.reset();
            if (this.hasHopCompID()) {
                encoder.hopCompIDAsCopy(this.hopCompID.byteArray(), 0, this.hopCompIDLength);
            }
            if (this.hasHopSendingTime()) {
                encoder.hopSendingTimeAsCopy(this.hopSendingTime.byteArray(), 0, this.hopSendingTimeLength);
            }
            if (this.hasHopRefID()) {
                encoder.hopRefID(this.hopRefID());
            }
            return encoder;
        }
    }
}

