/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class TrailerEncoder {
    private static final int signatureLengthHeaderLength = 3;
    private static final byte[] signatureLengthHeader = new byte[]{57, 51, 61};
    private static final int signatureHeaderLength = 3;
    private static final byte[] signatureHeader = new byte[]{56, 57, 61};
    private static final int checkSumHeaderLength = 3;
    private static final byte[] checkSumHeader = new byte[]{49, 48, 61};
    private int signatureLength;
    private boolean hasSignatureLength;
    private byte[] signature;
    private boolean hasSignature;
    private final MutableDirectBuffer checkSum = new UnsafeBuffer();
    private int checkSumOffset = 0;
    private int checkSumLength = 0;

    public boolean hasSignatureLength() {
        return this.hasSignatureLength;
    }

    public TrailerEncoder signatureLength(int value) {
        this.signatureLength = value;
        this.hasSignatureLength = true;
        return this;
    }

    public int signatureLength() {
        return this.signatureLength;
    }

    public boolean hasSignature() {
        return this.hasSignature;
    }

    public TrailerEncoder signature(byte[] value) {
        this.signature = value;
        this.hasSignature = true;
        return this;
    }

    public byte[] signature() {
        return this.signature;
    }

    public TrailerEncoder checkSum(DirectBuffer value, int offset, int length) {
        this.checkSum.wrap(value);
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(DirectBuffer value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(DirectBuffer value) {
        return this.checkSum(value, 0, value.capacity());
    }

    public TrailerEncoder checkSum(byte[] value, int offset, int length) {
        this.checkSum.wrap(value);
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(byte[] value) {
        return this.checkSum(value, 0, value.length);
    }

    public boolean hasCheckSum() {
        return this.checkSumLength > 0;
    }

    public MutableDirectBuffer checkSum() {
        return this.checkSum;
    }

    public String checkSumAsString() {
        return this.checkSum.getStringWithoutLengthAscii(this.checkSumOffset, this.checkSumLength);
    }

    public TrailerEncoder checkSum(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.checkSum);
        this.checkSumOffset = 0;
        this.checkSumLength = value.length();
        return this;
    }

    public TrailerEncoder checkSum(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.checkSum.wrap(buffer);
            this.checkSumOffset = value.offset();
            this.checkSumLength = value.length();
        }
        return this;
    }

    public TrailerEncoder checkSum(char[] value) {
        return this.checkSum(value, 0, value.length);
    }

    public TrailerEncoder checkSum(char[] value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.checkSum, (int)offset, (int)length);
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    long finishMessage(MutableAsciiBuffer buffer, int messageStart, int offset) {
        int position = offset;
        int checkSum = buffer.computeChecksum(messageStart, position);
        buffer.putBytes(position, checkSumHeader, 0, 3);
        buffer.putNaturalPaddedIntAscii(position += 3, 3, checkSum);
        buffer.putSeparator(position += 3);
        return Encoder.result((int)(++position - messageStart), (int)messageStart);
    }

    int startTrailer(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset;
        if (this.hasSignatureLength) {
            buffer.putBytes(position, signatureLengthHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.signatureLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasSignature) {
            buffer.putBytes(position, signatureHeader, 0, 3);
            buffer.putBytes(position += 3, this.signature);
            buffer.putSeparator(position += this.signature.length);
            ++position;
        }
        return position - start;
    }

    public void reset() {
        this.resetSignatureLength();
        this.resetSignature();
    }

    public void resetSignatureLength() {
        this.hasSignatureLength = false;
    }

    public void resetSignature() {
        this.hasSignature = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Trailer\",\n");
        if (this.hasSignatureLength()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"SignatureLength\": \"");
            builder.append(this.signatureLength);
            builder.append("\",\n");
        }
        if (this.hasSignature()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Signature\": \"");
            CodecUtil.appendData((StringBuilder)builder, (byte[])this.signature, (int)this.signatureLength);
            builder.append("\",\n");
        }
        if (this.hasCheckSum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"CheckSum\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.checkSum, (int)this.checkSumOffset, (int)this.checkSumLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }
}

