/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.builder;

import java.util.Arrays;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fixt.SessionRejectReason;
import uk.co.real_logic.artio.fixt.builder.HeaderEncoder;
import uk.co.real_logic.artio.fixt.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class RejectEncoder
implements AbstractRejectEncoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int refSeqNumHeaderLength = 3;
    private static final byte[] refSeqNumHeader = new byte[]{52, 53, 61};
    private static final int refTagIDHeaderLength = 4;
    private static final byte[] refTagIDHeader = new byte[]{51, 55, 49, 61};
    private static final int refMsgTypeHeaderLength = 4;
    private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
    private static final int refApplVerIDHeaderLength = 5;
    private static final byte[] refApplVerIDHeader = new byte[]{49, 49, 51, 48, 61};
    private static final int refApplExtIDHeaderLength = 5;
    private static final byte[] refApplExtIDHeader = new byte[]{49, 52, 48, 54, 61};
    private static final int refCstmApplVerIDHeaderLength = 5;
    private static final byte[] refCstmApplVerIDHeader = new byte[]{49, 49, 51, 49, 61};
    private static final int sessionRejectReasonHeaderLength = 4;
    private static final byte[] sessionRejectReasonHeader = new byte[]{51, 55, 51, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int refSeqNum;
    private boolean hasRefSeqNum;
    private int refTagID;
    private boolean hasRefTagID;
    private final MutableDirectBuffer refMsgType = new UnsafeBuffer();
    private int refMsgTypeOffset = 0;
    private int refMsgTypeLength = 0;
    private final MutableDirectBuffer refApplVerID = new UnsafeBuffer();
    private int refApplVerIDOffset = 0;
    private int refApplVerIDLength = 0;
    private int refApplExtID;
    private boolean hasRefApplExtID;
    private final MutableDirectBuffer refCstmApplVerID = new UnsafeBuffer();
    private int refCstmApplVerIDOffset = 0;
    private int refCstmApplVerIDLength = 0;
    private int sessionRejectReason;
    private boolean hasSessionRejectReason;
    private final MutableDirectBuffer text = new UnsafeBuffer();
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;

    public long messageType() {
        return 51L;
    }

    public RejectEncoder() {
        this.header.msgType("3");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasRefSeqNum() {
        return this.hasRefSeqNum;
    }

    public RejectEncoder refSeqNum(int value) {
        this.refSeqNum = value;
        this.hasRefSeqNum = true;
        return this;
    }

    public int refSeqNum() {
        return this.refSeqNum;
    }

    public boolean hasRefTagID() {
        return this.hasRefTagID;
    }

    public RejectEncoder refTagID(int value) {
        this.refTagID = value;
        this.hasRefTagID = true;
        return this;
    }

    public int refTagID() {
        return this.refTagID;
    }

    public RejectEncoder refMsgType(DirectBuffer value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(DirectBuffer value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(DirectBuffer value) {
        return this.refMsgType(value, 0, value.capacity());
    }

    public RejectEncoder refMsgType(byte[] value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(byte[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(byte[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public boolean hasRefMsgType() {
        return this.refMsgTypeLength > 0;
    }

    public MutableDirectBuffer refMsgType() {
        return this.refMsgType;
    }

    public String refMsgTypeAsString() {
        return this.refMsgType.getStringWithoutLengthAscii(this.refMsgTypeOffset, this.refMsgTypeLength);
    }

    public RejectEncoder refMsgType(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.refMsgType);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = value.length();
        return this;
    }

    public RejectEncoder refMsgType(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.refMsgType.wrap(buffer);
            this.refMsgTypeOffset = value.offset();
            this.refMsgTypeLength = value.length();
        }
        return this;
    }

    public RejectEncoder refMsgType(char[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public RejectEncoder refMsgType(char[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.refMsgType, (int)offset, (int)length);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(DirectBuffer value, int offset, int length) {
        this.refApplVerID.wrap(value);
        this.refApplVerIDOffset = offset;
        this.refApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(DirectBuffer value, int length) {
        return this.refApplVerID(value, 0, length);
    }

    public RejectEncoder refApplVerID(DirectBuffer value) {
        return this.refApplVerID(value, 0, value.capacity());
    }

    public RejectEncoder refApplVerID(byte[] value, int offset, int length) {
        this.refApplVerID.wrap(value);
        this.refApplVerIDOffset = offset;
        this.refApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(byte[] value, int length) {
        return this.refApplVerID(value, 0, length);
    }

    public RejectEncoder refApplVerID(byte[] value) {
        return this.refApplVerID(value, 0, value.length);
    }

    public boolean hasRefApplVerID() {
        return this.refApplVerIDLength > 0;
    }

    public MutableDirectBuffer refApplVerID() {
        return this.refApplVerID;
    }

    public String refApplVerIDAsString() {
        return this.refApplVerID.getStringWithoutLengthAscii(this.refApplVerIDOffset, this.refApplVerIDLength);
    }

    public RejectEncoder refApplVerID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.refApplVerID);
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = value.length();
        return this;
    }

    public RejectEncoder refApplVerID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.refApplVerID.wrap(buffer);
            this.refApplVerIDOffset = value.offset();
            this.refApplVerIDLength = value.length();
        }
        return this;
    }

    public RejectEncoder refApplVerID(char[] value) {
        return this.refApplVerID(value, 0, value.length);
    }

    public RejectEncoder refApplVerID(char[] value, int length) {
        return this.refApplVerID(value, 0, length);
    }

    public RejectEncoder refApplVerID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.refApplVerID, (int)offset, (int)length);
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = length;
        return this;
    }

    public boolean hasRefApplExtID() {
        return this.hasRefApplExtID;
    }

    public RejectEncoder refApplExtID(int value) {
        this.refApplExtID = value;
        this.hasRefApplExtID = true;
        return this;
    }

    public int refApplExtID() {
        return this.refApplExtID;
    }

    public RejectEncoder refCstmApplVerID(DirectBuffer value, int offset, int length) {
        this.refCstmApplVerID.wrap(value);
        this.refCstmApplVerIDOffset = offset;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refCstmApplVerID(DirectBuffer value, int length) {
        return this.refCstmApplVerID(value, 0, length);
    }

    public RejectEncoder refCstmApplVerID(DirectBuffer value) {
        return this.refCstmApplVerID(value, 0, value.capacity());
    }

    public RejectEncoder refCstmApplVerID(byte[] value, int offset, int length) {
        this.refCstmApplVerID.wrap(value);
        this.refCstmApplVerIDOffset = offset;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refCstmApplVerID(byte[] value, int length) {
        return this.refCstmApplVerID(value, 0, length);
    }

    public RejectEncoder refCstmApplVerID(byte[] value) {
        return this.refCstmApplVerID(value, 0, value.length);
    }

    public boolean hasRefCstmApplVerID() {
        return this.refCstmApplVerIDLength > 0;
    }

    public MutableDirectBuffer refCstmApplVerID() {
        return this.refCstmApplVerID;
    }

    public String refCstmApplVerIDAsString() {
        return this.refCstmApplVerID.getStringWithoutLengthAscii(this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
    }

    public RejectEncoder refCstmApplVerID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.refCstmApplVerID);
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = value.length();
        return this;
    }

    public RejectEncoder refCstmApplVerID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.refCstmApplVerID.wrap(buffer);
            this.refCstmApplVerIDOffset = value.offset();
            this.refCstmApplVerIDLength = value.length();
        }
        return this;
    }

    public RejectEncoder refCstmApplVerID(char[] value) {
        return this.refCstmApplVerID(value, 0, value.length);
    }

    public RejectEncoder refCstmApplVerID(char[] value, int length) {
        return this.refCstmApplVerID(value, 0, length);
    }

    public RejectEncoder refCstmApplVerID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.refCstmApplVerID, (int)offset, (int)length);
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public boolean hasSessionRejectReason() {
        return this.hasSessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(int value) {
        this.sessionRejectReason = value;
        this.hasSessionRejectReason = true;
        return this;
    }

    public int sessionRejectReason() {
        return this.sessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(SessionRejectReason value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == SessionRejectReason.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: sessionRejectReason Value: " + (Object)((Object)value));
            }
            if (value == SessionRejectReason.NULL_VAL) {
                return this;
            }
        }
        return this.sessionRejectReason(value.representation());
    }

    public RejectEncoder text(DirectBuffer value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(DirectBuffer value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(DirectBuffer value) {
        return this.text(value, 0, value.capacity());
    }

    public RejectEncoder text(byte[] value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(byte[] value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(byte[] value) {
        return this.text(value, 0, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public MutableDirectBuffer text() {
        return this.text;
    }

    public String textAsString() {
        return this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength);
    }

    public RejectEncoder text(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public RejectEncoder text(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.text.wrap(buffer);
            this.textOffset = value.offset();
            this.textLength = value.length();
        }
        return this;
    }

    public RejectEncoder text(char[] value) {
        return this.text(value, 0, value.length);
    }

    public RejectEncoder text(char[] value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public RejectEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public RejectEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public boolean supportsRefMsgType() {
        return true;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasRefSeqNum) {
            buffer.putBytes(position, refSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.refSeqNum);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: RefSeqNum");
        }
        if (this.hasRefTagID) {
            buffer.putBytes(position, refTagIDHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.refTagID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refMsgTypeLength > 0) {
            buffer.putBytes(position, refMsgTypeHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
            buffer.putSeparator(position += this.refMsgTypeLength);
            ++position;
        }
        if (this.refApplVerIDLength > 0) {
            buffer.putBytes(position, refApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, (DirectBuffer)this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength);
            buffer.putSeparator(position += this.refApplVerIDLength);
            ++position;
        }
        if (this.hasRefApplExtID) {
            buffer.putBytes(position, refApplExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.refApplExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refCstmApplVerIDLength > 0) {
            buffer.putBytes(position, refCstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, (DirectBuffer)this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
            buffer.putSeparator(position += this.refCstmApplVerIDLength);
            ++position;
        }
        if (this.hasSessionRejectReason) {
            buffer.putBytes(position, sessionRejectReasonHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.sessionRejectReason);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetRefSeqNum();
        this.resetRefTagID();
        this.resetRefMsgType();
        this.resetRefApplVerID();
        this.resetRefApplExtID();
        this.resetRefCstmApplVerID();
        this.resetSessionRejectReason();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
    }

    public void resetRefSeqNum() {
        this.hasRefSeqNum = false;
    }

    public void resetRefTagID() {
        this.hasRefTagID = false;
    }

    public void resetRefMsgType() {
        this.refMsgTypeLength = 0;
    }

    public void resetRefApplVerID() {
        this.refApplVerIDLength = 0;
    }

    public void resetRefApplExtID() {
        this.hasRefApplExtID = false;
    }

    public void resetRefCstmApplVerID() {
        this.refCstmApplVerIDLength = 0;
    }

    public void resetSessionRejectReason() {
        this.hasSessionRejectReason = false;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasRefSeqNum() ? String.format("  \"RefSeqNum\": \"%s\",\n", this.refSeqNum) : "") + (this.hasRefTagID() ? String.format("  \"RefTagID\": \"%s\",\n", this.refTagID) : "") + (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", this.refMsgType.getStringWithoutLengthAscii(this.refMsgTypeOffset, this.refMsgTypeLength)) : "") + (this.hasRefApplVerID() ? String.format("  \"RefApplVerID\": \"%s\",\n", this.refApplVerID.getStringWithoutLengthAscii(this.refApplVerIDOffset, this.refApplVerIDLength)) : "") + (this.hasRefApplExtID() ? String.format("  \"RefApplExtID\": \"%s\",\n", this.refApplExtID) : "") + (this.hasRefCstmApplVerID() ? String.format("  \"RefCstmApplVerID\": \"%s\",\n", this.refCstmApplVerID.getStringWithoutLengthAscii(this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength)) : "") + (this.hasSessionRejectReason() ? String.format("  \"SessionRejectReason\": \"%s\",\n", this.sessionRejectReason) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Reject\",\n" + entries + "}";
        return entries;
    }
}

