/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.builder;

import java.util.Arrays;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fixt.EncryptMethod;
import uk.co.real_logic.artio.fixt.SessionStatus;
import uk.co.real_logic.artio.fixt.builder.HeaderEncoder;
import uk.co.real_logic.artio.fixt.builder.MsgTypeGrpEncoder;
import uk.co.real_logic.artio.fixt.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogonEncoder
implements AbstractLogonEncoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int encryptMethodHeaderLength = 3;
    private static final byte[] encryptMethodHeader = new byte[]{57, 56, 61};
    private static final int heartBtIntHeaderLength = 4;
    private static final byte[] heartBtIntHeader = new byte[]{49, 48, 56, 61};
    private static final int rawDataLengthHeaderLength = 3;
    private static final byte[] rawDataLengthHeader = new byte[]{57, 53, 61};
    private static final int rawDataHeaderLength = 3;
    private static final byte[] rawDataHeader = new byte[]{57, 54, 61};
    private static final int resetSeqNumFlagHeaderLength = 4;
    private static final byte[] resetSeqNumFlagHeader = new byte[]{49, 52, 49, 61};
    private static final int nextExpectedMsgSeqNumHeaderLength = 4;
    private static final byte[] nextExpectedMsgSeqNumHeader = new byte[]{55, 56, 57, 61};
    private static final int maxMessageSizeHeaderLength = 4;
    private static final byte[] maxMessageSizeHeader = new byte[]{51, 56, 51, 61};
    private static final int testMessageIndicatorHeaderLength = 4;
    private static final byte[] testMessageIndicatorHeader = new byte[]{52, 54, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private static final int newPasswordHeaderLength = 4;
    private static final byte[] newPasswordHeader = new byte[]{57, 50, 53, 61};
    private static final int encryptedPasswordMethodHeaderLength = 5;
    private static final byte[] encryptedPasswordMethodHeader = new byte[]{49, 52, 48, 48, 61};
    private static final int encryptedPasswordLenHeaderLength = 5;
    private static final byte[] encryptedPasswordLenHeader = new byte[]{49, 52, 48, 49, 61};
    private static final int encryptedPasswordHeaderLength = 5;
    private static final byte[] encryptedPasswordHeader = new byte[]{49, 52, 48, 50, 61};
    private static final int encryptedNewPasswordLenHeaderLength = 5;
    private static final byte[] encryptedNewPasswordLenHeader = new byte[]{49, 52, 48, 51, 61};
    private static final int encryptedNewPasswordHeaderLength = 5;
    private static final byte[] encryptedNewPasswordHeader = new byte[]{49, 52, 48, 52, 61};
    private static final int sessionStatusHeaderLength = 5;
    private static final byte[] sessionStatusHeader = new byte[]{49, 52, 48, 57, 61};
    private static final int defaultApplVerIDHeaderLength = 5;
    private static final byte[] defaultApplVerIDHeader = new byte[]{49, 49, 51, 55, 61};
    private static final int defaultApplExtIDHeaderLength = 5;
    private static final byte[] defaultApplExtIDHeader = new byte[]{49, 52, 48, 55, 61};
    private static final int defaultCstmApplVerIDHeaderLength = 5;
    private static final byte[] defaultCstmApplVerIDHeader = new byte[]{49, 52, 48, 56, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int encryptMethod;
    private boolean hasEncryptMethod;
    private int heartBtInt;
    private boolean hasHeartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private final MsgTypeGrpEncoder msgTypeGrp = new MsgTypeGrpEncoder();
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private final MutableDirectBuffer username = new UnsafeBuffer();
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private final MutableDirectBuffer password = new UnsafeBuffer();
    private int passwordOffset = 0;
    private int passwordLength = 0;
    private final MutableDirectBuffer newPassword = new UnsafeBuffer();
    private int newPasswordOffset = 0;
    private int newPasswordLength = 0;
    private int encryptedPasswordMethod;
    private boolean hasEncryptedPasswordMethod;
    private int encryptedPasswordLen;
    private boolean hasEncryptedPasswordLen;
    private byte[] encryptedPassword;
    private boolean hasEncryptedPassword;
    private int encryptedNewPasswordLen;
    private boolean hasEncryptedNewPasswordLen;
    private byte[] encryptedNewPassword;
    private boolean hasEncryptedNewPassword;
    private int sessionStatus;
    private boolean hasSessionStatus;
    private final MutableDirectBuffer defaultApplVerID = new UnsafeBuffer();
    private int defaultApplVerIDOffset = 0;
    private int defaultApplVerIDLength = 0;
    private int defaultApplExtID;
    private boolean hasDefaultApplExtID;
    private final MutableDirectBuffer defaultCstmApplVerID = new UnsafeBuffer();
    private int defaultCstmApplVerIDOffset = 0;
    private int defaultCstmApplVerIDLength = 0;
    private final MutableDirectBuffer text = new UnsafeBuffer();
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;

    public long messageType() {
        return 65L;
    }

    public LogonEncoder() {
        this.header.msgType("A");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasEncryptMethod() {
        return this.hasEncryptMethod;
    }

    public LogonEncoder encryptMethod(int value) {
        this.encryptMethod = value;
        this.hasEncryptMethod = true;
        return this;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public LogonEncoder encryptMethod(EncryptMethod value) {
        return this.encryptMethod(value.representation());
    }

    public boolean hasHeartBtInt() {
        return this.hasHeartBtInt;
    }

    public LogonEncoder heartBtInt(int value) {
        this.heartBtInt = value;
        this.hasHeartBtInt = true;
        return this;
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public LogonEncoder rawDataLength(int value) {
        this.rawDataLength = value;
        this.hasRawDataLength = true;
        return this;
    }

    public int rawDataLength() {
        return this.rawDataLength;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public LogonEncoder rawData(byte[] value) {
        this.rawData = value;
        this.hasRawData = true;
        return this;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public LogonEncoder resetSeqNumFlag(boolean value) {
        this.resetSeqNumFlag = value;
        this.hasResetSeqNumFlag = true;
        return this;
    }

    public boolean resetSeqNumFlag() {
        return this.resetSeqNumFlag;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public LogonEncoder nextExpectedMsgSeqNum(int value) {
        this.nextExpectedMsgSeqNum = value;
        this.hasNextExpectedMsgSeqNum = true;
        return this;
    }

    public int nextExpectedMsgSeqNum() {
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public LogonEncoder maxMessageSize(int value) {
        this.maxMessageSize = value;
        this.hasMaxMessageSize = true;
        return this;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public MsgTypeGrpEncoder msgTypeGrp() {
        return this.msgTypeGrp;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public LogonEncoder testMessageIndicator(boolean value) {
        this.testMessageIndicator = value;
        this.hasTestMessageIndicator = true;
        return this;
    }

    public boolean testMessageIndicator() {
        return this.testMessageIndicator;
    }

    public LogonEncoder username(DirectBuffer value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(DirectBuffer value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(DirectBuffer value) {
        return this.username(value, 0, value.capacity());
    }

    public LogonEncoder username(byte[] value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(byte[] value) {
        return this.username(value, 0, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public MutableDirectBuffer username() {
        return this.username;
    }

    public String usernameAsString() {
        return this.username.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength);
    }

    public LogonEncoder username(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public LogonEncoder username(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.username.wrap(buffer);
            this.usernameOffset = value.offset();
            this.usernameLength = value.length();
        }
        return this;
    }

    public LogonEncoder username(char[] value) {
        return this.username(value, 0, value.length);
    }

    public LogonEncoder username(char[] value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder password(DirectBuffer value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(DirectBuffer value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(DirectBuffer value) {
        return this.password(value, 0, value.capacity());
    }

    public LogonEncoder password(byte[] value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(byte[] value) {
        return this.password(value, 0, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public MutableDirectBuffer password() {
        return this.password;
    }

    public String passwordAsString() {
        return this.password.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength);
    }

    public LogonEncoder password(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public LogonEncoder password(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.password.wrap(buffer);
            this.passwordOffset = value.offset();
            this.passwordLength = value.length();
        }
        return this;
    }

    public LogonEncoder password(char[] value) {
        return this.password(value, 0, value.length);
    }

    public LogonEncoder password(char[] value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder newPassword(DirectBuffer value, int offset, int length) {
        this.newPassword.wrap(value);
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(DirectBuffer value, int length) {
        return this.newPassword(value, 0, length);
    }

    public LogonEncoder newPassword(DirectBuffer value) {
        return this.newPassword(value, 0, value.capacity());
    }

    public LogonEncoder newPassword(byte[] value, int offset, int length) {
        this.newPassword.wrap(value);
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value, int length) {
        return this.newPassword(value, 0, length);
    }

    public LogonEncoder newPassword(byte[] value) {
        return this.newPassword(value, 0, value.length);
    }

    public boolean hasNewPassword() {
        return this.newPasswordLength > 0;
    }

    public MutableDirectBuffer newPassword() {
        return this.newPassword;
    }

    public String newPasswordAsString() {
        return this.newPassword.getStringWithoutLengthAscii(this.newPasswordOffset, this.newPasswordLength);
    }

    public LogonEncoder newPassword(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.newPassword);
        this.newPasswordOffset = 0;
        this.newPasswordLength = value.length();
        return this;
    }

    public LogonEncoder newPassword(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.newPassword.wrap(buffer);
            this.newPasswordOffset = value.offset();
            this.newPasswordLength = value.length();
        }
        return this;
    }

    public LogonEncoder newPassword(char[] value) {
        return this.newPassword(value, 0, value.length);
    }

    public LogonEncoder newPassword(char[] value, int length) {
        return this.newPassword(value, 0, length);
    }

    public LogonEncoder newPassword(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.newPassword, (int)offset, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public boolean hasEncryptedPasswordMethod() {
        return this.hasEncryptedPasswordMethod;
    }

    public LogonEncoder encryptedPasswordMethod(int value) {
        this.encryptedPasswordMethod = value;
        this.hasEncryptedPasswordMethod = true;
        return this;
    }

    public int encryptedPasswordMethod() {
        return this.encryptedPasswordMethod;
    }

    public boolean hasEncryptedPasswordLen() {
        return this.hasEncryptedPasswordLen;
    }

    public LogonEncoder encryptedPasswordLen(int value) {
        this.encryptedPasswordLen = value;
        this.hasEncryptedPasswordLen = true;
        return this;
    }

    public int encryptedPasswordLen() {
        return this.encryptedPasswordLen;
    }

    public boolean hasEncryptedPassword() {
        return this.hasEncryptedPassword;
    }

    public LogonEncoder encryptedPassword(byte[] value) {
        this.encryptedPassword = value;
        this.hasEncryptedPassword = true;
        return this;
    }

    public byte[] encryptedPassword() {
        return this.encryptedPassword;
    }

    public boolean hasEncryptedNewPasswordLen() {
        return this.hasEncryptedNewPasswordLen;
    }

    public LogonEncoder encryptedNewPasswordLen(int value) {
        this.encryptedNewPasswordLen = value;
        this.hasEncryptedNewPasswordLen = true;
        return this;
    }

    public int encryptedNewPasswordLen() {
        return this.encryptedNewPasswordLen;
    }

    public boolean hasEncryptedNewPassword() {
        return this.hasEncryptedNewPassword;
    }

    public LogonEncoder encryptedNewPassword(byte[] value) {
        this.encryptedNewPassword = value;
        this.hasEncryptedNewPassword = true;
        return this;
    }

    public byte[] encryptedNewPassword() {
        return this.encryptedNewPassword;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public LogonEncoder sessionStatus(int value) {
        this.sessionStatus = value;
        this.hasSessionStatus = true;
        return this;
    }

    public int sessionStatus() {
        return this.sessionStatus;
    }

    public LogonEncoder sessionStatus(SessionStatus value) {
        return this.sessionStatus(value.representation());
    }

    public LogonEncoder defaultApplVerID(DirectBuffer value, int offset, int length) {
        this.defaultApplVerID.wrap(value);
        this.defaultApplVerIDOffset = offset;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(DirectBuffer value, int length) {
        return this.defaultApplVerID(value, 0, length);
    }

    public LogonEncoder defaultApplVerID(DirectBuffer value) {
        return this.defaultApplVerID(value, 0, value.capacity());
    }

    public LogonEncoder defaultApplVerID(byte[] value, int offset, int length) {
        this.defaultApplVerID.wrap(value);
        this.defaultApplVerIDOffset = offset;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(byte[] value, int length) {
        return this.defaultApplVerID(value, 0, length);
    }

    public LogonEncoder defaultApplVerID(byte[] value) {
        return this.defaultApplVerID(value, 0, value.length);
    }

    public boolean hasDefaultApplVerID() {
        return this.defaultApplVerIDLength > 0;
    }

    public MutableDirectBuffer defaultApplVerID() {
        return this.defaultApplVerID;
    }

    public String defaultApplVerIDAsString() {
        return this.defaultApplVerID.getStringWithoutLengthAscii(this.defaultApplVerIDOffset, this.defaultApplVerIDLength);
    }

    public LogonEncoder defaultApplVerID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.defaultApplVerID);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultApplVerID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.defaultApplVerID.wrap(buffer);
            this.defaultApplVerIDOffset = value.offset();
            this.defaultApplVerIDLength = value.length();
        }
        return this;
    }

    public LogonEncoder defaultApplVerID(char[] value) {
        return this.defaultApplVerID(value, 0, value.length);
    }

    public LogonEncoder defaultApplVerID(char[] value, int length) {
        return this.defaultApplVerID(value, 0, length);
    }

    public LogonEncoder defaultApplVerID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.defaultApplVerID, (int)offset, (int)length);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public boolean hasDefaultApplExtID() {
        return this.hasDefaultApplExtID;
    }

    public LogonEncoder defaultApplExtID(int value) {
        this.defaultApplExtID = value;
        this.hasDefaultApplExtID = true;
        return this;
    }

    public int defaultApplExtID() {
        return this.defaultApplExtID;
    }

    public LogonEncoder defaultCstmApplVerID(DirectBuffer value, int offset, int length) {
        this.defaultCstmApplVerID.wrap(value);
        this.defaultCstmApplVerIDOffset = offset;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(DirectBuffer value, int length) {
        return this.defaultCstmApplVerID(value, 0, length);
    }

    public LogonEncoder defaultCstmApplVerID(DirectBuffer value) {
        return this.defaultCstmApplVerID(value, 0, value.capacity());
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int offset, int length) {
        this.defaultCstmApplVerID.wrap(value);
        this.defaultCstmApplVerIDOffset = offset;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int length) {
        return this.defaultCstmApplVerID(value, 0, length);
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value) {
        return this.defaultCstmApplVerID(value, 0, value.length);
    }

    public boolean hasDefaultCstmApplVerID() {
        return this.defaultCstmApplVerIDLength > 0;
    }

    public MutableDirectBuffer defaultCstmApplVerID() {
        return this.defaultCstmApplVerID;
    }

    public String defaultCstmApplVerIDAsString() {
        return this.defaultCstmApplVerID.getStringWithoutLengthAscii(this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength);
    }

    public LogonEncoder defaultCstmApplVerID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.defaultCstmApplVerID);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.defaultCstmApplVerID.wrap(buffer);
            this.defaultCstmApplVerIDOffset = value.offset();
            this.defaultCstmApplVerIDLength = value.length();
        }
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(char[] value) {
        return this.defaultCstmApplVerID(value, 0, value.length);
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int length) {
        return this.defaultCstmApplVerID(value, 0, length);
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.defaultCstmApplVerID, (int)offset, (int)length);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder text(DirectBuffer value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(DirectBuffer value, int length) {
        return this.text(value, 0, length);
    }

    public LogonEncoder text(DirectBuffer value) {
        return this.text(value, 0, value.capacity());
    }

    public LogonEncoder text(byte[] value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value, int length) {
        return this.text(value, 0, length);
    }

    public LogonEncoder text(byte[] value) {
        return this.text(value, 0, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public MutableDirectBuffer text() {
        return this.text;
    }

    public String textAsString() {
        return this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength);
    }

    public LogonEncoder text(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public LogonEncoder text(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.text.wrap(buffer);
            this.textOffset = value.offset();
            this.textLength = value.length();
        }
        return this;
    }

    public LogonEncoder text(char[] value) {
        return this.text(value, 0, value.length);
    }

    public LogonEncoder text(char[] value, int length) {
        return this.text(value, 0, length);
    }

    public LogonEncoder text(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public LogonEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public LogonEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public boolean supportsUsername() {
        return true;
    }

    public boolean supportsPassword() {
        return true;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasEncryptMethod) {
            buffer.putBytes(position, encryptMethodHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.encryptMethod);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EncryptMethod");
        }
        if (this.hasHeartBtInt) {
            buffer.putBytes(position, heartBtIntHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.heartBtInt);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: HeartBtInt");
        }
        if (this.hasRawDataLength) {
            buffer.putBytes(position, rawDataLengthHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.rawDataLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasRawData) {
            buffer.putBytes(position, rawDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.rawData);
            buffer.putSeparator(position += this.rawData.length);
            ++position;
        }
        if (this.hasResetSeqNumFlag) {
            buffer.putBytes(position, resetSeqNumFlagHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.resetSeqNumFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNextExpectedMsgSeqNum) {
            buffer.putBytes(position, nextExpectedMsgSeqNumHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.nextExpectedMsgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasMaxMessageSize) {
            buffer.putBytes(position, maxMessageSizeHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.maxMessageSize);
            buffer.putSeparator(position);
            ++position;
        }
        position += this.msgTypeGrp.encode(buffer, position);
        if (this.hasTestMessageIndicator) {
            buffer.putBytes(position, testMessageIndicatorHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.testMessageIndicator);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        if (this.newPasswordLength > 0) {
            buffer.putBytes(position, newPasswordHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.newPassword, this.newPasswordOffset, this.newPasswordLength);
            buffer.putSeparator(position += this.newPasswordLength);
            ++position;
        }
        if (this.hasEncryptedPasswordMethod) {
            buffer.putBytes(position, encryptedPasswordMethodHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedPasswordMethod);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPasswordLen) {
            buffer.putBytes(position, encryptedPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPassword) {
            buffer.putBytes(position, encryptedPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedPassword);
            buffer.putSeparator(position += this.encryptedPassword.length);
            ++position;
        }
        if (this.hasEncryptedNewPasswordLen) {
            buffer.putBytes(position, encryptedNewPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedNewPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedNewPassword) {
            buffer.putBytes(position, encryptedNewPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedNewPassword);
            buffer.putSeparator(position += this.encryptedNewPassword.length);
            ++position;
        }
        if (this.hasSessionStatus) {
            buffer.putBytes(position, sessionStatusHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.sessionStatus);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultApplVerIDLength > 0) {
            buffer.putBytes(position, defaultApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, (DirectBuffer)this.defaultApplVerID, this.defaultApplVerIDOffset, this.defaultApplVerIDLength);
            buffer.putSeparator(position += this.defaultApplVerIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: DefaultApplVerID");
        }
        if (this.hasDefaultApplExtID) {
            buffer.putBytes(position, defaultApplExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.defaultApplExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultCstmApplVerIDLength > 0) {
            buffer.putBytes(position, defaultCstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, (DirectBuffer)this.defaultCstmApplVerID, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength);
            buffer.putSeparator(position += this.defaultCstmApplVerIDLength);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
        this.resetEncryptedPasswordMethod();
        this.resetEncryptedPasswordLen();
        this.resetEncryptedPassword();
        this.resetEncryptedNewPasswordLen();
        this.resetEncryptedNewPassword();
        this.resetSessionStatus();
        this.resetDefaultApplVerID();
        this.resetDefaultApplExtID();
        this.resetDefaultCstmApplVerID();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
        this.msgTypeGrp.reset();
    }

    public void resetEncryptMethod() {
        this.hasEncryptMethod = false;
    }

    public void resetHeartBtInt() {
        this.hasHeartBtInt = false;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public void resetNewPassword() {
        this.newPasswordLength = 0;
    }

    public void resetEncryptedPasswordMethod() {
        this.hasEncryptedPasswordMethod = false;
    }

    public void resetEncryptedPasswordLen() {
        this.hasEncryptedPasswordLen = false;
    }

    public void resetEncryptedPassword() {
        this.hasEncryptedPassword = false;
    }

    public void resetEncryptedNewPasswordLen() {
        this.hasEncryptedNewPasswordLen = false;
    }

    public void resetEncryptedNewPassword() {
        this.hasEncryptedNewPassword = false;
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetDefaultApplVerID() {
        this.defaultApplVerIDLength = 0;
    }

    public void resetDefaultApplExtID() {
        this.hasDefaultApplExtID = false;
    }

    public void resetDefaultCstmApplVerID() {
        this.defaultCstmApplVerIDLength = 0;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasEncryptMethod() ? String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) : "") + (this.hasHeartBtInt() ? String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) : "") + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + String.format("  \"MsgTypeGrp\":  %s\n", this.msgTypeGrp.toString().replace("\n", "\n  ")) + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", this.username.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", this.password.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength)) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", this.newPassword.getStringWithoutLengthAscii(this.newPasswordOffset, this.newPasswordLength)) : "") + (this.hasEncryptedPasswordMethod() ? String.format("  \"EncryptedPasswordMethod\": \"%s\",\n", this.encryptedPasswordMethod) : "") + (this.hasEncryptedPasswordLen() ? String.format("  \"EncryptedPasswordLen\": \"%s\",\n", this.encryptedPasswordLen) : "") + (this.hasEncryptedPassword() ? String.format("  \"EncryptedPassword\": \"%s\",\n", Arrays.toString(this.encryptedPassword)) : "") + (this.hasEncryptedNewPasswordLen() ? String.format("  \"EncryptedNewPasswordLen\": \"%s\",\n", this.encryptedNewPasswordLen) : "") + (this.hasEncryptedNewPassword() ? String.format("  \"EncryptedNewPassword\": \"%s\",\n", Arrays.toString(this.encryptedNewPassword)) : "") + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + (this.hasDefaultApplVerID() ? String.format("  \"DefaultApplVerID\": \"%s\",\n", this.defaultApplVerID.getStringWithoutLengthAscii(this.defaultApplVerIDOffset, this.defaultApplVerIDLength)) : "") + (this.hasDefaultApplExtID() ? String.format("  \"DefaultApplExtID\": \"%s\",\n", this.defaultApplExtID) : "") + (this.hasDefaultCstmApplVerID() ? String.format("  \"DefaultCstmApplVerID\": \"%s\",\n", this.defaultCstmApplVerID.getStringWithoutLengthAscii(this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength)) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }
}

