/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HopGrpEncoder {
    private static final int noHopsGroupCounterHeaderLength = 4;
    private static final byte[] noHopsGroupCounterHeader = new byte[]{54, 50, 55, 61};
    private int noHopsGroupCounter;
    private boolean hasNoHopsGroupCounter;
    private HopsGroupEncoder hopsGroup = null;

    public boolean hasNoHopsGroupCounter() {
        return this.hasNoHopsGroupCounter;
    }

    public HopGrpEncoder noHopsGroupCounter(int value) {
        this.noHopsGroupCounter = value;
        this.hasNoHopsGroupCounter = true;
        return this;
    }

    public int noHopsGroupCounter() {
        return this.noHopsGroupCounter;
    }

    public HopsGroupEncoder hopsGroup(int numberOfElements) {
        this.hasNoHopsGroupCounter = true;
        this.noHopsGroupCounter = numberOfElements;
        if (this.hopsGroup == null) {
            this.hopsGroup = new HopsGroupEncoder();
        }
        return this.hopsGroup;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasNoHopsGroupCounter) {
            buffer.putBytes(position, noHopsGroupCounterHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.noHopsGroupCounter);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hopsGroup != null) {
            position += this.hopsGroup.encode(buffer, position, this.noHopsGroupCounter);
        }
        return position - offset;
    }

    public void reset() {
        this.resetHopsGroup();
    }

    public void resetHopsGroup() {
        if (this.hopsGroup != null) {
            this.hopsGroup.reset();
        }
        this.noHopsGroupCounter = 0;
        this.hasNoHopsGroupCounter = false;
    }

    public String toString() {
        String entries = this.noHopsGroupCounter > 0 ? String.format("  \"HopsGroup\": [\n  %s\n  ]\n", this.hopsGroup.toString(this.noHopsGroupCounter).replace("\n", "\n  ")) : "";
        entries = "{\n  \"MessageName\": \"HopGrp\",\n" + entries + "}";
        return entries;
    }

    public static class HopsGroupEncoder {
        private HopsGroupEncoder next = null;
        private static final int hopCompIDHeaderLength = 4;
        private static final byte[] hopCompIDHeader = new byte[]{54, 50, 56, 61};
        private static final int hopSendingTimeHeaderLength = 4;
        private static final byte[] hopSendingTimeHeader = new byte[]{54, 50, 57, 61};
        private static final int hopRefIDHeaderLength = 4;
        private static final byte[] hopRefIDHeader = new byte[]{54, 51, 48, 61};
        private final MutableDirectBuffer hopCompID = new UnsafeBuffer();
        private int hopCompIDOffset = 0;
        private int hopCompIDLength = 0;
        private final MutableDirectBuffer hopSendingTime = new UnsafeBuffer();
        private int hopSendingTimeOffset = 0;
        private int hopSendingTimeLength = 0;
        private int hopRefID;
        private boolean hasHopRefID;

        public HopsGroupEncoder next() {
            if (this.next == null) {
                this.next = new HopsGroupEncoder();
            }
            return this.next;
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value, int offset, int length) {
            this.hopCompID.wrap(value);
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(DirectBuffer value) {
            return this.hopCompID(value, 0, value.capacity());
        }

        public HopsGroupEncoder hopCompID(byte[] value, int offset, int length) {
            this.hopCompID.wrap(value);
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(byte[] value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(byte[] value) {
            return this.hopCompID(value, 0, value.length);
        }

        public boolean hasHopCompID() {
            return this.hopCompIDLength > 0;
        }

        public MutableDirectBuffer hopCompID() {
            return this.hopCompID;
        }

        public String hopCompIDAsString() {
            return this.hopCompID.getStringWithoutLengthAscii(this.hopCompIDOffset, this.hopCompIDLength);
        }

        public HopsGroupEncoder hopCompID(CharSequence value) {
            CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.hopCompID);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = value.length();
            return this;
        }

        public HopsGroupEncoder hopCompID(AsciiSequenceView value) {
            DirectBuffer buffer = value.buffer();
            if (buffer != null) {
                this.hopCompID.wrap(buffer);
                this.hopCompIDOffset = value.offset();
                this.hopCompIDLength = value.length();
            }
            return this;
        }

        public HopsGroupEncoder hopCompID(char[] value) {
            return this.hopCompID(value, 0, value.length);
        }

        public HopsGroupEncoder hopCompID(char[] value, int length) {
            return this.hopCompID(value, 0, length);
        }

        public HopsGroupEncoder hopCompID(char[] value, int offset, int length) {
            CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.hopCompID, (int)offset, (int)length);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value, int offset, int length) {
            this.hopSendingTime.wrap(value);
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value, int length) {
            return this.hopSendingTime(value, 0, length);
        }

        public HopsGroupEncoder hopSendingTime(DirectBuffer value) {
            return this.hopSendingTime(value, 0, value.capacity());
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int offset, int length) {
            this.hopSendingTime.wrap(value);
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int length) {
            return this.hopSendingTime(value, 0, length);
        }

        public HopsGroupEncoder hopSendingTime(byte[] value) {
            return this.hopSendingTime(value, 0, value.length);
        }

        public boolean hasHopSendingTime() {
            return this.hopSendingTimeLength > 0;
        }

        public MutableDirectBuffer hopSendingTime() {
            return this.hopSendingTime;
        }

        public String hopSendingTimeAsString() {
            return this.hopSendingTime.getStringWithoutLengthAscii(this.hopSendingTimeOffset, this.hopSendingTimeLength);
        }

        public boolean hasHopRefID() {
            return this.hasHopRefID;
        }

        public HopsGroupEncoder hopRefID(int value) {
            this.hopRefID = value;
            this.hasHopRefID = true;
            return this;
        }

        public int hopRefID() {
            return this.hopRefID;
        }

        public int encode(MutableAsciiBuffer buffer, int offset, int remainingElements) {
            if (remainingElements == 0) {
                return 0;
            }
            int position = offset;
            if (this.hopCompIDLength > 0) {
                buffer.putBytes(position, hopCompIDHeader, 0, 4);
                buffer.putBytes(position += 4, (DirectBuffer)this.hopCompID, this.hopCompIDOffset, this.hopCompIDLength);
                buffer.putSeparator(position += this.hopCompIDLength);
                ++position;
            }
            if (this.hopSendingTimeLength > 0) {
                buffer.putBytes(position, hopSendingTimeHeader, 0, 4);
                buffer.putBytes(position += 4, (DirectBuffer)this.hopSendingTime, this.hopSendingTimeOffset, this.hopSendingTimeLength);
                buffer.putSeparator(position += this.hopSendingTimeLength);
                ++position;
            }
            if (this.hasHopRefID) {
                buffer.putBytes(position, hopRefIDHeader, 0, 4);
                position += 4;
                position += buffer.putIntAscii(position, this.hopRefID);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.next != null) {
                position += this.next.encode(buffer, position, remainingElements - 1);
            }
            return position - offset;
        }

        public void reset() {
            this.resetHopCompID();
            this.resetHopSendingTime();
            this.resetHopRefID();
            if (this.next != null) {
                this.next.reset();
            }
        }

        public void resetHopCompID() {
            this.hopCompIDLength = 0;
        }

        public void resetHopSendingTime() {
            this.hopSendingTimeLength = 0;
        }

        public void resetHopRefID() {
            this.hasHopRefID = false;
        }

        public String toString(int remainingEntries) {
            String entries = (this.hasHopCompID() ? String.format("  \"HopCompID\": \"%s\",\n", this.hopCompID.getStringWithoutLengthAscii(this.hopCompIDOffset, this.hopCompIDLength)) : "") + (this.hasHopSendingTime() ? String.format("  \"HopSendingTime\": \"%s\",\n", this.hopSendingTime.getStringWithoutLengthAscii(this.hopSendingTimeOffset, this.hopSendingTimeLength)) : "") + (this.hasHopRefID() ? String.format("  \"HopRefID\": \"%s\",\n", this.hopRefID) : "");
            entries = "{\n  \"MessageName\": \"HopsGroup\",\n" + entries + "}";
            if (remainingEntries > 1) {
                entries = entries + ",\n" + this.next.toString(remainingEntries - 1);
            }
            return entries;
        }
    }
}

