/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.decoder;

import uk.co.real_logic.artio.fixt.decoder.DictionaryAcceptor;
import uk.co.real_logic.artio.fixt.decoder.HeartbeatDecoder;
import uk.co.real_logic.artio.fixt.decoder.LogonDecoder;
import uk.co.real_logic.artio.fixt.decoder.LogoutDecoder;
import uk.co.real_logic.artio.fixt.decoder.RejectDecoder;
import uk.co.real_logic.artio.fixt.decoder.ResendRequestDecoder;
import uk.co.real_logic.artio.fixt.decoder.SequenceResetDecoder;
import uk.co.real_logic.artio.fixt.decoder.TestRequestDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;

public final class DictionaryDecoder {
    private final DictionaryAcceptor acceptor;
    private final HeartbeatDecoder heartbeat = new HeartbeatDecoder();
    private final TestRequestDecoder testRequest = new TestRequestDecoder();
    private final ResendRequestDecoder resendRequest = new ResendRequestDecoder();
    private final RejectDecoder reject = new RejectDecoder();
    private final SequenceResetDecoder sequenceReset = new SequenceResetDecoder();
    private final LogoutDecoder logout = new LogoutDecoder();
    private final LogonDecoder logon = new LogonDecoder();

    public DictionaryDecoder(DictionaryAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void onMessage(AsciiBuffer buffer, int offset, int length, int messageType) {
        switch (messageType) {
            case 48: {
                this.heartbeat.decode(buffer, offset, length);
                this.acceptor.onHeartbeat(this.heartbeat);
                this.heartbeat.reset();
                break;
            }
            case 49: {
                this.testRequest.decode(buffer, offset, length);
                this.acceptor.onTestRequest(this.testRequest);
                this.testRequest.reset();
                break;
            }
            case 50: {
                this.resendRequest.decode(buffer, offset, length);
                this.acceptor.onResendRequest(this.resendRequest);
                this.resendRequest.reset();
                break;
            }
            case 51: {
                this.reject.decode(buffer, offset, length);
                this.acceptor.onReject(this.reject);
                this.reject.reset();
                break;
            }
            case 52: {
                this.sequenceReset.decode(buffer, offset, length);
                this.acceptor.onSequenceReset(this.sequenceReset);
                this.sequenceReset.reset();
                break;
            }
            case 53: {
                this.logout.decode(buffer, offset, length);
                this.acceptor.onLogout(this.logout);
                this.logout.reset();
                break;
            }
            case 65: {
                this.logon.decode(buffer, offset, length);
                this.acceptor.onLogon(this.logon);
                this.logon.reset();
            }
        }
    }
}

