/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.builder.IntRepresentable;

public enum SessionStatus implements IntRepresentable
{
    SESSION_ACTIVE(0),
    SESSION_PASSWORD_CHANGED(1),
    SESSION_PASSWORD_DUE_TO_EXPIRE(2),
    NEW_SESSION_PASSWORD_DOES_NOT_COMPLY_WITH_POLICY(3),
    SESSION_LOGOUT_COMPLETE(4),
    INVALID_USERNAME_OR_PASSWORD(5),
    ACCOUNT_LOCKED(6),
    LOGONS_ARE_NOT_ALLOWED_AT_THIS_TIME(7),
    PASSWORD_EXPIRED(8),
    NULL_VAL(Integer.MIN_VALUE),
    ARTIO_UNKNOWN(Integer.MAX_VALUE);

    private final int representation;
    private static final IntHashSet intSet;

    private SessionStatus(int representation) {
        this.representation = representation;
    }

    public final int representation() {
        return this.representation;
    }

    public static boolean isValid(int representation) {
        return intSet.contains(representation);
    }

    public static SessionStatus decode(int representation) {
        switch (representation) {
            case 0: {
                return SESSION_ACTIVE;
            }
            case 1: {
                return SESSION_PASSWORD_CHANGED;
            }
            case 2: {
                return SESSION_PASSWORD_DUE_TO_EXPIRE;
            }
            case 3: {
                return NEW_SESSION_PASSWORD_DOES_NOT_COMPLY_WITH_POLICY;
            }
            case 4: {
                return SESSION_LOGOUT_COMPLETE;
            }
            case 5: {
                return INVALID_USERNAME_OR_PASSWORD;
            }
            case 6: {
                return ACCOUNT_LOCKED;
            }
            case 7: {
                return LOGONS_ARE_NOT_ALLOWED_AT_THIS_TIME;
            }
            case 8: {
                return PASSWORD_EXPIRED;
            }
        }
        return ARTIO_UNKNOWN;
    }

    static {
        intSet = new IntHashSet(18);
        intSet.add(0);
        intSet.add(1);
        intSet.add(2);
        intSet.add(3);
        intSet.add(4);
        intSet.add(5);
        intSet.add(6);
        intSet.add(7);
        intSet.add(8);
    }
}

