/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.SessionStatus;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.MessageDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class LogoutDecoder
implements MessageDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(0);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final int MESSAGE_TYPE = 53;
    public static final String MESSAGE_TYPE_AS_STRING = "5";
    public static final char[] MESSAGE_TYPE_CHARS = "5".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "5".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private int sessionStatus;
    private boolean hasSessionStatus;
    private final CharArrayWrapper sessionStatusWrapper;
    private char[] text;
    private boolean hasText;
    private int textOffset;
    private int textLength;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;
    private AsciiBuffer buffer;

    public LogoutDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            // empty if block
        }
        this.alreadyVisitedFields = new IntHashSet(8);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(0);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(72);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(1128);
        this.messageFields.add(1156);
        this.messageFields.add(1129);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(115);
        this.messageFields.add(128);
        this.messageFields.add(90);
        this.messageFields.add(91);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(116);
        this.messageFields.add(144);
        this.messageFields.add(129);
        this.messageFields.add(145);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(212);
        this.messageFields.add(213);
        this.messageFields.add(347);
        this.messageFields.add(369);
        this.messageFields.add(1409);
        this.messageFields.add(58);
        this.messageFields.add(354);
        this.messageFields.add(355);
        this.messageFields.add(93);
        this.messageFields.add(89);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.sessionStatusWrapper = new CharArrayWrapper();
        this.text = new char[1];
        this.encodedText = new byte[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (this.hasSessionStatus && RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !SessionStatus.isValid(this.sessionStatus())) {
            this.invalidTagId = 1409;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public int sessionStatus() {
        if (!this.hasSessionStatus) {
            throw new IllegalArgumentException("No value for optional field: SessionStatus");
        }
        return this.sessionStatus;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public SessionStatus sessionStatusAsEnum() {
        if (!this.hasSessionStatus) {
            return SessionStatus.NULL_VAL;
        }
        return SessionStatus.decode(this.sessionStatus);
    }

    public char[] text() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        return this.text;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public int textLength() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        return this.textLength;
    }

    public String textAsString() {
        return this.hasText ? new String(this.text, 0, this.textLength) : null;
    }

    public void text(AsciiSequenceView view) {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        view.wrap((DirectBuffer)this.buffer, this.textOffset, this.textLength);
    }

    public int encodedTextLen() {
        if (!this.hasEncodedTextLen) {
            throw new IllegalArgumentException("No value for optional field: EncodedTextLen");
        }
        return this.encodedTextLen;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public byte[] encodedText() {
        if (!this.hasEncodedText) {
            throw new IllegalArgumentException("No value for optional field: EncodedText");
        }
        return this.encodedText;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 1409: {
                    this.hasSessionStatus = true;
                    this.sessionStatus = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 58: {
                    this.hasText = true;
                    this.text = buffer.getChars(this.text, valueOffset, valueLength);
                    this.textOffset = valueOffset;
                    this.textLength = valueLength;
                    break;
                }
                case 354: {
                    this.hasEncodedTextLen = true;
                    this.encodedTextLen = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 355: {
                    this.hasEncodedText = true;
                    this.encodedText = buffer.getBytes(this.encodedText, valueOffset, this.encodedTextLen);
                    endOfField = valueOffset + this.encodedTextLen;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetSessionStatus();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetText() {
        this.hasText = false;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", this.textAsString()) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logout\",\n" + entries + "}";
        return entries;
    }
}

