/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.MsgDirection;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class MsgTypeGrpEncoder {
    private static final int noMsgTypesGroupCounterHeaderLength = 4;
    private static final byte[] noMsgTypesGroupCounterHeader = new byte[]{51, 56, 52, 61};
    private int noMsgTypesGroupCounter;
    private boolean hasNoMsgTypesGroupCounter;
    private MsgTypesGroupEncoder msgTypesGroup = null;

    public boolean hasNoMsgTypesGroupCounter() {
        return this.hasNoMsgTypesGroupCounter;
    }

    public MsgTypeGrpEncoder noMsgTypesGroupCounter(int value) {
        this.noMsgTypesGroupCounter = value;
        this.hasNoMsgTypesGroupCounter = true;
        return this;
    }

    public int noMsgTypesGroupCounter() {
        return this.noMsgTypesGroupCounter;
    }

    public MsgTypesGroupEncoder msgTypesGroup(int numberOfElements) {
        this.hasNoMsgTypesGroupCounter = true;
        this.noMsgTypesGroupCounter = numberOfElements;
        if (this.msgTypesGroup == null) {
            this.msgTypesGroup = new MsgTypesGroupEncoder();
        }
        return this.msgTypesGroup;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasNoMsgTypesGroupCounter) {
            buffer.putBytes(position, noMsgTypesGroupCounterHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.noMsgTypesGroupCounter);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.msgTypesGroup != null) {
            position += this.msgTypesGroup.encode(buffer, position, this.noMsgTypesGroupCounter);
        }
        return position - offset;
    }

    public void reset() {
        this.resetMsgTypesGroup();
    }

    public void resetMsgTypesGroup() {
        if (this.msgTypesGroup != null) {
            this.msgTypesGroup.reset();
        }
        this.noMsgTypesGroupCounter = 0;
        this.hasNoMsgTypesGroupCounter = false;
    }

    public String toString() {
        String entries = this.noMsgTypesGroupCounter > 0 ? String.format("  \"MsgTypesGroup\": [\n  %s\n  ]\n", this.msgTypesGroup.toString(this.noMsgTypesGroupCounter).replace("\n", "\n  ")) : "";
        entries = "{\n  \"MessageName\": \"MsgTypeGrp\",\n" + entries + "}";
        return entries;
    }

    public static class MsgTypesGroupEncoder {
        private MsgTypesGroupEncoder next = null;
        private static final int refMsgTypeHeaderLength = 4;
        private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
        private static final int msgDirectionHeaderLength = 4;
        private static final byte[] msgDirectionHeader = new byte[]{51, 56, 53, 61};
        private static final int refApplVerIDHeaderLength = 5;
        private static final byte[] refApplVerIDHeader = new byte[]{49, 49, 51, 48, 61};
        private static final int refApplExtIDHeaderLength = 5;
        private static final byte[] refApplExtIDHeader = new byte[]{49, 52, 48, 54, 61};
        private static final int refCstmApplVerIDHeaderLength = 5;
        private static final byte[] refCstmApplVerIDHeader = new byte[]{49, 49, 51, 49, 61};
        private static final int defaultVerIndicatorHeaderLength = 5;
        private static final byte[] defaultVerIndicatorHeader = new byte[]{49, 52, 49, 48, 61};
        private byte[] refMsgType = new byte[1];
        private int refMsgTypeOffset = 0;
        private int refMsgTypeLength = 0;
        private char msgDirection;
        private boolean hasMsgDirection;
        private byte[] refApplVerID = new byte[1];
        private int refApplVerIDOffset = 0;
        private int refApplVerIDLength = 0;
        private int refApplExtID;
        private boolean hasRefApplExtID;
        private byte[] refCstmApplVerID = new byte[1];
        private int refCstmApplVerIDOffset = 0;
        private int refCstmApplVerIDLength = 0;
        private boolean defaultVerIndicator;
        private boolean hasDefaultVerIndicator;

        public MsgTypesGroupEncoder next() {
            if (this.next == null) {
                this.next = new MsgTypesGroupEncoder();
            }
            return this.next;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value, int length) {
            this.refMsgType = value;
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value, int offset, int length) {
            this.refMsgType = value;
            this.refMsgTypeOffset = offset;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value) {
            return this.refMsgType(value, value.length);
        }

        public boolean hasRefMsgType() {
            return this.refMsgTypeLength > 0;
        }

        public byte[] refMsgType() {
            return this.refMsgType;
        }

        public MsgTypesGroupEncoder refMsgType(CharSequence value) {
            this.refMsgType = CodecUtil.toBytes((CharSequence)value, (byte[])this.refMsgType);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(char[] value) {
            return this.refMsgType(value, value.length);
        }

        public MsgTypesGroupEncoder refMsgType(char[] value, int length) {
            this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)length);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(char[] value, int offset, int length) {
            this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)offset, (int)length);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public boolean hasMsgDirection() {
            return this.hasMsgDirection;
        }

        public MsgTypesGroupEncoder msgDirection(char value) {
            this.msgDirection = value;
            this.hasMsgDirection = true;
            return this;
        }

        public char msgDirection() {
            return this.msgDirection;
        }

        public MsgTypesGroupEncoder msgDirection(MsgDirection value) {
            return this.msgDirection(value.representation());
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value, int length) {
            this.refApplVerID = value;
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value, int offset, int length) {
            this.refApplVerID = value;
            this.refApplVerIDOffset = offset;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value) {
            return this.refApplVerID(value, value.length);
        }

        public boolean hasRefApplVerID() {
            return this.refApplVerIDLength > 0;
        }

        public byte[] refApplVerID() {
            return this.refApplVerID;
        }

        public MsgTypesGroupEncoder refApplVerID(CharSequence value) {
            this.refApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refApplVerID);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value) {
            return this.refApplVerID(value, value.length);
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value, int length) {
            this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)length);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value, int offset, int length) {
            this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)offset, (int)length);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public boolean hasRefApplExtID() {
            return this.hasRefApplExtID;
        }

        public MsgTypesGroupEncoder refApplExtID(int value) {
            this.refApplExtID = value;
            this.hasRefApplExtID = true;
            return this;
        }

        public int refApplExtID() {
            return this.refApplExtID;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value, int length) {
            this.refCstmApplVerID = value;
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value, int offset, int length) {
            this.refCstmApplVerID = value;
            this.refCstmApplVerIDOffset = offset;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value) {
            return this.refCstmApplVerID(value, value.length);
        }

        public boolean hasRefCstmApplVerID() {
            return this.refCstmApplVerIDLength > 0;
        }

        public byte[] refCstmApplVerID() {
            return this.refCstmApplVerID;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(CharSequence value) {
            this.refCstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refCstmApplVerID);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value) {
            return this.refCstmApplVerID(value, value.length);
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value, int length) {
            this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)length);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value, int offset, int length) {
            this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)offset, (int)length);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public boolean hasDefaultVerIndicator() {
            return this.hasDefaultVerIndicator;
        }

        public MsgTypesGroupEncoder defaultVerIndicator(boolean value) {
            this.defaultVerIndicator = value;
            this.hasDefaultVerIndicator = true;
            return this;
        }

        public boolean defaultVerIndicator() {
            return this.defaultVerIndicator;
        }

        public int encode(MutableAsciiBuffer buffer, int offset, int remainingElements) {
            if (remainingElements == 0) {
                return 0;
            }
            int position = offset;
            if (this.refMsgTypeLength > 0) {
                buffer.putBytes(position, refMsgTypeHeader, 0, 4);
                buffer.putBytes(position += 4, this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
                buffer.putSeparator(position += this.refMsgTypeLength);
                ++position;
            }
            if (this.hasMsgDirection) {
                buffer.putBytes(position, msgDirectionHeader, 0, 4);
                position += 4;
                position += buffer.putCharAscii(position, this.msgDirection);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.refApplVerIDLength > 0) {
                buffer.putBytes(position, refApplVerIDHeader, 0, 5);
                buffer.putBytes(position += 5, this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength);
                buffer.putSeparator(position += this.refApplVerIDLength);
                ++position;
            }
            if (this.hasRefApplExtID) {
                buffer.putBytes(position, refApplExtIDHeader, 0, 5);
                position += 5;
                position += buffer.putIntAscii(position, this.refApplExtID);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.refCstmApplVerIDLength > 0) {
                buffer.putBytes(position, refCstmApplVerIDHeader, 0, 5);
                buffer.putBytes(position += 5, this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
                buffer.putSeparator(position += this.refCstmApplVerIDLength);
                ++position;
            }
            if (this.hasDefaultVerIndicator) {
                buffer.putBytes(position, defaultVerIndicatorHeader, 0, 5);
                position += 5;
                position += buffer.putBooleanAscii(position, this.defaultVerIndicator);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.next != null) {
                position += this.next.encode(buffer, position, remainingElements - 1);
            }
            return position - offset;
        }

        public void reset() {
            this.resetRefMsgType();
            this.resetMsgDirection();
            this.resetRefApplVerID();
            this.resetRefApplExtID();
            this.resetRefCstmApplVerID();
            this.resetDefaultVerIndicator();
            if (this.next != null) {
                this.next.reset();
            }
        }

        public void resetRefMsgType() {
            this.refMsgTypeLength = 0;
        }

        public void resetMsgDirection() {
            this.hasMsgDirection = false;
        }

        public void resetRefApplVerID() {
            this.refApplVerIDLength = 0;
        }

        public void resetRefApplExtID() {
            this.hasRefApplExtID = false;
        }

        public void resetRefCstmApplVerID() {
            this.refCstmApplVerIDLength = 0;
        }

        public void resetDefaultVerIndicator() {
            this.hasDefaultVerIndicator = false;
        }

        public String toString(int remainingEntries) {
            String entries = (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", new String(this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength, StandardCharsets.US_ASCII)) : "") + (this.hasMsgDirection() ? String.format("  \"MsgDirection\": \"%s\",\n", Character.valueOf(this.msgDirection)) : "") + (this.hasRefApplVerID() ? String.format("  \"RefApplVerID\": \"%s\",\n", new String(this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasRefApplExtID() ? String.format("  \"RefApplExtID\": \"%s\",\n", this.refApplExtID) : "") + (this.hasRefCstmApplVerID() ? String.format("  \"RefCstmApplVerID\": \"%s\",\n", new String(this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDefaultVerIndicator() ? String.format("  \"DefaultVerIndicator\": \"%s\",\n", this.defaultVerIndicator) : "");
            entries = "{\n  \"MessageName\": \"MsgTypesGroup\",\n" + entries + "}";
            if (remainingEntries > 1) {
                entries = entries + ",\n" + this.next.toString(remainingEntries - 1);
            }
            return entries;
        }
    }
}

