/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.SessionStatus;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.MsgTypeGrpEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogonEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int encryptMethodHeaderLength = 3;
    private static final byte[] encryptMethodHeader = new byte[]{57, 56, 61};
    private static final int heartBtIntHeaderLength = 4;
    private static final byte[] heartBtIntHeader = new byte[]{49, 48, 56, 61};
    private static final int rawDataLengthHeaderLength = 3;
    private static final byte[] rawDataLengthHeader = new byte[]{57, 53, 61};
    private static final int rawDataHeaderLength = 3;
    private static final byte[] rawDataHeader = new byte[]{57, 54, 61};
    private static final int resetSeqNumFlagHeaderLength = 4;
    private static final byte[] resetSeqNumFlagHeader = new byte[]{49, 52, 49, 61};
    private static final int nextExpectedMsgSeqNumHeaderLength = 4;
    private static final byte[] nextExpectedMsgSeqNumHeader = new byte[]{55, 56, 57, 61};
    private static final int maxMessageSizeHeaderLength = 4;
    private static final byte[] maxMessageSizeHeader = new byte[]{51, 56, 51, 61};
    private static final int testMessageIndicatorHeaderLength = 4;
    private static final byte[] testMessageIndicatorHeader = new byte[]{52, 54, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private static final int newPasswordHeaderLength = 4;
    private static final byte[] newPasswordHeader = new byte[]{57, 50, 53, 61};
    private static final int encryptedPasswordMethodHeaderLength = 5;
    private static final byte[] encryptedPasswordMethodHeader = new byte[]{49, 52, 48, 48, 61};
    private static final int encryptedPasswordLenHeaderLength = 5;
    private static final byte[] encryptedPasswordLenHeader = new byte[]{49, 52, 48, 49, 61};
    private static final int encryptedPasswordHeaderLength = 5;
    private static final byte[] encryptedPasswordHeader = new byte[]{49, 52, 48, 50, 61};
    private static final int encryptedNewPasswordLenHeaderLength = 5;
    private static final byte[] encryptedNewPasswordLenHeader = new byte[]{49, 52, 48, 51, 61};
    private static final int encryptedNewPasswordHeaderLength = 5;
    private static final byte[] encryptedNewPasswordHeader = new byte[]{49, 52, 48, 52, 61};
    private static final int sessionStatusHeaderLength = 5;
    private static final byte[] sessionStatusHeader = new byte[]{49, 52, 48, 57, 61};
    private static final int defaultApplVerIDHeaderLength = 5;
    private static final byte[] defaultApplVerIDHeader = new byte[]{49, 49, 51, 55, 61};
    private static final int defaultApplExtIDHeaderLength = 5;
    private static final byte[] defaultApplExtIDHeader = new byte[]{49, 52, 48, 55, 61};
    private static final int defaultCstmApplVerIDHeaderLength = 5;
    private static final byte[] defaultCstmApplVerIDHeader = new byte[]{49, 52, 48, 56, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int encryptMethod;
    private boolean hasEncryptMethod;
    private int heartBtInt;
    private boolean hasHeartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private final MsgTypeGrpEncoder msgTypeGrp = new MsgTypeGrpEncoder();
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private byte[] username = new byte[1];
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private byte[] password = new byte[1];
    private int passwordOffset = 0;
    private int passwordLength = 0;
    private byte[] newPassword = new byte[1];
    private int newPasswordOffset = 0;
    private int newPasswordLength = 0;
    private int encryptedPasswordMethod;
    private boolean hasEncryptedPasswordMethod;
    private int encryptedPasswordLen;
    private boolean hasEncryptedPasswordLen;
    private byte[] encryptedPassword;
    private boolean hasEncryptedPassword;
    private int encryptedNewPasswordLen;
    private boolean hasEncryptedNewPasswordLen;
    private byte[] encryptedNewPassword;
    private boolean hasEncryptedNewPassword;
    private int sessionStatus;
    private boolean hasSessionStatus;
    private byte[] defaultApplVerID = new byte[1];
    private int defaultApplVerIDOffset = 0;
    private int defaultApplVerIDLength = 0;
    private int defaultApplExtID;
    private boolean hasDefaultApplExtID;
    private byte[] defaultCstmApplVerID = new byte[1];
    private int defaultCstmApplVerIDOffset = 0;
    private int defaultCstmApplVerIDLength = 0;
    private byte[] text = new byte[1];
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;

    public int messageType() {
        return 65;
    }

    public LogonEncoder() {
        this.header.msgType("A");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasEncryptMethod() {
        return this.hasEncryptMethod;
    }

    public LogonEncoder encryptMethod(int value) {
        this.encryptMethod = value;
        this.hasEncryptMethod = true;
        return this;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public LogonEncoder encryptMethod(EncryptMethod value) {
        return this.encryptMethod(value.representation());
    }

    public boolean hasHeartBtInt() {
        return this.hasHeartBtInt;
    }

    public LogonEncoder heartBtInt(int value) {
        this.heartBtInt = value;
        this.hasHeartBtInt = true;
        return this;
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public LogonEncoder rawDataLength(int value) {
        this.rawDataLength = value;
        this.hasRawDataLength = true;
        return this;
    }

    public int rawDataLength() {
        return this.rawDataLength;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public LogonEncoder rawData(byte[] value) {
        this.rawData = value;
        this.hasRawData = true;
        return this;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public LogonEncoder resetSeqNumFlag(boolean value) {
        this.resetSeqNumFlag = value;
        this.hasResetSeqNumFlag = true;
        return this;
    }

    public boolean resetSeqNumFlag() {
        return this.resetSeqNumFlag;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public LogonEncoder nextExpectedMsgSeqNum(int value) {
        this.nextExpectedMsgSeqNum = value;
        this.hasNextExpectedMsgSeqNum = true;
        return this;
    }

    public int nextExpectedMsgSeqNum() {
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public LogonEncoder maxMessageSize(int value) {
        this.maxMessageSize = value;
        this.hasMaxMessageSize = true;
        return this;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public MsgTypeGrpEncoder msgTypeGrp() {
        return this.msgTypeGrp;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public LogonEncoder testMessageIndicator(boolean value) {
        this.testMessageIndicator = value;
        this.hasTestMessageIndicator = true;
        return this;
    }

    public boolean testMessageIndicator() {
        return this.testMessageIndicator;
    }

    public LogonEncoder username(byte[] value, int length) {
        this.username = value;
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value, int offset, int length) {
        this.username = value;
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value) {
        return this.username(value, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public byte[] username() {
        return this.username;
    }

    public LogonEncoder username(CharSequence value) {
        this.username = CodecUtil.toBytes((CharSequence)value, (byte[])this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public LogonEncoder username(char[] value) {
        return this.username(value, value.length);
    }

    public LogonEncoder username(char[] value, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(char[] value, int offset, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int length) {
        this.password = value;
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int offset, int length) {
        this.password = value;
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value) {
        return this.password(value, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public byte[] password() {
        return this.password;
    }

    public LogonEncoder password(CharSequence value) {
        this.password = CodecUtil.toBytes((CharSequence)value, (byte[])this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public LogonEncoder password(char[] value) {
        return this.password(value, value.length);
    }

    public LogonEncoder password(char[] value, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(char[] value, int offset, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value, int length) {
        this.newPassword = value;
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value, int offset, int length) {
        this.newPassword = value;
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value) {
        return this.newPassword(value, value.length);
    }

    public boolean hasNewPassword() {
        return this.newPasswordLength > 0;
    }

    public byte[] newPassword() {
        return this.newPassword;
    }

    public LogonEncoder newPassword(CharSequence value) {
        this.newPassword = CodecUtil.toBytes((CharSequence)value, (byte[])this.newPassword);
        this.newPasswordOffset = 0;
        this.newPasswordLength = value.length();
        return this;
    }

    public LogonEncoder newPassword(char[] value) {
        return this.newPassword(value, value.length);
    }

    public LogonEncoder newPassword(char[] value, int length) {
        this.newPassword = CodecUtil.toBytes((char[])value, (byte[])this.newPassword, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(char[] value, int offset, int length) {
        this.newPassword = CodecUtil.toBytes((char[])value, (byte[])this.newPassword, (int)offset, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public boolean hasEncryptedPasswordMethod() {
        return this.hasEncryptedPasswordMethod;
    }

    public LogonEncoder encryptedPasswordMethod(int value) {
        this.encryptedPasswordMethod = value;
        this.hasEncryptedPasswordMethod = true;
        return this;
    }

    public int encryptedPasswordMethod() {
        return this.encryptedPasswordMethod;
    }

    public boolean hasEncryptedPasswordLen() {
        return this.hasEncryptedPasswordLen;
    }

    public LogonEncoder encryptedPasswordLen(int value) {
        this.encryptedPasswordLen = value;
        this.hasEncryptedPasswordLen = true;
        return this;
    }

    public int encryptedPasswordLen() {
        return this.encryptedPasswordLen;
    }

    public boolean hasEncryptedPassword() {
        return this.hasEncryptedPassword;
    }

    public LogonEncoder encryptedPassword(byte[] value) {
        this.encryptedPassword = value;
        this.hasEncryptedPassword = true;
        return this;
    }

    public byte[] encryptedPassword() {
        return this.encryptedPassword;
    }

    public boolean hasEncryptedNewPasswordLen() {
        return this.hasEncryptedNewPasswordLen;
    }

    public LogonEncoder encryptedNewPasswordLen(int value) {
        this.encryptedNewPasswordLen = value;
        this.hasEncryptedNewPasswordLen = true;
        return this;
    }

    public int encryptedNewPasswordLen() {
        return this.encryptedNewPasswordLen;
    }

    public boolean hasEncryptedNewPassword() {
        return this.hasEncryptedNewPassword;
    }

    public LogonEncoder encryptedNewPassword(byte[] value) {
        this.encryptedNewPassword = value;
        this.hasEncryptedNewPassword = true;
        return this;
    }

    public byte[] encryptedNewPassword() {
        return this.encryptedNewPassword;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public LogonEncoder sessionStatus(int value) {
        this.sessionStatus = value;
        this.hasSessionStatus = true;
        return this;
    }

    public int sessionStatus() {
        return this.sessionStatus;
    }

    public LogonEncoder sessionStatus(SessionStatus value) {
        return this.sessionStatus(value.representation());
    }

    public LogonEncoder defaultApplVerID(byte[] value, int length) {
        this.defaultApplVerID = value;
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(byte[] value, int offset, int length) {
        this.defaultApplVerID = value;
        this.defaultApplVerIDOffset = offset;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(byte[] value) {
        return this.defaultApplVerID(value, value.length);
    }

    public boolean hasDefaultApplVerID() {
        return this.defaultApplVerIDLength > 0;
    }

    public byte[] defaultApplVerID() {
        return this.defaultApplVerID;
    }

    public LogonEncoder defaultApplVerID(CharSequence value) {
        this.defaultApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.defaultApplVerID);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultApplVerID(char[] value) {
        return this.defaultApplVerID(value, value.length);
    }

    public LogonEncoder defaultApplVerID(char[] value, int length) {
        this.defaultApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultApplVerID, (int)length);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(char[] value, int offset, int length) {
        this.defaultApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultApplVerID, (int)offset, (int)length);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public boolean hasDefaultApplExtID() {
        return this.hasDefaultApplExtID;
    }

    public LogonEncoder defaultApplExtID(int value) {
        this.defaultApplExtID = value;
        this.hasDefaultApplExtID = true;
        return this;
    }

    public int defaultApplExtID() {
        return this.defaultApplExtID;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int length) {
        this.defaultCstmApplVerID = value;
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int offset, int length) {
        this.defaultCstmApplVerID = value;
        this.defaultCstmApplVerIDOffset = offset;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value) {
        return this.defaultCstmApplVerID(value, value.length);
    }

    public boolean hasDefaultCstmApplVerID() {
        return this.defaultCstmApplVerIDLength > 0;
    }

    public byte[] defaultCstmApplVerID() {
        return this.defaultCstmApplVerID;
    }

    public LogonEncoder defaultCstmApplVerID(CharSequence value) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.defaultCstmApplVerID);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(char[] value) {
        return this.defaultCstmApplVerID(value, value.length);
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int length) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultCstmApplVerID, (int)length);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int offset, int length) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultCstmApplVerID, (int)offset, (int)length);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value, int length) {
        this.text = value;
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value, int offset, int length) {
        this.text = value;
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value) {
        return this.text(value, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public byte[] text() {
        return this.text;
    }

    public LogonEncoder text(CharSequence value) {
        this.text = CodecUtil.toBytes((CharSequence)value, (byte[])this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public LogonEncoder text(char[] value) {
        return this.text(value, value.length);
    }

    public LogonEncoder text(char[] value, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(char[] value, int offset, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public LogonEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public LogonEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasEncryptMethod) {
            buffer.putBytes(position, encryptMethodHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.encryptMethod);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EncryptMethod");
        }
        if (this.hasHeartBtInt) {
            buffer.putBytes(position, heartBtIntHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.heartBtInt);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: HeartBtInt");
        }
        if (this.hasRawDataLength) {
            buffer.putBytes(position, rawDataLengthHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.rawDataLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasRawData) {
            buffer.putBytes(position, rawDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.rawData);
            buffer.putSeparator(position += this.rawData.length);
            ++position;
        }
        if (this.hasResetSeqNumFlag) {
            buffer.putBytes(position, resetSeqNumFlagHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.resetSeqNumFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNextExpectedMsgSeqNum) {
            buffer.putBytes(position, nextExpectedMsgSeqNumHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.nextExpectedMsgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasMaxMessageSize) {
            buffer.putBytes(position, maxMessageSizeHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.maxMessageSize);
            buffer.putSeparator(position);
            ++position;
        }
        position += this.msgTypeGrp.encode(buffer, position);
        if (this.hasTestMessageIndicator) {
            buffer.putBytes(position, testMessageIndicatorHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.testMessageIndicator);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        if (this.newPasswordLength > 0) {
            buffer.putBytes(position, newPasswordHeader, 0, 4);
            buffer.putBytes(position += 4, this.newPassword, this.newPasswordOffset, this.newPasswordLength);
            buffer.putSeparator(position += this.newPasswordLength);
            ++position;
        }
        if (this.hasEncryptedPasswordMethod) {
            buffer.putBytes(position, encryptedPasswordMethodHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedPasswordMethod);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPasswordLen) {
            buffer.putBytes(position, encryptedPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPassword) {
            buffer.putBytes(position, encryptedPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedPassword);
            buffer.putSeparator(position += this.encryptedPassword.length);
            ++position;
        }
        if (this.hasEncryptedNewPasswordLen) {
            buffer.putBytes(position, encryptedNewPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.encryptedNewPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedNewPassword) {
            buffer.putBytes(position, encryptedNewPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedNewPassword);
            buffer.putSeparator(position += this.encryptedNewPassword.length);
            ++position;
        }
        if (this.hasSessionStatus) {
            buffer.putBytes(position, sessionStatusHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.sessionStatus);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultApplVerIDLength > 0) {
            buffer.putBytes(position, defaultApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.defaultApplVerID, this.defaultApplVerIDOffset, this.defaultApplVerIDLength);
            buffer.putSeparator(position += this.defaultApplVerIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: DefaultApplVerID");
        }
        if (this.hasDefaultApplExtID) {
            buffer.putBytes(position, defaultApplExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putIntAscii(position, this.defaultApplExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultCstmApplVerIDLength > 0) {
            buffer.putBytes(position, defaultCstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.defaultCstmApplVerID, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength);
            buffer.putSeparator(position += this.defaultCstmApplVerIDLength);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
        this.resetEncryptedPasswordMethod();
        this.resetEncryptedPasswordLen();
        this.resetEncryptedPassword();
        this.resetEncryptedNewPasswordLen();
        this.resetEncryptedNewPassword();
        this.resetSessionStatus();
        this.resetDefaultApplVerID();
        this.resetDefaultApplExtID();
        this.resetDefaultCstmApplVerID();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
        this.msgTypeGrp.reset();
    }

    public void resetEncryptMethod() {
        this.hasEncryptMethod = false;
    }

    public void resetHeartBtInt() {
        this.hasHeartBtInt = false;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public void resetNewPassword() {
        this.newPasswordLength = 0;
    }

    public void resetEncryptedPasswordMethod() {
        this.hasEncryptedPasswordMethod = false;
    }

    public void resetEncryptedPasswordLen() {
        this.hasEncryptedPasswordLen = false;
    }

    public void resetEncryptedPassword() {
        this.hasEncryptedPassword = false;
    }

    public void resetEncryptedNewPasswordLen() {
        this.hasEncryptedNewPasswordLen = false;
    }

    public void resetEncryptedNewPassword() {
        this.hasEncryptedNewPassword = false;
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetDefaultApplVerID() {
        this.defaultApplVerIDLength = 0;
    }

    public void resetDefaultApplExtID() {
        this.hasDefaultApplExtID = false;
    }

    public void resetDefaultCstmApplVerID() {
        this.defaultCstmApplVerIDLength = 0;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasEncryptMethod() ? String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) : "") + (this.hasHeartBtInt() ? String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) : "") + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + String.format("  \"MsgTypeGrp\":  %s\n", this.msgTypeGrp.toString().replace("\n", "\n  ")) + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", new String(this.username, this.usernameOffset, this.usernameLength, StandardCharsets.US_ASCII)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", new String(this.password, this.passwordOffset, this.passwordLength, StandardCharsets.US_ASCII)) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", new String(this.newPassword, this.newPasswordOffset, this.newPasswordLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncryptedPasswordMethod() ? String.format("  \"EncryptedPasswordMethod\": \"%s\",\n", this.encryptedPasswordMethod) : "") + (this.hasEncryptedPasswordLen() ? String.format("  \"EncryptedPasswordLen\": \"%s\",\n", this.encryptedPasswordLen) : "") + (this.hasEncryptedPassword() ? String.format("  \"EncryptedPassword\": \"%s\",\n", Arrays.toString(this.encryptedPassword)) : "") + (this.hasEncryptedNewPasswordLen() ? String.format("  \"EncryptedNewPasswordLen\": \"%s\",\n", this.encryptedNewPasswordLen) : "") + (this.hasEncryptedNewPassword() ? String.format("  \"EncryptedNewPassword\": \"%s\",\n", Arrays.toString(this.encryptedNewPassword)) : "") + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + (this.hasDefaultApplVerID() ? String.format("  \"DefaultApplVerID\": \"%s\",\n", new String(this.defaultApplVerID, this.defaultApplVerIDOffset, this.defaultApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDefaultApplExtID() ? String.format("  \"DefaultApplExtID\": \"%s\",\n", this.defaultApplExtID) : "") + (this.hasDefaultCstmApplVerID() ? String.format("  \"DefaultCstmApplVerID\": \"%s\",\n", new String(this.defaultCstmApplVerID, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, this.textOffset, this.textLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }
}

