/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HopGrpEncoder {
    private static final int noHopsGroupCounterHeaderLength = 4;
    private static final byte[] noHopsGroupCounterHeader = new byte[]{54, 50, 55, 61};
    private int noHopsGroupCounter;
    private boolean hasNoHopsGroupCounter;
    private HopsGroupEncoder hopsGroup = null;

    public boolean hasNoHopsGroupCounter() {
        return this.hasNoHopsGroupCounter;
    }

    public HopGrpEncoder noHopsGroupCounter(int value) {
        this.noHopsGroupCounter = value;
        this.hasNoHopsGroupCounter = true;
        return this;
    }

    public int noHopsGroupCounter() {
        return this.noHopsGroupCounter;
    }

    public HopsGroupEncoder hopsGroup(int numberOfElements) {
        this.hasNoHopsGroupCounter = true;
        this.noHopsGroupCounter = numberOfElements;
        if (this.hopsGroup == null) {
            this.hopsGroup = new HopsGroupEncoder();
        }
        return this.hopsGroup;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasNoHopsGroupCounter) {
            buffer.putBytes(position, noHopsGroupCounterHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.noHopsGroupCounter);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hopsGroup != null) {
            position += this.hopsGroup.encode(buffer, position, this.noHopsGroupCounter);
        }
        return position - offset;
    }

    public void reset() {
        this.resetHopsGroup();
    }

    public void resetHopsGroup() {
        if (this.hopsGroup != null) {
            this.hopsGroup.reset();
        }
        this.noHopsGroupCounter = 0;
        this.hasNoHopsGroupCounter = false;
    }

    public String toString() {
        String entries = this.noHopsGroupCounter > 0 ? String.format("  \"HopsGroup\": [\n  %s\n  ]\n", this.hopsGroup.toString(this.noHopsGroupCounter).replace("\n", "\n  ")) : "";
        entries = "{\n  \"MessageName\": \"HopGrp\",\n" + entries + "}";
        return entries;
    }

    public static class HopsGroupEncoder {
        private HopsGroupEncoder next = null;
        private static final int hopCompIDHeaderLength = 4;
        private static final byte[] hopCompIDHeader = new byte[]{54, 50, 56, 61};
        private static final int hopSendingTimeHeaderLength = 4;
        private static final byte[] hopSendingTimeHeader = new byte[]{54, 50, 57, 61};
        private static final int hopRefIDHeaderLength = 4;
        private static final byte[] hopRefIDHeader = new byte[]{54, 51, 48, 61};
        private byte[] hopCompID = new byte[1];
        private int hopCompIDOffset = 0;
        private int hopCompIDLength = 0;
        private byte[] hopSendingTime = new byte[1];
        private int hopSendingTimeOffset = 0;
        private int hopSendingTimeLength = 0;
        private int hopRefID;
        private boolean hasHopRefID;

        public HopsGroupEncoder next() {
            if (this.next == null) {
                this.next = new HopsGroupEncoder();
            }
            return this.next;
        }

        public HopsGroupEncoder hopCompID(byte[] value, int length) {
            this.hopCompID = value;
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(byte[] value, int offset, int length) {
            this.hopCompID = value;
            this.hopCompIDOffset = offset;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(byte[] value) {
            return this.hopCompID(value, value.length);
        }

        public boolean hasHopCompID() {
            return this.hopCompIDLength > 0;
        }

        public byte[] hopCompID() {
            return this.hopCompID;
        }

        public HopsGroupEncoder hopCompID(CharSequence value) {
            this.hopCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.hopCompID);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = value.length();
            return this;
        }

        public HopsGroupEncoder hopCompID(char[] value) {
            return this.hopCompID(value, value.length);
        }

        public HopsGroupEncoder hopCompID(char[] value, int length) {
            this.hopCompID = CodecUtil.toBytes((char[])value, (byte[])this.hopCompID, (int)length);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopCompID(char[] value, int offset, int length) {
            this.hopCompID = CodecUtil.toBytes((char[])value, (byte[])this.hopCompID, (int)offset, (int)length);
            this.hopCompIDOffset = 0;
            this.hopCompIDLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int length) {
            this.hopSendingTime = value;
            this.hopSendingTimeOffset = 0;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(byte[] value, int offset, int length) {
            this.hopSendingTime = value;
            this.hopSendingTimeOffset = offset;
            this.hopSendingTimeLength = length;
            return this;
        }

        public HopsGroupEncoder hopSendingTime(byte[] value) {
            return this.hopSendingTime(value, value.length);
        }

        public boolean hasHopSendingTime() {
            return this.hopSendingTimeLength > 0;
        }

        public byte[] hopSendingTime() {
            return this.hopSendingTime;
        }

        public boolean hasHopRefID() {
            return this.hasHopRefID;
        }

        public HopsGroupEncoder hopRefID(int value) {
            this.hopRefID = value;
            this.hasHopRefID = true;
            return this;
        }

        public int hopRefID() {
            return this.hopRefID;
        }

        public int encode(MutableAsciiBuffer buffer, int offset, int remainingElements) {
            if (remainingElements == 0) {
                return 0;
            }
            int position = offset;
            if (this.hopCompIDLength > 0) {
                buffer.putBytes(position, hopCompIDHeader, 0, 4);
                buffer.putBytes(position += 4, this.hopCompID, this.hopCompIDOffset, this.hopCompIDLength);
                buffer.putSeparator(position += this.hopCompIDLength);
                ++position;
            }
            if (this.hopSendingTimeLength > 0) {
                buffer.putBytes(position, hopSendingTimeHeader, 0, 4);
                buffer.putBytes(position += 4, this.hopSendingTime, this.hopSendingTimeOffset, this.hopSendingTimeLength);
                buffer.putSeparator(position += this.hopSendingTimeLength);
                ++position;
            }
            if (this.hasHopRefID) {
                buffer.putBytes(position, hopRefIDHeader, 0, 4);
                position += 4;
                position += buffer.putIntAscii(position, this.hopRefID);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.next != null) {
                position += this.next.encode(buffer, position, remainingElements - 1);
            }
            return position - offset;
        }

        public void reset() {
            this.resetHopCompID();
            this.resetHopSendingTime();
            this.resetHopRefID();
            if (this.next != null) {
                this.next.reset();
            }
        }

        public void resetHopCompID() {
            this.hopCompIDLength = 0;
        }

        public void resetHopSendingTime() {
            this.hopSendingTimeLength = 0;
        }

        public void resetHopRefID() {
            this.hasHopRefID = false;
        }

        public String toString(int remainingEntries) {
            String entries = (this.hasHopCompID() ? String.format("  \"HopCompID\": \"%s\",\n", new String(this.hopCompID, this.hopCompIDOffset, this.hopCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasHopSendingTime() ? String.format("  \"HopSendingTime\": \"%s\",\n", new String(this.hopSendingTime, this.hopSendingTimeOffset, this.hopSendingTimeLength, StandardCharsets.US_ASCII)) : "") + (this.hasHopRefID() ? String.format("  \"HopRefID\": \"%s\",\n", this.hopRefID) : "");
            entries = "{\n  \"MessageName\": \"HopsGroup\",\n" + entries + "}";
            if (remainingEntries > 1) {
                entries = entries + ",\n" + this.next.toString(remainingEntries - 1);
            }
            return entries;
        }
    }
}

